/******************************************************************************
*
*    nx.h header file
*    Copyright (C) 1993 A. Bode, S. Lamberts, T. Ludwig, G. Stellner
*
*    This file is part of NXLIB (Paragon(TM) message passing on workstations)
*
*    NXLIB is free software; you can redistribute it and/or
*    modify it under the terms of the GNU Library General Public
*    License as published by the Free Software Foundation; either
*    version 2 of the License, or (at your option) any later version.
*
*    NXLIB is distributed in the hope that it will be useful,
*    but WITHOUT ANY WARRANTY; without even the implied warranty of
*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
*    Library General Public License for more details.
*
*    You should have received a copy of the GNU Library General Public
*    License along with this library; if not, write to the Free
*    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*
*    Contact to the authors:
*
*    electronic mail: nxlib@informatik.tu-muenchen.de
*
*    paper mail:      Prof. Dr. A. Bode
*                     Lehrstuhl f"ur Rechnertechnik und Rechnerorganisation
*                     Institut f"ur Informatik
*                     Technische Universit"at M"unchen
*                     80290 M"unchen
*                     Germany
*
*    Paragon(TM) is a trademark of Intel Corporation.
*
******************************************************************************/
/******************************************************************************

  nx.h,v
  1995/02/09 10:53:25
  1.6
  Exp
  lamberts
 
  Authors: Stefan Lamberts

  Description: External function and procedure definition

******************************************************************************/
/* rcs_id: "nx.h,v 1.6 1995/02/09 10:53:25 lamberts Exp" */



#ifndef __nx_h
#define __nx_h

#include <sys/types.h>

#include <sys/nxesize.h>

/*
 * Invalid ptype
 */
#define INVALID_PTYPE -1

/*
 * First number in the force type message type
 */
#define FORCE_TYPE 1073741824

/*
 * Message passing information array
 */
extern long msginfo[8];

#define HOST myhost()

/* DECLVOID handling omitted--deemed unnecessary. Also don't need to prefix a
   function declaration with extern keyword.  Only data declarations. */

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#if defined(__cplusplus) || defined(__STDC__)
#define _P(a) a
#else
#define _P(a) ()
#endif /* __cplusplus || __STDC__ */

void    cprobe     _P(( long typesel ));
void    cprobex    _P(( long typesel, long nodesel, long ptypesel, 
                       long info[] ));
void    crecv      _P(( long typesel, char *buf, long count ));
void    crecvx     _P(( long typesel, char *buf, long count, long nodesel,
                    long ptypesel, long info[] ));
void    csend      _P(( long type, char *buf, long count, long node,
                       long ptype ));
void    csendrecv  _P(( long type, char *sbuf, long scount, long node,
                       long ptype, long typesel, char *rbuf, long rcount ));
void    etos       _P(( esize_t e, char *s ));
void    flick      _P(( void ));
void    flushmsg   _P(( long typesel, long nodesel, long ptypesel ));
void    gcol       _P(( char x[], long xlen, char y[], long ylen,
                       long *ncnt ));
void    gcolx      _P(( char x[], long xlens[], char y[] ));
void    gdhigh     _P(( double x[], long n, double work[] ));
void    gdlow      _P(( double x[], long n, double work[] ));
void    gdprod     _P(( double x[], long n, double work[] ));
void    gdsum      _P(( double x[], long n, double work[] ));
void    giand      _P(( long x[], long n, long work[] ));
void    gihigh     _P(( long x[], long n, long work[] ));
void    gilow      _P(( long x[], long n, long work[] ));
void    gior       _P(( long x[], long n, long work[] ));
void    giprod     _P(( long x[], long n, long work[] ));
void    gisum      _P(( long x[], long n, long work[] ));
void    gland      _P(( long x[], long n, long work[] ));
void    glor       _P(( long x[], long n, long work[] ));
void    gopf       _P(( char x[], long xlen, char work[],
                       long (*function)() ));
void    gsendx     _P(( long type, char *buf, long count,
                       long nodes[], long nodecount ));
void    gshigh     _P(( float x[], long n, float work[] ));
void    gslow      _P(( float x[], long n, float work[] ));
void    gsprod     _P(( float x[], long n, float work[] ));
void    gssum      _P(( float x[], long n, float work[] ));
void    gsync      _P(( void ));
void    hrecv      _P(( long typesel, char *buf, long count,
                       void (*handler)() ));
void    hrecvx     _P(( long typesel, char *buf, long count, long nodesel,
                       long ptypesel, void (*xhandler)(), long hparam ));
void    hsend      _P(( long type, char *buf, long count, long node,
                       long ptype,
                       void (*handler)() ));
void    hsendx     _P(( long type, char *buf, long count, long node,
                       long ptype, void (*xhandler)(), long hparam ));
void    hsendrecv  _P(( long type, char *sbuf, long scount, long node,
                       long ptype, long typesel, char *rbuf, long rcount,
                       void (*handler)() ));
void    led        _P(( long state ));
void    msgcancel  _P(( long mid ));
void    msgignore  _P(( long mid ));
void    msgwait    _P(( long mid ));
void    nx_perror  _P(( char *string ));
void    setptype   _P(( long ptype ));
esize_t eadd       _P(( esize_t e1, esize_t e2 ));
long    ecmp       _P(( esize_t e1, esize_t e2 ));
long    ediv       _P(( esize_t e, long n ));
esize_t emul       _P(( esize_t e, long n ));
esize_t esub       _P(( esize_t e1, esize_t e2 ));
esize_t stoe       _P(( char *s ));
double  dclock     _P(( void ));
long    infocount  _P(( void ));
long    infonode   _P(( void ));
long    infoptype  _P(( void ));
long    infotype   _P(( void ));
long    iprobe     _P(( long typesel ));
long    iprobex    _P(( long typesel, long nodesel, long ptypesel,
                       long info[] ));
long    irecv      _P(( long typesel, char *buf, long count ));
long    irecvx     _P(( long typesel, char *buf, long count, long nodesel,
                       long ptypesel, long info[] ));
long    isend      _P(( long type, char *buf, long count, long node,
                       long ptype ));
long    isendrecv  _P(( long type, char *sbuf, long scount, long node,
                       long ptype, long typesel, char *rbuf, long rcount ));
long    masktrap   _P(( long state ));
long    msgdone    _P(( long mid ));
long    msgmerge   _P(( long mid1, long mid2 ));
long    myhost     _P(( void ));
long    mynode     _P(( void ));
long    myptype    _P(( void ));
long    numnodes   _P(( void ));
long    nx_initve  _P(( char *partition, long size, char *account,
                       long *argc, char *argv[] ));
long    nx_loadve  _P(( long node_list[], long numnodes, long ptype,
                       long pid_list[], char *pathname,
                       char *argv[], char *envp[] ));
long    nx_load    _P(( long node_list[], long numnodes, long ptype,
                      long pid_listp[], char *pathname ));
long    nx_waitall _P(( void ));
long    _cprobe    _P(( long ));
long    _cprobex   _P(( long, long, long, long * ));
long    _crecv     _P(( long, void *, long ));
long    _crecvx    _P(( long, void *, long, long, long, long * ));
long    _csend     _P(( long, void *, long, long, long ));
long    _csendrecv _P(( long, void *, long, long, long, long, void *, long ));
double  _dclock    _P(( void ));
esize_t _eadd      _P(( esize_t, esize_t ));
long    _ecmp      _P(( esize_t, esize_t ));
long    _ediv      _P(( esize_t, long ));
esize_t _emul      _P(( esize_t, long ));
esize_t _esub      _P(( esize_t, esize_t ));
long    _etos      _P(( esize_t, char * ));
esize_t _stoe      _P(( char * ));
long    _flick     _P(( void ));
long    _flushmsg  _P(( long, long, long ));
long    _gcol      _P(( void *, long, void *, long, long * ));
long    _gcolx     _P(( void *, long *, void * ));
long    _gdhigh    _P(( double *, long, double * ));
long    _gdlow     _P(( double *, long, double * ));
long    _gdprod    _P(( double *, long, double * ));
long    _gdsum     _P(( double *, long, double * ));
long    _giand     _P(( long *, long, long * ));
long    _gihigh    _P(( long *, long, long * ));
long    _gilow     _P(( long *, long, long * ));
long    _gior      _P(( long *, long, long * ));
long    _giprod    _P(( long *, long, long * ));
long    _gisum     _P(( long *, long, long * ));
long    _gland     _P(( long *, long, long * ));
long    _glor      _P(( long *, long, long * ));
long    _gopf      _P(( void *, long, void *, long (*function)() ));
long    _gsendx    _P(( long, void *, long, long *, long ));
long    _gshigh    _P(( float *, long, float * ));
long    _gslow     _P(( float *, long, float * ));
long    _gsprod    _P(( float *, long, float * ));
long    _gssum     _P(( float *, long, float * ));
long    _gsync     _P(( void ));
long    _hrecv     _P(( long, void *, long, void (*handler)() ));
long    _hrecvx    _P(( long, void *, long, long, long, void (*xhandler)(),
                       long ));
long    _hsend     _P(( long, void *, long, long, long, void (*handler)() ));
long    _hsendx    _P(( long, void *, long, long, long, void (*xhandler)(),
                       long ));
long    _hsendrecv _P(( long, void *, long, long, long, long, void *, long,
                       void (*handler)() ));
long    _infocount _P(( void ));
long    _infonode  _P(( void ));
long    _infoptype _P(( void ));
long    _infotype  _P(( void ));
long    _iprobe    _P(( long ));
long    _iprobex   _P(( long, long, long, long * ));
long    _irecv     _P(( long, void *, long ));
long    _irecvx    _P(( long, void *, long, long, long, long * ));
long    _isend     _P(( long, void *, long, long, long ));
long    _isendrecv _P(( long, void *, long, long, long, long, void *, long ));
long    _led       _P(( long ));
long    _masktrap  _P(( long  ));
long    _msgcancel _P(( long ));
long    _msgdone   _P(( long ));
long    _msgmerge  _P(( long, long ));
long    _msgignore _P(( long ));
long    _msgwait   _P(( long ));
long    _myhost    _P(( void ));
long    _mynode    _P(( void ));
long    _numnodes  _P(( void ));
long    _setptype  _P(( long  ));

#ifdef __cplusplus
int main_nxlib_( int argc, char *argv[] );
};
#endif /* __cplusplus */

#endif /* __nx_h */
