/******************************************************************************
*
*    Configuration header file
*    Copyright (C) 1993 A. Bode, S. Lamberts, T. Ludwig, G. Stellner
*
*    This file is part of NXLIB (Paragon(TM) message passing on workstations)
*
*    NXLIB is free software; you can redistribute it and/or
*    modify it under the terms of the GNU Library General Public
*    License as published by the Free Software Foundation; either
*    version 2 of the License, or (at your option) any later version.
*
*    NXLIB is distributed in the hope that it will be useful,
*    but WITHOUT ANY WARRANTY; without even the implied warranty of
*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
*    Library General Public License for more details.
*
*    You should have received a copy of the GNU Library General Public
*    License along with this library; if not, write to the Free
*    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*
*    Contact to the authors:
*
*    electronic mail: nxlib@informatik.tu-muenchen.de
*
*    paper mail:      Prof. Dr. A. Bode
*                     Lehrstuhl f"ur Rechnertechnik und Rechnerorganisation
*                     Institut f"ur Informatik
*                     Technische Universit"at M"unchen
*                     80290 M"unchen
*                     Germany
*
*    Paragon(TM) is a trademark of Intel Corporation.
*
******************************************************************************/
/******************************************************************************

  config.h,v
  1996/10/16 15:18:18
  1.12
  Exp
  lamberts
 
  Authors: Stefan Lamberts

  Description: Configuration header file

  Available functions from this module:

******************************************************************************/
#ifndef lint
static char rcs_id_config_h[] = "config.h,v 1.12 1996/10/16 15:18:18 lamberts Exp";
#endif


/*
 * Filename of the nx daemon
 */
#define NXDAEMONNAME "nxdaemon"

/*
 * Full pathname of the rsh command
 */
#ifdef HP_UX
#define RSHPATH "/usr/bin/remsh"
#endif
#ifdef SGI_IRIX
#define RSHPATH "/usr/bsd/rsh"
#endif
#ifdef SUN_OS4
#define RSHPATH "/usr/ucb/rsh"
#endif
#ifdef SUN_OS5
#define RSHPATH "/usr/bin/rsh"
#endif
#ifdef RS6K_AIX
#define RSHPATH "/usr/bin/rsh"
#endif
#ifdef ALPHA_AXP
#define RSHPATH "/bin/rsh"
#endif
#ifdef LINUX
#define RSHPATH "/usr/bin/rsh"
#endif


/*
 * Filename of the rsh command
 */
#ifdef HP_UX
#define RSHNAME "remsh"
#else
#define RSHNAME "rsh"
#endif

/*
 * Portnumbers which might be used
 */
#define START_PORT							4000
#define END_PORT								7000

/*
 * Max number of connection requests on one socket
 */
#define MAXSOCKCONN 5

/*
 * Default TCP receive and send buffer size
 */
#define DEFAULT_TCP_BUFFER_SIZE 32768

/*
 * Time in seconds and microseconds after which a SIGARLM is raised.
 * This is necessaru only on Linux systems since SIGIO doesn't work 
 * propperly.
 */

#ifdef ALRM_POLL
#define ALRM_POLL_TV_SEC 0
#define ALRM_POLL_TV_USEC 500
#endif
