/******************************************************************************
*
*    Implementation of global calls
*    Copyright (C) 1993 A. Bode, S. Lamberts, T. Ludwig, G. Stellner
*
*    This file is part of NXLIB (Paragon(TM) message passing on workstations)
*
*    NXLIB is free software; you can redistribute it and/or
*    modify it under the terms of the GNU Library General Public
*    License as published by the Free Software Foundation; either
*    version 2 of the License, or (at your option) any later version.
*
*    NXLIB is distributed in the hope that it will be useful,
*    but WITHOUT ANY WARRANTY; without even the implied warranty of
*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
*    Library General Public License for more details.
*
*    You should have received a copy of the GNU Library General Public
*    License along with this library; if not, write to the Free
*    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*
*    Contact to the authors:
*
*    electronic mail: nxlib@informatik.tu-muenchen.de
*
*    paper mail:      Prof. Dr. A. Bode
*                     Lehrstuhl f"ur Rechnertechnik und Rechnerorganisation
*                     Institut f"ur Informatik
*                     Technische Universit"at M"unchen
*                     80290 M"unchen
*                     Germany
*
*    Paragon(TM) is a trademark of Intel Corporation.
*
******************************************************************************/
/******************************************************************************

  global_calls.c,v
  1995/02/06 16:11:38
  1.11
  Exp
  lamberts
 
  Authors: Stefan Lamberts

  Description: Implementation of global calls

  Available functions from this module:

******************************************************************************/
#ifndef lint
static char rcs_id[] = "global_calls.c,v 1.11 1995/02/06 16:11:38 lamberts Exp";
#endif


#include <stdlib.h>
#include <string.h>

#ifdef SUN_OS4
#include <memory.h>             /* Should be included in string.h */
#endif

#include "../include/sys/nxlib.h"
#include "../include/nxmalloc.h"

extern long __myhost();
extern long __mynode();
extern long __myptype();
extern long __numnodes();
extern int  _rel_send();
extern void _rel_wait_msg();

static unsigned element_size;
static char *xarray;
static char *yarray;
static long xlength;
static long ylength;
static long *numcount;
static long (*gfunction)();
static int g_funct_complete;


/*****************************************************************************/
long __gdhigh
#ifdef ANSI
(char *xvec, char *wvec)
#else
(xvec, wvec)
char *xvec;
char *wvec;
#endif
/*****************************************************************************/
{
  long i;
  double *x = (double *)xvec;
  double *w = (double *)wvec;

  for (i = 0; i < xlength; i++)
    if (x[i] < w[i])
      x[i] = w[i];

  return (0);
}


/*****************************************************************************/
long __gihigh
#ifdef ANSI
(char *xvec, char *wvec)
#else
(xvec, wvec)
char *xvec;
char *wvec;
#endif
/*****************************************************************************/
{
  long i;
  long *x = (long *)xvec;
  long *w = (long *)wvec;

  for (i = 0; i < xlength; i++)
    if (x[i] < w[i])
      x[i] = w[i];

  return (0);
}

  


/*****************************************************************************/
long __gshigh
#ifdef ANSI
(char *xvec, char *wvec)
#else
(xvec, wvec)
char *xvec;
char *wvec;
#endif
/*****************************************************************************/
{
  long i;
  float *x = (float *)xvec;
  float *w = (float *)wvec;

  for (i = 0; i < xlength; i++)
    if (x[i] < w[i])
      x[i] = w[i];

  return (0);
}


/*****************************************************************************/
long __gdlow
#ifdef ANSI
(char *xvec, char *wvec)
#else
(xvec, wvec)
char *xvec;
char *wvec;
#endif
/*****************************************************************************/
{
  long i;
  double *x = (double *)xvec;
  double *w = (double *)wvec;

  for (i = 0; i < xlength; i++)
    if (x[i] > w[i])
      x[i] = w[i];

  return (0);
}


/*****************************************************************************/
long __gilow
#ifdef ANSI
(char *xvec, char *wvec)
#else
(xvec, wvec)
char *xvec;
char *wvec;
#endif
/*****************************************************************************/
{
  long i;
  long *x = (long *)xvec;
  long *w = (long *)wvec;

  for (i = 0; i < xlength; i++)
    if (x[i] > w[i])
      x[i] = w[i];

  return (0);
}

  

/*****************************************************************************/
long __gslow
#ifdef ANSI
(char *xvec, char *wvec)
#else
(xvec, wvec)
char *xvec;
char *wvec;
#endif
/*****************************************************************************/
{
  long i;
  float *x = (float *)xvec;
  float *w = (float *)wvec;

  for (i = 0; i < xlength; i++)
    if (x[i] > w[i])
      x[i] = w[i];

  return (0);
}


/*****************************************************************************/
long __gdprod
#ifdef ANSI
(char *xvec, char *wvec)
#else
(xvec, wvec)
char *xvec;
char *wvec;
#endif
/*****************************************************************************/
{
  long i;
  double *x = (double *)xvec;
  double *w = (double *)wvec;

  for (i = 0; i < xlength; i++)
    x[i] *= w[i];

  return (0);
}


/*****************************************************************************/
long __giprod
#ifdef ANSI
(char *xvec, char *wvec)
#else
(xvec, wvec)
char *xvec;
char *wvec;
#endif
/*****************************************************************************/
{
  long i;
  long *x = (long *)xvec;
  long *w = (long *)wvec;

  for (i = 0; i < xlength; i++)
    x[i] *= w[i];

  return (0);
}

  
/*****************************************************************************/
long __gsprod
#ifdef ANSI
(char *xvec, char *wvec)
#else
(xvec, wvec)
char *xvec;
char *wvec;
#endif
/*****************************************************************************/
{
  long i;
  float *x = (float *)xvec;
  float *w = (float *)wvec;

  for (i = 0; i < xlength; i++)
    x[i] *= w[i];

  return (0);
}



/*****************************************************************************/
long __gdsum
#ifdef ANSI
(char *xvec, char *wvec)
#else
(xvec, wvec)
char *xvec;
char *wvec;
#endif
/*****************************************************************************/
{
  long i;
  double *x = (double *)xvec;
  double *w = (double *)wvec;

  for (i = 0; i < xlength; i++)
    x[i] += w[i];

  return (0);
}



/*****************************************************************************/
long __gisum
#ifdef ANSI
(char *xvec, char *wvec)
#else
(xvec, wvec)
char *xvec;
char *wvec;
#endif
/*****************************************************************************/
{
  long i;
  long *x = (long *)xvec;
  long *w = (long *)wvec;

  for (i = 0; i < xlength; i++)
    x[i] += w[i];

  return (0);
}

  
/*****************************************************************************/
long __gssum
#ifdef ANSI
(char *xvec, char *wvec)
#else
(xvec, wvec)
char *xvec;
char *wvec;
#endif
/*****************************************************************************/
{
  long i;
  float *x = (float *)xvec;
  float *w = (float *)wvec;

  for (i = 0; i < xlength; i++)
    x[i] += w[i];

  return (0);
}



/*****************************************************************************/
long __giand
#ifdef ANSI
(char *xvec, char *wvec)
#else
(xvec, wvec)
char *xvec;
char *wvec;
#endif
/*****************************************************************************/
{
  long i;
  long *x = (long *)xvec;
  long *w = (long *)wvec;

  for (i = 0; i < xlength; i++)
    x[i] &= w[i];

  return (0);
}



/*****************************************************************************/
long __gior
#ifdef ANSI
(char *xvec, char *wvec)
#else
(xvec, wvec)
char *xvec;
char *wvec;
#endif
/*****************************************************************************/
{
  long i;
  long *x = (long *)xvec;
  long *w = (long *)wvec;

  for (i = 0; i < xlength; i++)
    x[i] |= w[i];

  return (0);
}

  

/*****************************************************************************/
long __gland
#ifdef ANSI
(char *xvec, char *wvec)
#else
(xvec, wvec)
char *xvec;
char *wvec;
#endif
/*****************************************************************************/
{
  long i;
  long *x = (long *)xvec;
  long *w = (long *)wvec;

  for (i = 0; i < xlength; i++)
    x[i] = (x[i] && w[i]);

  return (0);
}



/*****************************************************************************/
long __glor
#ifdef ANSI
(char *xvec, char *wvec)
#else
(xvec, wvec)
char *xvec;
char *wvec;
#endif
/*****************************************************************************/
{
  long i;
  long *x = (long *)xvec;
  long *w = (long *)wvec;

  for (i = 0; i < xlength; i++)
    x[i] = (x[i] || w[i]);

  return (0);
}

  





/*****************************************************************************/
int _da_gfunct
#ifdef ANSI
(msg_desc *msgd)
#else
(msgd)
msg_desc *msgd;
#endif
/*****************************************************************************/
{
  long i;
  msg_ca_gfunct *msg;
  char *data;
  
  msg = (msg_ca_gfunct *)msgd->msg_ptr;

  data = msgd->msg_ptr + sizeof(msg_ca_gfunct);
  
  switch (msg->gtype)
  {
  case GSYNC:
    break;

  case GCOL:
    if (msg->ylen != 0)
    {
      if (ylength <= msg->ylen)
        memcpy((void *)yarray, (void *)data, (size_t)ylength);
      else 
        memcpy((void *)yarray, (void *)data, (size_t)msg->ylen);
    }
    
    *numcount = msg->ylen;
    break;

  case GCOLX:
    if (msg->ylen != 0)
    {
      if (ylength <= msg->ylen)
        memcpy((void *)yarray, (void *)data, (size_t)ylength);
      else 
        memcpy((void *)yarray, (void *)data, (size_t)msg->ylen);
    }
    break;
    
  default:
    for (i = 0; i < __numnodes(); i++)
    {
      memcpy((void*)yarray, (void *)data, (size_t)(xlength*element_size));
      if (i != __mynode())
      {
        gfunction(xarray,yarray);
      }
      data += (xlength*element_size);
    }
    break;
  }
  
  g_funct_complete = 1;

  return(0);
}



/*****************************************************************************/
int g_f_complete
#ifdef ANSI
(void)
#else
()
#endif
/*****************************************************************************/
{
  return (g_funct_complete == 0);
}

    


/*****************************************************************************/
long _gfunct
#ifdef ANSI
(int gtype, unsigned elsize,
 char *x, long xlen, char *y, long ylen,
 long *ncnt_xlen, long (*function)())
#else
(gtype, elsize, x, xlen, y, ylen, ncnt_xlens, function)
int gtype;
unsigned elsize;
char *x;
long xlen;
char *y;
long ylen;
long *ncnt_xlens;
long (*function)();
#endif
/*****************************************************************************/
{
  msg_ac_gfunct *omsg;
  char *msg;
  char *data;
  int i;
  long offset;
  
  switch (gtype)
  {
  case GCOLX:
    yarray = y;
    for (i=0, ylength = 0; i < __numnodes(); ylength += ncnt_xlens[i++]);
    for (i=0, offset = 0; i < __mynode(); offset += ncnt_xlens[i++]);
    break;
    
  case GCOL:
    yarray = y;
    ylength = ylen;
    numcount = ncnt_xlens;
    break;
    
  default:    
    element_size = elsize;
    xarray = x;
    xlength = xlen;
    yarray = y;
    gfunction = function;
    break;
  }
  
  
  if ((msg = malloc((size_t)(sizeof(msg_ac_gfunct)+(xlen*elsize))))
       == (char *)0)
    return (-1);

  omsg = (msg_ac_gfunct *)msg; 
  data = msg + sizeof(msg_ac_gfunct);

  omsg->node = __mynode();
  omsg->ptype = __myptype();
  omsg->gtype = gtype;
  omsg->xlen = xlen*elsize;
  omsg->ylen = ylength;
  omsg->offs = offset;
  
  /* Copy the data */
  if (omsg->xlen > 0)
    memcpy((void *)data, (void *)x, (size_t)omsg->xlen);
  
  _rel_disable();

  g_funct_complete = 0;
  
  if (_rel_send((long)AD_GFUNCT,
                msg,
                (long)(sizeof(msg_ac_gfunct)+omsg->xlen),
                __mynode(),
                (long)DAEMON_PTYPE) < 0)
  {
    _rel_enable();
    return (-1);
  }
  
  _rel_enable();
  
  free((void *)msg);

  _rel_wait_msg(g_f_complete);
  
  return (0);
}


  
/*****************************************************************************/
int _ad_gfunct
#ifdef ANSI
(msg_desc msgd*)
#else
(msgd)
msg_desc *msgd;
#endif
/*****************************************************************************/
{
  
  /* Forward message to the controlling process */
  if (_rel_send((long)DC_GFUNCT,
                msgd->msg_ptr,
                msgd->msg_len,
                __myhost(),
                (long)CP_PTYPE) < 0)
    return (-1);

  return (0);
}


/*****************************************************************************/
int _cd_gfunct
#ifdef ANSI
(msg_desc msgd*)
#else
(msgd)
msg_desc *msgd;
#endif
/*****************************************************************************/
{
  msg_ca_gfunct *msg;

  msg = (msg_ca_gfunct *)msgd->msg_ptr;
  
  /* Forward message to the application process */
  if (_rel_send((long)DA_GFUNCT,
                msgd->msg_ptr,
                msgd->msg_len,
                __mynode(),
                msg->ptype) < 0)
    return (-1);

  return (0);
}



