/******************************************************************************
*
*    Administration of global calls
*    Copyright (C) 1993 A. Bode, S. Lamberts, T. Ludwig, G. Stellner
*
*    This file is part of NXLIB (Paragon(TM) message passing on workstations)
*
*    NXLIB is free software; you can redistribute it and/or
*    modify it under the terms of the GNU Library General Public
*    License as published by the Free Software Foundation; either
*    version 2 of the License, or (at your option) any later version.
*
*    NXLIB is distributed in the hope that it will be useful,
*    but WITHOUT ANY WARRANTY; without even the implied warranty of
*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
*    Library General Public License for more details.
*
*    You should have received a copy of the GNU Library General Public
*    License along with this library; if not, write to the Free
*    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*
*    Contact to the authors:
*
*    electronic mail: nxlib@informatik.tu-muenchen.de
*
*    paper mail:      Prof. Dr. A. Bode
*                     Lehrstuhl f"ur Rechnertechnik und Rechnerorganisation
*                     Institut f"ur Informatik
*                     Technische Universit"at M"unchen
*                     80290 M"unchen
*                     Germany
*
*    Paragon(TM) is a trademark of Intel Corporation.
*
******************************************************************************/
/******************************************************************************

  global_admin.c,v
  1996/06/28 13:37:32
  1.9
  Exp
  lamberts
 
  Authors: Stefan Lamberts

  Description: Administration of global calls

  Available functions from this module: ....

******************************************************************************/
#ifndef lint
static char rcs_id[] = "global_admin.c,v 1.9 1996/06/28 13:37:32 lamberts Exp";
#endif

#include <stdlib.h>
#include <string.h>

#ifdef SUN_OS4
#include <memory.h>
#endif

#include "../include/sys/nxlib.h"
#include "../include/nxmalloc.h"

extern long __numnodes();
extern void _dbgmsg();
extern int  _rel_send();


static gc_list_el *first_gc = (gc_list_el *)0;

/*****************************************************************************/
static gc_list_el *ins_gc
#ifdef ANSI
(long ptype, int gtype, long xlen, long ylen)
#else
(ptype, gtype, xlen, ylen)
long ptype;
int gtype;
long xlen;
long ylen;
#endif
/*****************************************************************************/
{
  gc_list_el *el;
  gc_list_el *next;
  int i;
  
  if ((el = (gc_list_el *)malloc(sizeof(gc_list_el))) == (gc_list_el *)0)
    return (el);
  
  el->ptype = ptype;
  el->gtype = gtype;
  el->done = 0;
  
  switch (gtype)
  {
  case GSYNC:
    break;
    
  case GCOL:
    el->ylen = 0;
    if ((el->vardata = (gc_var_dat *)malloc((size_t)(sizeof(gc_var_dat *)*
                                                     __numnodes())))
        == (gc_var_dat *)0)
      return ((gc_list_el *)0);
    for (i = 0; i < __numnodes(); i++)
    {
      el->vardata[i].len = 0;
      el->vardata[i].data = (char *)0;
    }
    break;

  case GCOLX:
    el->ylen = ylen;
    if ((el->rmsg = (char *)malloc((size_t)(sizeof(msg_ca_gfunct) + ylen)))
        == (char *)0)
      return ((gc_list_el *)0);
    el->data = el->rmsg + sizeof(msg_ca_gfunct);
    break;
    
  default:
    el->xlen = xlen;
    if ((el->rmsg = (char *)malloc((size_t)(sizeof(msg_ca_gfunct) +
                                            (xlen * __numnodes()))))
        == (char *)0)
      return ((gc_list_el *)0);
    el->data = el->rmsg + sizeof(msg_ca_gfunct);
    break;
  }

  if ((next = first_gc) != (gc_list_el *)0)
    next->prev = el;
  first_gc = el;
  el->prev = (gc_list_el *)0;
  el->next = next;
  
  return (el);
}

    
/*****************************************************************************/
static gc_list_el *find_gc
#ifdef ANSI
(long ptype)
#else
(ptype)
long ptype;
#endif
/*****************************************************************************/
{
  gc_list_el *ptr;

  for (ptr = first_gc;
       (ptr != (gc_list_el *)0) && (ptr->ptype != (ptype));
       ptr = ptr->next);
  
  return (ptr);
}


/*****************************************************************************/
static int rm_gc
#ifdef ANSI
(gc_list_el *el)
#else
(el)
gc_list_el *el;
#endif
/*****************************************************************************/
{
  gc_list_el *prev;
  gc_list_el *next;
  
  if ((prev = el->prev) == (gc_list_el *)0)
    first_gc = el->next;
  else
    prev->next = el->next;

  if ((next = el->next) != (gc_list_el *)0)
    next->prev = prev;

  free((void *)el);

  return (0);
}

  


/*****************************************************************************/
int _dc_gfunct
#ifdef ANSI
(msg_desc msgd*)
#else
(msgd)
msg_desc *msgd;
#endif
/*****************************************************************************/
{
  gc_list_el *el;
  msg_ac_gfunct *imsg;
  char *data;
  msg_ca_gfunct *omsg;
  char *rmsg;
  long rmsglen;
  char *mptr;
  int i;
  
  imsg = (msg_ac_gfunct *)msgd->msg_ptr;

  data = msgd->msg_ptr + sizeof(msg_ac_gfunct);
  
  if (((el = find_gc(imsg->ptype)) == (gc_list_el *)0) &&
      ((el = ins_gc(imsg->ptype,
                    imsg->gtype,
                    imsg->xlen,
                    imsg->ylen)) == (gc_list_el *)0))
    return (-1);
    
  if (el->gtype != imsg->gtype)
  {
    _dbgmsg("Different global operations with one ptype.");
    return (-1);
  }
  switch (imsg->gtype)
  {
  case GSYNC:
    break;
  case GCOL:
    el->ylen += imsg->xlen;
    el->vardata[imsg->node].len = imsg->xlen;
    if (imsg->xlen > 0)
    {
      if ((el->vardata[imsg->node].data = malloc((size_t)imsg->xlen))
          == (char *)0)
        return (-1);
      memcpy((void *)el->vardata[imsg->node].data,
             (void *)data,
             (size_t)imsg->xlen);
    }
    break;

  case GCOLX:
    if (el->ylen < imsg->ylen)
    {
      el->ylen = imsg->ylen;
      if ((el->rmsg = (char *)realloc((void *)el->rmsg,
                                      (size_t)(sizeof(msg_ca_gfunct) +
                                               el->ylen)))
          == (char *)0)
        return (-1);
      el->data = el->rmsg + sizeof(msg_ca_gfunct);
    }
    if (imsg->xlen > 0)
      memcpy((void *)&el->data[imsg->offs],
             (void *)data,
             (size_t)imsg->xlen);
    break;
      
  default:
    if (el->xlen != imsg->xlen)
    {
      _dbgmsg("Different vector length in global operation");
      return (-1);
    }
    if (el->xlen > 0)
      memcpy((void *)&el->data[imsg->node * el->xlen],
             (void *)data,
             (size_t)el->xlen);
    break;
  }
  el->done++;

  if (el->done != __numnodes())
    return (0);
  
  /* Global operation completed */
  switch (el->gtype)
  {
  case GSYNC:
    if ((rmsg = malloc(sizeof(msg_ca_gfunct))) == (char *)0)
      return (-1);
    rmsglen = sizeof(msg_ca_gfunct);
    break;

  case GCOL:
    if ((rmsg = malloc((size_t)(sizeof(msg_ca_gfunct)+el->ylen)))
        == (char *)0)
      return (-1);
    for (mptr = rmsg + sizeof(msg_ca_gfunct), i=0;
         i < __numnodes();
         mptr += el->vardata[i].len, i++)
    {
      if (el->vardata[i].len > 0)
      {
        memcpy((void *)mptr,
               (void *)el->vardata[i].data,
               (size_t)el->vardata[i].len);
        free((void *)el->vardata[i].data);
      }
    }
    rmsglen = sizeof(msg_ca_gfunct) + el->ylen;
    free((void *)el->vardata);
    break;

  case GCOLX:
    rmsg = el->rmsg;
    rmsglen = sizeof(msg_ca_gfunct) + el->ylen;
    break;

  default:
    rmsg = el->rmsg;
    rmsglen = sizeof(msg_ca_gfunct) + (el->xlen * __numnodes());
    break;
  }    

  omsg = (msg_ca_gfunct *)rmsg;
  
  omsg->ptype = el->ptype;
  omsg->gtype = el->gtype;
  omsg->ylen = el->ylen;
    

  for (i = 0; i < __numnodes(); i++)
    if (_rel_send((long)CD_GFUNCT,
                  rmsg,
                  rmsglen,
                  (long)i,
                  (long)DAEMON_PTYPE) < 0)
    return (-1);

  free((void *)rmsg);

  if (rm_gc(el) < 0)
    return (-1);
  
  return (0);
}



