/******************************************************************************
*
*    Buffermanagement for h-calls (Interrupt driven message passing)
*    Copyright (C) 1993 A. Bode, S. Lamberts, T. Ludwig, G. Stellner
*
*    This file is part of NXLIB (Paragon(TM) message passing on workstations)
*
*    NXLIB is free software; you can redistribute it and/or
*    modify it under the terms of the GNU Library General Public
*    License as published by the Free Software Foundation; either
*    version 2 of the License, or (at your option) any later version.
*
*    NXLIB is distributed in the hope that it will be useful,
*    but WITHOUT ANY WARRANTY; without even the implied warranty of
*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
*    Library General Public License for more details.
*
*    You should have received a copy of the GNU Library General Public
*    License along with this library; if not, write to the Free
*    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*
*    Contact to the authors:
*
*    electronic mail: nxlib@informatik.tu-muenchen.de
*
*    paper mail:      Prof. Dr. A. Bode
*                     Lehrstuhl f"ur Rechnertechnik und Rechnerorganisation
*                     Institut f"ur Informatik
*                     Technische Universit"at M"unchen
*                     80290 M"unchen
*                     Germany
*
*    Paragon(TM) is a trademark of Intel Corporation.
*
******************************************************************************/
/******************************************************************************

  h_buffer.c,v
  1995/02/06 16:04:48
  1.6
  Exp
  lamberts
 
  Authors: Stefan Lamberts

  Description: Buffermanagement for h-calls (Interrupt driven message passing)

  Available functions from this module: .....

******************************************************************************/
#ifndef lint
static char rcs_id[] = "h_buffer.c,v 1.6 1995/02/06 16:04:48 lamberts Exp";
#endif

#include <errno.h>

#include "../include/sys/nxerrno.h"
#include "../include/sys/nxlib.h"

extern long __myptype();
extern int  _rm_call();
extern int  _del_call();

static buf_c_el *first_to_handle = (buf_c_el *)0;
static buf_c_el *last_to_handle = (buf_c_el *)0;
static long trap_mask = 0;       /* 0 Enables receive traps
                                   1 Disables receive traps */
static int handling_hcalls = 0; /* This variable is necessary if masktrap()
                                 * is called within a handler function.
                                 * It disables recursiv calls of
                                 * _handle_hcalls() */


/*****************************************************************************/
int _ins_hnd
#ifdef ANSI
(buf_c_el *bce)
#else
(bce)
buf_c_el *bce;
#endif
/*****************************************************************************/
{
  
  if (last_to_handle == (buf_c_el *)0)
  {
    first_to_handle = bce;
    last_to_handle = bce;
    bce->h_next = (buf_c_el *)0;
    bce->h_prev = (buf_c_el *)0;
    return (0);
  }

  last_to_handle->h_next = bce;
  bce->h_prev = last_to_handle;
  last_to_handle = bce;

  return (0);
}


/*****************************************************************************/
static int rm_hnd
#ifdef ANSI
(buf_c_el *bce)
#else
(bce)
buf_c_el *bce;
#endif
/*****************************************************************************/
{
  buf_c_el *prev;
  buf_c_el *next;

  prev = bce->h_prev;
  next = bce->h_next;
  
  if (next == (buf_c_el *)0)
    last_to_handle = prev;
  else
    next->h_prev = prev;

  if (prev == (buf_c_el *)0)
    first_to_handle = next;
  else
    prev->h_next = next;

  bce->h_prev = (buf_c_el *)0;
  bce->h_next = (buf_c_el *)0;

  return (0);
}


/*****************************************************************************/
int _handle_hcalls
#ifdef ANSI
(void)
#else
()
#endif
/*****************************************************************************/
{
  buf_c_el *bce;
  buf_c_el *next;
  
  handling_hcalls = 1;

  if (trap_mask == 0)
  {
    for (bce = first_to_handle; bce != (buf_c_el *)0; bce = next)
    {
      if ((bce->el_type == HSENDX) ||(bce->el_type == HRECVX))
      {
        next = bce->h_next;
      
        /* Remove call */
        if (rm_hnd(bce) < 0)
        {
          handling_hcalls = 0;
          return (-1);
        }

        if (_rm_call(bce) < 0)
        {
          handling_hcalls = 0;
          return (-1);
        }

        /* Execute handler function */
        bce->handler(bce->msg_type,
                     bce->msg_len,
                     bce->s_node,
                     bce->s_ptype,
                     bce->hparam);

        /* Delete call */

        if (_del_call(bce) < 0)
        {
          handling_hcalls = 0;
          return (-1);
        }
      }
    }
  }

  handling_hcalls = 0;
  return (0);
}


/*****************************************************************************/
long _set_trap_mask
#ifdef ANSI
(long state)
#else
(state)
long state;
#endif
/*****************************************************************************/
{
  long old_state;

  if ((state != 0) && (state != 1))
  {
    errno = EINVAL;
    return (-1);
  }

  old_state = trap_mask;

  trap_mask = state;

  if (!handling_hcalls)
    if (_handle_hcalls() < 0)
      return (-1);
  
  return (old_state);
}

