/******************************************************************************
*
*    Buffermanagement for send and receive calls
*    Copyright (C) 1993 A. Bode, S. Lamberts, T. Ludwig, G. Stellner
*
*    This file is part of NXLIB (Paragon(TM) message passing on workstations)
*
*    NXLIB is free software; you can redistribute it and/or
*    modify it under the terms of the GNU Library General Public
*    License as published by the Free Software Foundation; either
*    version 2 of the License, or (at your option) any later version.
*
*    NXLIB is distributed in the hope that it will be useful,
*    but WITHOUT ANY WARRANTY; without even the implied warranty of
*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
*    Library General Public License for more details.
*
*    You should have received a copy of the GNU Library General Public
*    License along with this library; if not, write to the Free
*    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*
*    Contact to the authors:
*
*    electronic mail: nxlib@informatik.tu-muenchen.de
*
*    paper mail:      Prof. Dr. A. Bode
*                     Lehrstuhl f"ur Rechnertechnik und Rechnerorganisation
*                     Institut f"ur Informatik
*                     Technische Universit"at M"unchen
*                     80290 M"unchen
*                     Germany
*
*    Paragon(TM) is a trademark of Intel Corporation.
*
******************************************************************************/
/******************************************************************************

  call_buffer.c,v
  1995/02/14 07:34:03
  1.9
  Exp
  lamberts
 
  Authors: Stefan Lamberts

  Description: Buffermanagement for send and receive calls

  Available functions from this module: ....

******************************************************************************/
#ifndef lint
static char rcs_id[] = "call_buffer.c,v 1.9 1995/02/14 07:34:03 lamberts Exp";
#endif

#include <errno.h>
#include <stdlib.h>

#include "../include/sys/nxerrno.h"
#include "../include/sys/nxlib.h"
#include "../include/nxmalloc.h"

extern long __numnodes();
extern long __myptype();
extern int  _confirm_msg();

static pt_tab_c_el *ptt[PT_TAB_C_SIZE];


/*****************************************************************************/
int _init_c_buf
#ifdef ANSI
(void)
#else
()
#endif
/*****************************************************************************/
{
  int i;

  for (i=0; i < PT_TAB_C_SIZE; i++)
    ptt[i] = (pt_tab_c_el *)0;

  return (0);
}

  

/*****************************************************************************/
static pt_tab_c_el *find_c_pel
#ifdef ANSI
(long ptype)
#else
(ptype)
long ptype;
#endif
/*****************************************************************************/
{
  int ind;
  pt_tab_c_el *ptr;

  ind = (int)ptype%PT_TAB_C_SIZE;

  for (ptr = ptt[ind]; ptr != (pt_tab_c_el *)0;  ptr = ptr->bucket)
    if (ptr->ptype == ptype)
      return (ptr);
  
  return (ptr);
}


/*****************************************************************************/
static int ins_c_pel
#ifdef ANSI
(pt_tab_c_el *pel)
#else
(pel)
pt_tab_c_el *pel;
#endif
/*****************************************************************************/
{
  int ind;
  pt_tab_c_el *ptr;
  
  ind = (int)pel->ptype%PT_TAB_C_SIZE;

  if (ptt[ind] == (pt_tab_c_el *)0)
  {
    ptt[ind] = pel;
    return (0);
  }
  
  /* Check wether there is already an element with that ptype */
  for (ptr = ptt[ind];
       ((ptr->bucket != (pt_tab_c_el *)0) || (ptr->ptype == pel->ptype));
       ptr = ptr->bucket);
  
  if (ptr->ptype == pel->ptype)
  {
    errno = ENXLBUF;              /* LAMBO: Internal error */
    return (1);
  }
  
  /* Append to the bucket list */
  ptr->bucket = pel;
  pel->bucket = (pt_tab_c_el *)0;
  
  return (0);
}



/*****************************************************************************/
static pt_tab_c_el *create_c_pel
#ifdef ANSI
(long ptype)
#else
(ptype)
long ptype;
#endif
/*****************************************************************************/
{
  pt_tab_c_el *ptr;

  if ((ptr = (pt_tab_c_el *)malloc(sizeof(pt_tab_c_el))) == (pt_tab_c_el *)0)
    return (ptr);

  ptr->ptype = ptype;
  ptr->first = (buf_c_el *)0;
  ptr->last = (buf_c_el *)0;
  ptr->bucket = (pt_tab_c_el *)0;

  return (ptr);
}



  
/*****************************************************************************/
buf_c_el *_find_rec_call
#ifdef ANSI
(long r_ptype, long msg_type, long s_node, long s_ptype, int status)
#else
(r_ptype, msg_type, s_node, s_ptype, status)
long r_ptype;
long msg_type;
long s_node;
long s_ptype;
int status;
#endif
/*****************************************************************************/
{
  pt_tab_c_el *pel;
  buf_c_el *bce;

  /* LAMBO: Theese parameter checks are neceassary */
  if (((r_ptype < 0) || (r_ptype > MAXPTYPE)) ||

      ((msg_type < 0) || 
       ((msg_type >= MAXUMT) && (msg_type < MAXSMT)) ||
       (msg_type >= MAXFMT)) ||

      ((s_node < 0) || (s_node > __numnodes())) ||

      ((s_ptype < 0) || (s_ptype > MAXPTYPE)))
  {
    errno = EINVAL;
    return ((buf_c_el *)0);
  }

  if ((pel = find_c_pel(r_ptype)) == (pt_tab_c_el *)0)
    return ((buf_c_el *)0);

  for (bce = pel->first; bce != (buf_c_el *)0; bce = bce->pt_next)
    if (((bce->el_type == IRECVX) || (bce->el_type == HRECVX)) &&
        /* Force type messages only match expicit msg_type */
        ((bce->msg_type == msg_type) ||
         ((msg_type < MAXSMT) && (bce->msg_type == -1))) &&
        ((bce->s_node == -1) || (bce->s_node == s_node)) &&
        ((bce->s_ptype == -1) || (bce->s_ptype == s_ptype)) &&
        (bce->status == status))
      return (bce);

  return (bce);
}



  
/*****************************************************************************/
buf_c_el *_find_snd_call
#ifdef ANSI
(long s_ptype,long r_node, long r_ptype, int status)
#else
(s_ptype, r_node, r_ptype, status)
long s_ptype;
long r_node;
long r_ptype;
int status;
#endif
/*****************************************************************************/
{
  pt_tab_c_el *pel;
  buf_c_el *bce;
  
  /* LAMBO: Theese parameter checks are neceassary */
  if (((s_ptype < 0) || (s_ptype > MAXPTYPE)) ||

      ((r_node < 0) || (r_node > __numnodes())) ||

      ((r_ptype < 0) || (r_ptype > MAXPTYPE)))
  {
    errno = EINVAL;
    return ((buf_c_el *)0);
  }

  if ((pel = find_c_pel(s_ptype)) == (pt_tab_c_el *)0)
    return ((buf_c_el *)0);

  for (bce = pel->first; bce != (buf_c_el *)0; bce = bce->pt_next)
    if (((bce->el_type == ISEND) || (bce->el_type == HSENDX)) &&
        (bce->r_node == r_node) &&
        (bce->r_ptype == r_ptype) &&
        (bce->status == status))
      return (bce);
  
  return (bce);
}




/*****************************************************************************/
int _rm_call
#ifdef ANSI
(buf_c_el *bce)
#else
(bce)
buf_c_el *bce;
#endif
/*****************************************************************************/
{
  pt_tab_c_el *pel;
  buf_c_el *prev;
  buf_c_el *next;
  long ptype;
  
  if (bce == (buf_c_el *)0)
  {
    errno = EINVAL;
    return (-1);
  }
  
  switch (bce->el_type)
  {
  case IRECVX:
  case HRECVX:
    ptype = bce->r_ptype;
    break;
  case ISEND:
  case HSENDX:
    ptype = bce->s_ptype;
    break;
  default:
    errno = ENOSYS;
    return (-1);
  }
      
  if ((ptype < 0) || (ptype > MAXPTYPE))
  {
    errno = EINVAL;
    return (-1);
  }

  if ((pel = find_c_pel(ptype)) == (pt_tab_c_el *)0)
  {
    errno = ENXLBUF;              /* LAMBO Internal error */
    return (-1);
  }

  if ((prev = bce->pt_prev) == (buf_c_el *)0)
    pel->first = bce->pt_next;
  else
    prev->pt_next = bce->pt_next;

  if ((next = bce->pt_next) == (buf_c_el *)0)
    pel->last = bce->pt_prev;
  else
    next->pt_prev = bce->pt_prev;

  return (0);
}


/*****************************************************************************/
int _ins_call
#ifdef ANSI
(buf_c_el *bce)
#else
(bce)
buf_c_el *bce;
#endif
/*****************************************************************************/
{
  pt_tab_c_el *pel;
  buf_c_el *last;
  long ptype;
  
  if (bce == (buf_c_el *)0)
  {
    errno = EINVAL;
    return (-1);
  }
  
  switch (bce->el_type)
  {
  case IRECVX:
  case HRECVX:
    ptype = bce->r_ptype;
    break;
  case ISEND:
  case HSENDX:
    ptype = bce->s_ptype;
    break;
  default:
    errno = ENOSYS;
    return (-1);
  }

  if ((ptype < 0) || (ptype > MAXPTYPE))
  {
    errno = EINVAL;
    return (-1);
  }

  if ((pel = find_c_pel(ptype)) == (pt_tab_c_el *)0)
  {
    if ((pel = create_c_pel(ptype)) == (pt_tab_c_el *)0)
      return (-1);

    if (ins_c_pel(pel) < 0)
      return (-1);
  }
      
  if ((last = pel->last) == (buf_c_el *)0)
  {
    pel->first = bce;
    bce->pt_prev = (buf_c_el *)0;
  }
  else
  {
    last->pt_next = bce;
    bce->pt_prev = last;
  }
  
  pel->last = bce;
  bce->pt_next = (buf_c_el *)0;

  return (0);
}


  
/*****************************************************************************/
buf_c_el *_create_call
#ifdef ANSI
(int el_type,
 long msg_type, char *buf, long count,
 long r_node, long r_ptype, long s_node, long s_ptype,
 void (*handler)(), long hparam, long *info)
#else
(el_type,
 msg_type, buf, count,
 r_node, r_ptype, s_node, s_ptype,
 handler, hparam, info)
int el_type;
long msg_type;
char *buf;
long count;
long r_node;
long r_ptype;
long s_node;
long s_ptype;
void (*handler)();
long hparam;
long *info;
#endif
/*****************************************************************************/
{
  buf_c_el *bcel;

#ifdef CBVERBOSE
  switch (el_type)
  {
  case IRECVX:
    _dbgmsg("IR N: %ld P: %ld T: %ld",s_node,s_ptype,msg_type);
    break;
  case HRECVX:
    _dbgmsg("HR N: %ld P: %ld T: %ld",s_node,s_ptype,msg_type);
    break;
  case ISEND:
    _dbgmsg("IS N: %ld P: %ld T: %ld",r_node,r_ptype,msg_type);
    break;
  case HSENDX:
    _dbgmsg("HS N: %ld P: %ld T: %ld",r_node,r_ptype,msg_type);
    break;
  }
#endif

  if ((bcel = (buf_c_el *)malloc(sizeof(buf_c_el))) == (buf_c_el *)0)
    return (bcel);
  
  bcel->el_type = el_type;
  bcel->msg_id = UNDEF_MSGID;
  bcel->status = CALL_PENDING;
  bcel->ignore = CALL_NOIGNORE;
  bcel->errno = 0;
  bcel->msg_type = msg_type;
  bcel->s_node = s_node;
  bcel->s_ptype = s_ptype;
  bcel->r_node = r_node;
  bcel->r_ptype = r_ptype;
  bcel->buf = buf;
  bcel->msg_len = 0;
  bcel->count = count;
  bcel->info = info;
  bcel->handler = handler;
  bcel->hparam = hparam;

  bcel->pt_next = (buf_c_el *)0;
  bcel->pt_prev = (buf_c_el *)0;
  bcel->id_next = (buf_c_el *)0;
  bcel->h_next = (buf_c_el *)0;
  bcel->h_prev = (buf_c_el *)0;
  
  return (bcel);
}


/*****************************************************************************/
int _del_call
#ifdef ANSI
(buf_c_el *bce)
#else
(bce)
buf_c_el *bce;
#endif
/*****************************************************************************/
{
  free((void *)bce);

  return (0);
}


  
/*****************************************************************************/
int _conf_calls
#ifdef ANSI
(void)
#else
()
#endif
/*****************************************************************************/
{
  pt_tab_c_el *pel;
  buf_c_el *bce,*next_bce;
  
  if (__myptype() < 0)
  {
    errno = EQNOSET;
    return (-1);
  }

  if ((pel = find_c_pel(__myptype())) == (pt_tab_c_el *)0)
    return (0);

  for (bce = pel->first; bce != (buf_c_el *)0; bce = next_bce)
  {
    next_bce = bce->pt_next;
    
    if (((bce->el_type == IRECVX) || (bce->el_type == HRECVX)) &&
        (bce->status == CALL_RECEIVED))
    {
      if (_confirm_msg(bce->s_node, bce->s_ptype) < 0)
        return (-1);

      if (bce->ignore == CALL_IGNORE)
      {
        if (_rm_call(bce) < 0)
          return (-1);
        if (_del_call(bce) < 0)
          return (-1);
      }
      else
        bce->status = CALL_DONE;
    }
  }
  
  return (0);
}

