/******************************************************************************
*
*    Send messages from the buffer layer
*    Copyright (C) 1993 A. Bode, S. Lamberts, T. Ludwig, G. Stellner
*
*    This file is part of NXLIB (Paragon(TM) message passing on workstations)
*
*    NXLIB is free software; you can redistribute it and/or
*    modify it under the terms of the GNU Library General Public
*    License as published by the Free Software Foundation; either
*    version 2 of the License, or (at your option) any later version.
*
*    NXLIB is distributed in the hope that it will be useful,
*    but WITHOUT ANY WARRANTY; without even the implied warranty of
*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
*    Library General Public License for more details.
*
*    You should have received a copy of the GNU Library General Public
*    License along with this library; if not, write to the Free
*    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*
*    Contact to the authors:
*
*    electronic mail: nxlib@informatik.tu-muenchen.de
*
*    paper mail:      Prof. Dr. A. Bode
*                     Lehrstuhl f"ur Rechnertechnik und Rechnerorganisation
*                     Institut f"ur Informatik
*                     Technische Universit"at M"unchen
*                     80290 M"unchen
*                     Germany
*
*    Paragon(TM) is a trademark of Intel Corporation.
*
******************************************************************************/
/******************************************************************************

  buf_send.c,v
  1994/08/29 12:51:03
  1.4
  Exp
  lamberts
 
  Authors: Stefan Lamberts

  Description: Send messages form the buffer layer

  Available functions from this module: ....

******************************************************************************/
#ifndef lint
static char rcs_id[] = "buf_send.c,v 1.4 1994/08/29 12:51:03 lamberts Exp";
#endif

#include <errno.h>

#include "../include/sys/nxerrno.h"
#include "../include/sys/nxlib.h"

extern long      __mynode();
extern long      __myptype();
extern int       _conf_calls();
extern int       _conf_msgs();
extern int       _del_call();
extern buf_c_el *_find_snd_call();
extern int       _handle_hcalls();
extern int       _ins_hnd();
extern int       _rel_send();
extern int       _rm_call();

#ifdef XPARAGON
extern void _xp_send_prot();
#endif


/*****************************************************************************/
int _aa_confirm
#ifdef ANSI
(msg_desc *msgd)
#else
(msgd)
msg_desc *msgd;
#endif
/*****************************************************************************/
{
  msg_aa_confirm *msg;
  buf_c_el *bce;

  msg = (msg_aa_confirm *)msgd->msg_ptr;
  
  if ((bce = _find_snd_call(msg->s_ptype,
                            msg->r_node, msg->r_ptype,
                            CALL_SENT)) == (buf_c_el *)0)
  {
    errno = ENXLBUF;
    return (-1);
  }

#ifdef BSVERBOSE
  _dbgmsg("RC N: %ld P: %ld T: %ld",
          bce->r_node,
          bce->r_ptype,
          bce->msg_type);
#endif

  bce->status = CALL_DONE;
  
  if (bce->el_type == ISEND) 
  {
    if (bce->ignore == CALL_IGNORE)
    {
      if (_rm_call(bce) < 0)
        return (-1);
      if (_del_call(bce) < 0)
        return (-1);
    }
  }
  else                          /* HSENDX */
  {
    if (_ins_hnd(bce) < 0)
      return (-1);
    if (_handle_hcalls() < 0)
      return (-1);
  }
  
  return (0);
}



/*****************************************************************************/
int _buf_send
#ifdef ANSI
(long s_ptype, long r_node, long r_ptype)
#else
(s_ptype, r_node, r_ptype)
long s_ptype;
long r_node;
long r_ptype;
#endif
/*****************************************************************************/
{
  buf_c_el *bce;

  if ((bce = _find_snd_call(s_ptype, r_node, r_ptype, CALL_PENDING))
      == (buf_c_el *)0)
  {
    errno = ENXLBUF;
    return (-1);
  }

#ifdef BSVERBOSE
  _dbgmsg("BS N: %ld P: %ld T: %ld",
          bce->r_node,
          bce->r_ptype,
          bce->msg_type);
#endif

  bce->status = CALL_SENT;      /* Set status to CALL_SENT before successful
                                   compeltion of _rel_send() for messages
                                   sent to myself */

  if (_rel_send(bce->msg_type,
                bce->buf,
                bce->count,
                bce->r_node,
                bce->r_ptype) < 0)
    return (-1);

#ifdef XPARAGON
  /* Send a protocol of the send to the XPARAGON */
  _xp_send_prot(__mynode(),r_node);
#endif

  return (0);
}





/*****************************************************************************/
int _confirm_msg
#ifdef ANSI
(long node, long ptype)
#else
(node, ptype)
long node;
long ptype;
#endif
/*****************************************************************************/
{
  msg_aa_confirm msg;

  msg.r_node = __mynode();
  msg.r_ptype = __myptype();
  msg.s_ptype = ptype;
  
#ifdef BSVERBOSE
  _dbgmsg("SC N: %ld P: %ld",
          node,
          ptype);
#endif

  if (_rel_send((long)AA_CONFIRM,
                (char *)&msg,
                (long)sizeof(msg_aa_confirm),
                node,
                ptype) < 0)
    return (-1);

  return (0);
}


/*****************************************************************************/
int _confirm_messages
#ifdef ANSI
(void)
#else
()
#endif
/*****************************************************************************/
{
  if (_conf_calls() < 0)
    return (-1);

  if (_conf_msgs() < 0)
    return (-1);

  return (0);
}
