/******************************************************************************
*
*    malloc.c (disable messages during standard malloc calls)
*    Copyright (C) 1993 A. Bode, S. Lamberts, T. Ludwig, G. Stellner
*
*    This file is part of NXLIB (Paragon(TM) message passing on workstations)
*
*    NXLIB is free software; you can redistribute it and/or
*    modify it under the terms of the GNU Library General Public
*    License as published by the Free Software Foundation; either
*    version 2 of the License, or (at your option) any later version.
*
*    NXLIB is distributed in the hope that it will be useful,
*    but WITHOUT ANY WARRANTY; without even the implied warranty of
*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
*    Library General Public License for more details.
*
*    You should have received a copy of the GNU Library General Public
*    License along with this library; if not, write to the Free
*    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*
*    Contact to the authors:
*
*    electronic mail: nxlib@informatik.tu-muenchen.de
*
*    paper mail:      Prof. Dr. A. Bode
*                     Lehrstuhl f"ur Rechnertechnik und Rechnerorganisation
*                     Institut f"ur Informatik
*                     Technische Universit"at M"unchen
*                     80290 M"unchen
*                     Germany
*
*    Paragon(TM) is a trademark of Intel Corporation.
*
******************************************************************************/
/******************************************************************************

  nxmalloc.c,v
  1995/02/09 10:31:33
  1.6
  Exp
  lamberts
 
  Authors: Stefan Lamberts

  Description:

    This file contains stubs for malloc calls which might cause problems.
    It is necessary that messages are disabled during memmory allocation
    system  calls.

  Available functions from this module:

     
******************************************************************************/
#ifndef lint
static char rcs_id[] = "nxmalloc.c,v 1.6 1995/02/09 10:31:33 lamberts Exp";
#endif


#include <stdio.h>
#include <malloc.h>
#include <stdlib.h>

extern void _rel_disable();
extern void _rel_enable();

void *nxlib_malloc(size)
size_t size;
{
  void *res;

  _rel_disable();
  res = malloc(size);
  _rel_enable();
  return(res);
}

void nxlib_free(ptr)
void *ptr;
{
  _rel_disable();
  free(ptr);
  _rel_enable();
  return;
}

void *nxlib_realloc(ptr,size)
void *ptr;
size_t size;
{
  void *res;

  _rel_disable();
  res = realloc(ptr,size);
  _rel_enable();
  return(res);
}

void *nxlib_calloc(nelem,size)
size_t nelem;
size_t size;
{
  void *res;

  _rel_disable();
  res = calloc(nelem,size);
  _rel_enable();
  return(res);
}


