/******************************************************************************
**  xvmstat.c -- snapshot vm_statistics on service nodes
**
**  to compile:  cc -o xvmstat xvmstat.c -lnx
**  to run:  xvmstatd outputfile&
******************************************************************************/

#include <stdio.h>
#include <nx.h>
#include <mach.h>
#include <stdlib.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <fcntl.h>
#include <sys/time.h>
#include <sys/resource.h>

typedef struct {
   int free;
   int inactive;
   int active;
   int wired;
} PAGE_COUNTS;

typedef struct {
   int pnode;
   PAGE_COUNTS pc;
} PMSG;

char file[256];

#define HOST_PTYPE 0
#define NODE_PTYPE 1

/******************************************************************************
**  main()
******************************************************************************/
main(argc, argv)
int argc;
char **argv;
{
   void host( int);
   void node( void);
   int *p_pid;
   int n;

   sprintf(file, "%s", DEFAULT_FILE);
   if(argc > 1)
	   sprintf(file, "%s", argv[1]);

   if ((n = nx_initve( ".service", NULL, NULL, NULL, NULL)) < 0) {
      perror( "nx_initve");
      exit( -1);
   }
   p_pid = (int *) calloc( n, sizeof(int));
   if ((n = nx_nfork( NULL, -1, NODE_PTYPE, p_pid)) < 0) {
      perror( "nx_nfork");
      exit( -1);
   }
   if (n) {
      setptype( HOST_PTYPE);
      for (;;) {
         host( n);
	 sleep( INTERVAL);
      }
   } else { 
      for (;;) {
         node();
	 sleep( INTERVAL);
      }
   }
   free( p_pid);
}

/******************************************************************************
**  host()
******************************************************************************/
void host( int n)
{
   void vm_stats( PAGE_COUNTS *);
   int compare( PMSG *, PMSG *);
   PMSG *pmsg;
   int i, fd;
   FILE *stream;

   pmsg = (PMSG *) calloc( n, sizeof( PMSG));
   pmsg[0].pnode = _myphysnode();
   vm_stats( &pmsg[0].pc);
   for (i=1; i<n; i++) crecv( -1, &pmsg[i], sizeof( PMSG));
#ifdef DEBUG
  printf("host: crecv's from %d nodes complete\n", n-1);
#endif
   qsort( pmsg, n, sizeof( PMSG), &compare);
   fd = open(file, O_WRONLY|O_CREAT|O_TRUNC,
	      S_IRWXU|S_IRGRP|S_IROTH);
   if (fd < 0) {
       perror( "open");
       exit( -1);
   }
   stream = fdopen( fd, "wb");
   if (stream < 0) {
       perror( "fdopen");
       exit( -1);
   }
   for (i=0; i<n; i++) {
      fprintf( stream, "%d %d %d %d %d\n", pmsg[i].pnode, pmsg[i].pc.free,
	      pmsg[i].pc.inactive, pmsg[i].pc.active, pmsg[i].pc.wired);
   }
#ifdef DEBUG
   printf("host: write to fd %d stream %d complete\n", fd, stream);
#endif
   fclose( stream);
   close( fd);
   free( pmsg);
}

/******************************************************************************
**  node()
******************************************************************************/
void node( void)
{
   void vm_stats( PAGE_COUNTS *);
   PMSG msg;

   if (mynode() != myhost()) {
      msg.pnode = _myphysnode();
      vm_stats( &msg.pc);
      csend( 0, &msg, sizeof( PMSG), myhost(), HOST_PTYPE);
   }
}

/******************************************************************************
**  vm_stats()
******************************************************************************/
void vm_stats( PAGE_COUNTS *ppc)
{
   struct vm_statistics vms;

   vm_statistics( current_task(), &vms);
   ppc->free = vms.free_count;
   ppc->inactive = vms.inactive_count;
   ppc->active = vms.active_count;
   ppc->wired = vms.wire_count;
}

/******************************************************************************
**  compare()
******************************************************************************/
int compare( PMSG *i, PMSG *j)
{
   if (i->pnode < j->pnode)
      return( -1);
   else if (i->pnode > j->pnode)
      return( 1);
   else
      return( 0);
}
