#include <stdio.h>
#include <signal.h>
#include <sys/types.h>
#include <sys/stat.h>

#define SECONDS_PER_REFRESH     15
int width = 200;
int height = 200;
int age = 100000000;
char file[256];

main(argc, argv)
int argc;
char **argv;
{
	if(argc > 1)
		sprintf(file, "%s/%s/xvmstat.dat", FILEROOT, argv[1]);
	else
		sprintf(file, "%s/%s/xvmstat.dat", FILEROOT, DEFAULTMACHINE);

	printf("Using page file %s\n", file);
	init_graphics(width, height, 100, 100);
	read_file(0);
	while(1)
		get_event();
}

#define MAXNODE			64
#define DATAPERNODE		8
int a[MAXNODE][DATAPERNODE];
int procnum[MAXNODE];
int nnode;
char modify_time[64];

read_file(sig)
int sig;
{
	time_t *modify;
	struct stat buf;
	int c, len = 0;
	FILE *fp;
	char line[255];
	int *aa;

/* printf("opening file\n");*/
	if(!(fp = fopen(file, "r"))){
		printf("Page data file %s not found\n", file);
		goto alarmset;
	}

	nnode = 0;
	while(fgets(line, 255, fp)){
		aa = &a[nnode][0];
		sscanf(line, "%d %d %d %d %d\n", &procnum[nnode], aa, aa+1, aa+2, aa+3);
		nnode++;
	}
	fclose(fp);
	stat(file, &buf);
	modify = &buf.st_mtime;
	age = time() - (long)(buf.st_mtime);
	sprintf(modify_time, "Age %d seconds", age);

alarmset:
	erase();
	redraw();
	signal(SIGALRM, read_file);
	alarm(SECONDS_PER_REFRESH);
}

redraw()
{
	int inode, total, graphheight = height - 20;
	double dymin, dymax;
	char num[16];
	int xmin, xmax, id;

	if(age > 300){
		rectangle(0, 0, width, height, 2);
	} else {
		for(inode=0; inode<nnode; inode++){
			xmin = (inode*width)/nnode;
			xmax = ((inode+1)*width)/nnode;
			total = 0;
			for(id=0; id<DATAPERNODE; id++)
				total += a[inode][id];
			dymax = 0.0;
			for(id=0; id<DATAPERNODE; id++){
				dymin = dymax;
				dymax = dymin + (double)(a[inode][id]*graphheight)/total;
				rectangle(xmin, 10+(int)dymin, xmax, 10+(int)dymax, id+2);
			}
			sprintf(num, "%d", procnum[inode]);
			string(xmin,height,num);
		}
	}
	string(5,10,modify_time);
	sendplot();
}
