#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xos.h>
#include <X11/Intrinsic.h>
#include <X11/Shell.h>
#include <stdio.h>
#include "xvmstat.icon"

extern int width, height;

Display *display;
Window win;
int screen;
static GC gc;
int xpix, ypix;
int xorg, yorg;

int colors[256];

int width;
int height;

#define NCOLS          6
int col[NCOLS][3] = 
	{0,0,0,            /* black */
	255,255,255,       /* white */
	127,127,255,       /* blue sky */
	235,201,0,         /* yellow */
	242,165,0,        /* darker yellow */
	255,0,0           /* red */
};

static unsigned char hatch[]={
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x88, 0x44, 0x22, 0x11, 0x88, 0x44, 0x22, 0x11,
	0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55,
	0xff, 0x00, 0xff, 0x00, 0xff, 0x00, 0xff, 0x00
};

int is_color;

init_graphics(passwidth, passheight, winx, winy)
int passwidth, passheight, winx, winy;
{
	char *window_name = "xvmstat";
	XSizeHints size_hints;
	XFontStruct *font_info;
	char *display_name = NULL;
    	unsigned long valuemask = 0; /* ignore XGCvalues and use defaults */
    	XGCValues values;
	XSetWindowAttributes attr;
	Colormap cmap;
	int class;

	if ( !(display=XOpenDisplay(display_name))){
		fprintf( stderr, "Cannot connect to X server %s\n", 
			XDisplayName(display_name));
		exit(1);
	}

	screen = DefaultScreen(display);
	class = DefaultVisual(display, screen)->class;
	is_color = (class == PseudoColor || class == TrueColor);

	win = XCreateSimpleWindow(display, 
		RootWindow(display,screen), 
		winx, winy, 
		width = passwidth, 
		height = passheight, 
		4, 
		WhitePixel(display,screen),
		BlackPixel(display, screen));

	attr.backing_store = Always;
	XChangeWindowAttributes(display, win, CWBackingStore, &attr);

	get_cmap();

	size_hints.flags = PPosition | PSize;
	size_hints.x = winx;
	size_hints.y = winy;
	size_hints.width = width;
	size_hints.height = height;

	XSetStandardProperties(display, win, window_name, NULL, 
	    NULL, NULL, 0, &size_hints);
	XSelectInput(display, win, StructureNotifyMask | ExposureMask);
	load_font(&font_info);
	gc = XCreateGC(display, win, valuemask, &values);
	XSetFont(display, gc, font_info->fid);
	XMapWindow(display, win);
	XSetIconName(display,win,"");
	IconCreate();
	redraw();
	XSync(display, True);
}

load_font(font_info)
XFontStruct **font_info;
{
	char *fontname = "8x13";
	if((*font_info = XLoadQueryFont(display, fontname)) == NULL){
		fprintf(stderr, "Cannot open 9x15 font\n");
		exit(-1);
	}
}

IconCreate()
{
    XWMHints *wmhints;
    Pixmap   icon;
    unsigned long color;

	icon = XCreateBitmapFromData(display,
		win, xvmstat_bits,xvmstat_width,xvmstat_height);

    wmhints = XAllocWMHints();
    if (wmhints != (XWMHints *) NULL) {
	wmhints->initial_state	= NormalState;
	wmhints->input		= True;
	wmhints->icon_pixmap	= icon;
	wmhints->icon_mask	= 1;
	wmhints->icon_x		= 865;
	wmhints->icon_y		= 0;
	wmhints->flags		= StateHint	 |
				  InputHint	 |
				  IconPixmapHint |
				  IconMaskHint	 |
				  IconPositionHint;
	XSetWMHints(display, win, wmhints);
	XFree(wmhints);
    }
}

get_cmap()
{
	int i, ncols, ncolors = 0;
	Colormap cmap;
	XColor xcolor;

	if(is_color)
		ncols = NCOLS;
	else
		ncols = 2;

	cmap = DefaultColormap(display, screen);
		
	for(i=0; i<ncols; i++){
		xcolor.red   = col[i][0]<<8;
		xcolor.green = col[i][1]<<8;
		xcolor.blue  = col[i][2]<<8;
		xcolor.flags = DoRed | DoGreen | DoBlue;
		if(!XAllocColor(display, cmap, &xcolor)){
			fprintf(stderr, "Only %d colors available\n", ncolors);
			break;
		}
		colors[ncolors++] = xcolor.pixel;
	}
}

get_event()
{
	int x, y;
	XEvent report;

	XNextEvent(display, &report);
	switch  (report.type) {
	case Expose:
	case ConfigureNotify:
		if(width != report.xconfigure.width
		|| height != report.xconfigure.height){
			width = report.xconfigure.width;
			height = report.xconfigure.height;
			redraw();
		}
		break;
	}
}

rectangle(x0, y0, x1, y1, shade)
int x0, y0, x1, y1, shade;
{
	int tmp;
	if(x1 < x0){tmp = x0; x0 = x1; x1 = tmp;}
	if(y1 < y0){tmp = y0; y0 = y1; y1 = tmp;}
	setcolor(shade);
	XFillRectangle(display, win, gc, x0, y0, x1-x0+1, y1-y0+1);
}

line(x0, y0, x1, y1, shade)
int x0, y0, x1, y1, shade;
{
	setcolor(shade);
	XDrawLine(display, win, gc, x0, y0, x1, y1);
}

string(x, y, s)
int x, y;
char *s;
{
	setcolor(1);
	XDrawString(display, win, gc, x, y, s, strlen(s));
}

sendplot()
{
	XSync(display, True);
}

setcolor(shade)
int shade;
{
	Pixmap stip;
	if(is_color){
		XSetForeground(display, gc, colors[shade%NCOLS]);
	} else {
		stip = XCreateBitmapFromData(display, RootWindow(display, screen),
			&hatch[8*(shade-1)], 8, 8);
		XSetStipple(display, gc, stip);
		XSetForeground(display, gc, colors[1]);
		XSetFillStyle(display, gc, FillOpaqueStippled);
	}
}

erase()
{
	XSetForeground(display, gc, colors[0]);
	XFillRectangle(display, win, gc, 0, 0, width, height);
}
