/* Character classification and correspondance.
   Copyright (C) 1990 Free Software Foundation, Inc.
   Francois Pinard <pinard@iro.umontreal.ca>, 1988.
*/


/* These introduce 256 character set.  Usually, ISO 8859-1 Latin-1 code is
   used as the underlying character set.  However, if MSDOS is defined,
   IBM-PC's character set code is used instead.  */


#include <stdio.h>
#include "ctype.h"


char _ctype_set[256] =	/* attributes for each character */
 {
   0                          | _C           , /* 00 nul */
   0                          | _C           , /* 01 soh */
   0                          | _C           , /* 02 stx */
   0                          | _C           , /* 03 etx */
   0                          | _C           , /* 04 eot */
   0                          | _C           , /* 05 enq */
   0                          | _C           , /* 06 ack */
   0                          | _C           , /* 07 bel */
   0                          | _C           , /* 08 bs  */
   0                | _S      | _C           , /* 09 ht  */
   0                | _S      | _C           , /* 0a nl  */
   0                | _S      | _C           , /* 0b vt  */
   0                | _S      | _C           , /* 0c np  */
   0                | _S      | _C           , /* 0d cr  */
   0                          | _C           , /* 0e so  */
   0                          | _C           , /* 0f si  */
   0                          | _C           , /* 10 dle */
   0                          | _C           , /* 11 dc1 */
   0                          | _C           , /* 12 dc2 */
   0                          | _C           , /* 13 dc3 */
   0                          | _C           , /* 14 dc4 */
   0                          | _C           , /* 15 nak */
   0                          | _C           , /* 16 syn */
   0                          | _C           , /* 17 etb */
   0                          | _C           , /* 18 can */
   0                          | _C           , /* 19 em  */
   0                          | _C           , /* 1a sub */
   0                          | _C           , /* 1b esc */
   0                          | _C           , /* 1c fs  */
   0                          | _C           , /* 1d gs  */
   0                          | _C           , /* 1e gs  */
   0                          | _C           , /* 1f rs  */
   0                | _S           | _B      , /* 20 spc */
   0                     | _P                , /* 21  !  */
   0                     | _P                , /* 22  "  */
   0                     | _P                , /* 23  #  */
   0                     | _P                , /* 24  $  */
   0                     | _P                , /* 25  %  */
   0                     | _P                , /* 26  &  */
   0                     | _P                , /* 27  '  */
   0                     | _P                , /* 28  (  */
   0                     | _P                , /* 29  )  */
   0                     | _P                , /* 2a  *  */
   0                     | _P                , /* 2b  +  */
   0                     | _P                , /* 2c  ,  */
   0                     | _P                , /* 2d  -  */
   0                     | _P                , /* 2e  .  */
   0                     | _P                , /* 2f  /  */
   0           | _N                     | _X , /* 30  0  */
   0           | _N                     | _X , /* 31  1  */
   0           | _N                     | _X , /* 32  2  */
   0           | _N                     | _X , /* 33  3  */
   0           | _N                     | _X , /* 34  4  */
   0           | _N                     | _X , /* 35  5  */
   0           | _N                     | _X , /* 36  6  */
   0           | _N                     | _X , /* 37  7  */
   0           | _N                     | _X , /* 38  8  */
   0           | _N                     | _X , /* 39  9  */
   0                     | _P                , /* 3a  :  */
   0                     | _P                , /* 3b  ;  */
   0                     | _P                , /* 3c  <  */
   0                     | _P                , /* 3d  =  */
   0                     | _P                , /* 3e  >  */
   0                     | _P                , /* 3f  ?  */
   0                     | _P                , /* 40  @  */
   0 | _U                               | _X , /* 41  A  */
   0 | _U                               | _X , /* 42  B  */
   0 | _U                               | _X , /* 43  C  */
   0 | _U                               | _X , /* 44  D  */
   0 | _U                               | _X , /* 45  E  */
   0 | _U                               | _X , /* 46  F  */
   0 | _U                                    , /* 47  G  */
   0 | _U                                    , /* 48  H  */
   0 | _U                                    , /* 49  I  */
   0 | _U                                    , /* 4a  J  */
   0 | _U                                    , /* 4b  K  */
   0 | _U                                    , /* 4c  L  */
   0 | _U                                    , /* 4d  M  */
   0 | _U                                    , /* 4e  N  */
   0 | _U                                    , /* 4f  O  */
   0 | _U                                    , /* 50  P  */
   0 | _U                                    , /* 51  Q  */
   0 | _U                                    , /* 52  R  */
   0 | _U                                    , /* 53  S  */
   0 | _U                                    , /* 54  T  */
   0 | _U                                    , /* 55  U  */
   0 | _U                                    , /* 56  V  */
   0 | _U                                    , /* 57  W  */
   0 | _U                                    , /* 58  X  */
   0 | _U                                    , /* 59  Y  */
   0 | _U                                    , /* 5a  Z  */
   0                     | _P                , /* 5b  [  */
   0                     | _P                , /* 5c  \  */
   0                     | _P                , /* 5d  ]  */
   0                     | _P                , /* 5e  ^  */
   0                     | _P                , /* 5f  _  */
   0                     | _P                , /* 60  `  */
   0      | _L                          | _X , /* 61  a  */
   0      | _L                          | _X , /* 62  b  */
   0      | _L                          | _X , /* 63  c  */
   0      | _L                          | _X , /* 64  d  */
   0      | _L                          | _X , /* 65  e  */
   0      | _L                          | _X , /* 66  f  */
   0      | _L                               , /* 67  g  */
   0      | _L                               , /* 68  h  */
   0      | _L                               , /* 69  i  */
   0      | _L                               , /* 6a  j  */
   0      | _L                               , /* 6b  k  */
   0      | _L                               , /* 6c  l  */
   0      | _L                               , /* 6d  m  */
   0      | _L                               , /* 6e  n  */
   0      | _L                               , /* 6f  o  */
   0      | _L                               , /* 70  p  */
   0      | _L                               , /* 71  q  */
   0      | _L                               , /* 72  r  */
   0      | _L                               , /* 73  s  */
   0      | _L                               , /* 74  t  */
   0      | _L                               , /* 75  u  */
   0      | _L                               , /* 76  v  */
   0      | _L                               , /* 77  w  */
   0      | _L                               , /* 78  x  */
   0      | _L                               , /* 79  y  */
   0      | _L                               , /* 7a  z  */
   0                     | _P                , /* 7b  {  */
   0                     | _P                , /* 7c  |  */
   0                     | _P                , /* 7d  }  */
   0                     | _P                , /* 7e  ~  */
   0                          | _C           , /* 7f     */

#ifdef MSDOS

   0 | _U                                    , /* 80  C, */
   0      | _L                               , /* 81  u" */
   0      | _L                               , /* 82  e' */
   0      | _L                               , /* 83  a^ */
   0      | _L                               , /* 84  a" */
   0      | _L                               , /* 85  a` */
   0      | _L                               , /* 86  a+ */
   0      | _L                               , /* 87  c, */
   0      | _L                               , /* 88  e^ */
   0      | _L                               , /* 89  e" */
   0      | _L                               , /* 8a  e` */
   0      | _L                               , /* 8b  i" */
   0      | _L                               , /* 8c  i^ */
   0      | _L                               , /* 8d  i` */
   0 | _U                                    , /* 8e  A" */
   0 | _U                                    , /* 8f  A+ */
   0 | _U                                    , /* 90  E' */
   0      | _L                               , /* 91  ae */
   0 | _U                                    , /* 92  AE */
   0      | _L                               , /* 93  o^ */
   0      | _L                               , /* 94  o" */
   0      | _L                               , /* 95  o` */
   0      | _L                               , /* 96  u^ */
   0      | _L                               , /* 97  u` */
   0      | _L                               , /* 98  y" */
   0 | _U                                    , /* 99  O" */
   0 | _U                                    , /* 9a  U" */
   0                     | _P                , /* 9b  c| */
   0                     | _P                , /* 9c  ## */
   0                     | _P                , /* 9d  y- */
   0                     | _P                , /* 9e     */
   0                     | _P                , /* 9f     */
   0      | _L                               , /* a0  a' */
   0      | _L                               , /* a1  i' */
   0      | _L                               , /* a2  o' */
   0      | _L                               , /* a3  u' */
   0      | _L                               , /* a4  n~ */
   0 | _U                                    , /* a5  N~ */
   0      | _L                               , /* a6  a- */
   0      | _L                               , /* a7  o- */
   0                     | _P                , /* a8  ?? */
   0                     | _P                , /* a9     */
   0                     | _P                , /* aa  -. */
   0                     | _P                , /* ab  12 */
   0                     | _P                , /* ac  14 */
   0                     | _P                , /* ad  !! */
   0                     | _P                , /* ae  << */
   0                     | _P                , /* af  >> */
   0                     | _P                , /* b0   # */
   0                     | _P                , /* b1   # */
   0                     | _P                , /* b2   # */
   0                     | _P                , /* b3   | */
   0                     | _P                , /* b4   + */
   0                     | _P                , /* b5   | */
   0                     | _P                , /* b6   + */
   0                     | _P                , /* b7   + */
   0                     | _P                , /* b8   = */
   0                     | _P                , /* b9   = */
   0                     | _P                , /* ba   | */
   0                     | _P                , /* bb   = */
   0                     | _P                , /* bc   = */
   0                     | _P                , /* bd   + */
   0                     | _P                , /* be   = */
   0                     | _P                , /* bf   + */
   0                     | _P                , /* c0   + */
   0                     | _P                , /* c1   + */
   0                     | _P                , /* c2   + */
   0                     | _P                , /* c3   + */
   0                     | _P                , /* c4   - */
   0                     | _P                , /* c5   + */
   0                     | _P                , /* c6   | */
   0                     | _P                , /* c7   + */
   0                     | _P                , /* c8   = */
   0                     | _P                , /* c9   = */
   0                     | _P                , /* ca   = */
   0                     | _P                , /* cb   = */
   0                     | _P                , /* cc   = */
   0                     | _P                , /* cd   = */
   0                     | _P                , /* ce   = */
   0                     | _P                , /* cf   = */
   0                     | _P                , /* d0   + */
   0                     | _P                , /* d1   = */
   0                     | _P                , /* d2   + */
   0                     | _P                , /* d3   + */
   0                     | _P                , /* d4   = */
   0                     | _P                , /* d5   = */
   0                     | _P                , /* d6   + */
   0                     | _P                , /* d7   + */
   0                     | _P                , /* d8   = */
   0                     | _P                , /* d9   + */
   0                     | _P                , /* da   + */
   0                     | _P                , /* db   # */
   0                     | _P                , /* dc   # */
   0                     | _P                , /* dd   # */
   0                     | _P                , /* de   # */
   0                     | _P                , /* df   # */
   0                     | _P                , /* e0   a */
   0                     | _P                , /* e1  ss */
   0                     | _P                , /* e2   G */
   0                     | _P                , /* e3   p */
   0                     | _P                , /* e4   S */
   0                     | _P                , /* e5   s */
   0                     | _P                , /* e6  uu */
   0                     | _P                , /* e7   t */
   0                     | _P                , /* e8   F */
   0                     | _P                , /* e9   h */
   0                     | _P                , /* ea   O */
   0                     | _P                , /* eb   d */
   0                     | _P                , /* ec     */
   0                     | _P                , /* ed   f */
   0                     | _P                , /* ee     */
   0                     | _P                , /* ef     */
   0                     | _P                , /* f0     */
   0                     | _P                , /* f1  +- */
   0                     | _P                , /* f2  >= */
   0                     | _P                , /* f3  <= */
   0                     | _P                , /* f4     */
   0                     | _P                , /* f5     */
   0                     | _P                , /* f6  // */
   0                     | _P                , /* f7  ~~ */
   0                     | _P                , /* f8  ++ */
   0                     | _P                , /* f9     */
   0                     | _P                , /* fa     */
   0                     | _P                , /* fb     */
   0                     | _P                , /* fc  nn */
   0                     | _P                , /* fd  22 */
   0                     | _P                , /* fe     */
   0                          | _C           , /* ff     */

#else /* not MSDOS */

   0                          | _C           , /* 80     */
   0                          | _C           , /* 81     */
   0                          | _C           , /* 82     */
   0                          | _C           , /* 83     */
   0                          | _C           , /* 84     */
   0                          | _C           , /* 85     */
   0                          | _C           , /* 86     */
   0                          | _C           , /* 87     */
   0                          | _C           , /* 88     */
   0                          | _C           , /* 89     */
   0                          | _C           , /* 8a     */
   0                          | _C           , /* 8b     */
   0                          | _C           , /* 8c     */
   0                          | _C           , /* 8d     */
   0                          | _C           , /* 8e     */
   0                          | _C           , /* 8f     */
   0                          | _C           , /* 90     */
   0                          | _C           , /* 91     */
   0                          | _C           , /* 92     */
   0                          | _C           , /* 93     */
   0                          | _C           , /* 94     */
   0                          | _C           , /* 95     */
   0                          | _C           , /* 96     */
   0                          | _C           , /* 97     */
   0                          | _C           , /* 98     */
   0                          | _C           , /* 99     */
   0                          | _C           , /* 9a     */
   0                          | _C           , /* 9b     */
   0                          | _C           , /* 9c     */
   0                          | _C           , /* 9d     */
   0                          | _C           , /* 9e     */
   0                          | _C           , /* 9f     */
   0                     | _P                , /* a0 nsp */
   0                     | _P                , /* a1  !! */
   0                     | _P                , /* a2  c| */
   0                     | _P                , /* a3  ## */
   0                     | _P                , /* a4  cu */
   0                     | _P                , /* a5  y- */
   0                     | _P                , /* a6  || */
   0                     | _P                , /* a7  $$ */
   0                     | _P                , /* a8  "" */
   0                     | _P                , /* a9  cO */
   0                     | _P                , /* aa  a- */
   0                     | _P                , /* ab  << */
   0                     | _P                , /* ac  -. */
   0                     | _P                , /* ad  -- */
   0                     | _P                , /* ae  tO */
   0                     | _P                , /* af mac */
   0                     | _P                , /* b0  ++ */
   0                     | _P                , /* b1  +- */
   0                     | _P                , /* b2  22 */
   0                     | _P                , /* b3  33 */
   0                     | _P                , /* b4  '' */
   0                     | _P                , /* b5  uu */
   0                     | _P                , /* b6 pil */
   0                     | _P                , /* b7  .. */
   0                     | _P                , /* b8  ,, */
   0                     | _P                , /* b9  11 */
   0                     | _P                , /* ba  o- */
   0                     | _P                , /* bb  >> */
   0                     | _P                , /* bc  14 */
   0                     | _P                , /* bd  12 */
   0                     | _P                , /* be  34 */
   0                     | _P                , /* bf  ?? */
   0 | _U                                    , /* c0  A` */
   0 | _U                                    , /* c1  A' */
   0 | _U                                    , /* c2  A^ */
   0 | _U                                    , /* c3  A~ */
   0 | _U                                    , /* c4  A" */
   0 | _U                                    , /* c5  A+ */
   0 | _U                                    , /* c6  AE */
   0 | _U                                    , /* c7  C, */
   0 | _U                                    , /* c8  E` */
   0 | _U                                    , /* c9  E' */
   0 | _U                                    , /* ca  E^ */
   0 | _U                                    , /* cb  E" */
   0 | _U                                    , /* cc  I` */
   0 | _U                                    , /* cd  I' */
   0 | _U                                    , /* ce  I^ */
   0 | _U                                    , /* cf  I" */
   0 | _U                                    , /* d0  DD */
   0 | _U                                    , /* d1  N~ */
   0 | _U                                    , /* d2  O` */
   0 | _U                                    , /* d3  O' */
   0 | _U                                    , /* d4  O^ */
   0 | _U                                    , /* d5  O~ */
   0 | _U                                    , /* d6  O" */
   0                     | _P                , /* d7  xx */
   0 | _U                                    , /* d8  O/ */
   0 | _U                                    , /* d9  U` */
   0 | _U                                    , /* da  U' */
   0 | _U                                    , /* db  U^ */
   0 | _U                                    , /* dc  U" */
   0 | _U                                    , /* dd  Y' */
   0 | _U                                    , /* de  PP */
   0      | _L                               , /* df  ss */
   0      | _L                               , /* e0  a` */
   0      | _L                               , /* e1  a' */
   0      | _L                               , /* e2  a^ */
   0      | _L                               , /* e3  a~ */
   0      | _L                               , /* e4  a" */
   0      | _L                               , /* e5  a+ */
   0      | _L                               , /* e6  ae */
   0      | _L                               , /* e7  c, */
   0      | _L                               , /* e8  e` */
   0      | _L                               , /* e9  e' */
   0      | _L                               , /* ea  e^ */
   0      | _L                               , /* eb  e" */
   0      | _L                               , /* ec  i` */
   0      | _L                               , /* ed  i' */
   0      | _L                               , /* ee  i^ */
   0      | _L                               , /* ef  i" */
   0      | _L                               , /* f0  dd */
   0      | _L                               , /* f1  n~ */
   0      | _L                               , /* f2  o` */
   0      | _L                               , /* f3  o' */
   0      | _L                               , /* f4  o^ */
   0      | _L                               , /* f5  o~ */
   0      | _L                               , /* f6  o" */
   0                     | _P                , /* f7  // */
   0      | _L                               , /* f8  o/ */
   0      | _L                               , /* f9  u` */
   0      | _L                               , /* fa  u' */
   0      | _L                               , /* fb  u^ */
   0      | _L                               , /* fc  u" */
   0      | _L                               , /* fd  y' */
   0      | _L                               , /* fe  pp */
   0      | _L                               , /* ff  y" */

#endif /* not MSDOS */
 };


#ifdef MSDOS

char _ctype_lower[256] =	/* lower case equivalents */
  {
	'\000',	'\001',	'\002',	'\003',	'\004',	'\005',	'\006',	'\007',
	'\010',	'\011',	'\012',	'\013',	'\014',	'\015',	'\016',	'\017',
	'\020',	'\021',	'\022',	'\023',	'\024',	'\025',	'\026',	'\027',
	'\030',	'\031',	'\032',	'\033',	'\034',	'\035',	'\036',	'\037',
	' ',	'!',	'"',	'#',	'$',	'%',	'&',	'\'',
	'(',	')',	'*',	'+',	',',	'-',	'.',	'/',
	'0',	'1',	'2',	'3',	'4',	'5',	'6',	'7',
	'8',	'9',	':',	';',	'<',	'=',	'>',	'?',
	'@',	'a',	'b',	'c',	'd',	'e',	'f',	'g',
	'h',	'i',	'j',	'k',	'l',	'm',	'n',	'o',
	'p',	'q',	'r',	's',	't',	'u',	'v',	'w',
	'x',	'y',	'z',	'[',	'\\',	']',	'^',	'_',
	'`',	'a',	'b',	'c',	'd',	'e',	'f',	'g',
	'h',	'i',	'j',	'k',	'l',	'm',	'n',	'o',
	'p',	'q',	'r',	's',	't',	'u',	'v',	'w',
	'x',	'y',	'z',	'{',	'|',	'}',	'~',	'\177',
	'\227',	'\201',	'\202',	'\203',	'\204',	'\205',	'\206',	'\207',
	'\210',	'\211',	'\212',	'\213',	'\214',	'\215',	'\204',	'\206',
	'\202',	'\221',	'\221',	'\223',	'\224',	'\225',	'\226',	'\227',
	'\230',	'\224',	'\201',	'\233',	'\234',	'\235',	'\236',	'\237',
	'\240',	'\241',	'\242',	'\243',	'\244',	'\244',	'\246',	'\247',
	'\250',	'\251',	'\252',	'\253',	'\254',	'\255',	'\256',	'\257',
	'\260',	'\261',	'\262',	'\263',	'\264',	'\265',	'\266',	'\267',
	'\270',	'\271',	'\272',	'\273',	'\274',	'\275',	'\276',	'\277',
	'\300',	'\301',	'\302',	'\303',	'\304',	'\305',	'\306',	'\307',
	'\310',	'\311',	'\312',	'\313',	'\314',	'\315',	'\316',	'\317',
	'\320',	'\321',	'\322',	'\323',	'\324',	'\325',	'\326',	'\327',
	'\330',	'\331',	'\332',	'\333',	'\334',	'\335',	'\336',	'\337',
	'\340',	'\341',	'\342',	'\343',	'\344',	'\345',	'\346',	'\347',
	'\350',	'\351',	'\352',	'\353',	'\354',	'\355',	'\356',	'\357',
	'\360',	'\361',	'\362',	'\363',	'\364',	'\365',	'\366',	'\367',
	'\370',	'\371',	'\372',	'\373',	'\374',	'\375',	'\376',	'\377',
  };

char _ctype_upper[256] =	/* upper case equivalents */
  {
	'\000',	'\001',	'\002',	'\003',	'\004',	'\005',	'\006',	'\007',
	'\010',	'\011',	'\012',	'\013',	'\014',	'\015',	'\016',	'\017',
	'\020',	'\021',	'\022',	'\023',	'\024',	'\025',	'\026',	'\027',
	'\030',	'\031',	'\032',	'\033',	'\034',	'\035',	'\036',	'\037',
	' ',	'!',	'"',	'#',	'$',	'%',	'&',	'\'',
	'(',	')',	'*',	'+',	',',	'-',	'.',	'/',
	'0',	'1',	'2',	'3',	'4',	'5',	'6',	'7',
	'8',	'9',	':',	';',	'<',	'=',	'>',	'?',
	'@',	'A',	'B',	'C',	'D',	'E',	'F',	'G',
	'H',	'I',	'J',	'K',	'L',	'M',	'N',	'O',
	'P',	'Q',	'R',	'S',	'T',	'U',	'V',	'W',
	'X',	'Y',	'Z',	'[',	'\\',	']',	'^',	'_',
	'`',	'A',	'B',	'C',	'D',	'E',	'F',	'G',
	'H',	'I',	'J',	'K',	'L',	'M',	'N',	'O',
	'P',	'Q',	'R',	'S',	'T',	'U',	'V',	'W',
	'X',	'Y',	'Z',	'{',	'|',	'}',	'~',	'\177',
	'\200',	'\232',	'\220',	'\203',	'\216',	'\205',	'\217',	'\207',
	'\210',	'\211',	'\212',	'\213',	'\214',	'\215',	'\216',	'\217',
	'\220',	'\222',	'\222',	'\223',	'\231',	'\225',	'\226',	'\200',
	'\230',	'\231',	'\232',	'\233',	'\234',	'\235',	'\236',	'\237',
	'\240',	'\241',	'\242',	'\243',	'\245',	'\245',	'\246',	'\247',
	'\250',	'\251',	'\252',	'\253',	'\254',	'\255',	'\256',	'\257',
	'\260',	'\261',	'\262',	'\263',	'\264',	'\265',	'\266',	'\267',
	'\270',	'\271',	'\272',	'\273',	'\274',	'\275',	'\276',	'\277',
	'\300',	'\301',	'\302',	'\303',	'\304',	'\305',	'\306',	'\307',
	'\310',	'\311',	'\312',	'\313',	'\314',	'\315',	'\316',	'\317',
	'\320',	'\321',	'\322',	'\323',	'\324',	'\325',	'\326',	'\327',
	'\330',	'\331',	'\332',	'\333',	'\334',	'\335',	'\336',	'\337',
	'\340',	'\341',	'\342',	'\343',	'\344',	'\345',	'\346',	'\347',
	'\350',	'\351',	'\352',	'\353',	'\354',	'\355',	'\356',	'\357',
	'\360',	'\361',	'\362',	'\363',	'\364',	'\365',	'\366',	'\367',
	'\370',	'\371',	'\372',	'\373',	'\374',	'\375',	'\376',	'\377',
  };

#endif /* MSDOS */


char _ctype_base[256] =		/* characters without diacritics */
  {
	0,	0,	0,	0,	0,	0,	0,	0,
	0,	0,	0,	0,	0,	0,	0,	0,
	0,	0,	0,	0,	0,	0,	0,	0,
	0,	0,	0,	0,	0,	0,	0,	0,
	0,	0,	0,	0,	0,	0,	0,	0,
	0,	0,	0,	0,	0,	0,	0,	0,
	0,	0,	0,	0,	0,	0,	0,	0,
	0,	0,	0,	0,	0,	0,	0,	0,
	0,	'A',	'B',	'C',	'D',	'E',	'F',	'G',
	'H',	'I',	'J',	'K',	'L',	'M',	'N',	'O',
	'P',	'Q',	'R',	'S',	'T',	'U',	'V',	'W',
	'X',	'Y',	'Z',	0,	0,	0,	0,	0,
	0,	'a',	'b',	'c',	'd',	'e',	'f',	'g',
	'h',	'i',	'j',	'k',	'l',	'm',	'n',	'o',
	'p',	'q',	'r',	's',	't',	'u',	'v',	'w',
	'x',	'y',	'z',	0,	0,	0,	0,	0,

#ifdef MSDOS

	'C',	'u',	'e',	'a',	'a',	'a',	'a',	'c',
	'e',	'e',	'e',	'i',	'i',	'i',	'A',	'A',
	'E',	'e',	'E',	'o',	'o',	'o',	'u',	'u',
	'y',	'O',	'U',	0,	0,	0,	0,	0,
	'a',	'i',	'o',	'u',	'n',	'N',	0,	0,
	0,	0,	0,	0,	0,	0,	0,	0,
	0,	0,	0,	0,	0,	0,	0,	0,
	0,	0,	0,	0,	0,	0,	0,	0,
	0,	0,	0,	0,	0,	0,	0,	0,
	0,	0,	0,	0,	0,	0,	0,	0,
	0,	0,	0,	0,	0,	0,	0,	0,
	0,	0,	0,	0,	0,	0,	0,	0,
	0,	0,	0,	0,	0,	0,	0,	0,
	0,	0,	0,	0,	0,	0,	0,	0,
	0,	0,	0,	0,	0,	0,	0,	0,
	0,	0,	0,	0,	0,	0,	0,	0,

#else /* not MSDOS */

	0,	0,	0,	0,	0,	0,	0,	0,
	0,	0,	0,	0,	0,	0,	0,	0,
	0,	0,	0,	0,	0,	0,	0,	0,
	0,	0,	0,	0,	0,	0,	0,	0,
	0,	0,	0,	0,	0,	0,	0,	0,
	0,	0,	0,	0,	0,	0,	0,	0,
	0,	0,	0,	0,	0,	0,	0,	0,
	0,	0,	0,	0,	0,	0,	0,	0,
	'A',	'A',	'A',	'A',	'A',	'A',	'A',	'C',
	'E',	'E',	'E',	'E',	'I',	'I',	'I',	'I',
	0,	'N',	'O',	'O',	'O',	'O',	'O',	0,
	'O',	'U',	'U',	'U',	'U',	'Y',	0,	0,
	'a',	'a',	'a',	'a',	'a',	'a',	'a',	'c',
	'e',	'e',	'e',	'e',	'i',	'i',	'i',	'i',
	0,	'n',	'o',	'o',	'o',	'o',	'o',	0,
	'o',	'u',	'u',	'u',	'u',	'y',	0,	'y',

#endif /* not MSDOS */
  };

char _ctype_diac[256] =		/* diacritic code for each character */
  {
    /*  Codes:   1 eE  2 '  3 `  4 ^  5 "  6 ~  7 ,  8 o  9 |   */

	0,	0,	0,	0,	0,	0,	0,	0,
	0,	0,	0,	0,	0,	0,	0,	0,
	0,	0,	0,	0,	0,	0,	0,	0,
	0,	0,	0,	0,	0,	0,	0,	0,
	0,	0,	0,	0,	0,	0,	0,	0,
	0,	0,	0,	0,	0,	0,	0,	0,
	0,	0,	0,	0,	0,	0,	0,	0,
	0,	0,	0,	0,	0,	0,	0,	0,
	0,	0,	0,	0,	0,	0,	0,	0,
	0,	0,	0,	0,	0,	0,	0,	0,
	0,	0,	0,	0,	0,	0,	0,	0,
	0,	0,	0,	0,	0,	0,	4,	0,
	3,	0,	0,	0,	0,	0,	0,	0,
	0,	0,	0,	0,	0,	0,	0,	0,
	0,	0,	0,	0,	0,	0,	0,	0,
	0,	0,	0,	0,	0,	0,	6,	0,

#ifdef MSDOS

	7,	5,	2,	4,	5,	3,	8,	7,
	4,	5,	3,	5,	4,	3,	5,	8,
	2,	1,	1,	4,	5,	3,	4,	3,
	5,	5,	5,	0,	0,	0,	0,	0,
	2,	2,	2,	2,	6,	6,	0,	0,
	0,	0,	0,	0,	0,	0,	0,	0,
	0,	0,	0,	0,	0,	0,	0,	0,
	0,	0,	0,	0,	0,	0,	0,	0,
	0,	0,	0,	0,	0,	0,	0,	0,
	0,	0,	0,	0,	0,	0,	0,	0,
	0,	0,	0,	0,	0,	0,	0,	0,
	0,	0,	0,	0,	0,	0,	0,	0,
	0,	0,	0,	0,	0,	0,	0,	0,
	0,	0,	0,	0,	0,	0,	0,	0,
	0,	0,	0,	0,	0,	0,	0,	0,
	0,	0,	0,	0,	0,	0,	0,	0,

#else /* not MSDOS */

	0,	0,	0,	0,	0,	0,	0,	0,
	0,	0,	0,	0,	0,	0,	0,	0,
	0,	0,	0,	0,	0,	0,	0,	0,
	0,	0,	0,	0,	0,	0,	0,	0,
	0,	0,	0,	0,	0,	0,	0,	0,
	0,	0,	0,	0,	0,	0,	0,	0,
	0,	0,	0,	0,	0,	0,	0,	0,
	0,	0,	0,	0,	0,	0,	0,	0,
	3,	2,	4,	6,	5,	8,	1,	7,
	3,	2,	4,	5,	3,	2,	4,	5,
	0,	6,	3,	2,	4,	6,	5,	0,
	9,	3,	2,	4,	5,	2,	0,	0,
	3,	2,	4,	6,	5,	8,	1,	7,
	3,	2,	4,	5,	3,	2,	4,	5,
	0,	6,	3,	2,	4,	6,	5,	0,
	9,	3,	2,	4,	5,	2,	0,	0,

#endif /* not MSDOS */
  };
