#!/bin/sh
# Check whether a PR has been analyzed within the acknowledgment period.
# Copyright (C) 1993 Free Software Foundation, Inc.
# Contributed by Brendan Kehoe (brendan@cygnus.com).
#
# This file is part of GNU GNATS.
#
# GNU GNATS is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2, or (at your option)
# any later version.
#
# GNU GNATS is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with GNU GNATS; see the file COPYING.  If not, write to
# the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

# Arguments coming in are:
#
# $1 - response time
# $2 - PR number
# $3 - path to the PR file
# $4 - submitter-id
# $5 - full name of the submitter
# $6 - contact for the submitter
# $7 - address for GNATS_ADMIN

PATH=/bin:/usr/bin; export PATH

GNATS_ROOT=xGNATS_ROOTx
VERSION=xVERSIONx
LIBDIR=xLIBDIRx
MAIL_AGENT="xMAIL_AGENTx"

# Newer config information?
[ -f ${GNATS_ROOT}/gnats-adm/config ] && . ${GNATS_ROOT}/gnats-adm/config

if [ $# != 7 ]; then
  echo "$0: called with the incorrect number of arguments"
  exit 1
fi
 
if [ ! -d $GNATS_ROOT ]; then
  echo "$0: GNATS base directory $GNATS_ROOT does not exist."
  exit 1
fi

# If the PR file isn't there, it may have been reclassified, so don't
# fret about it.
if [ ! -f $3 ]; then exit 0; fi

# Grab the current state of the PR, and the synopsis.
STATE=`grep '^>State:' $3 | sed -e 's,^>State:[ 	]*,,g'`
SYNOPSIS=`grep '^>Synopsis:' $3 | sed -e 's,^>Synopsis:[ 	]*,,g'`
RESPONSIBLE=`grep '^>Responsible:' $3 | sed -e 's,^>Responsible:[ 	]*,,g'`
RESP_ADDR=`$LIBDIR/gnats/pr-addr "$RESPONSIBLE"`

if [ -n "$DEBUG_MODE" ]; then
  STEALTH_HEADER="From: gnats (GNATS Management)
To: $GNATS_ADMIN
Subject: mail output from at-pr


"
fi

if [ "$STATE" = "open" ]; then
  $MAIL_AGENT << __EOF__
${STEALTH_HEADER}From: gnats (GNATS Management)
To: $6, $RESP_ADDR, $7
Subject: PR $2 not analyzed in $1 hours


PR $2 was not analyzed within the acknowledgment period
of $1 business hours.  The pertinent information is:

 Submitter-Id: $4
 Originator: $5
 Synopsis: $SYNOPSIS
 Person responsible for the PR: $RESPONSIBLE

--
The GNU Problem Report Management System (GNATS)
__EOF__
fi

exit 0
