.\" descend.man,v 1.1 1992/04/03 05:22:53 berliner Exp
.TH DESCEND 1 "31 March 1992"
.SH NAME 
descend \- walk directory tree and execute a command at each node
.SH SYNOPSIS 
.B descend
[
.B \-afqrv
]
.I command
[
.I directory
\&.\|.\|.
]
.SH DESCRIPTION
.B descend
walks down a directory tree and executes a command at each node.  It
is not as versatile as
.BR find (1),
but it has a simpler syntax.  If no
.I directory
is specified,
.B descend
starts at the current one.
.LP
Unlike
.BR find ,
.B descend
can be told to skip the special directories associated with RCS,
CVS, and SCCS.  This makes
.B descend
especially handy for use with these packages.  It can be used with
other commands too, of course.
.LP
.B descend
is a poor man's way to make any command recursive.  Note:
.B descend
does not follow symbolic links to directories unless they are
specified on the command line.
.SH OPTIONS
.TP 15
.B \-a
.I All.
Descend into directories that begin with '.'.
.TP
.B \-f
.I Force.
Ignore errors during descent.  Normally,
.B descend
quits when an error occurs.
.TP
.B \-q
.I Quiet.
Suppress the message `In directory
.IR directory '
that is normally printed during the descent.
.TP
.B \-r
.I Restricted.
Don't descend into the special directories 
.SB RCS,
.SB CVS,
.SB CVS.adm,
and
.SB SCCS.
.TP
.B \-v
.I Verbose.
Print 
.I command
before executing it.
.SH EXAMPLES
.TP 15
.B "descend ls"
Cheap substitute for `ls -R'.
.TP 15
.B "descend -f 'rm *' tree"
Strip `tree' of its leaves.  This command descends the `tree'
directory, removing all regular files.  Since 
.BR rm (1)
does not remove directories, this command leaves the directory
structure of `tree' intact, but denuded.  The
.B \-f
option is required to keep
.B descend
from quitting.  You could use `rm \-f' instead.
.TP 
.B "descend -r 'co RCS/*'" /project/src/
Check out every RCS file under the directory
.BR "/project/src" .
.TP
.B "descend -r 'cvs diff'"
Perform CVS `diff' operation on every directory below (and including)
the current one.
.SH DIAGNOSTICS
Returns 1 if errors occur (and the
.B \-f
option is not used).  Otherwise returns 0.
.SH SEE ALSO
.BR find (1),
.BR rcsintro (1),
.BR cvs (1),
.BR sccs (1)
.SH AUTHOR
Lowell Skoog
.br
Software Technology Group
.br
John Fluke Mfg. Co., Inc.
.SH BUGS
Shell metacharacters in
.I command
may have bizarre effects.  In particular, compound commands
(containing ';', '[', and ']' characters) will not work.  It is best
to enclose complicated commands in single quotes \(aa\ \(aa.
