
# line 2 "bc.y"
/* bc.y: The grammar for a POSIX compatable bc processor with some
         extensions to the language. */

/*  This file is part of bc written for MINIX.
    Copyright (C) 1991, 1992 Free Software Foundation, Inc.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License , or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; see the file COPYING.  If not, write to
    the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

    You may contact the author by:
       e-mail:  phil@cs.wwu.edu
      us-mail:  Philip A. Nelson
                Computer Science Department, 9062
                Western Washington University
                Bellingham, WA 98226-9062
       
*************************************************************************/

#include "bcdefs.h"
#include "global.h"
#include "proto.h"

# line 38 "bc.y"
typedef union  {
	char	 *s_value;
	char	  c_value;
	int	  i_value;
	arg_list *a_value;
       } YYSTYPE;
# define NEWLINE 257
# define AND 258
# define OR 259
# define NOT 260
# define STRING 261
# define NAME 262
# define NUMBER 263
# define MUL_OP 264
# define ASSIGN_OP 265
# define REL_OP 266
# define INCR_DECR 267
# define Define 268
# define Break 269
# define Quit 270
# define Length 271
# define Return 272
# define For 273
# define If 274
# define While 275
# define Sqrt 276
# define Else 277
# define Scale 278
# define Ibase 279
# define Obase 280
# define Auto 281
# define Read 282
# define Warranty 283
# define Halt 284
# define Last 285
# define Continue 286
# define Print 287
# define Limits 288
# define UNARY_MINUS 289
#define yyclearin yychar = -1
#define yyerrok yyerrflag = 0
extern int yychar;
extern int yyerrflag;
#ifndef YYMAXDEPTH
#define YYMAXDEPTH 150
#endif
YYSTYPE yylval, yyval;
typedef int yytabelem;
# define YYERRCODE 256

# line 612 "bc.y"

static yytabelem yyexca[] ={
-1, 1,
	0, -1,
	257, 6,
	59, 6,
	-2, 0,
-1, 21,
	257, 10,
	59, 10,
	125, 10,
	-2, 0,
-1, 38,
	257, 9,
	59, 9,
	-2, 0,
-1, 85,
	257, 12,
	59, 12,
	125, 12,
	-2, 0,
-1, 153,
	257, 10,
	59, 10,
	-2, 0,
-1, 161,
	257, 12,
	59, 12,
	-2, 0,
	};
# define YYNPROD 98
# define YYLAST 706
static yytabelem yyact[]={

    27,    65,   149,   145,    48,    25,    57,    45,    58,    46,
   105,   135,    41,   125,    86,    86,    38,    66,    34,    35,
   141,   109,    53,    54,    36,     6,   134,    11,   159,    88,
   104,    48,   150,    27,   136,    62,    62,    62,    25,   142,
   126,    63,   151,   127,   125,   118,   115,   162,   139,   124,
     8,   117,    59,    60,   108,    61,    40,   102,    48,    84,
    82,    72,    71,    70,    69,    68,    27,    67,    51,    49,
    23,    25,    75,    76,    77,    78,    79,    81,    74,    83,
    87,    73,    92,    21,    91,   163,   140,   119,    63,   153,
    96,    98,   152,    89,    56,    99,   100,   101,    27,   129,
    64,   106,   107,    25,    52,   144,    40,   128,   164,   113,
   110,   155,   112,   137,    50,     4,    21,     3,     2,    95,
   116,    94,   148,   103,    80,     1,     0,    27,     0,     0,
     0,     0,    25,     0,     0,     0,     0,   114,     0,     0,
     0,     0,     0,    91,     0,   130,   131,    98,     0,    21,
     0,     0,     0,     0,     0,     0,    27,     0,     0,   143,
     0,    25,     0,     0,     0,   110,    27,     0,    98,     0,
     0,    25,     0,     0,    47,     0,   157,   160,     0,   138,
   154,    21,     0,   110,     0,   113,     0,     0,     0,     0,
   146,     0,    27,     0,     0,     0,     0,    25,     0,     0,
     0,     0,    27,   156,     0,     0,     0,    25,     0,   147,
    21,     0,    85,   161,    37,   165,    55,     0,     0,   133,
    24,    12,    28,    26,     0,     0,   158,    29,    47,    13,
    15,    30,    17,    18,    19,    20,    31,     0,    32,    34,
    35,     0,    33,     9,    16,    36,    14,    22,    10,     5,
     0,     0,    27,    24,    12,    28,    26,    25,     0,     0,
    29,     7,    13,    15,    30,    17,    18,    19,    20,    31,
     0,    32,    34,    35,     0,    33,     9,    16,    36,    14,
    22,    10,    55,     0,     0,    27,    24,    12,    28,    26,
    25,     0,     0,    29,     0,    13,    15,    30,    17,    18,
    19,    20,    31,     0,    32,    34,    35,     0,    33,     9,
    16,    36,    14,    22,    10,    39,     0,     0,    24,    12,
    28,    26,     0,     0,     0,    29,     0,    13,    15,    30,
    17,    18,    19,    20,    31,     0,    32,    34,    35,     0,
    33,     9,    16,    36,    14,    22,    10,    24,    12,    28,
    26,     0,     0,     0,    29,     0,    13,    15,    30,    17,
    18,    19,    20,    31,     0,    32,    34,    35,     0,    33,
     9,    16,    36,    14,    22,    10,    24,     0,    28,    26,
     0,     0,     0,    29,     0,     0,    24,    30,    28,    26,
     0,     0,    31,    29,    32,    34,    35,    30,    33,     0,
     0,    36,    31,     0,    32,    34,    35,    45,    33,    46,
     0,    36,    24,    90,    28,    26,   123,     0,    45,    29,
    46,     0,    24,    30,    28,    26,     0,     0,    31,    29,
    32,    34,    35,    30,    33,     0,     0,    36,    31,     0,
    32,    34,    35,     0,    33,     0,   122,    36,    45,   121,
    46,    45,    45,    46,    46,     0,     0,   120,    48,     0,
   111,     0,    45,     0,    46,     0,    45,     0,    46,    48,
     0,     0,    24,     0,   132,    26,    93,     0,    45,    29,
    46,     0,    45,    30,    46,     0,     0,     0,    31,     0,
    32,    34,    35,     0,    33,     0,     0,    36,     0,    48,
     0,     0,    48,    48,     0,    24,     0,    97,    26,     0,
     0,     0,    29,    48,     0,     0,    30,    48,     0,     0,
     0,    31,     0,    32,    34,    35,     0,    33,     0,    48,
    36,     0,     0,    48,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,    42,    43,     0,     0,     0,     0,    47,     0,
    44,     0,     0,    42,    43,     0,     0,     0,     0,    47,
     0,    44,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,    42,    43,     0,    42,    43,     0,    47,
     0,    44,    47,    47,    44,    44,     0,    42,    43,     0,
     0,    42,    43,    47,     0,    44,     0,    47,     0,    44,
     0,     0,     0,    42,    43,     0,     0,    42,     0,    47,
     0,    44,     0,    47,     0,    44 };
static yytabelem yypact[]={

 -1000,    -7, -1000,   -43, -1000,    58, -1000,  -250, -1000, -1000,
 -1000,   423, -1000, -1000, -1000, -1000, -1000,    29, -1000,    28,
 -1000,    26, -1000,  -259,   162,   162, -1000,   162,    -3,  -261,
    27,    25,    24,    23, -1000, -1000, -1000, -1000,    26, -1000,
 -1000,    21, -1000, -1000,   162,   162,   162,   162,   162,   162,
    20,   162,    19,   -45, -1000,    87,   152, -1000, -1000,   409,
 -1000,   435,   245,   162, -1000,   -50, -1000,   162,   162,   162,
    16, -1000,  -252,   162,   162,   -36,   -90,   -90,   -63,   -63,
    13,   423,   162,   419,   162,    26,    87, -1000, -1000,     2,
 -1000,   423,   162, -1000,    10,     1,   423,    -4,   364,   408,
   405,   375, -1000,     8,     0,   -51,   409,   439, -1000,   -16,
   423, -1000,   423, -1000, -1000,   152,   -36, -1000,   212,   126,
 -1000, -1000, -1000, -1000,   -97,  -251,   -59, -1000,    87,     7,
 -1000,   423,    -5, -1000,  -237,   -52, -1000,   162,  -274,    87,
   116,  -279,   -61,   -17, -1000, -1000, -1000, -1000, -1000,  -252,
 -1000, -1000,    87,    26,   -31,   162, -1000,   -44, -1000, -1000,
     6,   -40, -1000, -1000,    87, -1000 };
static yytabelem yypgo[]={

     0,   125,    27,   124,    70,    21,   123,   122,    30,   121,
   119,   118,   117,    22,    50,   115,    23,   114,   113,   111,
   108,   107,   105,   104,    99,    94,    29,    93,    92,    89,
    82,    81,    78 };
static yytabelem yyr1[]={

     0,     1,     1,    11,    11,    11,    12,    12,    12,    12,
    13,    13,    13,    13,    13,    13,    16,    16,    14,    14,
    14,    14,    14,    14,    14,    14,    14,    14,    17,    18,
    19,    20,    14,    21,    14,    23,    24,    14,    14,    25,
    14,    26,    26,    27,    27,    22,    28,    22,    29,    15,
     6,     6,     7,     7,     7,     8,     8,     8,     8,     9,
     9,    10,    10,    10,    10,     5,     5,     3,     3,    30,
     2,    31,     2,    32,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     4,     4,     4,     4,     4,     4 };
static yytabelem yyr2[]={

     0,     1,     4,     5,     3,     5,     1,     2,     6,     4,
     1,     2,     4,     6,     4,     6,     2,     5,     3,     3,
     3,     3,     3,     3,     3,     3,     3,     9,     1,     1,
     1,     1,    27,     1,    15,     1,     1,    15,     7,     1,
     6,     2,     6,     3,     3,     0,     1,     6,     1,    25,
     1,     2,     1,     7,     7,     3,     7,     7,    11,     1,
     2,     3,     7,     7,    11,     1,     2,     1,     3,     1,
     9,     1,     9,     1,     9,     5,     7,     7,     7,     7,
     7,     5,     3,     3,     7,     9,     5,     5,     9,     9,
     9,     7,     3,     9,     3,     3,     3,     3 };
static yytabelem yychk[]={

 -1000,    -1,   -11,   -12,   -15,   256,   -16,   268,   -14,   283,
   288,    -2,   261,   269,   286,   270,   284,   272,   273,   274,
   275,   123,   287,    -4,   260,    45,   263,    40,   262,   267,
   271,   276,   278,   282,   279,   280,   285,   257,    59,   257,
   -14,   262,   258,   259,   266,    43,    45,   264,    94,    40,
   -17,    40,   -23,   -13,   -16,   256,   -25,   265,   267,    -2,
    -2,    -2,    40,    91,    -4,   262,   278,    40,    40,    40,
    40,   -16,    40,   -31,   -32,    -2,    -2,    -2,    -2,    -2,
    -3,    -2,    40,    -2,    40,   257,    59,   125,   -26,   -27,
   261,    -2,   -30,    41,    -9,   -10,    -2,   262,    -2,    -2,
    -2,    -2,    41,    -6,    -8,   262,    -2,    -2,    41,    -5,
    -2,    41,    -2,   -16,   -14,    44,    -2,    41,    44,    91,
    93,    41,    41,    41,    41,    44,    91,    59,   -21,   -24,
   -26,    -2,   262,    93,   123,   262,    93,   -18,   -14,    41,
    91,   257,    91,    -5,   -22,   277,   -14,    93,    -7,   281,
    93,    59,   -28,   -29,    -8,   -19,   -14,   -13,   257,    59,
    -5,   257,    41,   125,   -20,   -14 };
static yytabelem yydef[]={

     1,    -2,     2,     0,     4,     0,     7,     0,    16,    18,
    19,    20,    21,    22,    23,    24,    25,    26,    28,     0,
    35,    -2,    39,    82,     0,     0,    83,     0,    92,     0,
     0,     0,    96,     0,    94,    95,    97,     3,    -2,     5,
    17,     0,    71,    73,     0,     0,     0,     0,     0,    67,
     0,     0,     0,     0,    11,     0,     0,    69,    87,    75,
    81,     0,    59,     0,    86,    92,    96,     0,     0,     0,
     0,     8,    50,     0,     0,    76,    77,    78,    79,    80,
     0,    68,    65,     0,     0,    -2,    14,    38,    40,    41,
    43,    44,     0,    84,     0,    60,    61,    92,     0,     0,
     0,     0,    91,     0,    51,    55,    72,    74,    27,     0,
    66,    33,    36,    13,    15,     0,    70,    85,     0,     0,
    93,    88,    89,    90,     0,     0,     0,    29,     0,     0,
    42,    63,    92,    62,     0,    57,    56,    65,    45,     0,
     0,    52,     0,     0,    34,    46,    37,    64,    48,     0,
    58,    30,     0,    -2,     0,    65,    47,     0,    53,    54,
     0,    -2,    31,    49,     0,    32 };
typedef struct { char *t_name; int t_val; } yytoktype;
#ifndef YYDEBUG
#	define YYDEBUG	0	/* don't allow debugging */
#endif

#if YYDEBUG

yytoktype yytoks[] =
{
	"NEWLINE",	257,
	"AND",	258,
	"OR",	259,
	"NOT",	260,
	"STRING",	261,
	"NAME",	262,
	"NUMBER",	263,
	"MUL_OP",	264,
	"ASSIGN_OP",	265,
	"REL_OP",	266,
	"INCR_DECR",	267,
	"Define",	268,
	"Break",	269,
	"Quit",	270,
	"Length",	271,
	"Return",	272,
	"For",	273,
	"If",	274,
	"While",	275,
	"Sqrt",	276,
	"Else",	277,
	"Scale",	278,
	"Ibase",	279,
	"Obase",	280,
	"Auto",	281,
	"Read",	282,
	"Warranty",	283,
	"Halt",	284,
	"Last",	285,
	"Continue",	286,
	"Print",	287,
	"Limits",	288,
	"+",	43,
	"-",	45,
	"^",	94,
	"UNARY_MINUS",	289,
	"-unknown-",	-1	/* ends search */
};

char * yyreds[] =
{
	"-no such reduction-",
      "program : /* empty */",
      "program : program input_item",
      "input_item : semicolon_list NEWLINE",
      "input_item : function",
      "input_item : error NEWLINE",
      "semicolon_list : /* empty */",
      "semicolon_list : statement_or_error",
      "semicolon_list : semicolon_list ';' statement_or_error",
      "semicolon_list : semicolon_list ';'",
      "statement_list : /* empty */",
      "statement_list : statement_or_error",
      "statement_list : statement_list NEWLINE",
      "statement_list : statement_list NEWLINE statement_or_error",
      "statement_list : statement_list ';'",
      "statement_list : statement_list ';' statement",
      "statement_or_error : statement",
      "statement_or_error : error statement",
      "statement : Warranty",
      "statement : Limits",
      "statement : expression",
      "statement : STRING",
      "statement : Break",
      "statement : Continue",
      "statement : Quit",
      "statement : Halt",
      "statement : Return",
      "statement : Return '(' return_expression ')'",
      "statement : For",
      "statement : For '(' opt_expression ';'",
      "statement : For '(' opt_expression ';' opt_expression ';'",
      "statement : For '(' opt_expression ';' opt_expression ';' opt_expression ')'",
      "statement : For '(' opt_expression ';' opt_expression ';' opt_expression ')' statement",
      "statement : If '(' expression ')'",
      "statement : If '(' expression ')' statement opt_else",
      "statement : While",
      "statement : While '(' expression",
      "statement : While '(' expression ')' statement",
      "statement : '{' statement_list '}'",
      "statement : Print",
      "statement : Print print_list",
      "print_list : print_element",
      "print_list : print_element ',' print_list",
      "print_element : STRING",
      "print_element : expression",
      "opt_else : /* empty */",
      "opt_else : Else",
      "opt_else : Else statement",
      "function : Define NAME '(' opt_parameter_list ')' '{' NEWLINE opt_auto_define_list",
      "function : Define NAME '(' opt_parameter_list ')' '{' NEWLINE opt_auto_define_list statement_list NEWLINE '}'",
      "opt_parameter_list : /* empty */",
      "opt_parameter_list : define_list",
      "opt_auto_define_list : /* empty */",
      "opt_auto_define_list : Auto define_list NEWLINE",
      "opt_auto_define_list : Auto define_list ';'",
      "define_list : NAME",
      "define_list : NAME '[' ']'",
      "define_list : define_list ',' NAME",
      "define_list : define_list ',' NAME '[' ']'",
      "opt_argument_list : /* empty */",
      "opt_argument_list : argument_list",
      "argument_list : expression",
      "argument_list : NAME '[' ']'",
      "argument_list : argument_list ',' expression",
      "argument_list : argument_list ',' NAME '[' ']'",
      "opt_expression : /* empty */",
      "opt_expression : expression",
      "return_expression : /* empty */",
      "return_expression : expression",
      "expression : named_expression ASSIGN_OP",
      "expression : named_expression ASSIGN_OP expression",
      "expression : expression AND",
      "expression : expression AND expression",
      "expression : expression OR",
      "expression : expression OR expression",
      "expression : NOT expression",
      "expression : expression REL_OP expression",
      "expression : expression '+' expression",
      "expression : expression '-' expression",
      "expression : expression MUL_OP expression",
      "expression : expression '^' expression",
      "expression : '-' expression",
      "expression : named_expression",
      "expression : NUMBER",
      "expression : '(' expression ')'",
      "expression : NAME '(' opt_argument_list ')'",
      "expression : INCR_DECR named_expression",
      "expression : named_expression INCR_DECR",
      "expression : Length '(' expression ')'",
      "expression : Sqrt '(' expression ')'",
      "expression : Scale '(' expression ')'",
      "expression : Read '(' ')'",
      "named_expression : NAME",
      "named_expression : NAME '[' expression ']'",
      "named_expression : Ibase",
      "named_expression : Obase",
      "named_expression : Scale",
      "named_expression : Last",
};
#endif /* YYDEBUG */
/*
 * (c) Copyright 1990, OPEN SOFTWARE FOUNDATION, INC.
 * ALL RIGHTS RESERVED
 */
/*
 * OSF/1 Release 1.0
 */
/* @(#)yaccpar	1.3  com/cmd/lang/yacc,3.1, 9/7/89 18:46:37 */
/*
** Skeleton parser driver for yacc output
*/

/*
** yacc user known macros and defines
*/
#ifdef YYSPLIT
#   define YYERROR	return(-2)
#else
#   define YYERROR	goto yyerrlab
#endif

#define YYACCEPT	return(0)
#define YYABORT		return(1)
#define YYBACKUP( newtoken, newvalue )\
{\
	if ( yychar >= 0 || ( yyr2[ yytmp ] >> 1 ) != 1 )\
	{\
		yyerror( "syntax error - cannot backup" );\
		goto yyerrlab;\
	}\
	yychar = newtoken;\
	yystate = *yyps;\
	yylval = newvalue;\
	goto yynewstate;\
}
#define YYRECOVERING()	(!!yyerrflag)
#ifndef YYDEBUG
#	define YYDEBUG	1	/* make debugging available */
#endif

/*
** user known globals
*/
int yydebug;			/* set to 1 to get debugging */

/*
** driver internal defines
*/
#define YYFLAG		(-1000)

#ifdef YYSPLIT
#   define YYSCODE { \
			extern int (*yyf[])(); \
			register int yyret; \
			if (yyf[yytmp]) \
			    if ((yyret=(*yyf[yytmp])()) == -2) \
				    goto yyerrlab; \
				else if (yyret>=0) return(yyret); \
		   }
#endif

/*
** global variables used by the parser
*/
YYSTYPE yyv[ YYMAXDEPTH ];	/* value stack */
int yys[ YYMAXDEPTH ];		/* state stack */

YYSTYPE *yypv;			/* top of value stack */
YYSTYPE *yypvt;			/* top of value stack for $vars */
int *yyps;			/* top of state stack */

int yystate;			/* current state */
int yytmp;			/* extra var (lasts between blocks) */

int yynerrs;			/* number of errors */
int yyerrflag;			/* error recovery flag */
int yychar;			/* current input token number */



/*
** yyparse - return 0 if worked, 1 if syntax error not recovered from
*/
int
yyparse()
{
	/*
	** Initialize externals - yyparse may be called more than once
	*/
	yypv = &yyv[-1];
	yyps = &yys[-1];
	yystate = 0;
	yytmp = 0;
	yynerrs = 0;
	yyerrflag = 0;
	yychar = -1;

	goto yystack;
	{
		register YYSTYPE *yy_pv;	/* top of value stack */
		register int *yy_ps;		/* top of state stack */
		register int yy_state;		/* current state */
		register int  yy_n;		/* internal state number info */

		/*
		** get globals into registers.
		** branch to here only if YYBACKUP was called.
		*/
	yynewstate:
		yy_pv = yypv;
		yy_ps = yyps;
		yy_state = yystate;
		goto yy_newstate;

		/*
		** get globals into registers.
		** either we just started, or we just finished a reduction
		*/
	yystack:
		yy_pv = yypv;
		yy_ps = yyps;
		yy_state = yystate;

		/*
		** top of for (;;) loop while no reductions done
		*/
	yy_stack:
		/*
		** put a state and value onto the stacks
		*/
#if YYDEBUG
		/*
		** if debugging, look up token value in list of value vs.
		** name pairs.  0 and negative (-1) are special values.
		** Note: linear search is used since time is not a real
		** consideration while debugging.
		*/
		if ( yydebug )
		{
			register int yy_i;

			printf( "State %d, token ", yy_state );
			if ( yychar == 0 )
				printf( "end-of-file\n" );
			else if ( yychar < 0 )
				printf( "-none-\n" );
			else
			{
				for ( yy_i = 0; yytoks[yy_i].t_val >= 0;
					yy_i++ )
				{
					if ( yytoks[yy_i].t_val == yychar )
						break;
				}
				printf( "%s\n", yytoks[yy_i].t_name );
			}
		}
#endif /* YYDEBUG */
		if ( ++yy_ps >= &yys[ YYMAXDEPTH ] )	/* room on stack? */
		{
			yyerror( "yacc stack overflow" );
			YYABORT;
		}
		*yy_ps = yy_state;
		*++yy_pv = yyval;

		/*
		** we have a new state - find out what to do
		*/
	yy_newstate:
		if ( ( yy_n = yypact[ yy_state ] ) <= YYFLAG )
			goto yydefault;		/* simple state */
#if YYDEBUG
		/*
		** if debugging, need to mark whether new token grabbed
		*/
		yytmp = yychar < 0;
#endif
		if ( ( yychar < 0 ) && ( ( yychar = yylex() ) < 0 ) )
			yychar = 0;		/* reached EOF */
#if YYDEBUG
		if ( yydebug && yytmp )
		{
			register int yy_i;

			printf( "Received token " );
			if ( yychar == 0 )
				printf( "end-of-file\n" );
			else if ( yychar < 0 )
				printf( "-none-\n" );
			else
			{
				for ( yy_i = 0; yytoks[yy_i].t_val >= 0;
					yy_i++ )
				{
					if ( yytoks[yy_i].t_val == yychar )
						break;
				}
				printf( "%s\n", yytoks[yy_i].t_name );
			}
		}
#endif /* YYDEBUG */
		if ( ( ( yy_n += yychar ) < 0 ) || ( yy_n >= YYLAST ) )
			goto yydefault;
		if ( yychk[ yy_n = yyact[ yy_n ] ] == yychar )	/*valid shift*/
		{
			yychar = -1;
			yyval = yylval;
			yy_state = yy_n;
			if ( yyerrflag > 0 )
				yyerrflag--;
			goto yy_stack;
		}

	yydefault:
		if ( ( yy_n = yydef[ yy_state ] ) == -2 )
		{
#if YYDEBUG
			yytmp = yychar < 0;
#endif
			if ( ( yychar < 0 ) && ( ( yychar = yylex() ) < 0 ) )
				yychar = 0;		/* reached EOF */
#if YYDEBUG
			if ( yydebug && yytmp )
			{
				register int yy_i;

				printf( "Received token " );
				if ( yychar == 0 )
					printf( "end-of-file\n" );
				else if ( yychar < 0 )
					printf( "-none-\n" );
				else
				{
					for ( yy_i = 0;
						yytoks[yy_i].t_val >= 0;
						yy_i++ )
					{
						if ( yytoks[yy_i].t_val
							== yychar )
						{
							break;
						}
					}
					printf( "%s\n", yytoks[yy_i].t_name );
				}
			}
#endif /* YYDEBUG */
			/*
			** look through exception table
			*/
			{
				register int *yyxi = yyexca;

				while ( ( *yyxi != -1 ) ||
					( yyxi[1] != yy_state ) )
				{
					yyxi += 2;
				}
				while ( ( *(yyxi += 2) >= 0 ) &&
					( *yyxi != yychar ) )
					;
				if ( ( yy_n = yyxi[1] ) < 0 )
					YYACCEPT;
			}
		}

		/*
		** check for syntax error
		*/
		if ( yy_n == 0 )	/* have an error */
		{
			/* no worry about speed here! */
			switch ( yyerrflag )
			{
			case 0:		/* new error */
				yyerror( "syntax error" );
				goto skip_init;
			yyerrlab:
				/*
				** get globals into registers.
				** we have a user generated syntax type error
				*/
				yy_pv = yypv;
				yy_ps = yyps;
				yy_state = yystate;
				yynerrs++;
			skip_init:
			case 1:
			case 2:		/* incompletely recovered error */
					/* try again... */
				yyerrflag = 3;
				/*
				** find state where "error" is a legal
				** shift action
				*/
				while ( yy_ps >= yys )
				{
					yy_n = yypact[ *yy_ps ] + YYERRCODE;
					if ( yy_n >= 0 && yy_n < YYLAST &&
						yychk[yyact[yy_n]] == YYERRCODE)					{
						/*
						** simulate shift of "error"
						*/
						yy_state = yyact[ yy_n ];
						goto yy_stack;
					}
					/*
					** current state has no shift on
					** "error", pop stack
					*/
#if YYDEBUG
#	define _POP_ "Error recovery pops state %d, uncovers state %d\n"
					if ( yydebug )
						printf( _POP_, *yy_ps,
							yy_ps[-1] );
#	undef _POP_
#endif
					yy_ps--;
					yy_pv--;
				}
				/*
				** there is no state on stack with "error" as
				** a valid shift.  give up.
				*/
				YYABORT;
			case 3:		/* no shift yet; eat a token */
#if YYDEBUG
				/*
				** if debugging, look up token in list of
				** pairs.  0 and negative shouldn't occur,
				** but since timing doesn't matter when
				** debugging, it doesn't hurt to leave the
				** tests here.
				*/
				if ( yydebug )
				{
					register int yy_i;

					printf( "Error recovery discards " );
					if ( yychar == 0 )
						printf( "token end-of-file\n" );
					else if ( yychar < 0 )
						printf( "token -none-\n" );
					else
					{
						for ( yy_i = 0;
							yytoks[yy_i].t_val >= 0;
							yy_i++ )
						{
							if ( yytoks[yy_i].t_val
								== yychar )
							{
								break;
							}
						}
						printf( "token %s\n",
							yytoks[yy_i].t_name );
					}
				}
#endif /* YYDEBUG */
				if ( yychar == 0 )	/* reached EOF. quit */
					YYABORT;
				yychar = -1;
				goto yy_newstate;
			}
		}/* end if ( yy_n == 0 ) */
		/*
		** reduction by production yy_n
		** put stack tops, etc. so things right after switch
		*/
#if YYDEBUG
		/*
		** if debugging, print the string that is the user's
		** specification of the reduction which is just about
		** to be done.
		*/
		if ( yydebug )
			printf( "Reduce by (%d) \"%s\"\n",
				yy_n, yyreds[ yy_n ] );
#endif
		yytmp = yy_n;			/* value to switch over */
		yypvt = yy_pv;			/* $vars top of value stack */
		/*
		** Look in goto table for next state
		** Sorry about using yy_state here as temporary
		** register variable, but why not, if it works...
		** If yyr2[ yy_n ] doesn't have the low order bit
		** set, then there is no action to be done for
		** this reduction.  So, no saving & unsaving of
		** registers done.  The only difference between the
		** code just after the if and the body of the if is
		** the goto yy_stack in the body.  This way the test
		** can be made before the choice of what to do is needed.
		*/
		{
			/* length of production doubled with extra bit */
			register int yy_len = yyr2[ yy_n ];

			if ( !( yy_len & 01 ) )
			{
				yy_len >>= 1;
				yyval = ( yy_pv -= yy_len )[1];	/* $$ = $1 */
				yy_state = yypgo[ yy_n = yyr1[ yy_n ] ] +
					*( yy_ps -= yy_len ) + 1;
				if ( yy_state >= YYLAST ||
					yychk[ yy_state =
					yyact[ yy_state ] ] != -yy_n )
				{
					yy_state = yyact[ yypgo[ yy_n ] ];
				}
				goto yy_stack;
			}
			yy_len >>= 1;
			yyval = ( yy_pv -= yy_len )[1];	/* $$ = $1 */
			yy_state = yypgo[ yy_n = yyr1[ yy_n ] ] +
				*( yy_ps -= yy_len ) + 1;
			if ( yy_state >= YYLAST ||
				yychk[ yy_state = yyact[ yy_state ] ] != -yy_n )
			{
				yy_state = yyact[ yypgo[ yy_n ] ];
			}
		}
					/* save until reenter driver code */
		yystate = yy_state;
		yyps = yy_ps;
		yypv = yy_pv;
	}
	/*
	** code supplied by user is placed in this switch
	*/

		switch(yytmp){

case 1:
# line 106 "bc.y"
{
			      yyval.i_value = 0;
			      if (interactive)
				{
				  printf ("%s\n", BC_VERSION);
				  welcome ();
				}
			    } /*NOTREACHED*/ break;
case 3:
# line 117 "bc.y"
{ run_code (); } /*NOTREACHED*/ break;
case 4:
# line 119 "bc.y"
{ run_code (); } /*NOTREACHED*/ break;
case 5:
# line 121 "bc.y"
{
			      yyerrok;
			      init_gen ();
			    } /*NOTREACHED*/ break;
case 6:
# line 127 "bc.y"
{ yyval.i_value = 0; } /*NOTREACHED*/ break;
case 10:
# line 133 "bc.y"
{ yyval.i_value = 0; } /*NOTREACHED*/ break;
case 17:
# line 142 "bc.y"
{ yyval.i_value = yypvt[-0].i_value; } /*NOTREACHED*/ break;
case 18:
# line 145 "bc.y"
{ warranty (""); } /*NOTREACHED*/ break;
case 19:
# line 147 "bc.y"
{ limits (); } /*NOTREACHED*/ break;
case 20:
# line 149 "bc.y"
{
			      if (yypvt[-0].i_value & 2)
				warn ("comparison in expression");
			      if (yypvt[-0].i_value & 1)
				generate ("W");
			      else 
				generate ("p");
			    } /*NOTREACHED*/ break;
case 21:
# line 158 "bc.y"
{
			      yyval.i_value = 0;
			      generate ("w");
			      generate (yypvt[-0].s_value);
			      free (yypvt[-0].s_value);
			    } /*NOTREACHED*/ break;
case 22:
# line 165 "bc.y"
{
			      if (break_label == 0)
				yyerror ("Break outside a for/while");
			      else
				{
				  sprintf (genstr, "J%1d:", break_label);
				  generate (genstr);
				}
			    } /*NOTREACHED*/ break;
case 23:
# line 175 "bc.y"
{
			      warn ("Continue statement");
			      if (continue_label == 0)
				yyerror ("Continue outside a for");
			      else
				{
				  sprintf (genstr, "J%1d:", continue_label);
				  generate (genstr);
				}
			    } /*NOTREACHED*/ break;
case 24:
# line 186 "bc.y"
{ exit (0); } /*NOTREACHED*/ break;
case 25:
# line 188 "bc.y"
{ generate ("h"); } /*NOTREACHED*/ break;
case 26:
# line 190 "bc.y"
{ generate ("0R"); } /*NOTREACHED*/ break;
case 27:
# line 192 "bc.y"
{ generate ("R"); } /*NOTREACHED*/ break;
case 28:
# line 194 "bc.y"
{
			      yypvt[-0].i_value = break_label; 
			      break_label = next_label++;
			    } /*NOTREACHED*/ break;
case 29:
# line 199 "bc.y"
{
			      if (yypvt[-1].i_value > 1)
				warn ("Comparison in first for expression");
			      yypvt[-1].i_value = next_label++;
			      if (yypvt[-1].i_value < 0)
				sprintf (genstr, "N%1d:", yypvt[-1].i_value);
			      else
				sprintf (genstr, "pN%1d:", yypvt[-1].i_value);
			      generate (genstr);
			    } /*NOTREACHED*/ break;
case 30:
# line 210 "bc.y"
{
			      if (yypvt[-1].i_value < 0) generate ("1");
			      yypvt[-1].i_value = next_label++;
			      sprintf (genstr, "B%1d:J%1d:", yypvt[-1].i_value, break_label);
			      generate (genstr);
			      yyval.i_value = continue_label;
			      continue_label = next_label++;
			      sprintf (genstr, "N%1d:", continue_label);
			      generate (genstr);
			    } /*NOTREACHED*/ break;
case 31:
# line 221 "bc.y"
{
			      if (yypvt[-1].i_value > 1)
				warn ("Comparison in third for expression");
			      if (yypvt[-1].i_value < 0)
				sprintf (genstr, "J%1d:N%1d:", yypvt[-7].i_value, yypvt[-4].i_value);
			      else
				sprintf (genstr, "pJ%1d:N%1d:", yypvt[-7].i_value, yypvt[-4].i_value);
			      generate (genstr);
			    } /*NOTREACHED*/ break;
case 32:
# line 231 "bc.y"
{
			      sprintf (genstr, "J%1d:N%1d:",
				       continue_label, break_label);
			      generate (genstr);
			      break_label = yypvt[-12].i_value;
			      continue_label = yypvt[-4].i_value;
			    } /*NOTREACHED*/ break;
case 33:
# line 239 "bc.y"
{
			      yypvt[-1].i_value = if_label;
			      if_label = next_label++;
			      sprintf (genstr, "Z%1d:", if_label);
			      generate (genstr);
			    } /*NOTREACHED*/ break;
case 34:
# line 246 "bc.y"
{
			      sprintf (genstr, "N%1d:", if_label); 
			      generate (genstr);
			      if_label = yypvt[-4].i_value;
			    } /*NOTREACHED*/ break;
case 35:
# line 252 "bc.y"
{
			      yypvt[-0].i_value = next_label++;
			      sprintf (genstr, "N%1d:", yypvt[-0].i_value);
			      generate (genstr);
			    } /*NOTREACHED*/ break;
case 36:
# line 258 "bc.y"
{
			      yypvt[-0].i_value = break_label; 
			      break_label = next_label++;
			      sprintf (genstr, "Z%1d:", break_label);
			      generate (genstr);
			    } /*NOTREACHED*/ break;
case 37:
# line 265 "bc.y"
{
			      sprintf (genstr, "J%1d:N%1d:", yypvt[-6].i_value, break_label);
			      generate (genstr);
			      break_label = yypvt[-3].i_value;
			    } /*NOTREACHED*/ break;
case 38:
# line 271 "bc.y"
{ yyval.i_value = 0; } /*NOTREACHED*/ break;
case 39:
# line 273 "bc.y"
{  warn ("print statement"); } /*NOTREACHED*/ break;
case 43:
# line 280 "bc.y"
{
			      generate ("O");
			      generate (yypvt[-0].s_value);
			      free (yypvt[-0].s_value);
			    } /*NOTREACHED*/ break;
case 44:
# line 286 "bc.y"
{ generate ("P"); } /*NOTREACHED*/ break;
case 46:
# line 290 "bc.y"
{
			      warn ("else clause in if statement");
			      yypvt[-0].i_value = next_label++;
			      sprintf (genstr, "J%d:N%1d:", yypvt[-0].i_value, if_label); 
			      generate (genstr);
			      if_label = yypvt[-0].i_value;
			    } /*NOTREACHED*/ break;
case 48:
# line 300 "bc.y"
{
			      /* Check auto list against parameter list? */
			      check_params (yypvt[-4].a_value,yypvt[-0].a_value);
			      sprintf (genstr, "F%d,%s.%s[", lookup(yypvt[-6].s_value,FUNCT), 
				       arg_str (yypvt[-4].a_value,TRUE), arg_str (yypvt[-0].a_value,TRUE));
			      generate (genstr);
			      free_args (yypvt[-4].a_value);
			      free_args (yypvt[-0].a_value);
			      yypvt[-7].i_value = next_label;
			      next_label = 0;
			    } /*NOTREACHED*/ break;
case 49:
# line 312 "bc.y"
{
			      generate ("0R]");
			      next_label = yypvt[-11].i_value;
			    } /*NOTREACHED*/ break;
case 50:
# line 318 "bc.y"
{ yyval.a_value = NULL; } /*NOTREACHED*/ break;
case 52:
# line 322 "bc.y"
{ yyval.a_value = NULL; } /*NOTREACHED*/ break;
case 53:
# line 324 "bc.y"
{ yyval.a_value = yypvt[-1].a_value; } /*NOTREACHED*/ break;
case 54:
# line 326 "bc.y"
{ yyval.a_value = yypvt[-1].a_value; } /*NOTREACHED*/ break;
case 55:
# line 329 "bc.y"
{ yyval.a_value = nextarg (NULL, lookup (yypvt[-0].s_value,SIMPLE)); } /*NOTREACHED*/ break;
case 56:
# line 331 "bc.y"
{ yyval.a_value = nextarg (NULL, lookup (yypvt[-2].s_value,ARRAY)); } /*NOTREACHED*/ break;
case 57:
# line 333 "bc.y"
{ yyval.a_value = nextarg (yypvt[-2].a_value, lookup (yypvt[-0].s_value,SIMPLE)); } /*NOTREACHED*/ break;
case 58:
# line 335 "bc.y"
{ yyval.a_value = nextarg (yypvt[-4].a_value, lookup (yypvt[-2].s_value,ARRAY)); } /*NOTREACHED*/ break;
case 59:
# line 338 "bc.y"
{ yyval.a_value = NULL; } /*NOTREACHED*/ break;
case 61:
# line 342 "bc.y"
{
			      if (yypvt[-0].i_value > 1) warn ("comparison in argument");
			      yyval.a_value = nextarg (NULL,0);
			    } /*NOTREACHED*/ break;
case 62:
# line 347 "bc.y"
{
			      sprintf (genstr, "K%d:", -lookup (yypvt[-2].s_value,ARRAY));
			      generate (genstr);
			      yyval.a_value = nextarg (NULL,1);
			    } /*NOTREACHED*/ break;
case 63:
# line 353 "bc.y"
{
			      if (yypvt[-0].i_value > 1) warn ("comparison in argument");
			      yyval.a_value = nextarg (yypvt[-2].a_value,0);
			    } /*NOTREACHED*/ break;
case 64:
# line 358 "bc.y"
{
			      sprintf (genstr, "K%d:", -lookup (yypvt[-2].s_value,ARRAY));
			      generate (genstr);
			      yyval.a_value = nextarg (yypvt[-4].a_value,1);
			    } /*NOTREACHED*/ break;
case 65:
# line 365 "bc.y"
{
			      yyval.i_value = -1;
			      warn ("Missing expression in for statement");
			    } /*NOTREACHED*/ break;
case 67:
# line 372 "bc.y"
{
			      yyval.i_value = 0;
			      generate ("0");
			    } /*NOTREACHED*/ break;
case 68:
# line 377 "bc.y"
{
			      if (yypvt[-0].i_value > 1)
				warn ("comparison in return expresion");
			    } /*NOTREACHED*/ break;
case 69:
# line 383 "bc.y"
{
			      if (yypvt[-0].c_value != '=')
				{
				  if (yypvt[-1].i_value < 0)
				    sprintf (genstr, "DL%d:", -yypvt[-1].i_value);
				  else
				    sprintf (genstr, "l%d:", yypvt[-1].i_value);
				  generate (genstr);
				}
			    } /*NOTREACHED*/ break;
case 70:
# line 394 "bc.y"
{
			      if (yypvt[-0].i_value > 1) warn("comparison in assignment");
			      if (yypvt[-2].c_value != '=')
				{
				  sprintf (genstr, "%c", yypvt[-2].c_value);
				  generate (genstr);
				}
			      if (yypvt[-3].i_value < 0)
				sprintf (genstr, "S%d:", -yypvt[-3].i_value);
			      else
				sprintf (genstr, "s%d:", yypvt[-3].i_value);
			      generate (genstr);
			      yyval.i_value = 0;
			    } /*NOTREACHED*/ break;
case 71:
# line 410 "bc.y"
{
			      warn("&& operator");
			      yypvt[-0].i_value = next_label++;
			      sprintf (genstr, "DZ%d:p", yypvt[-0].i_value);
			      generate (genstr);
			    } /*NOTREACHED*/ break;
case 72:
# line 417 "bc.y"
{
			      sprintf (genstr, "DZ%d:p1N%d:", yypvt[-2].i_value, yypvt[-2].i_value);
			      generate (genstr);
			      yyval.i_value = yypvt[-3].i_value | yypvt[-0].i_value;
			    } /*NOTREACHED*/ break;
case 73:
# line 423 "bc.y"
{
			      warn("|| operator");
			      yypvt[-0].i_value = next_label++;
			      sprintf (genstr, "B%d:", yypvt[-0].i_value);
			      generate (genstr);
			    } /*NOTREACHED*/ break;
case 74:
# line 430 "bc.y"
{
			      int tmplab;
			      tmplab = next_label++;
			      sprintf (genstr, "B%d:0J%d:N%d:1N%d:",
				       yypvt[-2].i_value, tmplab, yypvt[-2].i_value, tmplab);
			      generate (genstr);
			      yyval.i_value = yypvt[-3].i_value | yypvt[-0].i_value;
			    } /*NOTREACHED*/ break;
case 75:
# line 439 "bc.y"
{
			      yyval.i_value = yypvt[-0].i_value;
			      warn("! operator");
			      generate ("!");
			    } /*NOTREACHED*/ break;
case 76:
# line 445 "bc.y"
{
			      yyval.i_value = 3;
			      switch (*(yypvt[-1].s_value))
				{
				case '=':
				  generate ("=");
				  break;

				case '!':
				  generate ("#");
				  break;

				case '<':
				  if (yypvt[-1].s_value[1] == '=')
				    generate ("{");
				  else
				    generate ("<");
				  break;

				case '>':
				  if (yypvt[-1].s_value[1] == '=')
				    generate ("}");
				  else
				    generate (">");
				  break;
				}
			    } /*NOTREACHED*/ break;
case 77:
# line 473 "bc.y"
{
			      generate ("+");
			      yyval.i_value = yypvt[-2].i_value | yypvt[-0].i_value;
			    } /*NOTREACHED*/ break;
case 78:
# line 478 "bc.y"
{
			      generate ("-");
			      yyval.i_value = yypvt[-2].i_value | yypvt[-0].i_value;
			    } /*NOTREACHED*/ break;
case 79:
# line 483 "bc.y"
{
			      genstr[0] = yypvt[-1].c_value;
			      genstr[1] = 0;
			      generate (genstr);
			      yyval.i_value = yypvt[-2].i_value | yypvt[-0].i_value;
			    } /*NOTREACHED*/ break;
case 80:
# line 490 "bc.y"
{
			      generate ("^");
			      yyval.i_value = yypvt[-2].i_value | yypvt[-0].i_value;
			    } /*NOTREACHED*/ break;
case 81:
# line 495 "bc.y"
{
			      generate ("n");
			      yyval.i_value = yypvt[-0].i_value;
			    } /*NOTREACHED*/ break;
case 82:
# line 500 "bc.y"
{
			      yyval.i_value = 1;
			      if (yypvt[-0].i_value < 0)
				sprintf (genstr, "L%d:", -yypvt[-0].i_value);
			      else
				sprintf (genstr, "l%d:", yypvt[-0].i_value);
			      generate (genstr);
			    } /*NOTREACHED*/ break;
case 83:
# line 509 "bc.y"
{
			      int len = strlen(yypvt[-0].s_value);
			      yyval.i_value = 1;
			      if (len == 1 && *yypvt[-0].s_value == '0')
				generate ("0");
			      else if (len == 1 && *yypvt[-0].s_value == '1')
				generate ("1");
			      else
				{
				  generate ("K");
				  generate (yypvt[-0].s_value);
				  generate (":");
				}
			      free (yypvt[-0].s_value);
			    } /*NOTREACHED*/ break;
case 84:
# line 525 "bc.y"
{ yyval.i_value = yypvt[-1].i_value | 1; } /*NOTREACHED*/ break;
case 85:
# line 527 "bc.y"
{
			      yyval.i_value = 1;
			      if (yypvt[-1].a_value != NULL)
				{ 
				  sprintf (genstr, "C%d,%s:",
					   lookup (yypvt[-3].s_value,FUNCT),
					   arg_str (yypvt[-1].a_value,FALSE));
				  free_args (yypvt[-1].a_value);
				}
			      else
				{
				  sprintf (genstr, "C%d:", lookup (yypvt[-3].s_value,FUNCT));
				}
			      generate (genstr);
			    } /*NOTREACHED*/ break;
case 86:
# line 543 "bc.y"
{
			      yyval.i_value = 1;
			      if (yypvt[-0].i_value < 0)
				{
				  if (yypvt[-1].c_value == '+')
				    sprintf (genstr, "DA%d:L%d:", -yypvt[-0].i_value, -yypvt[-0].i_value);
				  else
				    sprintf (genstr, "DM%d:L%d:", -yypvt[-0].i_value, -yypvt[-0].i_value);
				}
			      else
				{
				  if (yypvt[-1].c_value == '+')
				    sprintf (genstr, "i%d:l%d:", yypvt[-0].i_value, yypvt[-0].i_value);
				  else
				    sprintf (genstr, "d%d:l%d:", yypvt[-0].i_value, yypvt[-0].i_value);
				}
			      generate (genstr);
			    } /*NOTREACHED*/ break;
case 87:
# line 562 "bc.y"
{
			      yyval.i_value = 1;
			      if (yypvt[-1].i_value < 0)
				{
				  sprintf (genstr, "DL%d:x", -yypvt[-1].i_value);
				  generate (genstr); 
				  if (yypvt[-0].c_value == '+')
				    sprintf (genstr, "A%d:", -yypvt[-1].i_value);
				  else
				      sprintf (genstr, "M%d:", -yypvt[-1].i_value);
				}
			      else
				{
				  sprintf (genstr, "l%d:", yypvt[-1].i_value);
				  generate (genstr);
				  if (yypvt[-0].c_value == '+')
				    sprintf (genstr, "i%d:", yypvt[-1].i_value);
				  else
				    sprintf (genstr, "d%d:", yypvt[-1].i_value);
				}
			      generate (genstr);
			    } /*NOTREACHED*/ break;
case 88:
# line 585 "bc.y"
{ generate ("cL"); yyval.i_value = 1;} /*NOTREACHED*/ break;
case 89:
# line 587 "bc.y"
{ generate ("cR"); yyval.i_value = 1;} /*NOTREACHED*/ break;
case 90:
# line 589 "bc.y"
{ generate ("cS"); yyval.i_value = 1;} /*NOTREACHED*/ break;
case 91:
# line 591 "bc.y"
{
			      warn ("read function");
			      generate ("cI"); yyval.i_value = 1;
			    } /*NOTREACHED*/ break;
case 92:
# line 597 "bc.y"
{ yyval.i_value = lookup(yypvt[-0].s_value,SIMPLE); } /*NOTREACHED*/ break;
case 93:
# line 599 "bc.y"
{
			      if (yypvt[-1].i_value > 1) warn("comparison in subscript");
			      yyval.i_value = lookup(yypvt[-3].s_value,ARRAY);
			    } /*NOTREACHED*/ break;
case 94:
# line 604 "bc.y"
{ yyval.i_value = 0; } /*NOTREACHED*/ break;
case 95:
# line 606 "bc.y"
{ yyval.i_value = 1; } /*NOTREACHED*/ break;
case 96:
# line 608 "bc.y"
{ yyval.i_value = 2; } /*NOTREACHED*/ break;
case 97:
# line 610 "bc.y"
{ yyval.i_value = 3; } /*NOTREACHED*/ break;
}


	goto yystack;		/* reset registers in driver code */
}
