
# line 22 "parse.y"
#include <stdio.h>
#include <sys/types.h>
#include <signal.h>
#include "bashansi.h"
#include "shell.h"
#include "flags.h"
#include "input.h"

#if defined (READLINE)
#  include <readline/readline.h>
#endif /* READLINE */

#if defined (HISTORY)
#  include <readline/history.h>
#endif /* HISTORY */

#if defined (JOB_CONTROL)
#  include "jobs.h"
#endif /* JOB_CONTROL */

#if defined (ALIAS)
#  include "alias.h"
#endif /* ALIAS */

#if defined (PROMPT_STRING_DECODE)
#include <sys/param.h>
#include <time.h>
#include "maxpath.h"
#endif /* PROMPT_STRING_DECODE */

#define YYDEBUG 1
extern int eof_encountered;
extern int no_line_editing;
extern int interactive, interactive_shell;
extern int posixly_correct;
extern int last_command_exit_value;

/* **************************************************************** */
/*								    */
/*		    "Forward" declarations			    */
/*								    */
/* **************************************************************** */

/* This is kind of sickening.  In order to let these variables be seen by
   all the functions that need them, I am forced to place their declarations
   far away from the place where they should logically be found. */

static int reserved_word_acceptable ();
static int read_token ();

static void report_syntax_error ();
static void handle_eof_input_unit ();
static void prompt_again ();
static void bash_add_history ();
static void reset_readline_prompt ();

/* PROMPT_STRING_POINTER points to one of these, never to an actual string. */
char *ps1_prompt, *ps2_prompt;

/* Handle on the current prompt string.  Indirectly points through
   ps1_ or ps2_prompt. */
char **prompt_string_pointer = (char **)NULL;
char *current_prompt_string;

char *decode_prompt_string ();

void gather_here_documents ();

/* The number of lines read from input while creating the current command. */
int current_command_line_count = 0;

/* Variables to manage the task of reading here documents, because we need to
   defer the reading until after a complete command has been collected. */
static REDIRECT *redir_stack[10];
int need_here_doc = 0;

# line 99 "parse.y"
typedef union  {
  WORD_DESC *word;		/* the word that we read. */
  int number;			/* the number that we read. */
  WORD_LIST *word_list;
  COMMAND *command;
  REDIRECT *redirect;
  ELEMENT element;
  PATTERN_LIST *pattern;
} YYSTYPE;
# define IF 257
# define THEN 258
# define ELSE 259
# define ELIF 260
# define FI 261
# define CASE 262
# define ESAC 263
# define FOR 264
# define WHILE 265
# define UNTIL 266
# define DO 267
# define DONE 268
# define FUNCTION 269
# define IN 270
# define BANG 271
# define WORD 272
# define ASSIGNMENT_WORD 273
# define NUMBER 274
# define AND_AND 275
# define OR_OR 276
# define GREATER_GREATER 277
# define LESS_LESS 278
# define LESS_AND 279
# define GREATER_AND 280
# define SEMI_SEMI 281
# define LESS_LESS_MINUS 282
# define AND_GREATER 283
# define LESS_GREATER 284
# define GREATER_BAR 285
# define yacc_EOF 286
#define yyclearin yychar = -1
#define yyerrok yyerrflag = 0
extern int yychar;
extern int yyerrflag;
#ifndef YYMAXDEPTH
#define YYMAXDEPTH 150
#endif
YYSTYPE yylval, yyval;
typedef int yytabelem;
# define YYERRCODE 256

# line 557 "parse.y"


/* Initial size to allocate for tokens, and the
   amount to grow them by. */
#define TOKEN_DEFAULT_GROW_SIZE 512

/* The token currently being read. */
int current_token = 0;

/* The last read token, or NULL.  read_token () uses this for context
   checking. */
int last_read_token = 0;

/* The token read prior to last_read_token. */
int token_before_that = 0;

/* Global var is non-zero when end of file has been reached. */
int EOF_Reached = 0;

/* yy_getc () returns the next available character from input or EOF.
   yy_ungetc (c) makes `c' the next character to read.
   init_yy_io (get, unget, type, location) makes the function GET the
   installed function for getting the next character, makes UNGET the
   installed function for un-getting a character, sets the type of stream
   (either string or file) from TYPE, and makes LOCATION point to where
   the input is coming from. */

/* Unconditionally returns end-of-file. */
return_EOF ()
{
  return (EOF);
}

/* Variable containing the current get and unget functions.
   See ./input.h for a clearer description. */
BASH_INPUT bash_input;

/* Set all of the fields in BASH_INPUT to NULL. */
void
initialize_bash_input ()
{
  bash_input.type = 0;
  bash_input.name = (char *)NULL;
  bash_input.location.file = (FILE *)NULL;
  bash_input.location.string = (char *)NULL;
  bash_input.getter = (Function *)NULL;
  bash_input.ungetter = (Function *)NULL;
}

/* Set the contents of the current bash input stream from
   GET, UNGET, TYPE, NAME, and LOCATION. */
init_yy_io (get, unget, type, name, location)
     Function *get, *unget;
     int type;
     char *name;
     INPUT_STREAM location;
{
  bash_input.type = type;
  if (bash_input.name)
    free (bash_input.name);

  if (name)
    bash_input.name = savestring (name);
  else
    bash_input.name = (char *)NULL;

  bash_input.location = location;
  bash_input.getter = get;
  bash_input.ungetter = unget;
}

/* Call this to get the next character of input. */
yy_getc ()
{
  return (*(bash_input.getter)) ();
}

/* Call this to unget C.  That is, to make C the next character
   to be read. */
yy_ungetc (c)
{
  return (*(bash_input.ungetter)) (c);
}

#if defined (BUFFERED_INPUT)
int
input_file_descriptor ()
{
  switch (bash_input.type)
    {
    case st_stream:
      return (fileno (bash_input.location.file));
    case st_bstream:
      return (bash_input.location.buffered_fd);
    default:
      return (fileno (stdin));
    }
}
#endif /* BUFFERED_INPUT */

/* **************************************************************** */
/*								    */
/*		  Let input be read from readline ().		    */
/*								    */
/* **************************************************************** */

#if defined (READLINE)
char *current_readline_prompt = (char *)NULL;
char *current_readline_line = (char *)NULL;
int current_readline_line_index = 0;

static int readline_initialized_yet = 0;
int
yy_readline_get ()
{
  if (!current_readline_line)
    {
      extern sighandler sigint_sighandler ();
      extern int interrupt_immediately;
      extern char *readline ();
      SigHandler *old_sigint;
#if defined (JOB_CONTROL)
      extern pid_t shell_pgrp;
      extern int job_control;
#endif /* JOB_CONTROL */

      if (!readline_initialized_yet)
	{
	  initialize_readline ();
	  readline_initialized_yet = 1;
	}

#if defined (JOB_CONTROL)
      if (job_control)
	give_terminal_to (shell_pgrp);
#endif /* JOB_CONTROL */

      old_sigint =
	(SigHandler *) set_signal_handler (SIGINT, sigint_sighandler);
      interrupt_immediately++;

      if (!current_readline_prompt)
	current_readline_line = readline ("");
      else
	current_readline_line = readline (current_readline_prompt);

      interrupt_immediately--;
      set_signal_handler (SIGINT, old_sigint);

      /* Reset the prompt to whatever is in the decoded value of
	 prompt_string_pointer. */
      reset_readline_prompt ();

      current_readline_line_index = 0;

      if (!current_readline_line)
	{
	  current_readline_line_index = 0;
	  return (EOF);
	}

      current_readline_line =
	(char *)xrealloc (current_readline_line,
			  2 + strlen (current_readline_line));
      strcat (current_readline_line, "\n");
    }

  if (!current_readline_line[current_readline_line_index])
    {
      free (current_readline_line);
      current_readline_line = (char *)NULL;
      return (yy_readline_get ());
    }
  else
    {
      int c = current_readline_line[current_readline_line_index++];
      return (c);
    }
}

int
yy_readline_unget (c)
{
  if (current_readline_line_index && current_readline_line)
    current_readline_line[--current_readline_line_index] = c;
  return (c);
}
  
with_input_from_stdin ()
{
  INPUT_STREAM location;

  location.string = current_readline_line;
  init_yy_io (yy_readline_get, yy_readline_unget,
	      st_string, "readline stdin", location);
}

#else  /* !READLINE */

with_input_from_stdin ()
{
  with_input_from_stream (stdin, "stdin");
}
#endif	/* !READLINE */

/* **************************************************************** */
/*								    */
/*   Let input come from STRING.  STRING is zero terminated.	    */
/*								    */
/* **************************************************************** */

int
yy_string_get ()
{
  register char *string;
  register int c;

  string = bash_input.location.string;
  c = EOF;

  /* If the string doesn't exist, or is empty, EOF found. */
  if (string && *string)
    {
      c = *string++;
      bash_input.location.string = string;
    }
  return (c);
}

int
yy_string_unget (c)
     int c;
{
  *(--bash_input.location.string) = c;
  return (c);
}

void
with_input_from_string (string, name)
     char *string;
     char *name;
{
  INPUT_STREAM location;

  location.string = string;

  init_yy_io (yy_string_get, yy_string_unget, st_string, name, location);
}

/* **************************************************************** */
/*								    */
/*		     Let input come from STREAM.		    */
/*								    */
/* **************************************************************** */

int
yy_stream_get ()
{
  int result = EOF;

  if (bash_input.location.file)
#if defined (NO_READ_RESTART_ON_SIGNAL)
    result = getc_with_restart (bash_input.location.file);
#else
    result = getc (bash_input.location.file);
#endif /* !NO_READ_RESTART_ON_SIGNAL */
  return (result);
}

int
yy_stream_unget (c)
     int c;
{
  return (ungetc (c, bash_input.location.file));
}

with_input_from_stream (stream, name)
     FILE *stream;
     char *name;
{
  INPUT_STREAM location;

  location.file = stream;
  init_yy_io (yy_stream_get, yy_stream_unget, st_stream, name, location);
}

typedef struct stream_saver {
  struct stream_saver *next;
  BASH_INPUT bash_input;
  int line;
#if defined (BUFFERED_INPUT)
  BUFFERED_STREAM *bstream;
#endif /* BUFFERED_INPUT */
} STREAM_SAVER;

/* The globally known line number. */
int line_number = 0;

STREAM_SAVER *stream_list = (STREAM_SAVER *)NULL;

push_stream ()
{
  STREAM_SAVER *saver = (STREAM_SAVER *)xmalloc (sizeof (STREAM_SAVER));

  bcopy (&bash_input, &(saver->bash_input), sizeof (BASH_INPUT));

#if defined (BUFFERED_INPUT)
  saver->bstream = (BUFFERED_STREAM *)NULL;
  /* If we have a buffered stream, clear out buffers[fd]. */
  if (bash_input.type == st_bstream)
    {
      saver->bstream = buffers[bash_input.location.buffered_fd];
      buffers[bash_input.location.buffered_fd] = (BUFFERED_STREAM *)NULL;
    }
#endif /* BUFFERED_INPUT */

  saver->line = line_number;
  bash_input.name = (char *)NULL;
  saver->next = stream_list;
  stream_list = saver;
  EOF_Reached = line_number = 0;
}

pop_stream ()
{
  if (!stream_list)
    {
      EOF_Reached = 1;
    }
  else
    {
      STREAM_SAVER *saver = stream_list;

      EOF_Reached = 0;
      stream_list = stream_list->next;

      init_yy_io (saver->bash_input.getter,
		  saver->bash_input.ungetter,
		  saver->bash_input.type,
		  saver->bash_input.name,
		  saver->bash_input.location);

#if defined (BUFFERED_INPUT)
      /* If we have a buffered stream, restore buffers[fd]. */
      if (bash_input.type == st_bstream)
        buffers[bash_input.location.buffered_fd] = saver->bstream;
#endif /* BUFFERED_INPUT */

      line_number = saver->line;

      if (saver->bash_input.name)
	free (saver->bash_input.name);
      free (saver);
    }
}

/*
 * This is used to inhibit alias expansion and reserved word recognition
 * inside case statement pattern lists.  A `case statement pattern list'
 * is:
 *	everything between the `in' in a `case word in' and the next ')'
 *	or `esac'
 *	everything between a `;;' and the next `)' or `esac'
 */
static int in_case_pattern_list = 0;

#if defined (ALIAS)
/*
 * Pseudo-global variables used in implementing token-wise alias expansion.
 */

static int expand_next_token = 0;

/*
 * Pushing and popping strings.  This works together with shell_getc to 
 * implement alias expansion on a per-token basis.
 */

typedef struct string_saver {
  struct string_saver *next;
  int expand_alias;  /* Value to set expand_alias to when string is popped. */
  char *saved_line;
  int saved_line_size, saved_line_index, saved_line_terminator;
} STRING_SAVER;

STRING_SAVER *pushed_string_list = (STRING_SAVER *)NULL;

static void save_expansion ();

/*
 * Push the current shell_input_line onto a stack of such lines and make S
 * the current input.  Used when expanding aliases.  EXPAND is used to set
 * the value of expand_next_token when the string is popped, so that the
 * word after the alias in the original line is handled correctly when the
 * alias expands to multiple words.  TOKEN is the token that was expanded
 * into S; it is saved and used to prevent infinite recursive expansion.
 */
static void
push_string (s, expand, token)
     char *s;
     int expand;
     char *token;
{
  extern char *shell_input_line;
  extern int shell_input_line_size, shell_input_line_index,
	     shell_input_line_terminator;
  STRING_SAVER *temp = (STRING_SAVER *) xmalloc (sizeof (STRING_SAVER));

  temp->expand_alias = expand;
  temp->saved_line = shell_input_line;
  temp->saved_line_size = shell_input_line_size;
  temp->saved_line_index = shell_input_line_index;
  temp->saved_line_terminator = shell_input_line_terminator;
  temp->next = pushed_string_list;
  pushed_string_list = temp;

  save_expansion (token);

  shell_input_line = s;
  shell_input_line_size = strlen (s);
  shell_input_line_index = 0;
  shell_input_line_terminator = '\0';
  expand_next_token = 0;
}

/*
 * Make the top of the pushed_string stack be the current shell input.
 * Only called when there is something on the stack.  Called from shell_getc
 * when it thinks it has consumed the string generated by an alias expansion
 * and needs to return to the original input line.
 */
static void
pop_string ()
{
  extern char *shell_input_line;
  extern int shell_input_line_size, shell_input_line_index,
	     shell_input_line_terminator;
  STRING_SAVER *t;

  if (shell_input_line)
    free (shell_input_line);
  shell_input_line = pushed_string_list->saved_line;
  shell_input_line_index = pushed_string_list->saved_line_index;
  shell_input_line_size = pushed_string_list->saved_line_size;
  shell_input_line_terminator = pushed_string_list->saved_line_terminator;
  expand_next_token = pushed_string_list->expand_alias;

  t = pushed_string_list;
  pushed_string_list = pushed_string_list->next;
  free((char *)t);
}

static void
free_string_list ()
{
  register STRING_SAVER *t = pushed_string_list, *t1;

  while (t)
    {
      t1 = t->next;
      if (t->saved_line)
	free (t->saved_line);
      free ((char *)t);
      t = t1;
    }
  pushed_string_list = (STRING_SAVER *)NULL;
}

/* This is a stack to save the values of all tokens for which alias
   expansion has been performed during the current call to read_token ().
   It is used to prevent alias expansion loops:

      alias foo=bar
      alias bar=baz
      alias baz=foo

   Ideally this would be taken care of by push and pop string, but because
   of when strings are popped the stack will not contain the correct
   strings to test against.  (The popping is done in shell_getc, so that when
   the current string is exhausted, shell_getc can simply pop that string off
   the stack, restore the previous string, and continue with the character
   following the token whose expansion was originally pushed on the stack.)

   What we really want is a record of all tokens that have been expanded for
   aliases during the `current' call to read_token().  This does that, at the
   cost of being somewhat special-purpose (OK, OK vile and unclean). */

typedef struct _exp_saver {
      struct _exp_saver *next;
      char *saved_token;
} EXPANSION_SAVER;

EXPANSION_SAVER *expanded_token_stack = (EXPANSION_SAVER *)NULL;

static void
save_expansion (s)
     char *s;
{
  EXPANSION_SAVER *t;

  t = (EXPANSION_SAVER *) xmalloc (sizeof (EXPANSION_SAVER));
  t->saved_token = savestring (s);
  t->next = expanded_token_stack;
  expanded_token_stack = t;
}

/* Return 1 if TOKEN has already been expanded in the current `stack' of
   expansions.  If it has been expanded already, it will appear as the value
   of saved_token for some entry in the stack of expansions created for the
   current token being expanded. */
static int
token_has_been_expanded (token)
     char *token;
{
  register EXPANSION_SAVER *t = expanded_token_stack;

  while (t)
    {
      if (STREQ (token, t->saved_token))
	return (1);
      t = t->next;
    }
  return (0);
}

static void
free_expansion_stack ()
{
  register EXPANSION_SAVER *t = expanded_token_stack, *t1;

  while (t)
    {
      t1 = t->next;
      free (t->saved_token);
      free (t);
      t = t1;
    }
  expanded_token_stack = (EXPANSION_SAVER *)NULL;
}

#endif /* ALIAS */


#if defined (index)
#  undef index
#endif /* index */

/* Return a line of text, taken from wherever yylex () reads input.
   If there is no more input, then we return NULL.  If REMOVE_QUOTED_NEWLINE
   is non-zero, we remove unquoted \<newline> pairs.  This is used by
   read_secondary_line to read here documents. */
static char *
read_a_line (remove_quoted_newline)
     int remove_quoted_newline;
{
  char *line_buffer = (char *)NULL;
  int index = 0, buffer_size = 0;
  int c, peekc, pass_next;

  pass_next = 0;
  while (1)
    {
      c = yy_getc ();

      /* Allow immediate exit if interrupted during input. */
      QUIT;

      if (c == 0)
	continue;

      /* If there is no more input, then we return NULL. */
      if (c == EOF)
	{
	  c = '\n';
	  if (!line_buffer)
	    return ((char *)NULL);
	}

      /* `+2' in case the final (200'th) character in the buffer is a newline;
	 otherwise the code below that NULL-terminates it will write over the
	 201st slot and kill the range checking in free(). */
      if (index + 2 > buffer_size)
	if (!buffer_size)
	  line_buffer = (char *)xmalloc (buffer_size = 200);
	else
	  line_buffer = (char *)xrealloc (line_buffer, buffer_size += 200);

      /* IF REMOVE_QUOTED_NEWLINES is non-zero, we are reading a
	 here document with an unquoted delimiter.  In this case,
	 the line will be expanded as if it were in double quotes.
	 We allow a backslash to escape the next character, but we
	 need to treat the backslash specially only if a backslash
	 quoting a backslash-newline pair appears in the line. */
      if (pass_next)
        {
	  line_buffer[index++] = c;
	  pass_next = 0;
        }
      else if (c == '\\' && remove_quoted_newline)
	{
	  peekc = yy_getc ();
	  if (peekc == '\n')
	    continue;	/* Make the unquoted \<newline> pair disappear. */
	  else
	    {
	      yy_ungetc (peekc);
	      pass_next = 1;
	      line_buffer[index++] = c;		/* Preserve the backslash. */
	    }
	}
      else
	line_buffer[index++] = c;

      if (c == '\n')
	{
	  line_buffer[index] = '\0';
	  return (line_buffer);
	}
    }
}

/* Return a line as in read_a_line (), but insure that the prompt is
   the secondary prompt.  This is used to read the lines of a here
   document.  REMOVE_QUOTED_NEWLINE is non-zero if we should remove
   newlines quoted with backslashes while reading the line.  It is
   non-zero unless the delimiter of the here document was quoted. */
char *
read_secondary_line (remove_quoted_newline)
     int remove_quoted_newline;
{
  prompt_string_pointer = &ps2_prompt;
  prompt_again ();
  return (read_a_line (remove_quoted_newline));
}


/* **************************************************************** */
/*								    */
/*				YYLEX ()			    */
/*								    */
/* **************************************************************** */

/* Reserved words.  These are only recognized as the first word of a
   command. */
STRING_INT_ALIST word_token_alist[] = {
  { "if", IF },
  { "then", THEN },
  { "else", ELSE },
  { "elif", ELIF },
  { "fi", FI },
  { "case", CASE },
  { "esac", ESAC },
  { "for", FOR },
  { "while", WHILE },
  { "until", UNTIL },
  { "do", DO },
  { "done", DONE },
  { "in", IN },
  { "function", FUNCTION },
  { "{", '{' },
  { "}", '}' },
  { "!", BANG },
  { (char *)NULL, 0}
};

/* Where shell input comes from.  History expansion is performed on each
   line when the shell is interactive. */
char *shell_input_line = (char *)NULL;
int shell_input_line_index = 0;
int shell_input_line_size = 0;	/* Amount allocated for shell_input_line. */
int shell_input_line_len = 0;	/* strlen (shell_input_line) */

/* Either zero, or EOF. */
int shell_input_line_terminator = 0;

/* Return the next shell input character.  This always reads characters
   from shell_input_line; when that line is exhausted, it is time to
   read the next line.  This is called by read_token when the shell is
   processing normal command input. */
static int
shell_getc (remove_quoted_newline)
     int remove_quoted_newline;
{
  int c;

  QUIT;

#if defined (ALIAS)
  /* If shell_input_line[shell_input_line_index] == 0, but there is
     something on the pushed list of strings, then we don't want to go
     off and get another line.  We let the code down below handle it. */

  if (!shell_input_line || ((!shell_input_line[shell_input_line_index]) &&
			    (pushed_string_list == (STRING_SAVER *)NULL)))
#else /* !ALIAS */
  if (!shell_input_line || !shell_input_line[shell_input_line_index])
#endif /* !ALIAS */
    {
      register int i, l;

      restart_read_next_line:

      line_number++;

    restart_read:

      /* Allow immediate exit if interrupted during input. */
      QUIT;

      i = 0;
      shell_input_line_terminator = 0;

#if defined (JOB_CONTROL)
      /* This can cause a problem when reading a command as the result
	 of a trap, when the trap is called from flush_child.  This call
	 had better not cause jobs to disappear from the job table in
	 that case, or we will have big trouble. */
      notify_and_cleanup ();
#else /* !JOB_CONTROL */
      cleanup_dead_jobs ();
#endif /* !JOB_CONTROL */

      if (bash_input.type == st_stream)
	clearerr (stdin);

      while (c = yy_getc ())
	{
	  /* Allow immediate exit if interrupted during input. */
	  QUIT;

	  if (i + 2 > shell_input_line_size)
	    shell_input_line = (char *)
	      xrealloc (shell_input_line, shell_input_line_size += 256);

	  if (c == EOF)
	    {
	      if (bash_input.type == st_stream)
		clearerr (stdin);

	      if (!i)
		shell_input_line_terminator = EOF;

	      shell_input_line[i] = '\0';
	      break;
	    }

	  shell_input_line[i++] = c;

	  if (c == '\n')
	    {
	      shell_input_line[--i] = '\0';
	      current_command_line_count++;
	      break;
	    }
	}
      shell_input_line_index = 0;
      shell_input_line_len = i;		/* == strlen (shell_input_line) */

#if defined (HISTORY)
      if (interactive && shell_input_line && shell_input_line[0])
	{
	  char *pre_process_line (), *expansions;

	  expansions = pre_process_line (shell_input_line, 1, 1);

	  free (shell_input_line);
	  shell_input_line = expansions;
	  shell_input_line_len = shell_input_line ?
				 strlen (shell_input_line) :
				 0;
	  if (!shell_input_line_len)
	    current_command_line_count--;

	  /* We have to force the xrealloc below because we don't know the
	     true allocated size of shell_input_line anymore. */
	  shell_input_line_size = shell_input_line_len;
	}
#endif /* HISTORY */

      if (shell_input_line)
	{
	  /* Lines that signify the end of the shell's input should not be
	     echoed. */
	  if (echo_input_at_read && (shell_input_line[0] ||
				     shell_input_line_terminator != EOF))
	    fprintf (stderr, "%s\n", shell_input_line);
	}
      else
	{
	  shell_input_line_size = 0;
	  prompt_string_pointer = &current_prompt_string;
	  prompt_again ();
	  goto restart_read;
	}

      /* Add the newline to the end of this string, iff the string does
	 not already end in an EOF character.  */
      if (shell_input_line_terminator != EOF)
	{
	  l = shell_input_line_len;	/* was a call to strlen */

	  if (l + 3 > shell_input_line_size)
	    shell_input_line = (char *)xrealloc (shell_input_line,
					1 + (shell_input_line_size += 2));

	  shell_input_line[l] = '\n';
	  shell_input_line[l + 1] = '\0';
	}
    }
  
  c = shell_input_line[shell_input_line_index];

  if (c)
    shell_input_line_index++;

  if (c == '\\' && remove_quoted_newline &&
      shell_input_line[shell_input_line_index] == '\n')
    {
	prompt_again ();
	goto restart_read_next_line;
    }

#if defined (ALIAS)
  /* If C is NULL, we have reached the end of the current input string.  If
     pushed_string_list is non-empty, it's time to pop to the previous string
     because we have fully consumed the result of the last alias expansion.
     Do it transparently; just return the next character of the string popped
     to. */
  if (!c && (pushed_string_list != (STRING_SAVER *)NULL))
    {
      pop_string ();
      c = shell_input_line[shell_input_line_index];
      if (c)
	shell_input_line_index++;
    }
#endif /* ALIAS */

  if (!c && shell_input_line_terminator == EOF)
    {
      if (shell_input_line_index != 0)
	return ('\n');
      else
	return (EOF);
    }

  return (c);
}

/* Put C back into the input for the shell. */
static void
shell_ungetc (c)
     int c;
{
  if (shell_input_line && shell_input_line_index)
    shell_input_line[--shell_input_line_index] = c;
}

/* Discard input until CHARACTER is seen. */
static void
discard_until (character)
     int character;
{
  int c;

  while ((c = shell_getc (0)) != EOF && c != character)
    ;

  if (c != EOF)
    shell_ungetc (c);
}

#if defined (HISTORY) && defined (HISTORY_REEDITING)
/* Tell readline () that we have some text for it to edit. */
re_edit (text)
     char *text;
{
#if defined (READLINE)
  if (strcmp (bash_input.name, "readline stdin") == 0)
    bash_re_edit (text);
#endif /* READLINE */
}
#endif /* HISTORY && HISTORY_REEDITING */

#if defined (HISTORY)
extern int remember_on_history, history_expansion;
extern int history_control, command_oriented_history;
extern int history_expand ();
extern int history_base, where_history ();

/* Non-zero means do no history expansion on this line, regardless
   of what history_expansion says. */
int history_expansion_inhibited = 0;

/* Do pre-processing on LINE.  If PRINT_CHANGES is non-zero, then
   print the results of expanding the line if there were any changes.
   If there is an error, return NULL, otherwise the expanded line is
   returned.  If ADDIT is non-zero the line is added to the history
   list after history expansion.  ADDIT is just a suggestion;
   REMEMBER_ON_HISTORY can veto, and does.
   Right now this does history expansion. */
char *
pre_process_line (line, print_changes, addit)
     char *line;
     int print_changes, addit;
{
  char *history_value;
  char *return_value;
  int expanded = 0;

  return_value = line;

#  if defined (BANG_HISTORY)
  /* History expand the line.  If this results in no errors, then
     add that line to the history if ADDIT is non-zero. */
  if (!history_expansion_inhibited && history_expansion)
    {
      expanded = history_expand (line, &history_value);

      if (expanded)
	{
	  if (print_changes)
	    fprintf (stderr, "%s\n", history_value);

	  /* If there was an error, return NULL. */
	  if (expanded < 0)
	    {
	      free (history_value);

#    if defined (HISTORY_REEDITING)
	      /* New hack.  We can allow the user to edit the
		 failed history expansion. */
	      re_edit (line);
#    endif /* HISTORY_REEDITING */
	      return ((char *)NULL);
	    }
	}

      /* Let other expansions know that return_value can be free'ed,
	 and that a line has been added to the history list.  Note
	 that we only add lines that have something in them. */
      expanded = 1;
      return_value = history_value;
    }
#  endif /* BANG_HISTORY */

  if (addit && remember_on_history && *return_value)
    {
      int h;

      /* Don't use the value of history_control to affect the second
	 and subsequent lines of a multi-line command when
	 command_oriented_history is enabled. */
      if (command_oriented_history && current_command_line_count > 1)
	h = 0;
      else
	h = history_control;

      switch (h)
	{
	  case 0:
	    bash_add_history (return_value);
	    break;
	  case 1:
	    if (*return_value != ' ')
	      bash_add_history (return_value);
	    break;
	  case 3:
	    if (*return_value == ' ')
	      break;
	    /* FALLTHROUGH if case == 3 (`ignoreboth') */
	  case 2:
	    {
	      HIST_ENTRY *temp;

	      using_history ();
	      temp = previous_history ();

	      if (!temp || (strcmp (temp->line, return_value) != 0))
		bash_add_history (return_value);

	      using_history ();
	    }
	    break;
	}
    }

  if (!expanded)
    return_value = savestring (line);

  return (return_value);
}
#endif /* HISTORY */

/* Place to remember the token.  We try to keep the buffer
   at a reasonable size, but it can grow. */
char *token = (char *)NULL;

/* Current size of the token buffer. */
int token_buffer_size = 0;

static void
execute_prompt_command (command)
     char *command;
{
  extern Function *last_shell_builtin, *this_shell_builtin;
  Function *temp_last, *temp_this;
  char *last_lastarg;
  int temp_exit_value, temp_eof_encountered;

  temp_last = last_shell_builtin;
  temp_this = this_shell_builtin;
  temp_exit_value = last_command_exit_value;
  temp_eof_encountered = eof_encountered;
  last_lastarg = get_string_value ("_");
  if (last_lastarg)
    last_lastarg = savestring (last_lastarg);

  parse_and_execute (savestring (command), "PROMPT_COMMAND");

  last_shell_builtin = temp_last;
  this_shell_builtin = temp_this;
  last_command_exit_value = temp_exit_value;
  eof_encountered = temp_eof_encountered;

  bind_variable ("_", last_lastarg);
  if (last_lastarg)
    free (last_lastarg);
}

/* Command to read_token () explaining what we want it to do. */
#define READ 0
#define RESET 1
#define prompt_is_ps1 \
      (!prompt_string_pointer || prompt_string_pointer == &ps1_prompt)

/* Function for yyparse to call.  yylex keeps track of
   the last two tokens read, and calls read_token.  */

yylex ()
{
  if (interactive && (!current_token || current_token == '\n'))
    {
      /* Before we print a prompt, we might have to check mailboxes.
	 We do this only if it is time to do so. Notice that only here
	 is the mail alarm reset; nothing takes place in check_mail ()
	 except the checking of mail.  Please don't change this. */
      if (prompt_is_ps1 && time_to_check_mail ())
	{
	  check_mail ();
	  reset_mail_timer ();
	}

      /* Allow the execution of a random command just before the printing
	 of each primary prompt.  If the shell variable PROMPT_COMMAND
	 is set then the value of it is the command to execute. */
      if (prompt_is_ps1)
	{
	  char *command_to_execute;

	  command_to_execute = get_string_value ("PROMPT_COMMAND");
	  if (command_to_execute)
	    execute_prompt_command (command_to_execute);
	}
      prompt_again ();
    }

  token_before_that = last_read_token;
  last_read_token = current_token;
  current_token = read_token (READ);
  return (current_token);
}

/* Called from shell.c when Control-C is typed at top level.  Or
   by the error rule at top level. */
reset_parser ()
{
  read_token (RESET);
}
  
/* When non-zero, we have read the required tokens
   which allow ESAC to be the next one read. */
static int allow_esac_as_next = 0;

/* When non-zero, accept single '{' as a token itself. */
static int allow_open_brace = 0;

/* DELIMITERS is a stack of the nested delimiters that we have
   encountered so far. */
static char *delimiters = (char *)NULL;

/* Offset into the stack of delimiters. */
static int delimiter_depth = 0;

/* How many slots are allocated to DELIMITERS. */
static int delimiter_space = 0;

void
gather_here_documents ()
{
  int r = 0;
  while (need_here_doc)
    {
      make_here_document (redir_stack[r++]);
      need_here_doc--;
    }
}

/* Macro for accessing the top delimiter on the stack.  Returns the
   delimiter or zero if none. */
#define current_delimiter() \
  (delimiter_depth ? delimiters[delimiter_depth - 1] : 0)

#define push_delimiter(character) \
  do \
    { \
      if (delimiter_depth + 2 > delimiter_space) \
	delimiters = (char *)xrealloc \
	  (delimiters, (delimiter_space += 10) * sizeof (char)); \
      delimiters[delimiter_depth] = character; \
      delimiter_depth++; \
    } \
  while (0)

/* When non-zero, an open-brace used to create a group is awaiting a close
   brace partner. */
static int open_brace_awaiting_satisfaction = 0;

/* If non-zero, it is the token that we want read_token to return regardless
   of what text is (or isn't) present to be read.  read_token resets this. */
int token_to_read = 0;

#define command_token_position(token) \
  (((token) == ASSIGNMENT_WORD) || \
   ((token) != SEMI_SEMI && reserved_word_acceptable(token)))

#define assignment_acceptable(token) command_token_position(token) && \
					(in_case_pattern_list == 0)

/* Check to see if TOKEN is a reserved word and return the token
   value if it is. */
#define CHECK_FOR_RESERVED_WORD(token) \
  do { \
    if (!dollar_present && !quoted && \
	reserved_word_acceptable (last_read_token)) \
      { \
	int i; \
	for (i = 0; word_token_alist[i].word != (char *)NULL; i++) \
	  if (STREQ (token, word_token_alist[i].word)) \
	    { \
	      if (in_case_pattern_list && (word_token_alist[i].token != ESAC)) \
		break; \
\
	      if (word_token_alist[i].token == ESAC) \
		in_case_pattern_list = 0; \
\
	      if (word_token_alist[i].token == '{') \
		open_brace_awaiting_satisfaction++; \
\
	      return (word_token_alist[i].token); \
	    } \
      } \
  } while (0)

/* Read the next token.  Command can be READ (normal operation) or 
   RESET (to normalize state). */
static int
read_token (command)
     int command;
{
  int character;		/* Current character. */
  int peek_char;		/* Temporary look-ahead character. */
  int result;			/* The thing to return. */
  WORD_DESC *the_word;		/* The value for YYLVAL when a WORD is read. */

  if (token_buffer_size < TOKEN_DEFAULT_GROW_SIZE)
    {
      if (token)
	free (token);
      token = (char *)xmalloc (token_buffer_size = TOKEN_DEFAULT_GROW_SIZE);
    }

  if (command == RESET)
    {
      delimiter_depth = 0;	/* No delimiters found so far. */
      open_brace_awaiting_satisfaction = 0;
      in_case_pattern_list = 0;

#if defined (ALIAS)
      if (pushed_string_list)
	{
	  free_string_list ();
	  pushed_string_list = (STRING_SAVER *)NULL;
	}

      if (expanded_token_stack)
	{
	  free_expansion_stack ();
	  expanded_token_stack = (EXPANSION_SAVER *)NULL;
	}

      expand_next_token = 0;
#endif /* ALIAS */

      if (shell_input_line)
	{
	  free (shell_input_line);
	  shell_input_line = (char *)NULL;
	  shell_input_line_size = shell_input_line_index = 0;
	}
      last_read_token = '\n';
      token_to_read = '\n';
      return ('\n');
    }

  if (token_to_read)
    {
      int rt = token_to_read;
      token_to_read = 0;
      return (rt);
    }

#if defined (ALIAS)
  /* If we hit read_token () and there are no saved strings on the
     pushed_string_list, then we are no longer currently expanding a
     token.  This can't be done in pop_stream, because pop_stream
     may pop the stream before the current token has finished being
     completely expanded (consider what happens when we alias foo to foo,
     and then try to expand it). */
  if (!pushed_string_list && expanded_token_stack)
    {
      free_expansion_stack ();
      expanded_token_stack = (EXPANSION_SAVER *)NULL;
    }

  /* This is a place to jump back to once we have successfully expanded a
     token with an alias and pushed the string with push_string () */
 re_read_token:

#endif /* ALIAS */

  /* Read a single word from input.  Start by skipping blanks. */
  while ((character = shell_getc (1)) != EOF && whitespace (character));

  if (character == EOF)
    {
      EOF_Reached = 1;
      return (yacc_EOF);
    }

  if (character == '#' && (!interactive || interactive_comments))
    {
      /* A comment.  Discard until EOL or EOF, and then return a newline. */
      discard_until ('\n');
      shell_getc (0);

      /* If we're about to return an unquoted newline, we can go and collect
	 the text of any pending here documents. */
      if (need_here_doc)
        gather_here_documents ();

#if defined (ALIAS)
      expand_next_token = 0;
#endif /* ALIAS */

      return ('\n');
    }

  if (character == '\n')
    {
      /* If we're about to return an unquoted newline, we can go and collect
	 the text of any pending here document. */
      if (need_here_doc)
	gather_here_documents ();

#if defined (ALIAS)
      expand_next_token = 0;
#endif /* ALIAS */

      return (character);
    }

  if (member (character, "()<>;&|"))
    {
#if defined (ALIAS)
      /* Turn off alias tokenization iff this character sequence would
	 not leave us ready to read a command. */
      if (character == '<' || character == '>')
	expand_next_token = 0;
#endif /* ALIAS */

      /* Please note that the shell does not allow whitespace to
	 appear in between tokens which are character pairs, such as
	 "<<" or ">>".  I believe this is the correct behaviour. */
      if (character == (peek_char = shell_getc (1)))
	{
	  switch (character)
	    {
	      /* If '<' then we could be at "<<" or at "<<-".  We have to
		 look ahead one more character. */
	    case '<':
	      peek_char = shell_getc (1);
	      if (peek_char == '-')
		return (LESS_LESS_MINUS);
	      else
		{
		  shell_ungetc (peek_char);
		  return (LESS_LESS);
		}

	    case '>':
	      return (GREATER_GREATER);

	    case ';':
	      in_case_pattern_list = 1;
#if defined (ALIAS)
	      expand_next_token = 0;
#endif /* ALIAS */
	      return (SEMI_SEMI);

	    case '&':
	      return (AND_AND);

	    case '|':
	      return (OR_OR);
	    }
	}
      else
	{
	  if (peek_char == '&')
	    {
	      switch (character)
		{
		case '<': return (LESS_AND);
		case '>': return (GREATER_AND);
		}
	    }
	  if (character == '<' && peek_char == '>')
	    return (LESS_GREATER);
	  if (character == '>' && peek_char == '|')
	    return (GREATER_BAR);
	  if (peek_char == '>' && character == '&')
	    return (AND_GREATER);
	}
      shell_ungetc (peek_char);

      /* If we look like we are reading the start of a function
	 definition, then let the reader know about it so that
	 we will do the right thing with `{'. */
      if (character == ')' &&
	  last_read_token == '(' && token_before_that == WORD)
	{
	  allow_open_brace = 1;
#if defined (ALIAS)
	  expand_next_token = 0;
#endif /* ALIAS */
	}

      if (in_case_pattern_list && (character == ')'))
	in_case_pattern_list = 0;

#if defined (PROCESS_SUBSTITUTION)
      /* Check for the constructs which introduce process substitution. */
      if (!((character == '>' || character == '<') && peek_char == '('))
#endif /* PROCESS_SUBSTITUTION */
	return (character);
    }

  /* Hack <&- (close stdin) case. */
  if (character == '-')
    {
      switch (last_read_token)
	{
	case LESS_AND:
	case GREATER_AND:
	  return (character);
	}
    }
  
  /* Okay, if we got this far, we have to read a word.  Read one,
     and then check it against the known ones. */
  {
    /* Index into the token that we are building. */
    int token_index = 0;

    /* ALL_DIGITS becomes zero when we see a non-digit. */
    int all_digits = digit (character);

    /* DOLLAR_PRESENT becomes non-zero if we see a `$'. */
    int dollar_present = 0;

    /* QUOTED becomes non-zero if we see one of ("), ('), (`), or (\). */
    int quoted = 0;

    /* Non-zero means to ignore the value of the next character, and just
       to add it no matter what. */
    int pass_next_character = 0;

    /* Non-zero means parsing a dollar-paren construct.  It is the count of
       un-quoted closes we need to see. */
    int dollar_paren_level = 0;

    /* Non-zero means parsing a dollar-bracket construct ($[...]).  It is
       the count of un-quoted `]' characters we need to see. */
    int dollar_bracket_level = 0;

    /* Non-zero means parsing a `${' construct.  It is the count of
       un-quoted `}' we need to see. */
    int dollar_brace_level = 0;

    /* A level variable for parsing '${ ... }' constructs inside of double
       quotes. */
    int delimited_brace_level = 0;

    /* A boolean variable denoting whether or not we are currently parsing
       a double-quoted string embedded in a $( ) or ${ } construct. */
    int embedded_quoted_string = 0;

    /* Another level variable.  This one is for dollar_parens inside of
       double-quotes. */
    int delimited_paren_level = 0;

    for (;;)
      {
	if (character == EOF)
	  goto got_token;

	if (pass_next_character)
	  {
	    pass_next_character = 0;
	    goto got_character;
	  }

	if (current_delimiter () &&
	    (character == '\\') &&
	    (current_delimiter () != '\''))
	  {
	    peek_char = shell_getc (0);
	    if (peek_char != '\\')
	      shell_ungetc (peek_char);
	    else
	      {
		token[token_index++] = character;
		goto got_character;
	      }
	  }

	/* Handle backslashes.  Quote lots of things when not inside of
	   double-quotes, quote some things inside of double-quotes. */
	   
	if (character == '\\' &&
	    (!delimiter_depth ||
	     (current_delimiter () != '\'')))
	  {
	    peek_char = shell_getc (0);

	    /* Backslash-newline is ignored in all cases excepting
	       when quoted with single quotes. */
	    if (peek_char == '\n')
	      {
		character = '\n';
		goto next_character;
	      }
	    else
	      {
		char delim = current_delimiter ();

		shell_ungetc (peek_char);

		/* If the next character is to be quoted, do it now. */
		if (!delim || (delim == '`') ||
		    ((delim == '"') &&
		     (member (peek_char, slashify_in_quotes))))
		  {
		    pass_next_character++;
		    quoted = 1;
		    goto got_character;
		  }
	      }
	  }

	/* This is a hack, in its present form.  If a backquote substitution
	   appears within double quotes, everything within the backquotes
	   should be read as part of a single word.  Jesus.  Now I see why
	   Korn introduced the $() form. */
	if (delimiter_depth &&
	    (current_delimiter () == '"') && (character == '`'))
	  {
	    push_delimiter (character);
	    goto got_character;
	  }

	if (delimiter_depth)
	  {
	    if (character == current_delimiter ())
	      {
	      	/* If we see a double quote while parsing a double-quoted
		  $( ) or ${ }, and we have not seen ) or }, respectively,
	      	   note that we are in the middle of reading an embedded
		   quoted string. */
		if ((delimited_paren_level || delimited_brace_level) &&
		    (character == '"'))
		  {
		    embedded_quoted_string = !embedded_quoted_string;
		    goto got_character;
		  }
		
		delimiter_depth--;
		goto got_character;
	      }
	  }

	if (current_delimiter () != '\'')
	  {
#if defined (PROCESS_SUBSTITUTION)
	    if (character == '$' || character == '<' || character == '>')
#else
	    if (character == '$')
#endif /* !PROCESS_SUBSTITUTION */
	      {
	      	/* If we're in the middle of parsing a $( ) or ${ }
	      	   construct with an embedded quoted string, don't
	      	   bother looking at this character any further. */
	      	if (embedded_quoted_string)
	      	  goto got_character;

		peek_char = shell_getc (1);
		shell_ungetc (peek_char);
		if (peek_char == '(')
		  {
		    if (!delimiter_depth)
		      dollar_paren_level++;
		    else
		      delimited_paren_level++;

		    pass_next_character++;
		    goto got_character;
		  }
		else if (peek_char == '[' && character == '$')
		  {
		    if (!delimiter_depth)
		      dollar_bracket_level++;

		    pass_next_character++;
		    goto got_character;
		  }
		/* This handles ${...} constructs. */
		else if (peek_char == '{' && character == '$')
		  {
		    if (!delimiter_depth)
		      dollar_brace_level++;
		    else
		      delimited_brace_level++;

		    pass_next_character++;
		    goto got_character;
		  }
	      }

	    /* If we are parsing a $() or $[] construct, we need to balance
	       parens and brackets inside the construct.  This whole function
	       could use a rewrite. */
	    if (character == '(' && !embedded_quoted_string)
	      {
		if (delimiter_depth && delimited_paren_level)
		  delimited_paren_level++;

		if (!delimiter_depth && dollar_paren_level)
		  dollar_paren_level++;
	      }

	    if (character == '[')
	      {
		if (!delimiter_depth && dollar_bracket_level)
		  dollar_bracket_level++;
	      }

	    if (character == '{' && !embedded_quoted_string)
	      {
	      	if (delimiter_depth && delimited_brace_level)
	      	  delimited_brace_level++;

	      	if (!delimiter_depth && dollar_brace_level)
	      	  dollar_brace_level++;
	      }

	    /* This code needs to take into account whether we are inside a
	       case statement pattern list, and whether this paren is supposed
	       to terminate it (hey, it could happen).  It's not as simple
	       as just using in_case_pattern_list, because we're not parsing
	       anything while we're reading a $( ) construct.  Maybe we
	       should move that whole mess into the yacc parser. */
	    if (character == ')' && !embedded_quoted_string)
	      {
		if (delimiter_depth && delimited_paren_level)
		  delimited_paren_level--;

		if (!delimiter_depth && dollar_paren_level)
		  {
		    dollar_paren_level--;
		    goto got_character;
		  }
	      }

	    if (character == ']')
	      {
		if (!delimiter_depth && dollar_bracket_level)
		  {
		    dollar_bracket_level--;
		    goto got_character;
		  }
	      }

	    if (character == '}' && !embedded_quoted_string)
	      {
		if (delimiter_depth && delimited_brace_level)
		  delimited_brace_level--;

		if (!delimiter_depth && dollar_brace_level)
		  {
		    dollar_brace_level--;
		    goto got_character;
		  }
	      }
	  }

	if (!dollar_paren_level && !dollar_bracket_level &&
	    !dollar_brace_level && !delimiter_depth &&
	    member (character, " \t\n;&()|<>"))
	  {
	    shell_ungetc (character);
	    goto got_token;
	  }
    
	if (!delimiter_depth)
	  {
	    if (character == '"' || character == '`' || character == '\'')
	      {
		push_delimiter (character);

		quoted = 1;
		goto got_character;
	      }
	  }

	if (all_digits) all_digits = digit (character);
	if (character == '$') dollar_present = 1;

      got_character:

	if (character == CTLESC || character == CTLNUL)
	  token[token_index++] = CTLESC;

	token[token_index++] = character;

	if (token_index == (token_buffer_size - 1))
	  token = (char *)xrealloc (token, (token_buffer_size
					    += TOKEN_DEFAULT_GROW_SIZE));
	{
	next_character:
	  if (character == '\n' && interactive && bash_input.type != st_string)
	    prompt_again ();
	}
	/* We want to remove quoted newlines (that is, a \<newline> pair)
	   unless we are within single quotes or pass_next_character is
	   set (the shell equivalent of literal-next). */
	character = shell_getc
	  ((current_delimiter () != '\'') && (!pass_next_character));
      }

  got_token:

    token[token_index] = '\0';
	
    if ((delimiter_depth || dollar_paren_level || dollar_bracket_level) &&
	character == EOF)
      {
	char reporter = '\0';

	if (!delimiter_depth)
	  {
	    if (dollar_paren_level)
	      reporter = ')';
	    else if (dollar_bracket_level)
	      reporter = ']';
	  }

	if (!reporter)
	  reporter = current_delimiter ();

	report_error ("unexpected EOF while looking for `%c'", reporter);
	return (-1);
      }

    if (all_digits)
      {
	/* Check to see what thing we should return.  If the last_read_token
	   is a `<', or a `&', or the character which ended this token is
	   a '>' or '<', then, and ONLY then, is this input token a NUMBER.
	   Otherwise, it is just a word, and should be returned as such. */

	if ((character == '<' || character == '>') ||
	    (last_read_token == LESS_AND ||
	     last_read_token == GREATER_AND))
	  {
	    yylval.number = atoi (token); /* was sscanf (token, "%d", &(yylval.number)); */
	    return (NUMBER);
	  }
      }

    /* Handle special case.  IN is recognized if the last token
       was WORD and the token before that was FOR or CASE. */
    if ((last_read_token == WORD) &&
	((token_before_that == FOR) || (token_before_that == CASE)) &&
	(STREQ (token, "in")))
      {
	if (token_before_that == CASE)
	  {
	    in_case_pattern_list = 1;
	    allow_esac_as_next++;
	  }
	return (IN);
      }

    /* Ditto for DO in the FOR case. */
    if ((last_read_token == WORD) && (token_before_that == FOR) &&
	(STREQ (token, "do")))
      return (DO);

    /* Ditto for ESAC in the CASE case. 
       Specifically, this handles "case word in esac", which is a legal
       construct, certainly because someone will pass an empty arg to the
       case construct, and we don't want it to barf.  Of course, we should
       insist that the case construct has at least one pattern in it, but
       the designers disagree. */
    if (allow_esac_as_next)
      {
	allow_esac_as_next--;
	if (STREQ (token, "esac"))
	  {
	    in_case_pattern_list = 0;
	    return (ESAC);
	  }
      }

    /* Ditto for `{' in the FUNCTION case. */
    if (allow_open_brace)
      {
	allow_open_brace = 0;
	if (STREQ (token, "{"))
	  {
	    open_brace_awaiting_satisfaction++;
	    return ('{');
	  }
      }

    if (posixly_correct)
      CHECK_FOR_RESERVED_WORD (token);

#if defined (ALIAS)

    /* OK, we have a token.  Let's try to alias expand it, if (and only if)
       it's eligible. 

       It is eligible for expansion if the shell is in interactive mode, and
       the token is unquoted and the last token read was a command
       separator (or expand_next_token is set), and we are currently
       processing an alias (pushed_string_list is non-empty) and this
       token is not the same as the current or any previously
       processed alias.

       Special cases that disqualify:
	 In a pattern list in a case statement (in_case_pattern_list). */
    if (interactive_shell && !quoted && !in_case_pattern_list &&
	(expand_next_token || command_token_position (last_read_token)))
      {
	char *alias_expand_word (), *expanded;

	if (expanded_token_stack && token_has_been_expanded (token))
	  goto no_expansion;

	expanded = alias_expand_word (token);
	if (expanded)
	  {
	    int len = strlen (expanded), expand_next;

	    /* Erase the current token. */
	    token_index = 0;

	    expand_next = (expanded[len - 1] == ' ') ||
			  (expanded[len - 1] == '\t');

	    push_string (expanded, expand_next, token);
	    goto re_read_token;
	  }
	else
	  /* This is an eligible token that does not have an expansion. */
no_expansion:
	  expand_next_token = 0;
      }
    else
      {
	expand_next_token = 0;
      }
#endif /* ALIAS */

    CHECK_FOR_RESERVED_WORD (token);

    /* What if we are attempting to satisfy an open-brace grouper? */
    if (open_brace_awaiting_satisfaction && token[0] == '}' && !token[1])
      {
	open_brace_awaiting_satisfaction--;
	return ('}');
      }

    the_word = (WORD_DESC *)xmalloc (sizeof (WORD_DESC));
    the_word->word = (char *)xmalloc (1 + token_index);
    strcpy (the_word->word, token);
    the_word->dollar_present = dollar_present;
    the_word->quoted = quoted;
    the_word->assignment = assignment (token);

    yylval.word = the_word;
    result = WORD;

    /* A word is an assignment if it appears at the beginning of a
       simple command, or after another assignment word.  This is
       context-dependent, so it cannot be handled in the grammar. */
    if (assignment_acceptable (last_read_token) && the_word->assignment)
      result = ASSIGNMENT_WORD;

    if (last_read_token == FUNCTION)
      allow_open_brace = 1;
  }
  return (result);
}

/* Return 1 if TOKEN is a token that after being read would allow
   a reserved word to be seen, else 0. */
static int
reserved_word_acceptable (token)
     int token;
{
  if (member (token, "\n;()|&{") ||
      token == '}' ||			/* XXX */
      token == AND_AND ||
      token == BANG ||
      token == DO ||
      token == ELIF ||
      token == ELSE ||
      token == FI ||
      token == IF ||
      token == OR_OR ||
      token == SEMI_SEMI ||
      token == THEN ||
      token == UNTIL ||
      token == WHILE ||
      token == DONE ||		/* XXX these two are experimental */
      token == ESAC ||
      token == 0)
    return (1);
  else
    return (0);
}

/* Return the index of TOKEN in the alist of reserved words, or -1 if
   TOKEN is not a shell reserved word. */
int
find_reserved_word (token)
     char *token;
{
  int i;
  for (i = 0; word_token_alist[i].word != (char *)NULL; i++)
    if (STREQ (token, word_token_alist[i].word))
      return i;
  return -1;
}

#if defined (READLINE)
/* Called after each time readline is called.  This insures that whatever
   the new prompt string is gets propagated to readline's local prompt
   variable. */
static void
reset_readline_prompt ()
{
  if (prompt_string_pointer && *prompt_string_pointer)
    {
      char *temp_prompt;

      temp_prompt = decode_prompt_string (*prompt_string_pointer);

      if (!temp_prompt)
	temp_prompt = savestring ("");

      if (current_readline_prompt)
	free (current_readline_prompt);

      current_readline_prompt = temp_prompt;
    }
}
#endif /* READLINE */

#if defined (HISTORY)
/* A list of tokens which can be followed by newlines, but not by
   semi-colons.  When concatenating multiple lines of history, the
   newline separator for such tokens is replaced with a space. */
static int no_semi_successors[] = {
  '\n', '{', '(', ')', ';', '&', '|',
  CASE, DO, ELSE, IF, IN, SEMI_SEMI, THEN, UNTIL, WHILE, AND_AND, OR_OR,
  0
};

/* Add a line to the history list.
   The variable COMMAND_ORIENTED_HISTORY controls the style of history
   remembering;  when non-zero, and LINE is not the first line of a
   complete parser construct, append LINE to the last history line instead
   of adding it as a new line. */
static void
bash_add_history (line)
     char *line;
{
  int add_it = 1;

  if (command_oriented_history && current_command_line_count > 1)
    {
      register int offset;
      register HIST_ENTRY *current, *old;
      char *chars_to_add, *new_line;

      /* If we are not within a delimited expression, try to be smart
	 about which separators can be semi-colons and which must be
	 newlines. */
      if (!delimiter_depth)
	{
	  register int i;

	  chars_to_add = (char *)NULL;

	  for (i = 0; no_semi_successors[i]; i++)
	    {
	      if (token_before_that == no_semi_successors[i])
		{
		  chars_to_add = " ";
		  break;
		}
	    }
	  if (!chars_to_add)
	    chars_to_add = "; ";
	}
      else
	chars_to_add = "\n";

      using_history ();

      current = previous_history ();

      if (current)
	{
	  /* If the previous line ended with an escaped newline (escaped
	     with backslash, but otherwise unquoted), then remove the quoted
	     newline, since that is what happens when the line is parsed. */
	  int curlen;

	  curlen = strlen (current->line);

	  if (!delimiter_depth && current->line[curlen - 1] == '\\' &&
	      current->line[curlen - 2] != '\\')
	    {
	      current->line[curlen - 1] = '\0';
	      curlen--;
	      chars_to_add = "";
	    }

	  offset = where_history ();
	  new_line = (char *) xmalloc (1
				       + curlen
				       + strlen (line)
				       + strlen (chars_to_add));
	  sprintf (new_line, "%s%s%s", current->line, chars_to_add, line);
	  old = replace_history_entry (offset, new_line, current->data);
	  free (new_line);

	  if (old)
	    {
	      /* Note that the old data is not freed, since it was simply
		 copied to the new history entry. */
	      if (old->line)
		free (old->line);

	      free (old);
	    }
	  add_it = 0;
	}
    }

  if (add_it)
    {
      extern int history_lines_this_session;

      add_history (line);
      history_lines_this_session++;
    }
  using_history ();
}
#endif /* HISTORY */

/* Issue a prompt, or prepare to issue a prompt when the next character
   is read. */
static void
prompt_again ()
{
  char *temp_prompt;

  ps1_prompt = get_string_value ("PS1");
  ps2_prompt = get_string_value ("PS2");

  if (!prompt_string_pointer)
    prompt_string_pointer = &ps1_prompt;

  if (*prompt_string_pointer)
    temp_prompt = decode_prompt_string (*prompt_string_pointer);
  else
    temp_prompt = savestring ("");

  current_prompt_string = *prompt_string_pointer;
  prompt_string_pointer = &ps2_prompt;

#if defined (READLINE)
  if (!no_line_editing)
    {
      if (current_readline_prompt)
	free (current_readline_prompt);
      
      current_readline_prompt = temp_prompt;
    }
  else
#endif	/* READLINE */
    {
      if (interactive)
	{
	  fprintf (stderr, "%s", temp_prompt);
	  fflush (stderr);
	}
      free (temp_prompt);
    }
}

/* Return a string which will be printed as a prompt.  The string
   may contain special characters which are decoded as follows:
   
	\t	the time
	\d	the date
	\n	CRLF
	\s	the name of the shell
	\w	the current working directory
	\W	the last element of PWD
	\u	your username
	\h	the hostname
	\#	the command number of this command
	\!	the history number of this command
	\$	a $ or a # if you are root
	\<octal> character code in octal
	\\	a backslash
*/
#define PROMPT_GROWTH 50
char *
decode_prompt_string (string)
     char *string;
{
  int result_size = PROMPT_GROWTH;
  int result_index = 0;
  char *result;
  int c;
  char *temp = (char *)NULL;

#if defined (PROMPT_STRING_DECODE)

  result = (char *)xmalloc (PROMPT_GROWTH);
  result[0] = 0;

  while (c = *string++)
    {
      if (posixly_correct && c == '!')
	{
	  if (*string == '!')
	    {
	      temp = savestring ("!");
	      goto add_string;
	    }
	  else
	    {
#if !defined (HISTORY)
		temp = savestring ("1");
#else /* HISTORY */
		char number_buffer[20];

		using_history ();
		if (get_string_value ("HISTSIZE"))
		  sprintf (number_buffer, "%d",
			   history_base + where_history ());
		else
		  strcpy (number_buffer, "!");
		temp = savestring (number_buffer);
#endif /* HISTORY */
		string--;	/* add_string increments string again. */
		goto add_string;
	    }
	} 
      if (c == '\\')
	{
	  c = *string;

	  switch (c)
	    {
	    case '0':
	    case '1':
	    case '2':
	    case '3':
	    case '4':
	    case '5':
	    case '6':
	    case '7':
	      {
		char octal_string[4];
		int n;

		strncpy (octal_string, string, 3);
		octal_string[3] = '\0';

		n = read_octal (octal_string);

		temp = savestring ("\\");
		if (n != -1)
		  {
		    string += 3;
		    temp[0] = n;
		  }

		c = 0;
		goto add_string;
	      }
	  
	    case 't':
	    case 'd':
	      /* Make the current time/date into a string. */
	      {
		time_t the_time = time (0);
		char *ttemp = ctime (&the_time);
		temp = savestring (ttemp);

		if (c == 't')
		  {
		    strcpy (temp, temp + 11);
		    temp[8] = '\0';
		  }
		else
		  temp[10] = '\0';

		goto add_string;
	      }

	    case 'n':
	      if (!no_line_editing)
		temp = savestring ("\r\n");
	      else
		temp = savestring ("\n");
	      goto add_string;

	    case 's':
	      {
		extern char *shell_name;

		temp = base_pathname (shell_name);
		temp = savestring (temp);
		goto add_string;
	      }
	
	    case 'w':
	    case 'W':
	      {
		/* Use the value of PWD because it is much more effecient. */
#define EFFICIENT
#ifdef EFFICIENT
		char *polite_directory_format (), t_string[MAXPATHLEN];

		temp = get_string_value ("PWD");

		if (!temp)
		  getwd (t_string);
		else
		  strcpy (t_string, temp);
#else
		getwd (t_string);
#endif	/* EFFICIENT */

		if (c == 'W')
		  {
		    char *dir = (char *)strrchr (t_string, '/');
		    if (dir && dir != t_string)
		      strcpy (t_string, dir + 1);
		    temp = savestring (t_string);
		  }
		else
		  temp = savestring (polite_directory_format (t_string));
		goto add_string;
	      }
      
	    case 'u':
	      {
		temp = savestring (current_user.user_name);

		goto add_string;
	      }

	    case 'h':
	      {
		extern char *current_host_name;
		char *t_string;

		temp = savestring (current_host_name);
		if (t_string = (char *)strchr (temp, '.'))
		  *t_string = '\0';
		
		goto add_string;
	      }

	    case '#':
	      {
		extern int current_command_number;
		char number_buffer[20];
		sprintf (number_buffer, "%d", current_command_number);
		temp = savestring (number_buffer);
		goto add_string;
	      }

	    case '!':
	      {
#if !defined (HISTORY)
		temp = savestring ("1");
#else /* HISTORY */
		char number_buffer[20];

		using_history ();
		if (get_string_value ("HISTSIZE"))
		  sprintf (number_buffer, "%d",
			   history_base + where_history ());
		else
		  strcpy (number_buffer, "!");
		temp = savestring (number_buffer);
#endif /* HISTORY */
		goto add_string;
	      }

	    case '$':
	      temp = savestring (geteuid () == 0 ? "#" : "$");
	      goto add_string;

	    case '\\':
	      temp = savestring ("\\");
	      goto add_string;

	    default:
	      temp = savestring ("\\ ");
	      temp[1] = c;

	    add_string:
	      if (c)
		string++;
	      result =
		sub_append_string (temp, result,
				   &result_index, &result_size);
	      temp = (char *)NULL; /* Free ()'ed in sub_append_string (). */
	      result[result_index] = '\0';
	      break;
	    }
	}
      else
	{
	  while (3 + result_index > result_size)
	    result = (char *)xrealloc (result, result_size += PROMPT_GROWTH);

	  result[result_index++] = c;
	  result[result_index] = '\0';
	}
    }
#else /* !PROMPT_STRING_DECODE */
  result = savestring (string);
#endif /* !PROMPT_STRING_DECODE */

  if (!find_variable ("NO_PROMPT_VARS"))
    {
      WORD_LIST *expand_string (), *list;
      char *string_list ();

      list = expand_string (result, 1);
      free (result);
      result = string_list (list);
      dispose_words (list);
    }

  return (result);
}

/* Report a syntax error, and restart the parser.  Call here for fatal
   errors. */
yyerror ()
{
  report_syntax_error ((char *)NULL);
  reset_parser ();
}

/* Report a syntax error with line numbers, etc.
   Call here for recoverable errors.  If you have a message to print,
   then place it in MESSAGE, otherwise pass NULL and this will figure
   out an appropriate message for you. */
static void
report_syntax_error (message)
     char *message;
{
  if (message)
    {
      if (!interactive)
	{
	  char *name = bash_input.name ? bash_input.name : "stdin";
	  report_error ("%s: line %d: `%s'", name, line_number, message);
	}
      else
	{
	  if (EOF_Reached)
	    EOF_Reached = 0;
	  report_error ("%s", message);
	}

      last_command_exit_value = 2;
      return;
    }

  if (shell_input_line && *shell_input_line)
    {
      char *error_token, *t = shell_input_line;
      register int i = shell_input_line_index;
      int token_end = 0;

      if (!t[i] && i)
	i--;

      while (i && (t[i] == ' ' || t[i] == '\t' || t[i] == '\n'))
	i--;

      if (i)
	token_end = i + 1;

      while (i && !member (t[i], " \n\t;|&"))
	i--;

      while (i != token_end && member (t[i], " \n\t"))
	i++;

      if (token_end)
	{
	  error_token = (char *)alloca (1 + (token_end - i));
	  strncpy (error_token, t + i, token_end - i);
	  error_token[token_end - i] = '\0';

	  report_error ("syntax error near unexpected token `%s'", error_token);
	}
      else if ((i == 0) && (token_end == 0))	/* a 1-character token */
	{
	  error_token = (char *) alloca (2);
	  strncpy (error_token, t + i, 1);
	  error_token[1] = '\0';

	  report_error ("syntax error near unexpected token `%s'", error_token);
	}

      if (!interactive)
	{
	  char *temp = savestring (shell_input_line);
	  char *name = bash_input.name ? bash_input.name : "stdin";
	  int l = strlen (temp);

	  while (l && temp[l - 1] == '\n')
	    temp[--l] = '\0';

	  report_error ("%s: line %d: `%s'", name, line_number, temp);
	  free (temp);
	}
    }
  else
    {
      char *name, *msg;
      if (!interactive)
	name = bash_input.name ? bash_input.name : "stdin";
      if (EOF_Reached)
	msg = "syntax error: unexpected end of file";
      else
	msg = "syntax error";
      if (!interactive)
	report_error ("%s: line %d: %s", name, line_number, msg);
      else
	{
	  /* This file uses EOF_Reached only for error reporting
	     when the shell is interactive.  Other mechanisms are 
	     used to decide whether or not to exit. */
	  EOF_Reached = 0;
	  report_error (msg);
	}
    }
  last_command_exit_value = 2;
}

/* ??? Needed function. ??? We have to be able to discard the constructs
   created during parsing.  In the case of error, we want to return
   allocated objects to the memory pool.  In the case of no error, we want
   to throw away the information about where the allocated objects live.
   (dispose_command () will actually free the command. */
discard_parser_constructs (error_p)
     int error_p;
{
}
   
/* Do that silly `type "bye" to exit' stuff.  You know, "ignoreeof". */

/* The number of times that we have encountered an EOF character without
   another character intervening.  When this gets above the limit, the
   shell terminates. */
int eof_encountered = 0;

/* The limit for eof_encountered. */
int eof_encountered_limit = 10;

/* If we have EOF as the only input unit, this user wants to leave
   the shell.  If the shell is not interactive, then just leave.
   Otherwise, if ignoreeof is set, and we haven't done this the
   required number of times in a row, print a message. */
static void
handle_eof_input_unit ()
{
  extern int login_shell, EOF_Reached;

  if (interactive)
    {
      /* shell.c may use this to decide whether or not to write out the
	 history, among other things.  We use it only for error reporting
	 in this file. */
      if (EOF_Reached)
	EOF_Reached = 0;

      /* If the user wants to "ignore" eof, then let her do so, kind of. */
      if (find_variable ("ignoreeof") || find_variable ("IGNOREEOF"))
	{
	  if (eof_encountered < eof_encountered_limit)
	    {
	      fprintf (stderr, "Use \"%s\" to leave the shell.\n",
		       login_shell ? "logout" : "exit");
	      eof_encountered++;
	      /* Reset the prompt string to be $PS1. */
	      prompt_string_pointer = (char **)NULL;
	      prompt_again ();
	      last_read_token = current_token = '\n';
	      return;
	    } 
	}

      /* In this case EOF should exit the shell.  Do it now. */
      reset_parser ();
      exit_builtin ((WORD_LIST *)NULL);
    }
  else
    {
      /* We don't write history files, etc., for non-interactive shells. */
      EOF_Reached = 1;
    }
}
static yytabelem yyexca[] ={
-1, 1,
	0, -1,
	-2, 0,
	};
# define YYNPROD 115
# define YYLAST 707
static yytabelem yyact[]={

     3,   225,   217,   209,   170,   134,   135,    41,    43,    44,
   178,   114,   113,   112,   105,    26,   131,    25,   104,   103,
   102,   111,    83,    80,    79,    78,    77,    70,    42,    69,
    22,    96,    59,    58,    53,    52,    96,   223,   193,   166,
    96,   158,   152,   100,   132,    94,   182,   160,   162,   159,
    26,   202,    25,   171,   189,    96,   221,   162,   203,   115,
    96,    22,   108,   151,   176,   133,    49,   150,    96,   224,
   194,   167,   210,   161,   195,   116,    96,    84,     6,    92,
    45,    26,    76,    25,    96,   177,    12,    40,   139,    96,
    22,    73,   101,    90,   117,    51,    39,    47,   169,   149,
   148,    23,   144,    19,    24,    11,    13,    10,     2,    96,
    26,    95,    25,    37,   177,     9,     1,     0,    96,    22,
    85,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,    26,
     0,    25,     0,     0,    37,     0,     0,     0,    22,     0,
     0,     0,     0,   206,     0,   196,     0,   196,     0,     0,
     0,     0,     0,     0,   121,   122,     0,     0,    26,     0,
    25,    96,     0,    37,     0,     0,     0,    22,     0,     0,
     0,   146,     0,     0,     0,     0,     0,     0,     0,    37,
     0,     0,     0,     0,     0,     0,     0,    26,    85,    25,
     0,    22,    37,     0,     0,     0,     0,   164,   165,     0,
     0,     0,   180,     0,     0,     0,   181,     0,     0,     0,
   140,    26,   126,    25,     0,     0,   141,    48,    15,    27,
     0,    37,    28,    29,    30,    31,     0,    32,    33,    34,
    35,    26,   197,    25,    43,    44,     4,    36,   110,     0,
   109,    61,    18,    60,    17,    20,    21,    22,   204,    38,
    37,     8,    14,    15,    27,   191,   168,    28,    29,    30,
    31,     0,    32,    33,    34,    35,     5,    26,    36,    25,
   172,   134,   135,    18,    37,    17,    20,    21,   222,   107,
    38,   106,    99,    14,    15,    27,   129,   205,    28,    29,
    30,    31,   226,    32,    33,    34,    35,    36,   198,    75,
     0,    74,    18,     0,    17,    20,    21,   178,    72,    38,
    71,    99,    14,    15,    27,   145,     0,    28,    29,    30,
    31,   218,    32,    33,    34,    35,    36,   175,     0,     0,
    37,    18,     0,    17,    20,    21,   178,     0,    38,     0,
    99,    14,    15,    27,    97,     0,    28,    29,    30,    31,
     0,    32,    33,    34,    35,    36,   125,     0,     0,   127,
    18,     0,    17,    20,    21,     0,     0,    38,     0,     8,
    14,    15,    27,     0,     0,    28,    29,    30,    31,     0,
    32,    33,    34,    35,    36,     0,     0,     0,     0,    18,
     0,    17,    20,    21,     0,     0,    38,     0,     8,    14,
    15,    27,     0,     0,    28,    29,    30,    31,    36,    32,
    33,    34,    35,    18,     0,    17,    20,    21,    16,     0,
    38,     0,     0,    14,    15,    27,     0,     0,    28,    29,
    30,    31,    50,    32,    33,    34,    35,     0,     0,     0,
     0,     0,     0,     0,     0,    27,     0,     0,    28,    29,
    30,    31,     0,    32,    33,    34,    35,     0,    62,    63,
    64,    65,    55,    66,    36,    67,    68,     0,    89,    18,
     0,    17,    20,    21,    54,     0,    38,     0,     0,    14,
    15,    27,     0,     0,    28,    29,    30,    31,     0,    32,
    33,    34,    35,     0,     0,     0,    56,    57,   183,   184,
   185,   186,   187,     0,     0,     0,    86,    87,    88,     0,
     0,    81,    82,     0,     0,    91,    93,     0,     0,    98,
     7,     0,     0,     0,     0,     0,     0,     0,    46,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,   118,     0,     0,     0,
     0,     0,     0,   124,     0,   128,   184,   185,   183,    50,
    50,     7,     7,     0,     0,     0,     0,     0,     0,   130,
     0,     0,     0,     0,     0,   137,     0,     0,     0,     0,
     0,     0,     0,    89,    89,     0,     0,     0,     0,     0,
   138,     0,   147,     0,   153,   154,   155,   156,   157,     0,
   142,   143,   163,     0,     0,     0,     7,     7,   123,     0,
    50,   179,     0,     0,     0,     0,     0,     0,     0,   136,
   173,   174,     0,    89,     0,     0,     0,     0,     0,     0,
     0,     0,   192,     0,     0,   188,     0,   190,     0,     7,
     7,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,   208,     0,
     0,     0,   211,   212,   213,     0,     0,     0,     0,     0,
   207,     0,     0,   220,     0,     0,     0,     0,   214,     0,
   215,   216,     0,     0,     0,   219,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,   227 };
static yytabelem yypact[]={

   -10, -1000,    86, -1000,    77, -1000,   -31,   -44,   217, -1000,
   -45, -1000, -1000,   181,    55, -1000, -1000,  -237,  -238, -1000,
 -1000, -1000, -1000, -1000, -1000,  -239,  -240,   191,  -243,  -245,
    46,    37,  -246,  -247,  -248,  -249, -1000, -1000,  -250, -1000,
 -1000,   137,   137, -1000, -1000, -1000,   -44, -1000, -1000,   181,
 -1000,    52,    20, -1000,  -222,    79,  -224,    51, -1000, -1000,
  -252,  -253,  -254,  -258,    17,   -24,  -259,  -260,  -261, -1000,
 -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
 -1000,  -199,   -50,    54,  -267,  -267,   108,   108,   161, -1000,
 -1000,    99, -1000,    26, -1000, -1000, -1000,     6,   -44,   217,
 -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
 -1000, -1000, -1000, -1000, -1000, -1000, -1000,    47,    66,   137,
   137, -1000, -1000,   -44,    66, -1000, -1000, -1000,    58, -1000,
  -226, -1000, -1000, -1000, -1000, -1000,   -44,  -227,  -212, -1000,
   181,   181,  -229,   -54,    -6, -1000, -1000,    74, -1000,  -217,
 -1000, -1000, -1000,    79,    79,    79,    79,    79, -1000, -1000,
 -1000,  -207, -1000,    66,   181,   181, -1000, -1000, -1000, -1000,
 -1000, -1000, -1000,  -230,   -55, -1000,    33,  -262, -1000,    45,
 -1000, -1000, -1000,  -270,  -270,  -270, -1000, -1000,  -210, -1000,
  -200,   181,    30, -1000, -1000, -1000,  -269,    31, -1000, -1000,
 -1000, -1000, -1000, -1000,   181, -1000, -1000,  -279,    50, -1000,
 -1000,    79,    79,    79,  -203,  -231,   -56, -1000, -1000,  -280,
    21, -1000, -1000, -1000, -1000, -1000, -1000, -1000 };
static yytabelem yypgo[]={

     0,   116,   115,   529,   484,   111,   354,   108,    77,   107,
   106,   105,   101,   104,   103,    73,   428,    66,    86,   102,
    64,    67,   100,    99,    63,   472,    98 };
static yytabelem yyr1[]={

     0,     1,     1,     1,     1,    19,    19,    16,    16,    16,
    16,    16,    16,    16,    16,    16,    16,    16,    16,    16,
    16,    16,    16,    16,    16,    16,    16,    16,    16,    16,
    16,    16,    16,    16,    18,    18,    18,    17,    17,     9,
     9,     2,     2,    11,    11,    10,    10,    10,    10,    10,
    10,    10,    10,    10,    10,    10,    10,    10,    10,    10,
    13,    13,    13,    13,    13,    13,    14,    14,    14,    12,
    15,    15,    15,    23,    23,    24,    24,    24,    24,    22,
    22,    21,    21,    21,    21,    20,    20,     4,     5,     5,
     5,     5,     6,     6,     6,     6,     6,     6,     6,    26,
    26,    26,    25,    25,     7,     7,     7,     8,     8,     8,
     8,     8,     8,     3,     3 };
static yytabelem yyr2[]={

     0,     5,     3,     5,     3,     1,     5,     5,     5,     7,
     7,     5,     7,     5,     7,     5,     7,     5,     7,     5,
     7,     5,     7,     5,     7,     5,     7,     5,     7,     5,
     7,     5,     5,     7,     3,     3,     3,     3,     5,     3,
     5,     3,     3,     3,     5,    13,    13,    15,    15,    21,
    21,    13,    15,    13,     3,    11,    11,     7,     3,     3,
    11,    13,    13,    15,     9,    11,    11,    15,    13,     7,
     9,    13,    11,     2,     5,     9,     9,    11,    11,     2,
     5,    11,    11,    13,    13,     3,     7,     5,     2,     6,
     7,     6,     9,     9,     9,     9,     9,     3,     5,     2,
     2,     2,     0,     4,     3,     5,     5,     9,     9,     7,
     7,     3,     5,     9,     3 };
static yytabelem yychk[]={

 -1000,    -1,    -7,    10,   256,   286,    -8,    -3,   271,    -2,
    -9,   -11,   -18,   -10,   272,   273,   -16,   264,   262,   -14,
   265,   266,    40,   -12,   -13,    62,    60,   274,   277,   278,
   279,   280,   282,   283,   284,   285,   257,   123,   269,    10,
    10,    38,    59,   275,   276,   124,    -3,   -18,   272,   -17,
   -16,    40,   272,   272,    -4,   -25,    -4,    -4,   272,   272,
    62,    60,   277,   278,   279,   280,   282,   284,   285,   272,
   272,   274,   272,    45,   274,   272,    45,   272,   272,   272,
   272,    -4,    -4,   272,    -8,    -8,   -25,   -25,   -25,   -16,
    41,   -25,    59,   -25,   267,    -5,    10,    -6,    -3,   271,
   267,    41,   272,   272,   272,   272,   274,   272,    45,   274,
   272,    45,   272,   272,   272,   258,   125,    40,   -25,    38,
    59,    -8,    -8,    -3,   -25,   267,   123,   270,   -25,   270,
    -4,    10,    38,    59,   275,   276,    -3,    -4,    -4,    41,
   -12,   -12,    -4,    -4,   -19,   267,   123,   -25,   -22,   -23,
   -21,   -24,   268,   -25,   -25,   -25,   -25,   -25,   268,   261,
   259,   -15,   260,   -25,   -17,   -17,   268,   125,   272,   -26,
    10,    59,   286,    -4,    -4,   263,   -20,    40,   272,   -25,
   -24,   -21,   263,    -6,    -6,    -6,    -6,    -6,    -4,   261,
    -4,   -12,   -25,   268,   125,    41,   124,   -20,   263,    38,
    59,    10,   261,   258,   -17,   267,   123,    -4,   -25,   272,
    41,   -25,   -25,   -25,    -4,    -4,    -4,   281,   281,    -4,
   -25,   259,   -15,   268,   125,   281,   281,    -4 };
static yytabelem yydef[]={

     0,    -2,     0,     2,     0,     4,   104,   111,     0,   114,
    41,    42,    39,    43,    34,    35,    36,     0,     0,    54,
   102,   102,   102,    58,    59,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,   102,   102,     0,     1,
     3,   105,   106,   102,   102,   102,   112,    40,    34,    44,
    37,     0,   102,   102,     0,     0,     0,     0,     7,     8,
     0,     0,     0,     0,     0,     0,     0,     0,     0,    11,
    13,    15,    19,    27,    17,    21,    25,    23,    29,    31,
    32,     0,     0,   102,   109,   110,     0,     0,     0,    38,
   102,     0,   102,     0,   102,    87,   103,    88,    97,     0,
   102,    57,     9,    10,    12,    14,    16,    20,    28,    18,
    22,    26,    24,    30,    33,   102,    69,     0,     0,     0,
     0,   107,   108,   113,     0,   102,   102,     5,     0,   102,
     0,   102,   102,   102,   102,   102,    98,     0,     0,   102,
    64,    60,     0,     0,     0,   102,   102,     0,   102,     0,
    79,    73,    55,    89,    90,    91,     0,     0,    56,    66,
   102,     0,   102,     0,    65,    61,    45,    46,     6,   102,
    99,   100,   101,     0,     0,    51,     0,     0,    85,     0,
    74,    80,    53,    96,    94,    95,    92,    93,     0,    68,
     0,    62,     0,    47,    48,   102,     0,     0,    52,   102,
   102,   102,    67,   102,    63,   102,   102,    75,    76,    86,
   102,     0,     0,     0,    70,     0,     0,    81,    82,    77,
    78,   102,    72,    49,    50,    83,    84,    71 };
typedef struct { char *t_name; int t_val; } yytoktype;
#ifndef YYDEBUG
#	define YYDEBUG	0	/* don't allow debugging */
#endif

#if YYDEBUG

yytoktype yytoks[] =
{
	"IF",	257,
	"THEN",	258,
	"ELSE",	259,
	"ELIF",	260,
	"FI",	261,
	"CASE",	262,
	"ESAC",	263,
	"FOR",	264,
	"WHILE",	265,
	"UNTIL",	266,
	"DO",	267,
	"DONE",	268,
	"FUNCTION",	269,
	"IN",	270,
	"BANG",	271,
	"WORD",	272,
	"ASSIGNMENT_WORD",	273,
	"NUMBER",	274,
	"AND_AND",	275,
	"OR_OR",	276,
	"GREATER_GREATER",	277,
	"LESS_LESS",	278,
	"LESS_AND",	279,
	"GREATER_AND",	280,
	"SEMI_SEMI",	281,
	"LESS_LESS_MINUS",	282,
	"AND_GREATER",	283,
	"LESS_GREATER",	284,
	"GREATER_BAR",	285,
	"&",	38,
	";",	59,
	"\n",	10,
	"yacc_EOF",	286,
	"|",	124,
	"-unknown-",	-1	/* ends search */
};

char * yyreds[] =
{
	"-no such reduction-",
      "inputunit : simple_list '\n'",
      "inputunit : '\n'",
      "inputunit : error '\n'",
      "inputunit : yacc_EOF",
      "words : /* empty */",
      "words : words WORD",
      "redirection : '>' WORD",
      "redirection : '<' WORD",
      "redirection : NUMBER '>' WORD",
      "redirection : NUMBER '<' WORD",
      "redirection : GREATER_GREATER WORD",
      "redirection : NUMBER GREATER_GREATER WORD",
      "redirection : LESS_LESS WORD",
      "redirection : NUMBER LESS_LESS WORD",
      "redirection : LESS_AND NUMBER",
      "redirection : NUMBER LESS_AND NUMBER",
      "redirection : GREATER_AND NUMBER",
      "redirection : NUMBER GREATER_AND NUMBER",
      "redirection : LESS_AND WORD",
      "redirection : NUMBER LESS_AND WORD",
      "redirection : GREATER_AND WORD",
      "redirection : NUMBER GREATER_AND WORD",
      "redirection : LESS_LESS_MINUS WORD",
      "redirection : NUMBER LESS_LESS_MINUS WORD",
      "redirection : GREATER_AND '-'",
      "redirection : NUMBER GREATER_AND '-'",
      "redirection : LESS_AND '-'",
      "redirection : NUMBER LESS_AND '-'",
      "redirection : AND_GREATER WORD",
      "redirection : NUMBER LESS_GREATER WORD",
      "redirection : LESS_GREATER WORD",
      "redirection : GREATER_BAR WORD",
      "redirection : NUMBER GREATER_BAR WORD",
      "simple_command_element : WORD",
      "simple_command_element : ASSIGNMENT_WORD",
      "simple_command_element : redirection",
      "redirections : redirection",
      "redirections : redirections redirection",
      "simple_command : simple_command_element",
      "simple_command : simple_command simple_command_element",
      "command : simple_command",
      "command : shell_command",
      "shell_command : shell_command_1",
      "shell_command : shell_command_1 redirections",
      "shell_command_1 : FOR WORD newlines DO list DONE",
      "shell_command_1 : FOR WORD newlines '{' list '}'",
      "shell_command_1 : FOR WORD ';' newlines DO list DONE",
      "shell_command_1 : FOR WORD ';' newlines '{' list '}'",
      "shell_command_1 : FOR WORD newlines IN words list_terminator newlines DO list DONE",
      "shell_command_1 : FOR WORD newlines IN words list_terminator newlines '{' list '}'",
      "shell_command_1 : CASE WORD newlines IN newlines ESAC",
      "shell_command_1 : CASE WORD newlines IN case_clause_sequence newlines ESAC",
      "shell_command_1 : CASE WORD newlines IN case_clause_1 ESAC",
      "shell_command_1 : if_command",
      "shell_command_1 : WHILE list DO list DONE",
      "shell_command_1 : UNTIL list DO list DONE",
      "shell_command_1 : '(' list ')'",
      "shell_command_1 : group_command",
      "shell_command_1 : function_def",
      "function_def : WORD '(' ')' newlines group_command",
      "function_def : WORD '(' ')' newlines group_command redirections",
      "function_def : FUNCTION WORD '(' ')' newlines group_command",
      "function_def : FUNCTION WORD '(' ')' newlines group_command redirections",
      "function_def : FUNCTION WORD newlines group_command",
      "function_def : FUNCTION WORD newlines group_command redirections",
      "if_command : IF list THEN list FI",
      "if_command : IF list THEN list ELSE list FI",
      "if_command : IF list THEN list elif_clause FI",
      "group_command : '{' list '}'",
      "elif_clause : ELIF list THEN list",
      "elif_clause : ELIF list THEN list ELSE list",
      "elif_clause : ELIF list THEN list elif_clause",
      "case_clause_1 : pattern_list_1",
      "case_clause_1 : case_clause_sequence pattern_list_1",
      "pattern_list_1 : newlines pattern ')' list",
      "pattern_list_1 : newlines pattern ')' newlines",
      "pattern_list_1 : newlines '(' pattern ')' list",
      "pattern_list_1 : newlines '(' pattern ')' newlines",
      "case_clause_sequence : pattern_list",
      "case_clause_sequence : case_clause_sequence pattern_list",
      "pattern_list : newlines pattern ')' list SEMI_SEMI",
      "pattern_list : newlines pattern ')' newlines SEMI_SEMI",
      "pattern_list : newlines '(' pattern ')' list SEMI_SEMI",
      "pattern_list : newlines '(' pattern ')' newlines SEMI_SEMI",
      "pattern : WORD",
      "pattern : pattern '|' WORD",
      "list : newlines list0",
      "list0 : list1",
      "list0 : list1 '\n' newlines",
      "list0 : list1 '&' newlines",
      "list0 : list1 ';' newlines",
      "list1 : list1 AND_AND newlines list1",
      "list1 : list1 OR_OR newlines list1",
      "list1 : list1 '&' newlines list1",
      "list1 : list1 ';' newlines list1",
      "list1 : list1 '\n' newlines list1",
      "list1 : pipeline",
      "list1 : BANG pipeline",
      "list_terminator : '\n'",
      "list_terminator : ';'",
      "list_terminator : yacc_EOF",
      "newlines : /* empty */",
      "newlines : newlines '\n'",
      "simple_list : simple_list1",
      "simple_list : simple_list1 '&'",
      "simple_list : simple_list1 ';'",
      "simple_list1 : simple_list1 AND_AND newlines simple_list1",
      "simple_list1 : simple_list1 OR_OR newlines simple_list1",
      "simple_list1 : simple_list1 '&' simple_list1",
      "simple_list1 : simple_list1 ';' simple_list1",
      "simple_list1 : pipeline",
      "simple_list1 : BANG pipeline",
      "pipeline : pipeline '|' newlines pipeline",
      "pipeline : command",
};
#endif /* YYDEBUG */
/*
 * (c) Copyright 1990, OPEN SOFTWARE FOUNDATION, INC.
 * ALL RIGHTS RESERVED
 */
/*
 * OSF/1 Release 1.0
 */
/* @(#)yaccpar	1.3  com/cmd/lang/yacc,3.1, 9/7/89 18:46:37 */
/*
** Skeleton parser driver for yacc output
*/

/*
** yacc user known macros and defines
*/
#ifdef YYSPLIT
#   define YYERROR	return(-2)
#else
#   define YYERROR	goto yyerrlab
#endif

#define YYACCEPT	return(0)
#define YYABORT		return(1)
#define YYBACKUP( newtoken, newvalue )\
{\
	if ( yychar >= 0 || ( yyr2[ yytmp ] >> 1 ) != 1 )\
	{\
		yyerror( "syntax error - cannot backup" );\
		goto yyerrlab;\
	}\
	yychar = newtoken;\
	yystate = *yyps;\
	yylval = newvalue;\
	goto yynewstate;\
}
#define YYRECOVERING()	(!!yyerrflag)
#ifndef YYDEBUG
#	define YYDEBUG	1	/* make debugging available */
#endif

/*
** user known globals
*/
int yydebug;			/* set to 1 to get debugging */

/*
** driver internal defines
*/
#define YYFLAG		(-1000)

#ifdef YYSPLIT
#   define YYSCODE { \
			extern int (*yyf[])(); \
			register int yyret; \
			if (yyf[yytmp]) \
			    if ((yyret=(*yyf[yytmp])()) == -2) \
				    goto yyerrlab; \
				else if (yyret>=0) return(yyret); \
		   }
#endif

/*
** global variables used by the parser
*/
YYSTYPE yyv[ YYMAXDEPTH ];	/* value stack */
int yys[ YYMAXDEPTH ];		/* state stack */

YYSTYPE *yypv;			/* top of value stack */
YYSTYPE *yypvt;			/* top of value stack for $vars */
int *yyps;			/* top of state stack */

int yystate;			/* current state */
int yytmp;			/* extra var (lasts between blocks) */

int yynerrs;			/* number of errors */
int yyerrflag;			/* error recovery flag */
int yychar;			/* current input token number */



/*
** yyparse - return 0 if worked, 1 if syntax error not recovered from
*/
int
yyparse()
{
	/*
	** Initialize externals - yyparse may be called more than once
	*/
	yypv = &yyv[-1];
	yyps = &yys[-1];
	yystate = 0;
	yytmp = 0;
	yynerrs = 0;
	yyerrflag = 0;
	yychar = -1;

	goto yystack;
	{
		register YYSTYPE *yy_pv;	/* top of value stack */
		register int *yy_ps;		/* top of state stack */
		register int yy_state;		/* current state */
		register int  yy_n;		/* internal state number info */

		/*
		** get globals into registers.
		** branch to here only if YYBACKUP was called.
		*/
	yynewstate:
		yy_pv = yypv;
		yy_ps = yyps;
		yy_state = yystate;
		goto yy_newstate;

		/*
		** get globals into registers.
		** either we just started, or we just finished a reduction
		*/
	yystack:
		yy_pv = yypv;
		yy_ps = yyps;
		yy_state = yystate;

		/*
		** top of for (;;) loop while no reductions done
		*/
	yy_stack:
		/*
		** put a state and value onto the stacks
		*/
#if YYDEBUG
		/*
		** if debugging, look up token value in list of value vs.
		** name pairs.  0 and negative (-1) are special values.
		** Note: linear search is used since time is not a real
		** consideration while debugging.
		*/
		if ( yydebug )
		{
			register int yy_i;

			printf( "State %d, token ", yy_state );
			if ( yychar == 0 )
				printf( "end-of-file\n" );
			else if ( yychar < 0 )
				printf( "-none-\n" );
			else
			{
				for ( yy_i = 0; yytoks[yy_i].t_val >= 0;
					yy_i++ )
				{
					if ( yytoks[yy_i].t_val == yychar )
						break;
				}
				printf( "%s\n", yytoks[yy_i].t_name );
			}
		}
#endif /* YYDEBUG */
		if ( ++yy_ps >= &yys[ YYMAXDEPTH ] )	/* room on stack? */
		{
			yyerror( "yacc stack overflow" );
			YYABORT;
		}
		*yy_ps = yy_state;
		*++yy_pv = yyval;

		/*
		** we have a new state - find out what to do
		*/
	yy_newstate:
		if ( ( yy_n = yypact[ yy_state ] ) <= YYFLAG )
			goto yydefault;		/* simple state */
#if YYDEBUG
		/*
		** if debugging, need to mark whether new token grabbed
		*/
		yytmp = yychar < 0;
#endif
		if ( ( yychar < 0 ) && ( ( yychar = yylex() ) < 0 ) )
			yychar = 0;		/* reached EOF */
#if YYDEBUG
		if ( yydebug && yytmp )
		{
			register int yy_i;

			printf( "Received token " );
			if ( yychar == 0 )
				printf( "end-of-file\n" );
			else if ( yychar < 0 )
				printf( "-none-\n" );
			else
			{
				for ( yy_i = 0; yytoks[yy_i].t_val >= 0;
					yy_i++ )
				{
					if ( yytoks[yy_i].t_val == yychar )
						break;
				}
				printf( "%s\n", yytoks[yy_i].t_name );
			}
		}
#endif /* YYDEBUG */
		if ( ( ( yy_n += yychar ) < 0 ) || ( yy_n >= YYLAST ) )
			goto yydefault;
		if ( yychk[ yy_n = yyact[ yy_n ] ] == yychar )	/*valid shift*/
		{
			yychar = -1;
			yyval = yylval;
			yy_state = yy_n;
			if ( yyerrflag > 0 )
				yyerrflag--;
			goto yy_stack;
		}

	yydefault:
		if ( ( yy_n = yydef[ yy_state ] ) == -2 )
		{
#if YYDEBUG
			yytmp = yychar < 0;
#endif
			if ( ( yychar < 0 ) && ( ( yychar = yylex() ) < 0 ) )
				yychar = 0;		/* reached EOF */
#if YYDEBUG
			if ( yydebug && yytmp )
			{
				register int yy_i;

				printf( "Received token " );
				if ( yychar == 0 )
					printf( "end-of-file\n" );
				else if ( yychar < 0 )
					printf( "-none-\n" );
				else
				{
					for ( yy_i = 0;
						yytoks[yy_i].t_val >= 0;
						yy_i++ )
					{
						if ( yytoks[yy_i].t_val
							== yychar )
						{
							break;
						}
					}
					printf( "%s\n", yytoks[yy_i].t_name );
				}
			}
#endif /* YYDEBUG */
			/*
			** look through exception table
			*/
			{
				register int *yyxi = yyexca;

				while ( ( *yyxi != -1 ) ||
					( yyxi[1] != yy_state ) )
				{
					yyxi += 2;
				}
				while ( ( *(yyxi += 2) >= 0 ) &&
					( *yyxi != yychar ) )
					;
				if ( ( yy_n = yyxi[1] ) < 0 )
					YYACCEPT;
			}
		}

		/*
		** check for syntax error
		*/
		if ( yy_n == 0 )	/* have an error */
		{
			/* no worry about speed here! */
			switch ( yyerrflag )
			{
			case 0:		/* new error */
				yyerror( "syntax error" );
				goto skip_init;
			yyerrlab:
				/*
				** get globals into registers.
				** we have a user generated syntax type error
				*/
				yy_pv = yypv;
				yy_ps = yyps;
				yy_state = yystate;
				yynerrs++;
			skip_init:
			case 1:
			case 2:		/* incompletely recovered error */
					/* try again... */
				yyerrflag = 3;
				/*
				** find state where "error" is a legal
				** shift action
				*/
				while ( yy_ps >= yys )
				{
					yy_n = yypact[ *yy_ps ] + YYERRCODE;
					if ( yy_n >= 0 && yy_n < YYLAST &&
						yychk[yyact[yy_n]] == YYERRCODE)					{
						/*
						** simulate shift of "error"
						*/
						yy_state = yyact[ yy_n ];
						goto yy_stack;
					}
					/*
					** current state has no shift on
					** "error", pop stack
					*/
#if YYDEBUG
#	define _POP_ "Error recovery pops state %d, uncovers state %d\n"
					if ( yydebug )
						printf( _POP_, *yy_ps,
							yy_ps[-1] );
#	undef _POP_
#endif
					yy_ps--;
					yy_pv--;
				}
				/*
				** there is no state on stack with "error" as
				** a valid shift.  give up.
				*/
				YYABORT;
			case 3:		/* no shift yet; eat a token */
#if YYDEBUG
				/*
				** if debugging, look up token in list of
				** pairs.  0 and negative shouldn't occur,
				** but since timing doesn't matter when
				** debugging, it doesn't hurt to leave the
				** tests here.
				*/
				if ( yydebug )
				{
					register int yy_i;

					printf( "Error recovery discards " );
					if ( yychar == 0 )
						printf( "token end-of-file\n" );
					else if ( yychar < 0 )
						printf( "token -none-\n" );
					else
					{
						for ( yy_i = 0;
							yytoks[yy_i].t_val >= 0;
							yy_i++ )
						{
							if ( yytoks[yy_i].t_val
								== yychar )
							{
								break;
							}
						}
						printf( "token %s\n",
							yytoks[yy_i].t_name );
					}
				}
#endif /* YYDEBUG */
				if ( yychar == 0 )	/* reached EOF. quit */
					YYABORT;
				yychar = -1;
				goto yy_newstate;
			}
		}/* end if ( yy_n == 0 ) */
		/*
		** reduction by production yy_n
		** put stack tops, etc. so things right after switch
		*/
#if YYDEBUG
		/*
		** if debugging, print the string that is the user's
		** specification of the reduction which is just about
		** to be done.
		*/
		if ( yydebug )
			printf( "Reduce by (%d) \"%s\"\n",
				yy_n, yyreds[ yy_n ] );
#endif
		yytmp = yy_n;			/* value to switch over */
		yypvt = yy_pv;			/* $vars top of value stack */
		/*
		** Look in goto table for next state
		** Sorry about using yy_state here as temporary
		** register variable, but why not, if it works...
		** If yyr2[ yy_n ] doesn't have the low order bit
		** set, then there is no action to be done for
		** this reduction.  So, no saving & unsaving of
		** registers done.  The only difference between the
		** code just after the if and the body of the if is
		** the goto yy_stack in the body.  This way the test
		** can be made before the choice of what to do is needed.
		*/
		{
			/* length of production doubled with extra bit */
			register int yy_len = yyr2[ yy_n ];

			if ( !( yy_len & 01 ) )
			{
				yy_len >>= 1;
				yyval = ( yy_pv -= yy_len )[1];	/* $$ = $1 */
				yy_state = yypgo[ yy_n = yyr1[ yy_n ] ] +
					*( yy_ps -= yy_len ) + 1;
				if ( yy_state >= YYLAST ||
					yychk[ yy_state =
					yyact[ yy_state ] ] != -yy_n )
				{
					yy_state = yyact[ yypgo[ yy_n ] ];
				}
				goto yy_stack;
			}
			yy_len >>= 1;
			yyval = ( yy_pv -= yy_len )[1];	/* $$ = $1 */
			yy_state = yypgo[ yy_n = yyr1[ yy_n ] ] +
				*( yy_ps -= yy_len ) + 1;
			if ( yy_state >= YYLAST ||
				yychk[ yy_state = yyact[ yy_state ] ] != -yy_n )
			{
				yy_state = yyact[ yypgo[ yy_n ] ];
			}
		}
					/* save until reenter driver code */
		yystate = yy_state;
		yyps = yy_ps;
		yypv = yy_pv;
	}
	/*
	** code supplied by user is placed in this switch
	*/

		switch(yytmp){

case 1:
# line 141 "parse.y"
{
			  /* Case of regular command.  Discard the error
			     safety net,and return the command just parsed. */
			  global_command = yypvt[-1].command;
			  eof_encountered = 0;
			  discard_parser_constructs (0);
			  YYACCEPT;
			} /*NOTREACHED*/ break;
case 2:
# line 150 "parse.y"
{
			  /* Case of regular command, but not a very
			     interesting one.  Return a NULL command. */
			  global_command = (COMMAND *)NULL;
			  YYACCEPT;
			} /*NOTREACHED*/ break;
case 3:
# line 158 "parse.y"
{
			  /* Error during parsing.  Return NULL command. */
			  global_command = (COMMAND *)NULL;
			  eof_encountered = 0;
			  discard_parser_constructs (1);
			  if (interactive)
			    {
			      YYACCEPT;
			    }
			  else
			    {
			      YYABORT;
			    }
			} /*NOTREACHED*/ break;
case 4:
# line 173 "parse.y"
{
			  /* Case of EOF seen by itself.  Do ignoreeof or 
			     not. */
			  global_command = (COMMAND *)NULL;
			  handle_eof_input_unit ();
			  YYACCEPT;
			} /*NOTREACHED*/ break;
case 5:
# line 183 "parse.y"
{ yyval.word_list = (WORD_LIST *)NULL; } /*NOTREACHED*/ break;
case 6:
# line 185 "parse.y"
{ yyval.word_list = make_word_list (yypvt[-0].word, yypvt[-1].word_list); } /*NOTREACHED*/ break;
case 7:
# line 189 "parse.y"
{ yyval.redirect = make_redirection ( 1, r_output_direction, yypvt[-0].word); } /*NOTREACHED*/ break;
case 8:
# line 191 "parse.y"
{ yyval.redirect = make_redirection ( 0, r_input_direction, yypvt[-0].word); } /*NOTREACHED*/ break;
case 9:
# line 193 "parse.y"
{ yyval.redirect = make_redirection (yypvt[-2].number, r_output_direction, yypvt[-0].word); } /*NOTREACHED*/ break;
case 10:
# line 195 "parse.y"
{ yyval.redirect = make_redirection (yypvt[-2].number, r_input_direction, yypvt[-0].word); } /*NOTREACHED*/ break;
case 11:
# line 197 "parse.y"
{ yyval.redirect = make_redirection ( 1, r_appending_to, yypvt[-0].word); } /*NOTREACHED*/ break;
case 12:
# line 199 "parse.y"
{ yyval.redirect = make_redirection (yypvt[-2].number, r_appending_to, yypvt[-0].word); } /*NOTREACHED*/ break;
case 13:
# line 201 "parse.y"
{
			  yyval.redirect = make_redirection ( 0, r_reading_until, yypvt[-0].word);
			  redir_stack[need_here_doc++] = yyval.redirect;
			} /*NOTREACHED*/ break;
case 14:
# line 206 "parse.y"
{
			  yyval.redirect = make_redirection (yypvt[-2].number, r_reading_until, yypvt[-0].word);
			  redir_stack[need_here_doc++] = yyval.redirect;
			} /*NOTREACHED*/ break;
case 15:
# line 211 "parse.y"
{
			  long rd = yypvt[-0].number;
			  yyval.redirect = make_redirection ( 0, r_duplicating_input, rd);
			} /*NOTREACHED*/ break;
case 16:
# line 216 "parse.y"
{
			  long rd = yypvt[-0].number;
			  yyval.redirect = make_redirection (yypvt[-2].number, r_duplicating_input, rd);
			} /*NOTREACHED*/ break;
case 17:
# line 221 "parse.y"
{
			  long rd = yypvt[-0].number;
			  yyval.redirect = make_redirection ( 1, r_duplicating_output, rd);
			} /*NOTREACHED*/ break;
case 18:
# line 226 "parse.y"
{
			  long rd = yypvt[-0].number;
			  yyval.redirect = make_redirection (yypvt[-2].number, r_duplicating_output, rd);
			} /*NOTREACHED*/ break;
case 19:
# line 231 "parse.y"
{
			  yyval.redirect = make_redirection
			    (0, r_duplicating_input_word, yypvt[-0].word);
			} /*NOTREACHED*/ break;
case 20:
# line 236 "parse.y"
{
			  yyval.redirect = make_redirection
			    (yypvt[-2].number, r_duplicating_input_word, yypvt[-0].word);
			} /*NOTREACHED*/ break;
case 21:
# line 241 "parse.y"
{
			  yyval.redirect = make_redirection
			    (1, r_duplicating_output_word, yypvt[-0].word);
			} /*NOTREACHED*/ break;
case 22:
# line 246 "parse.y"
{
			  yyval.redirect = make_redirection
			    (yypvt[-2].number, r_duplicating_output_word, yypvt[-0].word);
			} /*NOTREACHED*/ break;
case 23:
# line 251 "parse.y"
{
			  yyval.redirect = make_redirection
			    (0, r_deblank_reading_until, yypvt[-0].word);
			  redir_stack[need_here_doc++] = yyval.redirect;
			} /*NOTREACHED*/ break;
case 24:
# line 257 "parse.y"
{
			  yyval.redirect = make_redirection
			    (yypvt[-2].number, r_deblank_reading_until, yypvt[-0].word);
			  redir_stack[need_here_doc++] = yyval.redirect;
			} /*NOTREACHED*/ break;
case 25:
# line 263 "parse.y"
{ yyval.redirect = make_redirection ( 1, r_close_this, 0L); } /*NOTREACHED*/ break;
case 26:
# line 265 "parse.y"
{ yyval.redirect = make_redirection (yypvt[-2].number, r_close_this, 0L); } /*NOTREACHED*/ break;
case 27:
# line 267 "parse.y"
{ yyval.redirect = make_redirection ( 0, r_close_this, 0L); } /*NOTREACHED*/ break;
case 28:
# line 269 "parse.y"
{ yyval.redirect = make_redirection (yypvt[-2].number, r_close_this, 0L); } /*NOTREACHED*/ break;
case 29:
# line 271 "parse.y"
{ yyval.redirect = make_redirection ( 1, r_err_and_out, yypvt[-0].word); } /*NOTREACHED*/ break;
case 30:
# line 273 "parse.y"
{ yyval.redirect = make_redirection ( yypvt[-2].number, r_input_output, yypvt[-0].word); } /*NOTREACHED*/ break;
case 31:
# line 275 "parse.y"
{
			  REDIRECT *t1, *t2;

			  if (posixly_correct)
			    yyval.redirect = make_redirection (0, r_input_output, yypvt[-0].word);
			  else
			    {
			      t1 = make_redirection (0, r_input_direction, yypvt[-0].word);
			      t2 = make_redirection (1, r_output_direction, copy_word (yypvt[-0].word));
			      t1->next = t2;
			      yyval.redirect = t1;
			    }
			} /*NOTREACHED*/ break;
case 32:
# line 289 "parse.y"
{ yyval.redirect = make_redirection ( 1, r_output_force, yypvt[-0].word); } /*NOTREACHED*/ break;
case 33:
# line 291 "parse.y"
{ yyval.redirect = make_redirection ( yypvt[-2].number, r_output_force, yypvt[-0].word); } /*NOTREACHED*/ break;
case 34:
# line 295 "parse.y"
{ yyval.element.word = yypvt[-0].word; yyval.element.redirect = 0; } /*NOTREACHED*/ break;
case 35:
# line 297 "parse.y"
{ yyval.element.word = yypvt[-0].word; yyval.element.redirect = 0; } /*NOTREACHED*/ break;
case 36:
# line 299 "parse.y"
{ yyval.element.redirect = yypvt[-0].redirect; yyval.element.word = 0; } /*NOTREACHED*/ break;
case 37:
# line 303 "parse.y"
{
			  yyval.redirect = yypvt[-0].redirect;
			} /*NOTREACHED*/ break;
case 38:
# line 307 "parse.y"
{ 
			  register REDIRECT *t = yypvt[-1].redirect;

			  while (t->next)
			    t = t->next;
			  t->next = yypvt[-0].redirect; 
			  yyval.redirect = yypvt[-1].redirect;
			} /*NOTREACHED*/ break;
case 39:
# line 318 "parse.y"
{ yyval.command = make_simple_command (yypvt[-0].element, (COMMAND *)NULL); } /*NOTREACHED*/ break;
case 40:
# line 320 "parse.y"
{ yyval.command = make_simple_command (yypvt[-0].element, yypvt[-1].command); } /*NOTREACHED*/ break;
case 41:
# line 324 "parse.y"
{ yyval.command = clean_simple_command (yypvt[-0].command); } /*NOTREACHED*/ break;
case 42:
# line 326 "parse.y"
{ yyval.command = yypvt[-0].command; } /*NOTREACHED*/ break;
case 43:
# line 330 "parse.y"
{ yyval.command = yypvt[-0].command; } /*NOTREACHED*/ break;
case 44:
# line 332 "parse.y"
{ yypvt[-1].command->redirects = yypvt[-0].redirect; yyval.command = yypvt[-1].command; } /*NOTREACHED*/ break;
case 45:
# line 336 "parse.y"
{ yyval.command = make_for_command (yypvt[-4].word, add_string_to_list ("\"$@\"", (WORD_LIST *)NULL), yypvt[-1].command); } /*NOTREACHED*/ break;
case 46:
# line 338 "parse.y"
{ yyval.command = make_for_command (yypvt[-4].word, add_string_to_list ("$@", (WORD_LIST *)NULL), yypvt[-1].command); } /*NOTREACHED*/ break;
case 47:
# line 340 "parse.y"
{ yyval.command = make_for_command (yypvt[-5].word, add_string_to_list ("\"$@\"", (WORD_LIST *)NULL), yypvt[-1].command); } /*NOTREACHED*/ break;
case 48:
# line 342 "parse.y"
{ yyval.command = make_for_command (yypvt[-5].word, add_string_to_list ("\"$@\"", (WORD_LIST *)NULL), yypvt[-1].command); } /*NOTREACHED*/ break;
case 49:
# line 345 "parse.y"
{ yyval.command = make_for_command (yypvt[-8].word, (WORD_LIST *)reverse_list (yypvt[-5].word_list), yypvt[-1].command); } /*NOTREACHED*/ break;
case 50:
# line 347 "parse.y"
{ yyval.command = make_for_command (yypvt[-8].word, (WORD_LIST *)reverse_list (yypvt[-5].word_list), yypvt[-1].command); } /*NOTREACHED*/ break;
case 51:
# line 350 "parse.y"
{ yyval.command = make_case_command (yypvt[-4].word, (PATTERN_LIST *)NULL); } /*NOTREACHED*/ break;
case 52:
# line 352 "parse.y"
{ yyval.command = make_case_command (yypvt[-5].word, yypvt[-2].pattern); } /*NOTREACHED*/ break;
case 53:
# line 354 "parse.y"
{ /* Nobody likes this...
			     report_syntax_error ("Inserted `;;'"); */
			  yyval.command = make_case_command (yypvt[-4].word, yypvt[-1].pattern); } /*NOTREACHED*/ break;
case 54:
# line 359 "parse.y"
{ yyval.command = yypvt[-0].command; } /*NOTREACHED*/ break;
case 55:
# line 361 "parse.y"
{ yyval.command = make_while_command (yypvt[-3].command, yypvt[-1].command); } /*NOTREACHED*/ break;
case 56:
# line 363 "parse.y"
{ yyval.command = make_until_command (yypvt[-3].command, yypvt[-1].command); } /*NOTREACHED*/ break;
case 57:
# line 366 "parse.y"
{ yypvt[-1].command->flags |= CMD_WANT_SUBSHELL; yyval.command = yypvt[-1].command; } /*NOTREACHED*/ break;
case 58:
# line 369 "parse.y"
{ yyval.command = yypvt[-0].command; } /*NOTREACHED*/ break;
case 59:
# line 372 "parse.y"
{ yyval.command = yypvt[-0].command; } /*NOTREACHED*/ break;
case 60:
# line 376 "parse.y"
{ yyval.command = make_function_def (yypvt[-4].word, yypvt[-0].command); } /*NOTREACHED*/ break;
case 61:
# line 379 "parse.y"
{ yypvt[-1].command->redirects = yypvt[-0].redirect; yyval.command = make_function_def (yypvt[-5].word, yypvt[-1].command); } /*NOTREACHED*/ break;
case 62:
# line 382 "parse.y"
{ yyval.command = make_function_def (yypvt[-4].word, yypvt[-0].command); } /*NOTREACHED*/ break;
case 63:
# line 385 "parse.y"
{ yypvt[-1].command->redirects = yypvt[-0].redirect; yyval.command = make_function_def (yypvt[-5].word, yypvt[-1].command); } /*NOTREACHED*/ break;
case 64:
# line 388 "parse.y"
{ yyval.command = make_function_def (yypvt[-2].word, yypvt[-0].command); } /*NOTREACHED*/ break;
case 65:
# line 391 "parse.y"
{ yypvt[-1].command->redirects = yypvt[-0].redirect; yyval.command = make_function_def (yypvt[-3].word, yypvt[-1].command); } /*NOTREACHED*/ break;
case 66:
# line 395 "parse.y"
{ yyval.command = make_if_command (yypvt[-3].command, yypvt[-1].command, (COMMAND *)NULL); } /*NOTREACHED*/ break;
case 67:
# line 397 "parse.y"
{ yyval.command = make_if_command (yypvt[-5].command, yypvt[-3].command, yypvt[-1].command); } /*NOTREACHED*/ break;
case 68:
# line 399 "parse.y"
{ yyval.command = make_if_command (yypvt[-4].command, yypvt[-2].command, yypvt[-1].command); } /*NOTREACHED*/ break;
case 69:
# line 404 "parse.y"
{ yyval.command = make_group_command (yypvt[-1].command); } /*NOTREACHED*/ break;
case 70:
# line 408 "parse.y"
{ yyval.command = make_if_command (yypvt[-2].command, yypvt[-0].command, (COMMAND *)NULL); } /*NOTREACHED*/ break;
case 71:
# line 410 "parse.y"
{ yyval.command = make_if_command (yypvt[-4].command, yypvt[-2].command, yypvt[-0].command); } /*NOTREACHED*/ break;
case 72:
# line 412 "parse.y"
{ yyval.command = make_if_command (yypvt[-3].command, yypvt[-1].command, yypvt[-0].command); } /*NOTREACHED*/ break;
case 74:
# line 417 "parse.y"
{ yypvt[-0].pattern->next = yypvt[-1].pattern; yyval.pattern = yypvt[-0].pattern; } /*NOTREACHED*/ break;
case 75:
# line 421 "parse.y"
{ yyval.pattern = make_pattern_list (yypvt[-2].word_list, yypvt[-0].command); } /*NOTREACHED*/ break;
case 76:
# line 423 "parse.y"
{ yyval.pattern = make_pattern_list (yypvt[-2].word_list, (COMMAND *)NULL); } /*NOTREACHED*/ break;
case 77:
# line 425 "parse.y"
{ yyval.pattern = make_pattern_list (yypvt[-2].word_list, yypvt[-0].command); } /*NOTREACHED*/ break;
case 78:
# line 427 "parse.y"
{ yyval.pattern = make_pattern_list (yypvt[-2].word_list, (COMMAND *)NULL); } /*NOTREACHED*/ break;
case 80:
# line 433 "parse.y"
{ yypvt[-0].pattern->next = yypvt[-1].pattern; yyval.pattern = yypvt[-0].pattern; } /*NOTREACHED*/ break;
case 81:
# line 437 "parse.y"
{ yyval.pattern = make_pattern_list (yypvt[-3].word_list, yypvt[-1].command); } /*NOTREACHED*/ break;
case 82:
# line 439 "parse.y"
{ yyval.pattern = make_pattern_list (yypvt[-3].word_list, (COMMAND *)NULL); } /*NOTREACHED*/ break;
case 83:
# line 441 "parse.y"
{ yyval.pattern = make_pattern_list (yypvt[-3].word_list, yypvt[-1].command); } /*NOTREACHED*/ break;
case 84:
# line 443 "parse.y"
{ yyval.pattern = make_pattern_list (yypvt[-3].word_list, (COMMAND *)NULL); } /*NOTREACHED*/ break;
case 85:
# line 447 "parse.y"
{ yyval.word_list = make_word_list (yypvt[-0].word, (WORD_LIST *)NULL); } /*NOTREACHED*/ break;
case 86:
# line 449 "parse.y"
{ yyval.word_list = make_word_list (yypvt[-0].word, yypvt[-2].word_list); } /*NOTREACHED*/ break;
case 87:
# line 458 "parse.y"
{
			  yyval.command = yypvt[-0].command;
			  if (need_here_doc)
			    gather_here_documents ();
			 } /*NOTREACHED*/ break;
case 90:
# line 468 "parse.y"
{ yyval.command = command_connect (yypvt[-2].command, 0, '&'); } /*NOTREACHED*/ break;
case 92:
# line 474 "parse.y"
{ yyval.command = command_connect (yypvt[-3].command, yypvt[-0].command, AND_AND); } /*NOTREACHED*/ break;
case 93:
# line 476 "parse.y"
{ yyval.command = command_connect (yypvt[-3].command, yypvt[-0].command, OR_OR); } /*NOTREACHED*/ break;
case 94:
# line 478 "parse.y"
{
			  /* $1->flags |= CMD_FORCE_SUBSHELL; */
			  yyval.command = command_connect (yypvt[-3].command, yypvt[-0].command, '&');
			} /*NOTREACHED*/ break;
case 95:
# line 483 "parse.y"
{ yyval.command = command_connect (yypvt[-3].command, yypvt[-0].command, ';'); } /*NOTREACHED*/ break;
case 96:
# line 485 "parse.y"
{ yyval.command = command_connect (yypvt[-3].command, yypvt[-0].command, ';'); } /*NOTREACHED*/ break;
case 97:
# line 487 "parse.y"
{ yyval.command = yypvt[-0].command; } /*NOTREACHED*/ break;
case 98:
# line 489 "parse.y"
{
			  yypvt[-0].command->flags |= CMD_INVERT_RETURN;
			  yyval.command = yypvt[-0].command;
			} /*NOTREACHED*/ break;
case 104:
# line 511 "parse.y"
{
			  yyval.command = yypvt[-0].command;
			  if (need_here_doc)
			    gather_here_documents ();
			} /*NOTREACHED*/ break;
case 105:
# line 517 "parse.y"
{
			  /* $1->flags |= CMD_FORCE_SUBSHELL; */
			  yyval.command = command_connect (yypvt[-1].command, (COMMAND *)NULL, '&');
			  if (need_here_doc)
			    gather_here_documents ();
			} /*NOTREACHED*/ break;
case 106:
# line 524 "parse.y"
{
			  yyval.command = yypvt[-1].command;
			  if (need_here_doc)
			    gather_here_documents ();
			} /*NOTREACHED*/ break;
case 107:
# line 532 "parse.y"
{ yyval.command = command_connect (yypvt[-3].command, yypvt[-0].command, AND_AND); } /*NOTREACHED*/ break;
case 108:
# line 534 "parse.y"
{ yyval.command = command_connect (yypvt[-3].command, yypvt[-0].command, OR_OR); } /*NOTREACHED*/ break;
case 109:
# line 536 "parse.y"
{
			  /* $1->flags |= CMD_WANT_SUBSHELL; */
			  yyval.command = command_connect (yypvt[-2].command, yypvt[-0].command, '&');
			} /*NOTREACHED*/ break;
case 110:
# line 541 "parse.y"
{ yyval.command = command_connect (yypvt[-2].command, yypvt[-0].command, ';'); } /*NOTREACHED*/ break;
case 111:
# line 543 "parse.y"
{ yyval.command = yypvt[-0].command; } /*NOTREACHED*/ break;
case 112:
# line 545 "parse.y"
{
			  yypvt[-0].command->flags |= CMD_INVERT_RETURN;
			  yyval.command = yypvt[-0].command;
			} /*NOTREACHED*/ break;
case 113:
# line 553 "parse.y"
{ yyval.command = command_connect (yypvt[-3].command, yypvt[-0].command, '|'); } /*NOTREACHED*/ break;
case 114:
# line 555 "parse.y"
{ yyval.command = yypvt[-0].command; } /*NOTREACHED*/ break;
}


	goto yystack;		/* reset registers in driver code */
}
