/***************************************************************************
* This is a simple program to create Julia set images of  				   *
*   Z^2+C																   *
*   C*SINZ																   *
*   C*COSZ																   *
*   C*EXPZ																   *
*																		   *
* And images of															   *
*																		   *
*   Mandelbrot set 														   *
*   Spider 																   *
*   Phoenix  															   *
*   Glass																   *
*   Noel1																   *
*   Noel2																   *
*   Newton Power														   *
*   Tetrate																   *
*   Barnsley1															   *
*   Barnsley2															   *
*   Barnsley3															   *
*																		   *
*   The output file is in GIF format....								   *
*                           (C)1993 Massimo Casal						   *
*                          casal@udmi5400.cineca.it					       *
***************************************************************************/

#ifdef DBG
# define	OUT(x, y1, y2, y3, y4, y5)	fprintf(stderr, x, y1, y2, y3, y4, y5)
#else
# define	OUT(x,y)
#endif

#include <string.h>
#include <stdio.h>
#include <fcntl.h>
#include <ctype.h>
#include <malloc.h>
#include <time.h>
#include <sys/types.h>
#include <unistd.h>

#include "gifcompr.c"
#include "gifencod.c"
#include "complex.c"

int width,height; /*resolution*/

double xmin,xmax,ymin,ymax;  /* x and y limits*/ 

complex constant;       /* It's the perturbation or the constant.
                           it depends on the fractal type */ 

unsigned short dg;   /* degree for newton fractal type*/

char *file,*pal;  /* output and palette file names */
char *fractalname[14];   /*fractal type name*/

unsigned short fractaltype;     /* it stores the fractal type u choose*/  

time_t t1,t2;  /* t1= time fract starts the computation
                  t2 = time fract ends the coputation */  

long tot;     /* The number of pixels that must be computated */
long done = 0; /* The number of pixels that have been computated*/

short percent;
short oldpercent = -1;

short background = 0; /* I need it to know if 'Fract' is running in
                             background */
char esc=27;    /* Escape ASCII code */
char bell=7;    /* Bell ASCII code  */  

#include "read.c"
#include "pal.c"

#include "mandel.c"
#include "julia.c"
#include "jsin.c"
#include "jcos.c"
#include "jexp.c"
#include "spider.c"
#include "phoenix.c"
#include "glass.c"
#include "noel1.c"
#include "noel2.c"
#include "newton.c"
#include "tetrate.c"
#include "barnsley1.c"
#include "barnsley2.c"
#include "barnsley3.c"

/* Convert pixel to complex numbers and calculate */

calc(xp,yp) 
int xp,yp;
{
 complex point;

/* Convert to complex numbers.....   */

 point.r = xmin + ((xmax-xmin)*xp)/width;
 point.i = ymin + ((ymax-ymin)*yp)/height; 

/* and then calculate  */

 switch(fractaltype)  { 
      case 0:
             return(mandel(point)); 
      case 1:
             return(julia(point));
      case 2:
             return(jsin(point));
      case 3:
             return(jcos(point));
      case 4:
             return(jexp(point));
      case 5:
             return(spider(point));
      case 6:
             return(phoenix(point));
      case 7:  
             return(glass(point));
      case 8:
             return(noel1(point)); 
      case 9:
             return(noel2(point));
      case 10:
             return(newton(point));
      case 11:
             return(tetrate(point));
      case 12:
             return(barnsley1(point));
      case 13:
             return(barnsley2(point));
      case 14:
             return(barnsley3(point));
  }  
}

main(argc,argv)   
int argc;
char *argv[];
{
   int backcolor = 0; /*Set background color to 0*/
   int interlaced = 0; /* 1 if u want an interlaced GIF*/
   int bites = 8; /* 8 bites that is 256 colors*/
   int r[256],g[256],b[256];
   int ck1,ck2; /*checks*/

   file=malloc(30);
   pal=malloc(30);
   fractalname[0]="Mandelbrot set";
   fractalname[1]="Julia set of z^2+c";
   fractalname[2]="Julia set of c*sinz";
   fractalname[3]="Julia set of c*cosz";
   fractalname[4]="Julia set of c*expz";
   fractalname[5]="Spider";
   fractalname[6]="Phoenix";
   fractalname[7]="Glass";
   fractalname[8]="Noel1";
   fractalname[9]="Noel2";
   fractalname[10]="Newton";  
   fractalname[11]="Tetrate";
   fractalname[12]="Barnsley1";
   fractalname[13]="Barnsley2";
   fractalname[14]="Barnsley3"; 

   ck1=rd(argc,argv,file,pal,&width,&height,&constant,&dg,&xmin,&xmax,&ymin,&ymax,&fractaltype);
   ck2=createpalette(r,g,b,pal);
   tot=height*width;
   if (ck1==1 && ck2)  {
   	time(&t1);

   	if(mynode() == 0)  {
   		fprintf(stderr, "Computing %s\n",fractalname[fractaltype]);
		fprintf(stderr, "xmin: %f, xmax: %f, ymin: %f, ymax: %f\n", xmin, xmax, ymin, ymax);
	}
	
	/* OK start the computation ....  */
   	GIFEncode(file,width,height,interlaced,backcolor,bites,r,g,b,calc); 

   	time(&t2);

   	fprintf(stderr, "Berechnung auf Node %d dauerte %ld Sekunden\n", mynode(), t2 - t1);
   	fflush(stderr);
   }
   else  {
  	if(mynode() == 0)  {
  		printf("Usage:%s {-m -j -s -c -e -sp -ph -g -n1 -n2 -nw -t -b1 -b2 -b3 -f filename}  \n",argv[0]);
    		printf("         [-x] [-y] [-r] [-i] [-deg]\n");
    		printf("         [-x1] [-x2] [-y1] [-y2] \n");     
    		printf("         [-o] [-p]\n");
    		printf("Params in [] are optional \n");
    		if (ck2==-1) printf("\nError:palette file not found!\n");
    		printf("\n");
    	}
  }
}
 
