/*
* 
*     SOCKET Funktionssammlung 
*
*
*     Funktionen zur Socket-Programmierung
*     aus: Douglas Comer, Internetworking with TCP/IP III
*
*
*/

#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/errno.h>
#include <netinet/in.h>
#include <netdb.h>

/* for inet_ntoa() */
#include <arpa/inet.h>

#include <stdio.h>
#include <stdarg.h>

#include <sys/time.h>

#ifdef DEBUG
# define dfprintf(s) fprintf s
#else
# define dfprintf(s) /**/
#endif




extern int  errno;
extern char *sys_errlist[];

u_short port_base = 0;


/* only SUNs (!?) need this */
#ifndef INADDR_NONE
#define INADDR_NONE 0xffffffff
#endif


/*
 * print an errormessage and exit with exitcode > 0
 * 
 * returns nothing, since it will never return
 */
void
errexit(int exitcode,...)
{
     char *fmt;

     va_list arg_marker;
     va_start (arg_marker,exitcode);  
     
     fmt = va_arg(arg_marker,char*);
     vfprintf (stderr,fmt,arg_marker);
     exit (exitcode);
}



/*
 * convert address of connected socket to ip-number/hostname
 * this function, called with a connected socket, will
 * get the name of the peer an convert its address to
 * ip-number (dotted) format.
 * returns hostname/IP-number of connected host
 */
char *
from_sock (s)
     int s; /* connected socket to be converted to hostname */
{
     struct sockaddr_in peer;
     int peerlen = sizeof (peer);
     
     if ( getpeername(s,(struct sockaddr *) &peer, &peerlen) < 0 )
	 errexit (1,"can't get peername: %s\n", sys_errlist[errno]);
     
     return inet_ntoa (peer.sin_addr);
}





/*
 ********************************************************************
 * here comes the socket stuff..........
 ********************************************************************
 */


/*
 * USED internally (socketlib) only: create an active socket
 * make a tcp/udp connection to a host using specified portnumber
 *
 * returns socket-number
 */
int
connectTCP(host,port)
     char *host;     /* Host to connect to (name or IP-address) */
     int  port;  /* type of service wanted (name or number) */
{
     struct hostent  *phe;
     struct sockaddr_in sin;
     int s;
     
     bzero ((char*)&sin, sizeof(sin));
     sin.sin_family = AF_INET;

     sin.sin_port = htons(port);

     phe = gethostbyname(host);
     if (phe)
	 bcopy (phe->h_addr, (char*)&sin.sin_addr, phe->h_length);
     else if ((sin.sin_addr.s_addr = inet_addr(host)) == INADDR_NONE)
	 errexit (1,"can't get host by name: %s\n",sys_errlist[errno]);
     
     s = socket (PF_INET, SOCK_STREAM, IPPROTO_TCP );
     if (s<0)
	 errexit (1,"can't create socket: %s\n",sys_errlist[errno]);
   
     if (connect (s,(struct sockaddr*)&sin, sizeof(sin)) < 0 )
     {
       if (errno==ECONNREFUSED)
       {
         close(s);
         s = -1;
       }
       else
       {
	 errexit( 1, "can't connect to socket: %s\n",sys_errlist[errno]);
       }
     }
     return (s);     
}


int passiveTCP(port)
     int port;   /* type of service wanted (name or number) */
{
     struct sockaddr_in sin;
     int s;
     
     bzero ((char *)&sin,sizeof(sin));
     sin.sin_family = AF_INET;
     sin.sin_addr.s_addr = INADDR_ANY;
     
     /* map service name to port number */

     sin.sin_port = htons (port);
     
     /* allocate the socket */
     s = socket (PF_INET, SOCK_STREAM, IPPROTO_TCP );
     if (s < 0)
	 errexit (1,"can't create socket: %s\n",sys_errlist[errno]);
          
     if (bind (s,(struct sockaddr*)&sin, sizeof(sin)) < 0 )
	 errexit (1,"can't bind to port %d : %s\n", port,
		  sys_errlist[errno]);
     
     if ( listen (s,1) < 0 )
	 errexit (1,"can't listen on port %d : %s\n",port,
		  sys_errlist[errno]);
	 	      
     return (s);

}


/*
 * u_sleep() 
 * sleep (nonbusy) for n usec
 */
/*
void u_sleep(delay)
int delay;
{
     struct timeval tt;
     
     tt.tv_sec=0;
     tt.tv_usec = delay;
     select (32,NULL,NULL,NULL,&tt);
}
*/




/* EOF */

