#include <stdlib.h>
#include <sys/times.h>
#include <sys/param.h>
#include <sys/timeb.h>
#include <process.h>

#define HIGH_TICKS_PER_SECOND  (1.0 /  1.0E-6)
#define LOW_TICKS_PER_SECOND   (1.0 / 64.0E-6)

static int  proc_prio    = PROC_LOW;

struct timeb *tp;

int ProcTime( void )
{
  struct timeb tb;
  long long lticks;
  double real_seconds, emu_ticks_per_second;

  ftime(&tb);

  real_seconds = ((double) tb.time ) + ((double) tb.millitm ) * 0.001;
  emu_ticks_per_second = (proc_prio == PROC_HIGH) ? HIGH_TICKS_PER_SECOND : LOW_TICKS_PER_SECOND;

  lticks = ( real_seconds * emu_ticks_per_second );

  lticks = lticks % 100000000;

  return (int) ( lticks );
}

int ProcGetPriority( void )
{
  return proc_prio;
}

void ProcStop( void )
{
  exit(0);
}













