%SENDLINK Send data to Transputer via a C011 type link
%        sendlink() is a host PC transputer utility for MATLAB.
% 
%        [count] = SENDLINK(word_size, data, base_address, timeout) 
%        where count is the number of elements actually sent, word_size is 
%        the number of bytes in each element, data is the worspace array or
%        a number to send down the link, base_address is a decimal number 
%        representing the memory base location of the Transputer interface 
%        card and timeout is an optional parameter to set a timeout delay 
%        before abort (default is 10 seconds). A timeout value of -1 will 
%        disable the timeout.
% 
%        Example:
% 
%           [count] = sendlink(1, [1000 2000 3000 4000], 336, 3)
%        or
%           BASE = 336;
%           a = [1000 2000 3000 4000];
%           sendlink(2, a, BASE, -1)
%
%        Here four 16-bit (4 * 2 bytes) numbers are sent to a link adapter
%        at 336 (0x150 hex). A three second timeout is set for the first
%        example, whilst the second example has disabled it.
%        SENDLINK returns the number of actual elemens sent. A value of -1 
%        is returned after a timeout or a link error.
%
%        See also BOOTLINK, READLINK, RESETLNK

%-------------------------------
%        Additional details:
%
%

%        Author:Robert Shaw
%               Department of Electrical and Electronic Engineering
%               Nottingham Trent University
%               Burton Street
%               Nottingham
%               UK
%               Tel: +44 115 9418 418 extn. 2695
%               Fax: +44 115 9486567
%               EMail: ca153rs01@ntu.ac.uk
%

