%READLINK Read data from a Transputer via a C011 type link
%        readlink() is a host PC transputer utility for MATLAB.
% 
%        [data, count] = READLINK(word_size, nelem, base_address, timeout) 
%        where data is the returned data array, count is the number of
%        elements actually read, word_size is the number of bytes in each
%        element, nelem are the number of elements to read, base_address is 
%        a decimal number representing the memory base location of the 
%        Transputer interface card and timeout is an optional parameter to 
%        set a timeout delay before abort (default is 10 seconds). A timeout 
%        value of -1 will disable the timeout.
% 
%        Example:
% 
%           [data,count] = readlink(2, 4, 336, 3)
%        or
%           BASE = 336;
%           [data] = readlink(2, 4, BASE, -1)
%
%        Here four 16-bit (4 * 2 bytes) numbers are read from a link adapter
%        at 336 (0x150 hex). A three second timeout is set for the first
%        example, whilst the second example has disabled it.
%        READLINK returns the data array and the number of actual bytes 
%        received from the network. A value of -1 is returned after a
%        timeout or a link error.
%
%        See also BOOTLINK, SENDLINK, RESETLNK

%-------------------------------
%        Additional details:
%
%

%        Author:Robert Shaw
%               Department of Electrical and Electronic Engineering
%               Nottingham Trent University
%               Burton Street
%               Nottingham
%               UK
%               Tel: +44 115 9418 418 extn. 2695
%               Fax: +44 115 9486567
%               EMail: ca153rs01@ntu.ac.uk
%

