function [sent] = booter(file_string, base_add)
%	Booter resets and boots a transputer 
% 	network using file_string as a boot
% 	file and base_add as the memory
% 	location of the link adapter.
%
%	E.g.
%		base = hex2dec('150');
%		booter('boot.btl',base);
%
%	Booter returns the number of bytes sent.
%	A value of -1 indicates an error.
%
%	SEE ALSO: RESETLNK
%

fid = fopen(file_string,'r');
[boot,count] = fread(fid,inf,'char');
fclose(fid);
resetlnk(base_add);
sent = sendlink(1,boot',base_add,2);
