/* popcount.c

Copyright (C) 1998 by Alex Stuebinger

"bitcnt" = bitcount does not run on old t414, but who has a t414?

*/

#include "gmp.h"
#include "gmp-impl.h"

unsigned long int
#if __STDC__
mpn_popcount (register mp_srcptr p, register mp_size_t size)
#else
mpn_popcount (p, size)
     register mp_srcptr p;
     register mp_size_t size;
#endif
{
  unsigned long popcnt;
  mp_size_t i;
	mp_srcptr ptr;

  popcnt = 0;

	/*-----------------26/03/98 17:54-------------------
	 loop unrolling, using pointers avoiding indices
	--------------------------------------------------*/
  i = 0;
  __asm { align; }
  for (; i < size>>3; i += 8)
    __asm { ldl i; ldl p; wsub; stl ptr;
            ldl popcnt;
            ldl ptr; ldnl 0; bitcnt;
            ldl ptr; ldnl 1*4; bitcnt;
            ldl ptr; ldnl 2*4; bitcnt;
            ldl ptr; ldnl 3*4; bitcnt;
            ldl ptr; ldnl 4*4; bitcnt;
            ldl ptr; ldnl 5*4; bitcnt;
            ldl ptr; ldnl 6*4; bitcnt;
            ldl ptr; ldnl 7*4; bitcnt;
            stl popcnt;
		}
  __asm { align; }
  for (; i < size; i++)
    __asm { ldl popcnt;
            ldl i; ldl p; wsub; ldnl 0;
            bitcnt;
            stl popcnt;
    }

  return popcnt;
}
