/* mpn_mul_1 -- Multiply a limb vector with a single limb and
   store the product in a second limb vector, return carry;

Copyright (C) 1998 by Alex Stuebinger

*/

#include "gmp.h"
#include "gmp-impl.h"

mp_limb_t
mpn_mul_1 (res_ptr, s1_ptr, s1_size, s2_limb)
     register mp_ptr res_ptr;
     register mp_srcptr s1_ptr;
     mp_size_t s1_size;
     register mp_limb_t s2_limb;
{
  mp_limb_t carry_limb = 0;
  mp_size_t i;

  i = 0;
  __asm { align; }
  for (; i < s1_size; ++i )
  { unsigned * tres;
    __asm { ldl i;
            ldl res_ptr;
            wsub;
            stl tres;
            ldl carry_limb;
            ldl i;
            ldl s1_ptr;
            wsub;
            ldnl 0;
            ldl s2_limb;
            lmul;
            ldl tres;
            stnl 0;
            stl carry_limb;
		}
	}
	return carry_limb;
}

