/* mpn_hamdist --

Copyright (C) 1998 by Alex Stuebinger

*/

#include "gmp.h"
#include "gmp-impl.h"

unsigned long int
#if __STDC__
mpn_hamdist (mp_srcptr up, mp_srcptr vp, mp_size_t size)
#else
mpn_hamdist (up, vp, size)
     register mp_srcptr up;
     register mp_srcptr vp;
     register mp_size_t size;
#endif
{
  unsigned long hamdist;
  mp_size_t i;

  hamdist = 0;
  i = 0;
  __asm { align; }
  for (; i < size>>3; i+= 8)
  { mp_srcptr uptr = &up[i],
              vptr = &vp[i];
    __asm { ldl hamdist;
            ldl uptr; ldnl 0; ldl vptr; ldnl 0; xor; bitcnt;
            ldl uptr; ldnl 1*4; ldl vptr; ldnl 1*4; xor; bitcnt;
            ldl uptr; ldnl 2*4; ldl vptr; ldnl 2*4; xor; bitcnt;
            ldl uptr; ldnl 3*4; ldl vptr; ldnl 3*4; xor; bitcnt;
            ldl uptr; ldnl 4*4; ldl vptr; ldnl 4*4; xor; bitcnt;
            ldl uptr; ldnl 5*4; ldl vptr; ldnl 5*4; xor; bitcnt;
            ldl uptr; ldnl 6*4; ldl vptr; ldnl 6*4; xor; bitcnt;
            ldl uptr; ldnl 7*4; ldl vptr; ldnl 7*4; xor; bitcnt;
            stl hamdist;
    }
	}
  __asm { align; }
	for (; i < size; ++i)
	{  __asm {	ldl i; ldl up; wsub; ldnl 0;
							ldl i; ldl vp; wsub; ldnl 0;
							xor;
							ldl hamdist;
							rev;
							bitcnt;
							stl hamdist;
		}
	}

  return hamdist;
}
