/* mpn_add_n -- Add two limb vectors of equal, non-zero length, return carry.

Copyright (C) 1998 by Alex Stuebinger

*/

#include "gmp.h"
#include "gmp-impl.h"

mp_limb_t
#if __STDC__
mpn_add_n (mp_ptr res_ptr, mp_srcptr s1_ptr, mp_srcptr s2_ptr, mp_size_t size)
#else
mpn_add_n (res_ptr, s1_ptr, s2_ptr, size)
     register mp_ptr res_ptr;
     register mp_srcptr s1_ptr;
     register mp_srcptr s2_ptr;
     mp_size_t size;
#endif
{
  register mp_limb_t carry;
  register mp_size_t i;

  carry = 0;
  i = 0;
  __asm { align; }
  for (; i < size; ++i)
  { mp_ptr tres = &res_ptr[i];
		mp_srcptr ts1 = &s1_ptr[i],
							ts2 = &s2_ptr[i];
		__asm { ldl carry;
            ldl ts1;
            ldnl 0;
            ldl ts2;
            ldnl 0;
            lsum;
            ldl tres;
            stnl 0;
            stl carry;
    }
	}
	return carry;
}
