/* mpn_rshift -- Shift right a low-level natural-number integer.

Copyright (C) 1998 by Alex Stuebinger

*/

#include "gmp.h"
#include "gmp-impl.h"

/* Shift U (pointed to by UP and USIZE limbs long) CNT bits to the right
   and store the USIZE least significant limbs of the result at WP.
   The bits shifted out to the right are returned.

   Argument constraints:
   1. 0 < CNT < BITS_PER_MP_LIMB
   2. If the result is to be written over the input, WP must be <= UP.
*/


mp_limb_t
#if __STDC__
mpn_rshift (register mp_ptr wp,
	    register mp_srcptr up, mp_size_t usize,
	    register unsigned int cnt)
#else
mpn_rshift (wp, up, usize, cnt)
     register mp_ptr wp;
     register mp_srcptr up;
     mp_size_t usize;
     register unsigned int cnt;
#endif
{
  mp_limb_t retval = up[0] << (32-cnt),
	          hiword, loword;
  mp_size_t i;
  unsigned temp;

  temp = cnt;

	hiword = up[0];
  i = 0;
  __asm { align; }
  for (; i < usize - 1; ++i)
	{
		__asm { ldl hiword; dup; stl loword;
						ldl i; adc 1; ldl up; wsub; ldnl 0; dup;
						stl hiword; rev; ldl temp;
						lshr; ldl i; ldl wp; wsub; stnl 0;
		}
	}
	__asm { ldl hiword; ldl temp; shr; ldl i; ldl wp; wsub; stnl 0; }

  return retval;
}
