/* mpn_lshift -- Shift left low level.

Copyright (C) 1998 by Alex Stuebinger

*/


#include "gmp.h"
#include "gmp-impl.h"

/* Shift U (pointed to by UP and USIZE digits long) CNT bits to the left
   and store the USIZE least significant digits of the result at WP.
   Return the bits shifted out from the most significant digit.

   Argument constraints:
   1. 0 < CNT < BITS_PER_MP_LIMB
   2. If the result is to be written over the input, WP must be >= UP.
*/


mp_limb_t
#if __STDC__
mpn_lshift (register mp_ptr wp,
	    register mp_srcptr up, mp_size_t usize,
	    register unsigned int cnt)
#else
mpn_lshift (wp, up, usize, cnt)
     register mp_ptr wp;
     register mp_srcptr up;
     mp_size_t usize;
     register unsigned int cnt;
#endif
{
  mp_size_t i;
  mp_limb_t retval = up[usize-1]>>(32-cnt),
						hiword, loword;
  unsigned temp;


  temp = cnt;

	loword = up[usize-1];
  i = usize-1;
  __asm { align; };
  for (; i >= 1; --i)
  {
		__asm { ldl loword; dup; stl hiword;
						ldl i; adc -1; ldl up; wsub; ldnl 0;
            dup; stl loword; ldl temp;
						lshl; pop; ldl i; ldl wp; wsub; stnl 0;
		}
	}
	__asm { ldl up; ldnl 0; ldl temp; shl; ldl wp; stnl 0;
	}

	return retval;
}
