/* mpn_addmul_1 -- multiply the S1_SIZE long limb vector pointed to by S1_PTR
   by S2_LIMB, add the S1_SIZE least significant limbs of the product to the
   limb vector pointed to by RES_PTR.  Return the most significant limb of
   the product, adjusted for carry-out from the addition.

Copyright (C) 1998 by Alex Stuebinger

*/

#include "gmp.h"
#include "gmp-impl.h"

mp_limb_t
mpn_addmul_1 (res_ptr, s1_ptr, s1_size, s2_limb)
     register mp_ptr res_ptr;
     register mp_srcptr s1_ptr;
     mp_size_t s1_size;
     register mp_limb_t s2_limb;
{
  mp_limb_t carry_limb = 0;
  mp_size_t i;

  i = 0;
  __asm { align; }

  for (; i < s1_size; ++i )
  {	unsigned * pres, prod_low;
		__asm { ldl i;
						ldl res_ptr;
						wsub;
						stl pres;
						ldl carry_limb;
						ldl i;
						ldl s1_ptr;
						wsub;
						ldnl 0;
						ldl s2_limb;
						lmul;
						stl prod_low;
						stl carry_limb;
						ldc 0;
						ldl pres;
						ldnl 0;
						ldl prod_low;
						lsum;
						ldl pres;
						stnl 0;
						ldl carry_limb;
						sum;
						stl carry_limb;
		}
	}
	return carry_limb;
}




















