#############################################################################
#
#	file: 	inmos.mak
#       author: alex stuebinger
#       date:   08/04/98 17:28
#       makefile for gmp 2.0.2 for inmos transputer
#
#############################################################################

CC = icc
CC_OPT = /t805 /o2 /qt

LIB = ilibr

.EXTENSIONS:
.EXTENSIONS: .lib .tco .c .s .h
.c.tco:
	$(CC) $[@ $(CC_OPT)

#############################################################################
# GMP LIBRARY
gmp.lib : # mpcore.lib mpn.lib mpz.lib mpq.lib mpf.lib mpbsd.lib
	  ilibr  mpcore.lib mpn.lib mpz.lib mpq.lib  &
                 mpf.lib mpbsd.lib /i /o gmp.lib



#############################################################################
# CORE LIBRARY
CoreFiles = memory.$(ext) mp_set_fns.$(ext) mp_clz_tab.$(ext) version.$(ext) &
            stack-alloc.$(ext) mp_bpl.$(ext) extract-double.$(ext) &
            insert-double.$(ext)
ext = c
CoreSource = $+ $(CoreFiles) $-
ext = tco
CoreObjects = $+ $(CoreFiles) $-

mpcore.lib : $(CoreObjects) mpcore.lbb
	     $(LIB) /i /f $^*.lbb /o $^*.lib

mpcore.lbb :
	     echo $(CoreObjects) > mpcore.lbb

H = gmp.h gmp-impl.h gmp-mparam.h

extract-double.tco: extract-double.c $(H)
insert-double.tco: insert-double.c $(H)
memory.tco: memory.c $(H)
mp_bpl.tco: mp_bpl.c
mp_clz_tab.tco: mp_clz_tab.c
mp_set_fns.tco: mp_set_fns.c $(H)
stack-alloc.tco: stack-alloc.c stack-alloc.h
version.tco: version.c
#############################################################################

#############################################################################
# MPN LIBRARY
MPNFiles =  suppl.$(ext) &
            add_n.$(ext) addmul_1.$(ext) cmp.$(ext) divmod_1.$(ext) &
            divrem.$(ext) divrem_1.$(ext) dump.$(ext) lshift.$(ext) &
            mod_1.$(ext) mul.$(ext) mul_1.$(ext) mul_n.$(ext) random2.$(ext) &
            rshift.$(ext) sqrtrem.$(ext) sub_n.$(ext) submul_1.$(ext) &
            get_str.$(ext) set_str.$(ext) scan0.$(ext) scan1.$(ext)   &
            popcount.$(ext) hamdist.$(ext) gcd_1.$(ext) pre_mod_1.$(ext) &
            perfsqr.$(ext) bdivmod.$(ext) gcd.$(ext) gcdext.$(ext) &
            random.$(ext) mp_bases.$(ext)

ext = c
MPNSource = $+ $(MPNFiles) $-
ext = tco
MPNObjects = $+ $(MPNFiles) $-

mpn.lib : $(MPNObjects) mpn.lbb
          $(LIB) /i /f $^*.lbb /o $^*.lib

mpn.lbb :
	     echo $(MPNObjects) > mpn.lbb

H = gmp.h gmp-impl.h gmp-mparam.h
L = longlong.h

suppl.tco: suppl.c $(H)
random.tco: random.c $(H)
mp_bases.tco: mp_bases.c $(H)
bdivmod.tco: bdivmod.c $(H) $(L)
cmp.tco: cmp.c $(H)
divmod_1.tco: divmod_1.c $(H) $(L)
divrem.tco: divrem.c $(H) $(L)
divrem_1.tco: divrem_1.c $(H) $(L)
dump.tco: dump.c $(H)
gcd.tco: gcd.c $(H) $(L)
gcd_1.tco: gcd_1.c $(H) $(L)
gcdext.tco: gcdext.c $(H) $(L)
get_str.tco: get_str.c $(H) $(L)
hamdist.tco: hamdist.c $(H)
inlines.tco: inlines.c gmp.h
mod_1.tco: mod_1.c $(H) $(L)
mul.tco: mul.c $(H)
mul_n.tco: mul_n.c $(H)
perfsqr.tco: perfsqr.c $(H) $(L)
popcount.tco: popcount.c $(H)
pre_mod_1.tco: pre_mod_1.c $(H) $(L)
random2.tco: random2.c $(H)
scan0.tco: scan0.c $(H) $(L)
scan1.tco: scan1.c $(H) $(L)
set_str.tco: set_str.c $(H)
sqrtrem.tco: sqrtrem.c $(H) $(L)
#############################################################################

#############################################################################
# MPZ LIBRARY
MPZFiles = init.$(ext) set.$(ext) set_ui.$(ext) set_si.$(ext) set_str.$(ext) &
           set_d.$(ext) set_f.$(ext) set_q.$(ext) iset.$(ext) iset_ui.$(ext) &
           iset_si.$(ext) iset_str.$(ext) iset_d.$(ext) clear.$(ext) &
           get_ui.$(ext) get_si.$(ext) get_str.$(ext) get_d.$(ext) &
           size.$(ext) sizeinbase.$(ext) add.$(ext) add_ui.$(ext) sub.$(ext) &
           sub_ui.$(ext) mul.$(ext) mul_ui.$(ext) gcd.$(ext) gcd_ui.$(ext) &
           gcdext.$(ext) sqrt.$(ext) sqrtrem.$(ext) powm.$(ext) &
           powm_ui.$(ext) cmp.$(ext) cmp_ui.$(ext) cmp_si.$(ext) &
           mul_2exp.$(ext) fdiv_q_2exp.$(ext) fdiv_r_2exp.$(ext) &
           tdiv_q_2exp.$(ext) tdiv_r_2exp.$(ext) abs.$(ext) neg.$(ext) &
           com.$(ext) and.$(ext) ior.$(ext) inp_raw.$(ext) inp_str.$(ext) &
           out_raw.$(ext) out_str.$(ext) perfsqr.$(ext) random.$(ext) &
           random2.$(ext) pow_ui.$(ext) ui_pow_ui.$(ext) setbit.$(ext) &
           clrbit.$(ext) fac_ui.$(ext) pprime_p.$(ext) realloc.$(ext) &
           getlimbn.$(ext) popcount.$(ext) hamdist.$(ext) cdiv_qr.$(ext) &
           cdiv_q.$(ext) cdiv_r.$(ext) cdiv_qr_ui.$(ext) cdiv_q_ui.$(ext) &
           cdiv_r_ui.$(ext) cdiv_ui.$(ext) fdiv_qr.$(ext) fdiv_q.$(ext) &
           fdiv_r.$(ext) fdiv_qr_ui.$(ext) fdiv_q_ui.$(ext) fdiv_r_ui.$(ext) &
           fdiv_ui.$(ext) tdiv_qr.$(ext) tdiv_q.$(ext) tdiv_r.$(ext) &
           tdiv_qr_ui.$(ext) tdiv_q_ui.$(ext) tdiv_r_ui.$(ext) mod.$(ext) &
           divexact.$(ext) array_init.$(ext) scan0.$(ext) scan1.$(ext) &
           jacobi.$(ext) legendre.$(ext) invert.$(ext)

ext = c
MPZSource = $+ $(MPZFiles) $-
ext = tco
MPZObjects = $+ $(MPZFiles) $-

mpz.lib : $(MPZObjects) mpz.lbb
	     $(LIB) /i /f $^*.lbb /o $^*.lib

mpz.lbb :
	     echo $(MPZObjects) > mpz.lbb

H = gmp.h gmp-impl.h gmp-mparam.h

abs.tco: abs.c $(H)
add.tco: add.c $(H)
add_ui.tco: add_ui.c $(H)
and.tco: and.c $(H)
array_init.tco: array_init.c $(H)
cdiv_q.tco: cdiv_q.c $(H)
cdiv_q_ui.tco: cdiv_q_ui.c $(H)
cdiv_qr.tco: cdiv_qr.c $(H)
cdiv_qr_ui.tco: cdiv_qr_ui.c $(H)
cdiv_r.tco: cdiv_r.c $(H)
cdiv_r_ui.tco: cdiv_r_ui.c $(H)
cdiv_ui.tco: cdiv_ui.c $(H)
clear.tco: clear.c $(H)
clrbit.tco: clrbit.c $(H)
cmp.tco: cmp.c $(H)
cmp_si.tco: cmp_si.c $(H)
cmp_ui.tco: cmp_ui.c $(H)
com.tco: com.c $(H)
fdiv_q_2exp.tco: fdiv_q_2exp.c $(H)
fdiv_r_2exp.tco: fdiv_r_2exp.c $(H)
divexact.tco: divexact.c $(H) longlong.h
fac_ui.tco: fac_ui.c $(H) longlong.h
fdiv_q.tco: fdiv_q.c $(H)
fdiv_q_ui.tco: fdiv_q_ui.c $(H)
fdiv_qr.tco: fdiv_qr.c $(H)
fdiv_qr_ui.tco: fdiv_qr_ui.c $(H)
fdiv_r.tco: fdiv_r.c $(H)
fdiv_r_ui.tco: fdiv_r_ui.c $(H)
fdiv_ui.tco: fdiv_ui.c $(H)
gcd.tco: gcd.c $(H) longlong.h
gcd_ui.tco: gcd_ui.c $(H)
gcdext.tco: gcdext.c $(H)
get_d.tco: get_d.c $(H)
get_si.tco: get_si.c $(H)
get_str.tco: get_str.c $(H)
get_ui.tco: get_ui.c $(H)
getlimbn.tco: getlimbn.c $(H)
hamdist.tco: hamdist.c $(H)
init.tco: init.c $(H)
inp_raw.tco: inp_raw.c $(H)
inp_str.tco: inp_str.c $(H)
invert.tco: invert.c $(H)
ior.tco: ior.c $(H)
iset.tco: iset.c $(H)
iset_d.tco: iset_d.c $(H)
iset_si.tco: iset_si.c $(H)
iset_str.tco: iset_str.c $(H)
iset_ui.tco: iset_ui.c $(H)
jacobi.tco: jacobi.c $(H)
legendre.tco: legendre.c $(H)
mod.tco: mod.c $(H)
tdiv_q_2exp.tco: tdiv_q_2exp.c $(H)
tdiv_r_2exp.tco: tdiv_r_2exp.c $(H)
mul.tco: mul.c $(H)
mul_2exp.tco: mul_2exp.c $(H)
mul_ui.tco: mul_ui.c $(H)
neg.tco: neg.c $(H)
out_raw.tco: out_raw.c $(H)
out_str.tco: out_str.c $(H)
perfsqr.tco: perfsqr.c $(H)
popcount.tco: popcount.c $(H)
pow_ui.tco: pow_ui.c $(H) longlong.h
powm.tco: powm.c $(H) longlong.h
powm_ui.tco: powm_ui.c $(H) longlong.h
pprime_p.tco: pprime_p.c $(H)
random.tco: random.c $(H) urandom.h
random2.tco: random2.c $(H)
realloc.tco: realloc.c $(H)
scan0.tco: scan0.c $(H)
scan1.tco: scan1.c $(H)
set.tco: set.c $(H)
set_d.tco: set_d.c $(H)
set_f.tco: set_f.c $(H)
set_q.tco: set_q.c $(H)
set_si.tco: set_si.c $(H)
set_str.tco: set_str.c $(H) longlong.h
set_ui.tco: set_ui.c $(H)
setbit.tco: setbit.c $(H)
size.tco: size.c $(H)
sizeinbase.tco: sizeinbase.c $(H) longlong.h
sqrt.tco: sqrt.c $(H)
sqrtrem.tco: sqrtrem.c $(H)
sub.tco: sub.c $(H)
sub_ui.tco: sub_ui.c $(H)
tdiv_q.tco: tdiv_q.c $(H) longlong.h
tdiv_q_ui.tco: tdiv_q_ui.c $(H)
tdiv_qr.tco: tdiv_qr.c $(H) longlong.h dmincl.c $(H)
tdiv_qr_ui.tco: tdiv_qr_ui.c $(H)
tdiv_r.tco: tdiv_r.c $(H) longlong.h dmincl.c $(H)
tdiv_r_ui.tco: tdiv_r_ui.c $(H)
ui_pow_ui.tco: ui_pow_ui.c $(H) longlong.h
#############################################################################

#############################################################################
# MPQ LIBRARY
MPQFiles = add.$(ext) canonicalize.$(ext) clear.$(ext) cmp.$(ext) &
           cmp_ui.$(ext) div.$(ext) get_d.$(ext) get_den.$(ext) &
           get_num.$(ext) init.$(ext) inv.$(ext) mul.$(ext) neg.$(ext) &
           set.$(ext) set_den.$(ext) set_num.$(ext) set_si.$(ext) &
           set_ui.$(ext) sub.$(ext) equal.$(ext) set_z.$(ext)
ext = c
MPQSource = $+ $(MPQFiles) $-
ext = tco
MPQObjects = $+ $(MPQFiles) $-

mpq.lib : $(MPQObjects) mpq.lbb
	     $(LIB) /i /f $^*.lbb /o $^*.lib

mpq.lbb :
	     echo $(MPQObjects) > mpq.lbb

H = gmp.h gmp-impl.h gmp-mparam.h

add.tco: add.c $(H)
canonicalize.tco: canonicalize.c $(H)
clear.tco: clear.c $(H)
cmp.tco: cmp.c $(H) longlong.h
cmp_ui.tco: cmp_ui.c $(H)
div.tco: div.c $(H)
equal.tco: equal.c $(H)
get_d.tco: get_d.c $(H) longlong.h
get_den.tco: get_den.c $(H)
get_num.tco: get_num.c $(H)
init.tco: init.c $(H)
inv.tco: inv.c $(H)
mul.tco: mul.c $(H)
neg.tco: neg.c $(H)
set.tco: set.c $(H)
set_den.tco: set_den.c $(H)
set_num.tco: set_num.c $(H)
set_si.tco: set_si.c $(H)
set_ui.tco: set_ui.c $(H)
set_z.tco: set_z.c $(H)
sub.tco: sub.c $(H)
#############################################################################

#############################################################################
# MPF LIBRARY
MPFFiles = init.$(ext) init2.$(ext) set.$(ext) set_ui.$(ext) set_si.$(ext) &
           set_str.$(ext) set_d.$(ext) set_z.$(ext) iset.$(ext) &
           iset_ui.$(ext) iset_si.$(ext) iset_str.$(ext) iset_d.$(ext) &
           clear.$(ext) get_str.$(ext) dump.$(ext) size.$(ext) eq.$(ext) &
           reldiff.$(ext) sqrt.$(ext) random2.$(ext) inp_str.$(ext) &
           out_str.$(ext) add.$(ext) add_ui.$(ext) sub.$(ext) sub_ui.$(ext) &
           ui_sub.$(ext) mul.$(ext) mul_ui.$(ext) div.$(ext) div_ui.$(ext) &
           cmp.$(ext) cmp_ui.$(ext) cmp_si.$(ext) mul_2exp.$(ext) &
           div_2exp.$(ext) abs.$(ext) neg.$(ext) set_q.$(ext) get_d.$(ext) &
           set_dfl_prec.$(ext) set_prc.$(ext) set_prc_raw.$(ext) &
           get_prc.$(ext) ui_div.$(ext) sqrt_ui.$(ext)

ext = c
MPFSource = $+ $(MPFFiles) $-
ext = tco
MPFObjects = $+ $(MPFFiles) $-

mpf.lib : $(MPFObjects) mpf.lbb
	  $(LIB) /i /f $^*.lbb /o $^*.lib

mpf.lbb :
	     echo $(MPFObjects) > mpf.lbb

H = gmp.h gmp-impl.h gmp-mparam.h

abs.tco: abs.c $(H)
add.tco: add.c $(H)
add_ui.tco: add_ui.c $(H)
clear.tco: clear.c $(H)
cmp.tco: cmp.c $(H)
cmp_si.tco: cmp_si.c $(H)
cmp_ui.tco: cmp_ui.c $(H)
eq.tco: eq.c $(H)
div.tco: div.c  $(H) longlong.h
div_2exp.tco: div_2exp.c $(H)
div_ui.tco: div_ui.c $(H) longlong.h
dump.tco: dump.c $(H)
get_d.tco: get_d.c $(H)
get_prc.tco: get_prc.c $(H)
get_str.tco: get_str.c $(H) longlong.h
init.tco: init.c $(H)
init2.tco: init2.c $(H)
inp_str.tco: inp_str.c $(H)
iset.tco: iset.c $(H)
iset_d.tco: iset_d.c $(H)
iset_si.tco: iset_si.c $(H)
iset_str.tco: iset_str.c $(H)
iset_ui.tco: iset_ui.c $(H)
mul.tco: mul.c $(H)
mul_2exp.tco: mul_2exp.c $(H)
mul_ui.tco: mul_ui.c $(H)
neg.tco: neg.c $(H)
out_str.tco: out_str.c $(H)
random2.tco: random2.c $(H)
reldiff.tco: reldiff.c $(H)
set.tco: set.c $(H)
set_d.tco: set_d.c $(H)
set_dfl_prec.tco: set_dfl_prec.c $(H)
set_prc.tco: set_prc.c $(H)
set_prc_raw.tco: set_prc_raw.c $(H)
set_q.tco: set_q.c $(H)
set_si.tco: set_si.c $(H)
set_str.tco: set_str.c $(H) longlong.h
set_ui.tco: set_ui.c $(H)
set_z.tco: set_z.c $(H)
size.tco: size.c $(H)
sqrt.tco: sqrt.c $(H)
sqrt_ui.tco: sqrt_ui.c $(H)
sub.tco: sub.c $(H)
sub_ui.tco: sub_ui.c $(H)
ui_div.tco: ui_div.c $(H) longlong.h
ui_sub.tco: ui_sub.c $(H)
#############################################################################

#############################################################################
# MPBSB LIBRARY
MPBSDFiles = itom.$(ext) mdiv.$(ext) &
             mfree.$(ext) min.$(ext) mout.$(ext) move.$(ext) mtox.$(ext) &
             sdiv.$(ext) xtom.$(ext) realloc.$(ext)

ext = c
MPBSDSource = $+ $(MPBSDFiles) $-
ext = tco
MPBSDObjects = $+ $(MPBSDFiles) $-

mpbsd.lib : $(MPBSDObjects) mpbsd.lbb
	     $(LIB) /i /f $^*.lbb /o $^*.lib

mpbsd.lbb :
	     echo $(MPBSDObjects) > mpbsd.lbb


H = gmp.h gmp-impl.h gmp-mparam.h
L = longlong.h

itom.tco: itom.c ../mp.h $(H)
mdiv.tco: mdiv.c ../mp.h $(H) $(L) ../mpz/dmincl.c
mfree.tco: mfree.c ../mp.h $(H)
min.tco: min.c ../mp.h $(H)
mout.tco: mout.c ../mp.h $(H)
move.tco: move.c ../mp.h $(H)
mtox.tco: mtox.c ../mp.h $(H)
sdiv.tco: sdiv.c ../mp.h $(H) $(L)
xtom.tco: xtom.c ../mp.h $(H)
add.tco: ../mpz/add.c $(H)
cmp.tco: ../mpz/cmp.c $(H)
gcd.tco: ../mpz/gcd.c $(H) $(L)
mul.tco: ../mpz/mul.c $(H)
pow_ui.tco: ../mpz/pow_ui.c $(H) $(L)
powm.tco: ../mpz/powm.c $(H) $(L)
realloc.tco: realloc.c $(H)
sqrtrem.tco: ../mpz/sqrtrem.c $(H)
sub.tco: ../mpz/sub.c $(H)
#############################################################################
