{
Title:   LIBRARY Graphic Window DLL
Summary: A graphic window DLL library for WIServer.
Ref.:    19.01.93.01.mjm
Author:  mjm
Version: 1.0

-----------------------------------------------------------------------------------------------

Change history:

0.0      Under construction.
1.0      This is the first version.
13/8/93  Name change and packet size change.

----------------------------------------------------------------------------------------------

Associated documentation:
Ref.                  Title
18.01.93.01.mjm       WIServer (Windows IServer)
18.01.93.09.mjm       WIServer software description
18.01.93.08.mjm       WIServer user manual

---------------------------------------------------------------------------------------------


Known problems/bugs to sort out:

1:

----------------------------------------------------------------------------------------------

Possible future improvements:

1:

----------------------------------------------------------------------------------------------

Introduction

This is an example DLL for WIServer. It uses the DLL hook in WIServer to implement graphic
windows. The images in the windows are stored as an array of lines scaled to the size of the
window.
}

 library GraphicWindowDLL;

{$M 4096, 64000}
{$D-,G+,R-,S-,W-} {No debug info,
                   286 code generated,
                   No range checking,
                   no stack overflow checking,
                   Protected mode only}



uses
  WinTypes, WinProcs;

const
  MAX_PACKET_SIZE = 2048;             {Packet size if defined by WIServer.}
  MAX_LINES = 1000;                   {Maximum number of lines in a window.}
  MAX_WINDOWS = 7;                    {Maximum number of windows.}
  ClassName = 'WIServerGraphic';      {Class name for the windows.}


type
  PLinkString = ^TLinkString;                                 {Type definition for the data}
  TLinkString = record                                        {array supplied by WIServer.}
                  Size : Integer;
                  Data : array[0..MAX_PACKET_SIZE] of Byte;
                end;

  TLineRec = record                {Record for a single line.}
               used: Boolean;      {TRUE if the line is visible.}
               x1: Integer;
               y1: Integer;
               x2: Integer;
               y2: Integer;
             end;

  PLines = ^TLines;
  TLines = array[1..MAX_LINES+1] of TLineRec;    {Definition of the structure of a windows lines.}

var
  ClassRegistered: Boolean;                      {TRUE if the window class has been registered.}
  Chain: Pointer;                                {Pointer the the DLLs real exit procedure.}
  WndRec: array[1..MAX_WINDOWS] of record        {Array holding info for each window.}
            WndHandle: THandle;                  {Zero indicates the window is closed.}
            MemHandle: THandle;                  {Memory handle to the line record.}
          end;


function WindowProc (Window: HWnd; Message, wParam: Word; lParam: LongInt): Longint; export;
  {This function is the main function for the graphics windows. It only handles wm_Paint
   messages. For all other messages it calls DefWindowProc (the default window message
   procedure).
   For wm_Paint, the procedure works out which window is being painted, gets the memory handle
   to the lines record and draws all the lines. Every line is scaled.
  }
  var
    ok: Boolean;
    PaintStruct: TPaintStruct;
    OldPen, Pen: HPen;
    WindowID, i: Integer;
    Lines: PLines;
    WindowRect: TRect;
    x, y, width, height: LongInt;

  begin
    WindowProc := 0;
    ok := TRUE;
    case Message of
      wm_Paint:
        begin
          BeginPaint (Window, PaintStruct);               {Set up the DC ready for drawing.}
          Pen := CreatePen (ps_Solid, 1, 0);
          OldPen := SelectObject (PaintStruct.hdc, Pen);

          WindowID := -1;
          for i := 1 to MAX_WINDOWS do                    {Find out which window is being painted.}
            if WndRec[i].WndHandle = Window then
              WindowID := i;

          if WindowID <> -1 then                          {Draw every line scaled to the size of the window.}
            begin
              GetClientRect (Window, WindowRect);
              width := WindowRect.right - WindowRect.left;
              height := WindowRect.bottom - WindowRect.top;
              Lines := LocalLock (WndRec[WindowID].MemHandle);
              for i := 1 to MAX_LINES do
                if Lines^[i].used = TRUE then
                  begin
                    x := WindowRect.left + ((LongInt (Lines^[i].x1) * width)  div 10000);
                    y := WindowRect.top  + ((LongInt (Lines^[i].y1) * height) div 10000);
                    MoveTo (PaintStruct.hdc, x, y);

                    x := WindowRect.left + ((LongInt (Lines^[i].x2) * width)  div 10000);
                    y := WindowRect.top  + ((LongInt (Lines^[i].y2) * height) div 10000);
                    LineTo (PaintStruct.hdc, x, y);
                  end;

              LocalUnlock (WndRec[WindowID].MemHandle);
            end;

          SelectObject (PaintStruct.hdc, OldPen);         {Restore the DC.}
          DeleteObject (Pen);
          EndPaint (Window, PaintStruct);
          ok := FALSE;
        end;

      end;

    if ok then                                            {If the message was not understood then do default.}
      WindowProc := DefWindowProc (Window, Message, wParam, lParam);
  end;


const
  WindowClass: TWndClass = (                              {This is part of the class definition}
    style: cs_HRedraw or cs_VRedraw or cs_NoClose;        {for the windows.                    }
    lpfnWndProc: @WindowProc;
    cbClsExtra: 0;
    cbWndExtra: 0;
    hInstance: 0;
    hIcon: 0;
    hCursor: 0;
    hbrBackground: 0;
    lpszMenuName: ClassName;
    lpszClassName: ClassName);



procedure DLL_Proc (HProgramInstance: THandle; ParentWnd: HWnd; Data: PLinkString); export;
  {This is the procedure executed by WIServer. There are five command types
   1 - Open window
   2 - Close window
   3 - Add a set of lines to the window
   4 - Clear all lines from the window
   5 - Return the maximum number of lines per window.
  }

  var
    i: Integer;
    Window: HWnd;
    WindowID: PInteger;
    x, y, w, h, pi: PInteger;
    title_len: PInteger;
    Lines: PLines;
    no_of_lines, lines_left, line_pointer: Integer;
    DC: HDC;
    OldPen, Pen: HPen;
    xl, yl, width, height: LongInt;
    WindowRect: TRect;

  begin
    case Data^.Data[0] of

1:    begin                                   {Open a graphic window}
        x := @Data^.Data[1];                  {Get the position, size and title for the window.}
        y := @Data^.Data[3];
        w := @Data^.Data[5];
        h := @Data^.Data[7];
        title_len := @Data^.Data[9];
        Data^.Data[11 + title_len^] := 0;     {Title must be null terminated.}

        if not ClassRegistered then           {Register the class if not done so already.}
          begin
            WindowClass.hInstance := HProgramInstance;
            WindowClass.hIcon := LoadIcon (0, idi_Application);
            WindowClass.hCursor := LoadCursor (0, idc_Arrow);
            WindowClass.hbrBackground := GetStockObject (white_Brush);
            RegisterClass (WindowClass);
            ClassRegistered := TRUE;
          end;

        i := 1;                               {Find a free window}
        while (WndRec[i].WndHandle <> 0) and (i < MAX_WINDOWS) do
          Inc (i);

        if WndRec[i].WndHandle = 0 then       {If there is a free window then           }
          begin                               {  create it                              }
                                              {  set up the return data (the window id) }
            Window := CreateWindow (          {  put window data in window record array }
              ClassName, @Data^.Data[11],     {  allocate memory for lines              }
              ws_OverlappedWindow,            {  set all lines to unused (clear window) }
              x^, y^, w^, h^,                 {  show the window                        }
              ParentWnd, 0,
              HProgramInstance, nil);

            WindowID := @Data^.Data[0];
            WindowID^ := i;
            Data^.Size := 2;

            WndRec[WindowID^].WndHandle := Window;
            WndRec[WindowID^].MemHandle := LocalAlloc (lmem_Moveable, SizeOf (TLines));;

            Lines := LocalLock (WndRec[WindowID^].MemHandle);
            for i := 1 to MAX_LINES do
              Lines^[i].used := FALSE;
            LocalUnlock (WndRec[WindowID^].MemHandle);

            ShowWindow (Window, sw_ShowNoActivate);
            UpdateWindow (Window);
          end
        else
          begin
            WindowID := @Data^.Data[0];
            WindowID^ := -1;
            Data^.Size := 2;
          end;
      end;

2:    begin                                   {Close a graphic window}
        WindowID := @Data^.Data[1];           {Get the window ID from link}
                                              {If window ID valid, destroy window and free memory}
        if (WindowID^ > 0) and (WindowID^ <= MAX_WINDOWS) then
          if WndRec[WindowID^].WndHandle <> 0 then
            begin
              DestroyWindow (WndRec[WindowID^].WndHandle);
              LocalFree (WndRec[WindowID^].MemHandle);
            end;
        Data^.Size := 0;                      {No return data}
      end;

3:    begin                                   {Add a set of lines to the window}
        WindowID := @Data^.Data[1];           {Get the window ID}

        pi := @Data^.Data[3];                 {Get the number of lines in the packet}
        no_of_lines := pi^;
        lines_left := no_of_lines;
        line_pointer := 5;
                                              {If window ID valid the put lines in window}
        if (WindowID^ > 0) and (WindowID^ <= MAX_WINDOWS) then
          if WndRec[WindowID^].WndHandle <> 0 then
            begin
              Lines := LocalLock (WndRec[WindowID^].MemHandle);
              DC := GetDC (WndRec[WindowID^].WndHandle);

              GetClientRect (WndRec[WindowID^].WndHandle, WindowRect);
              width := WindowRect.right - WindowRect.left;
              height := WindowRect.bottom - WindowRect.top;

              Pen := CreatePen (ps_Solid, 1, 0);
              OldPen := SelectObject (DC, Pen);
              i := 1;
              while no_of_lines > 0 do
                begin
                  while (Lines^[i].used <> FALSE) and (i <= MAX_LINES) do
                    Inc (i);
                  if i <= MAX_LINES then
                    begin
                      Dec (no_of_lines);
                      Dec (lines_left);
                      Lines^[i].used := TRUE;

                      pi := @Data^.Data[0+line_pointer];
                      Lines^[i].x1 := pi^;
                      pi := @Data^.Data[2+line_pointer];
                      Lines^[i].y1 := pi^;
                      pi := @Data^.Data[4+line_pointer];
                      Lines^[i].x2 := pi^;
                      pi := @Data^.Data[6+line_pointer];
                      Lines^[i].y2 := pi^;
                      line_pointer := line_pointer + 8;

                      xl := WindowRect.left + ((LongInt (Lines^[i].x1) * width)  div 10000);
                      yl := WindowRect.top  + ((LongInt (Lines^[i].y1) * height) div 10000);
                      MoveTo (DC, xl, yl);

                      xl := WindowRect.left + ((LongInt (Lines^[i].x2) * width)  div 10000);
                      yl := WindowRect.top  + ((LongInt (Lines^[i].y2) * height) div 10000);
                      LineTo (DC, xl, yl);

                    end
                  else
                    no_of_lines := 0;

                end;
              SelectObject (DC, OldPen);
              DeleteObject (Pen);
              ReleaseDC (WndRec[WindowID^].WndHandle, DC);
              LocalUnlock (WndRec[WindowID^].MemHandle);
            end;

        pi := @Data^.Data[0];
        pi^ := lines_left;
        Data^.Size := 2;
        UpdateWindow (WndRec[WindowID^].WndHandle);

      end;

4:    begin                                   {Clear all lines from the window}
        WindowID := @Data^.Data[1];
        if (WindowID^ > 0) and (WindowID^ <= MAX_WINDOWS) then
          if WndRec[WindowID^].WndHandle <> 0 then
            begin
              Lines := LocalLock (WndRec[WindowID^].MemHandle);
              DC := GetDC (WndRec[WindowID^].WndHandle);

              GetClientRect (WndRec[WindowID^].WndHandle, WindowRect);
              width := WindowRect.right - WindowRect.left;
              height := WindowRect.bottom - WindowRect.top;

              Pen := CreatePen (ps_Solid, 1, GetSysColor (color_Window));
              OldPen := SelectObject (DC, Pen);
              for i := 1 to MAX_LINES do
                if Lines^[i].used then
                  begin
                    Lines^[i].used := FALSE;

                    xl := WindowRect.left + ((LongInt (Lines^[i].x1) * width)  div 10000);
                    yl := WindowRect.top  + ((LongInt (Lines^[i].y1) * height) div 10000);
                    MoveTo (DC, xl, yl);

                    xl := WindowRect.left + ((LongInt (Lines^[i].x2) * width)  div 10000);
                    yl := WindowRect.top  + ((LongInt (Lines^[i].y2) * height) div 10000);
                    LineTo (DC, xl, yl);

                  end;

              SelectObject (DC, OldPen);
              DeleteObject (Pen);
              ReleaseDC (WndRec[WindowID^].WndHandle, DC);
              LocalUnlock (WndRec[WindowID^].MemHandle);
            end;

        Data^.Size := 0;
      end;

5:    begin                                   {Return the maximum lines allowed in a window}
        {All windows have the same line capacity.}

        pi := @Data^.Data[0];
        pi^ := MAX_LINES;
        Data^.Size := 2;

      end;

    end; {case}
  end; {procedure DLL_Proc ---------------------------------------------------------------------------------------------------}


procedure DLLExitProc; far;                   {The DLL exit procedure will unregister}
  begin                                       {the graphic windows class.            }
    if ClassRegistered then
      UnregisterClass (WindowClass.lpszClassName, WindowClass.hInstance);
    ExitProc := Chain;
  end;

exports
  {Pascal proc name,   DLL index}
  DLL_Proc             index 1;


var
  i: Integer;

begin
  for i := 1 to MAX_WINDOWS do                {Initialise the window array.}
    begin
      WndRec[i].WndHandle := 0;
      WndRec[i].MemHandle := 0;
    end;

  ClassRegistered := FALSE;                   {Set the register flag to unregistered.}

  Chain := ExitProc;                          {Setup DLL exit proc.}
  ExitProc := @DLLExitProc;
end.
