--{{{  LIB WIServer I/O header
--{{{  SP protocol
-- The maximum size of link packets (in bytes)  in either direction. --
-- NOTE: WIServer can handle packet sizes of 2048 bytes but the TDS  --
-- kernel can only handle 512. MAX.PACKET.SIZE can be increased to   --
-- 2048 if stand alone programs are developed.                       --
VAL INT MAX.PACKET.SIZE IS 512:

PROTOCOL SP IS INT16::[]BYTE:   -- The IServer protocol. --
--}}} 
--{{{  SP. codes
VAL BYTE SP.OPEN      IS 10 (BYTE): -- These are standard IServer command  --
VAL BYTE SP.CLOSE     IS 11 (BYTE): -- tags. See the IServer documentation --
VAL BYTE SP.READ      IS 12 (BYTE): -- for details of their use.           --
VAL BYTE SP.WRITE     IS 13 (BYTE):
VAL BYTE SP.GETS      IS 14 (BYTE):
VAL BYTE SP.PUTS      IS 15 (BYTE):
VAL BYTE SP.FLUSH     IS 16 (BYTE):
VAL BYTE SP.SEEK      IS 17 (BYTE):
VAL BYTE SP.TELL      IS 18 (BYTE):
VAL BYTE SP.EOF       IS 19 (BYTE):
VAL BYTE SP.ERROR     IS 20 (BYTE):
VAL BYTE SP.REMOVE    IS 21 (BYTE):
VAL BYTE SP.RENAME    IS 22 (BYTE):
VAL BYTE SP.GETBLOCK  IS 23 (BYTE):
VAL BYTE SP.PUTBLOCK  IS 24 (BYTE):
VAL BYTE SP.GETKEY    IS 30 (BYTE):
VAL BYTE SP.POLLKEY   IS 31 (BYTE):
VAL BYTE SP.GETENV    IS 32 (BYTE):
VAL BYTE SP.TIME      IS 33 (BYTE):
VAL BYTE SP.SYSTEM    IS 34 (BYTE):
VAL BYTE SP.EXIT      IS 35 (BYTE):
VAL BYTE SP.CMDLINE   IS 40 (BYTE):
VAL BYTE SP.CORE      IS 41 (BYTE):
VAL BYTE SP.VERSION   IS 42 (BYTE):

VAL BYTE SP.OPEN.TEXT.WINDOW   IS 128 (BYTE): -- These are the extra WIServer   --
VAL BYTE SP.GET.FREE.RESOURCES IS 129 (BYTE): -- command tags. See the WIServer --
VAL BYTE SP.GET.INFO           IS 130 (BYTE): -- user manual for details of     --
VAL BYTE SP.GET.SYSTEM.INFO    IS 131 (BYTE): -- their use.                     --
VAL BYTE SP.GET.SYSTEM.METRIC  IS 132 (BYTE):
VAL BYTE SP.GET.APP.INFO       IS 133 (BYTE):
VAL BYTE SP.GET.WINDOW.HANDLE  IS 134 (BYTE):
VAL BYTE SP.GET.WINDOW.TEXT    IS 135 (BYTE):
VAL BYTE SP.SET.WINDOW.TEXT    IS 136 (BYTE):
VAL BYTE SP.GET.WINDOW.STATE   IS 137 (BYTE):
VAL BYTE SP.SHOW.WINDOW        IS 138 (BYTE):
VAL BYTE SP.GET.EVENT          IS 139 (BYTE):
VAL BYTE SP.LOAD.DLL           IS 140 (BYTE):
VAL BYTE SP.UNLOAD.DLL         IS 141 (BYTE):
VAL BYTE SP.EXEC.DLL           IS 142 (BYTE):
VAL BYTE SP.TAB                IS 143 (BYTE):
VAL BYTE SP.WIN.EXEC           IS 144 (BYTE):
VAL BYTE SP.GET.MODULE.USAGE   IS 145 (BYTE):
VAL BYTE SP.GET.CURSOR.POS     IS 146 (BYTE):
--}}} 
--{{{  SPT. and SPM. Open file codes
-- These code are for use with SP.OPEN and PROC open.file. --

VAL BYTE SPT.BINARY IS 1 (BYTE):           -- File is binary. --
VAL BYTE SPT.TEXT   IS 2 (BYTE):           -- File is host text file. --

VAL BYTE SPM.INPUT           IS 1 (BYTE):  -- File is read only. --
VAL BYTE SPM.OUTPUT          IS 2 (BYTE):  -- File is write only. --
VAL BYTE SPM.APPEND          IS 3 (BYTE):  -- File is append write. --
VAL BYTE SPM.EXISTING.UPDATE IS 4 (BYTE):  -- File is read/write. --
VAL BYTE SPM.NEW.UPDATE      IS 5 (BYTE):  -- File is created and read/write. --
VAL BYTE SPM.APPEND.UPDATE   IS 6 (BYTE):  -- File is read/write. --

--}}} 
--{{{  SPO. Seek codes
-- These code are for use with SP.SEEK. --

VAL INT32 SPO.START   IS 1 (INT32):
VAL INT32 SPO.CURRENT IS 2 (INT32):
VAL INT32 SPO.END     IS 3 (INT32):
--}}} 
--{{{  INFO.SYSTEM. codes
-- These codes are for use with SP.GET.SYSTEM.INFO and PROC get.system.information. --

VAL INT16 INFO.SYSTEM.DESKTOP        IS 0 (INT16):
VAL INT16 INFO.SYSTEM.ACTIVE.WINDOW  IS 1 (INT16):
VAL INT16 INFO.SYSTEM.CAPTURE.WINDOW IS 2 (INT16):
VAL INT16 INFO.SYSTEM.MODAL.WINDOW   IS 3 (INT16):
VAL INT16 INFO.SYSTEM.VERSION        IS 4 (INT16):
--}}} 
--{{{  SM. system metric codes
-- These codes are for use with SP.GET.SYSTEM.METRIC and PROC get.system.metric. --

VAL INT16 SM.CXBORDER      IS 5  (INT16): -- Non-sizeable window frame width. --
VAL INT16 SM.CYBORDER      IS 6  (INT16): -- Non-sizeable window frame height. --
VAL INT16 SM.CXCURSOR      IS 13 (INT16): -- Cursor width. --
VAL INT16 SM.CYCURSOR      IS 14 (INT16): -- Cursor height. --
VAL INT16 SM.CXDLGFRAME    IS 7  (INT16): -- ws_DlgFrame style window frame width. --
VAL INT16 SM.CYDLGFRAME    IS 8  (INT16): -- ws_DlgFrame style window frame height. --
VAL INT16 SM.CXFRAME       IS 32 (INT16): -- Sizeable window frame width. --
VAL INT16 SM.CYFRAME       IS 33 (INT16): -- Sizeable window frame height. --
VAL INT16 SM.CXFULLSCREEN  IS 16 (INT16): -- Maximized windows client area width. --
VAL INT16 SM.CYFULLSCREEN  IS 17 (INT16): -- Maximized windows client area height. --
VAL INT16 SM.CXHSCROLL     IS 21 (INT16): -- Horizontal scroll bar arrow width. --
VAL INT16 SM.CYHSCROLL     IS 3  (INT16): -- Horizontal scroll bar arrow height. --
VAL INT16 SM.CXVSCROLL     IS 2  (INT16): -- Vertical scroll bar arrow width. --
VAL INT16 SM.CYVSCROLL     IS 20 (INT16): -- Vertical scroll bar arrow height. --
VAL INT16 SM.CXHTHUMB      IS 10 (INT16): -- Horizontal scroll bar thumb width. --
VAL INT16 SM.CYVTHUMB      IS 9  (INT16): -- Horizontal scroll bar thumb height. --
VAL INT16 SM.CXICON        IS 11 (INT16): -- Icon width. --
VAL INT16 SM.CYICON        IS 12 (INT16): -- Icon height. --
VAL INT16 SM.CXMIN         IS 28 (INT16): -- Minimum window width. --
VAL INT16 SM.CYMIN         IS 29 (INT16): -- Minimum window height. --
VAL INT16 SM.CXMINTRACK    IS 34 (INT16): -- Minimum window tracking width. --
VAL INT16 SM.CYMINTRACK    IS 35 (INT16): -- Minimum window tracking height. --
VAL INT16 SM.CXSCREEN      IS 0  (INT16): -- Screen width. --
VAL INT16 SM.CYSCREEN      IS 1  (INT16): -- Screen height. --
VAL INT16 SM.CXSIZE        IS 30 (INT16): -- Title bar bitmap width. --
VAL INT16 SM.CYSIZE        IS 31 (INT16): -- Title bar bitmap height. --
VAL INT16 SM.DEBUG         IS 22 (INT16): -- Non-zero for windows debugging version. --
VAL INT16 SM.MOUSEPRESENT  IS 19 (INT16): -- Non-zero for mouse present. --
VAL INT16 SM.SWAPBUTTON    IS 23 (INT16): -- Non-zero for mouse buttons swapped. --
VAL INT16 SM.CYKANJIWINDOW IS 18 (INT16): -- Kanji window height. --
--}}} 
--{{{  SW. show window codes
-- These codes are for use with SP.SHOW.WINDOW and PROC show.window. --

VAL INT16 SW.HIDE              IS 0 (INT16): -- Hidden. --
VAL INT16 SW.MINIMIZE          IS 6 (INT16): -- Minimize window and deactivate. --
VAL INT16 SW.SHOW              IS 5 (INT16): -- Windows current size and position. --
VAL INT16 SW.SHOW.MAXIMIZED    IS 3 (INT16): -- Maximized and active. --
VAL INT16 SW.SHOW.MINIMIZED    IS 2 (INT16): -- Minimized and active. --
VAL INT16 SW.SHOW.MIN.NOACTIVE IS 7 (INT16): -- Minimized, no change to activation. --
VAL INT16 SW.SHOW.NORMAL       IS 1 (INT16): -- Restored and active. --
VAL INT16 SW.SHOW.NA           IS 4 (INT16): -- Current state, no activation. --

-- These codes are not part of the Window ShowWindow finction and are --
-- interpreted by SP_SHOW_WINDOW. SP_SHOW_WINDOW assumes that all     --
-- display codes without bit 15 set are standard windows codes.       --
VAL INT16 SW.SET.FOCUS           IS -1 (INT16): -- Give window the focus. --
VAL INT16 SW.RESTORE.NO.ACTIVATE IS -2 (INT16): -- Restores window but no focus. --
VAL INT16 SW.BRING.TO.TOP        IS -3 (INT16): -- Put window on top of all others. --
--}}} 
--{{{  SPR return codes
-- These are the error codes returned from WISERVER for almost every control --
-- tag. Nearly every procedure returns a WISERVER result which will be one   --
-- of these.                                                                 --

VAL BYTE SPR.OK                IS 0 (BYTE): -- Operation Ok. --
VAL BYTE SPR.NOT.IMPLEMENTED   IS 1 (BYTE): -- Operation not implemented. --
VAL BYTE SPR.BAD.NAME          IS 2 (BYTE):
VAL BYTE SPR.BAD.TYPE          IS 3 (BYTE): -- Bad file type with SP.OPEN. --
VAL BYTE SPR.BAD.MODE          IS 4 (BYTE): -- Bad file mode with SP.OPEN. --
VAL BYTE SPR.INVALID.STREAM.ID IS 5 (BYTE): -- Bad stream ID with file or text window. --
VAL BYTE SPR.BAD.STREAM.USE    IS 6 (BYTE):
VAL BYTE SPR.BUFFER.OVERFLOW   IS 7 (BYTE):
VAL BYTE SPR.BAD.PACKET.SIZE   IS 8 (BYTE):
VAL BYTE SPR.BAD.ORIGIN        IS 9 (BYTE): -- Bad origin with SP.SEEK. --

VAL BYTE SPR.NOTOK             IS 127 (BYTE):
VAL BYTE SPR.OPERATION.FAILED  IS 128 (BYTE):
VAL BYTE SPR.ERROR             IS 129 (BYTE): -- Generic error. --
VAL BYTE SPR.CANCEL            IS 130 (BYTE):
--}}} 
--{{{  Open Text window constants
-- These codes are for use with SP.OPEN.TEXT.WINDOW or PROC open.text.window. --
-- The values should be ORed with each other and placed in the window style   --
-- field.                                                                     --

VAL INT MIN.BOX.TEXT.WIN.STYLE        IS #0001: -- Include the minimize box. --
VAL INT CARET.TEXT.WIN.STYLE          IS #0002: -- Include the caret (cursor). --
VAL INT CENTRAL.TEXT.WIN.STYLE        IS #0004: -- Create the window in the centre of the desktop. --
VAL INT NO.TITLE.TEXT.WIN.STYLE       IS #0008: -- Hide the title bar. --
VAL INT HIDDEN.TEXT.WIN.STYLE         IS #0010: -- Do not display straight away. --
VAL INT NO.ACTIVATE.TEXT.WIN.STYLE    IS #0020: -- Do not change focus on create. --
VAL INT ANSI.CODES.TEXT.WIN.STYLE     IS #0040: -- Window will interpret ANSI screen codes. --
VAL INT WISERVER.CODES.TEXT.WIN.STYLE IS #0000: -- Window will interpret WISERVER screen codes. --

-- These constants are used for complex placing of the text window on creation. --
VAL INT WIN.POS.LEFT.TEXT.WIN.STYLE        IS #0000:
VAL INT WIN.POS.RIGHT.TEXT.WIN.STYLE       IS #0100:
VAL INT WIN.POS.X.CENTRE.TEXT.WIN.STYLE    IS #0200:
VAL INT SCREEN.POS.LEFT.TEXT.WIN.STYLE     IS #0000:
VAL INT SCREEN.POS.RIGHT.TEXT.WIN.STYLE    IS #0400:
VAL INT SCREEN.POS.X.CENTRE.TEXT.WIN.STYLE IS #0800:
VAL INT WIN.POS.TOP.TEXT.WIN.STYLE         IS #0000:
VAL INT WIN.POS.BOTTOM.TEXT.WIN.STYLE      IS #1000:
VAL INT WIN.POS.Y.CENTRE.TEXT.WIN.STYLE    IS #2000:
VAL INT SCREEN.POS.TOP.TEXT.WIN.STYLE      IS #0000:
VAL INT SCREEN.POS.BOTTOM.TEXT.WIN.STYLE   IS #4000:
VAL INT SCREEN.POS.Y.CENTRE.TEXT.WIN.STYLE IS #8000:
--}}} 
--{{{  SPS. exit constants
-- These codes are for use with SP.EXIT or PROC exit.server. --

VAL INT32 SPS.SUCCESS IS  999999999 (INT32): -- Program was a success. --
VAL INT32 SPS.FAILURE IS -999999999 (INT32): -- Program failed. --
--}}} 
--{{{  SPID. Default window stream ids
-- These are the stream ids for the default window. The default window   --
-- should not normally be used. The standard streams represent the       --
-- standard inputs and outputs in Unix systems, 'standard input (stdin), --
-- standard output (stdout) and standard error (stderr).                 --

VAL INT32 SPID.STDIN  IS 0 (INT32): -- Standard input. --
VAL INT32 SPID.STDOUT IS 1 (INT32): -- Standard output. --
VAL INT32 SPID.STDERR IS 2 (INT32): -- Standard error. --
--}}} 
--{{{  DLL constants
VAL INT DLL.DATA.SIZE IS 7: -- Bytes used to store loaded dll info. --
--}}} 
--{{{  KEY. Event masks
-- These codes are for use with SP.GET.EVENT and PROC get.event.             --
-- The values represent bits in a data field given for every event in a text --
-- window. If the corresponding bit is set then the condition is TRUE.       --

VAL INT16 KEY.SHIFT.PRESSED   IS #01 (INT16): -- Bit 0 set means Shift was pressed during event. --
VAL INT16 KEY.CONTROL.PRESSED IS #02 (INT16): -- Bit 1 set means Control was pressed during event. --
VAL INT16 KEY.ALT.PRESSED     IS #04 (INT16): -- Bit 2 set means Alt was pressed during event. --
VAL INT16 KEY.AUTO.REPEAT     IS #08 (INT16): -- Bit 3 set means event was generated due to key auto repeat. --
VAL INT16 KEY.IS.ANSI         IS #10 (INT16): -- Bit 4 set means key pressed has ANSI value. (See the relevant field. ) --
VAL INT16 KEY.IS.DOS.EXTENDED IS #20 (INT16): -- Bit 5 set means key is eqiv. to an extended DOS key which is preceded by a zero byte. --
--}}} 
--{{{  Timings
VAL INT POLL.PERIOD IS 1500: -- This is the suggested poll period for    --
                             -- the procedures                           --
                             -- PROC wait.event                          --
                             -- PROC wait.key                            --
                             -- PROC wait.any.event.                     --
                             -- The value should be multiplied by 64 if  --
                             -- the procs are executed in high priority. --
--}}} 
--{{{  ITERM. codes
-- These are control bytes for performing text operations in WIServer text --
-- windows. They replace the DOS BANSI codes of IServer.                   --

VAL BYTE ITERM.GOTO.CODE       IS  1 (BYTE): -- Goto X, Y. Places cursor at x, y. See PROC goto.xy. --
VAL BYTE ITERM.CLR.SCREEN.CODE IS  2 (BYTE): -- Clear screen, Place cursor at top left. --
VAL BYTE ITERM.CLR.EOS.CODE    IS  3 (BYTE): -- Clear screen from cursor to end of screen. --
VAL BYTE ITERM.CLR.EOL.CODE    IS  4 (BYTE): -- Clear from cursor to end of line. --
VAL BYTE ITERM.INS.LINE.CODE   IS  5 (BYTE): -- Insert a blank line at cursor (and scroll screen down). --
VAL BYTE ITERM.DEL.LINE.CODE   IS  6 (BYTE): -- Delete the line at cursor (and scroll screen up). --
VAL BYTE ITERM.BEEP.CODE       IS  7 (BYTE): -- Produce a bleep. --
VAL BYTE ITERM.INS.CHAR.CODE   IS  8 (BYTE): -- Insert a character at cursor. --
VAL BYTE ITERM.DEL.CHAR.CODE   IS  9 (BYTE): -- Delete the character at the cursor. --
VAL BYTE ITERM.DOWN.CODE       IS 10 (BYTE): -- Move cursor down. --
VAL BYTE ITERM.UP.CODE         IS 11 (BYTE): -- Move cursor up. --
VAL BYTE ITERM.LEFT.CODE       IS 12 (BYTE): -- Move cursor left. --
VAL BYTE ITERM.RIGHT.CODE      IS 14 (BYTE): -- Move cursor right. --
VAL BYTE ITERM.SHOW.CARET.CODE IS 15 (BYTE): -- Displays the caret. --
VAL BYTE ITERM.HIDE.CARET.CODE IS 16 (BYTE): -- Hides the caret. --

-- Byte 13 is used as Carriage Return. --
--}}} 
--{{{  VK. virtual key codes
-- These are the Virtual Key codes returned by windows for events. --
-- VK_A to VK_Z and VK_0 to VK_9 are the same as value as the ASCII values --
--{{{  Number pad

VAL INT16 VK.MULTIPLY         IS 106 (INT16): -- Num Pad. --
VAL INT16 VK.ADD              IS 107 (INT16): -- Num Pad. --
VAL INT16 VK.SUBTRACT         IS 109 (INT16): -- Num Pad. --
VAL INT16 VK.DECIMAL          IS 110 (INT16): -- Num Pad. --
VAL INT16 VK.DIVIDE           IS 111 (INT16): -- Num Pad. --
VAL INT16 VK.NUMLOCK          IS 144 (INT16): -- Num Pad. --

VAL INT16 VK.NUMPAD0          IS 96  (INT16): -- Num Pad 0. -- 
VAL INT16 VK.NUMPAD1          IS 97  (INT16): -- Num Pad 1. -- 
VAL INT16 VK.NUMPAD2          IS 98  (INT16): -- Num Pad 2. -- 
VAL INT16 VK.NUMPAD3          IS 99  (INT16): -- Num Pad 3. -- 
VAL INT16 VK.NUMPAD4          IS 100 (INT16): -- Num Pad 4. -- 
VAL INT16 VK.NUMPAD5          IS 101 (INT16): -- Num Pad 5. -- 
VAL INT16 VK.NUMPAD6          IS 102 (INT16): -- Num Pad 6. -- 
VAL INT16 VK.NUMPAD7          IS 103 (INT16): -- Num Pad 7. -- 
VAL INT16 VK.NUMPAD8          IS 104 (INT16): -- Num Pad 8. -- 
VAL INT16 VK.NUMPAD9          IS 105 (INT16): -- Num Pad 9. -- 
--}}} 
--{{{  Function keys
VAL INT16 VK.F1               IS 112 (INT16): -- 
VAL INT16 VK.F2               IS 113 (INT16): -- 
VAL INT16 VK.F3               IS 114 (INT16): -- 
VAL INT16 VK.F4               IS 115 (INT16): -- 
VAL INT16 VK.F5               IS 116 (INT16): -- 
VAL INT16 VK.F6               IS 117 (INT16): -- 
VAL INT16 VK.F7               IS 118 (INT16): -- 
VAL INT16 VK.F8               IS 119 (INT16): -- 
VAL INT16 VK.F9               IS 120 (INT16): -- 
VAL INT16 VK.F10              IS 121 (INT16): -- 
VAL INT16 VK.F11              IS 122 (INT16): -- 
VAL INT16 VK.F12              IS 123 (INT16): -- 
VAL INT16 VK.F13              IS 124 (INT16): -- 
VAL INT16 VK.F14              IS 125 (INT16): -- 
VAL INT16 VK.F15              IS 126 (INT16): -- 
VAL INT16 VK.F16              IS 127 (INT16): -- 
--}}} 
VAL INT16 VK.LBUTTON          IS 1   (INT16): -- Left mouse button. --
VAL INT16 VK.RBUTTON          IS 2   (INT16): -- Right mouse button. --
VAL INT16 VK.MBUTTON          IS 4   (INT16): -- Middle mouse button. --
VAL INT16 VK.INSERT           IS 45  (INT16): -- 
VAL INT16 VK.DELETE           IS 46  (INT16): -- 
VAL INT16 VK.LEFT             IS 37  (INT16): -- 
VAL INT16 VK.RIGHT            IS 39  (INT16): -- 
VAL INT16 VK.UP               IS 38  (INT16): -- 
VAL INT16 VK.DOWN             IS 40  (INT16): -- 
VAL INT16 VK.ESCAPE           IS 27  (INT16): -- 
VAL INT16 VK.SPACE            IS 32  (INT16): -- 
VAL INT16 VK.PRIOR            IS 33  (INT16): -- Page up. --
VAL INT16 VK.NEXT             IS 34  (INT16): -- Page down. --
VAL INT16 VK.END              IS 35  (INT16): -- 
VAL INT16 VK.HOME             IS 36  (INT16): -- 
VAL INT16 VK.SHIFT            IS 16  (INT16): -- 
VAL INT16 VK.CONTROL          IS 17  (INT16): -- 
VAL INT16 VK.CANCEL           IS 3   (INT16): -- For control-break processing. --
VAL INT16 VK.BACK             IS 8   (INT16): -- Backspace. --
VAL INT16 VK.TAB              IS 9   (INT16): -- 
VAL INT16 VK.CLEAR            IS 12  (INT16): -- 
VAL INT16 VK.RETURN           IS 13  (INT16): -- 
VAL INT16 VK.MENU             IS 18  (INT16): -- Alt key. --
VAL INT16 VK.PAUSE            IS 19  (INT16): -- 
VAL INT16 VK.CAPITAL          IS 20  (INT16): -- Caps Lock. --
VAL INT16 VK.SELECT           IS 41  (INT16): -- 
VAL INT16 VK.PRINT            IS 42  (INT16): -- OEM Specific. --
VAL INT16 VK.EXECUTE          IS 43  (INT16): -- 
VAL INT16 VK.SNAPSHOT         IS 44  (INT16): -- 
VAL INT16 VK.HELP             IS 47  (INT16): -- 
VAL INT16 VK.SEPARATOR        IS 108 (INT16): -- 
--}}} 
--}}} 
