/****************************************************************************
*       time.c
*
*       Time Functions
* **********************************************************************
* *     Copyright (c) by Barak Pearlmutter and Kevin Lang, 1987-98.    *
* *     Portions copyright (c) by Alex Stuebinger, 1998.               *
* *     Placed under the terms of the GNU General Public License       *
* *     as published by the Free Software Foundation.                  *
* **********************************************************************
*
*       Revision log:
*       *************
*
*       date     time   author  comments
*       ================================================================
*       17/01/98 11:17  stuebi  initial revision
*       ----------------------------------------------------------------
*
*       ================================================================
*
*
*       Description:
*       ************
*
*
*
*       Planned:
*       ********
*
*
*
*/

#include <stddef.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <time.h>
#include "emulator.h"


#if !defined(__unix__)

unsigned long get_real_time(void)
/*******************************/
{   double temp;
    temp = (double) clock() / CLOCKS_PER_SEC * 1000000.0;
    /* caution: the clock() function on some systems with a high
                frequency clock (e.g. transputers ) give values
                modulo a not too big time span, so a wrap around
                can occur between to calls, which leads to odd results
    */
    return (unsigned long) temp;
}

/* if you know how to get user time on __vms__, make it here */
/* for non multi-tasking systems it's just real time */

unsigned long get_user_time(void)
/*******************************/
{   return get_real_time();
}

#else /* __unix__ */

#include <sys/time.h>

#if (defined(__hpux) && !defined(_HPUX_SOURCE))
#define _HPUX_SOURCE
#endif

#if (defined(sun) && defined(__SVR4))
#include "/usr/ucbinclude/sys/rusage.h"
#include "/usr/ucbinclude/sys/resource.h"
#else
#include <sys/resource.h>
#endif

#ifdef __hpux
#include <sys/syscall.h>
#define     getrusage(a, b)     syscall(SYS_getrusage, (a), (b))
#endif

unsigned long get_real_time(void)     /* returns microseconds */
/*******************************/
{   unsigned long result;
    struct timeval tnow;

    if (0 != gettimeofday(&tnow, 0))
    {   fprintf(stderr, "ERROR (Time): Unable to obtain time of day; %s\n",
                strerror(errno));
        exit(EXIT_FAILURE);
    }
    else
    {   result= tnow.tv_sec * 1000000
                + tnow.tv_usec;
        return result;
    }
}


unsigned long get_user_time( void )     /* returns microseconds */
/*********************************/
{   struct rusage rusage;
    unsigned long result;

    if (0 != getrusage(RUSAGE_SELF, &rusage))
    {   fprintf(stderr, "ERROR (Time): Unable to getrusage(); %s\n",
                strerror(errno));
        exit(EXIT_FAILURE);
    }
    else
    {   result = rusage.ru_utime.tv_sec * 1000000
                 + rusage.ru_utime.tv_usec;
        return result;
    }
}

#endif /* not __unix__ */
