/****************************************************************************
*       mymalloc.c
*
*       Malloc Helper Routines
* **********************************************************************
* *     Copyright (c) by Barak Pearlmutter and Kevin Lang, 1987-98.    *
* *     Portions copyright (c) by Alex Stuebinger, 1998.               *
* *     Placed under the terms of the GNU General Public License       *
* *     as published by the Free Software Foundation.                  *
* **********************************************************************
*
*       Revision log:
*       *************
*
*       date     time   author  comments
*       ================================================================
*       11/01/98 18:33  stuebi  initial revision
*       ----------------------------------------------------------------
*
*       ================================================================
*
*
*       Description:
*       ************
*
*
*
*       Planned:
*       ********
*
*
*
*/

#include <stddef.h>
#include <stdlib.h>
#include <stdio.h>
#include "emulator.h"




char *my_malloc(size_t i)
/***********************/
{
#ifdef __mac__
  char *p;
  ResrvMem(i);
  p = mlalloc(i);
#else
  char *p = (char *)malloc((size_t)i);
#endif
  if (p == NULL)
    {
      fprintf(stderr, "\nUnable to allocate %lu bytes.\n", (unsigned long)i);
      exit(EXIT_FAILURE);
      return NULL;
    }

  else
  {
    return p;
  }
}


void realloc_space(space *pspace, ref* pfree)
/*******************************************/
{
  long new_size = pfree - pspace->start;
  pspace->size = new_size;
  /* realloc commented out because it might move the block, even though
     it's sure to be shrunk. */
  realloc((void *)pspace->start, (size_t)(sizeof(ref)*new_size));
  pspace->end = pspace->start + new_size;
  }



void free_space(space *pspace)
/****************************/
{
#ifdef UNALIGNED
  free((void *)pspace->start - pspace->offset);
  if (pspace->offset)
    pspace->size += 1;
#else
  free((void *)pspace->start);
#endif
  pspace->start = pspace->end = NULL;
}

void alloc_space(space *pspace)
/*****************************/
{
  char *p = my_malloc((size_t )(sizeof(ref) * pspace->size));

#ifdef UNALIGNED
  pspace->offset = (long)p & 3L;
  p = (char *) ((long)p + pspace->offset);
  if (pspace->offset)
    pspace->size -= 1;
#endif

  /*NOSTRICT*/
  pspace->start = (ref *) p;
  pspace->end = pspace->start + pspace->size;
}



