/****************************************************************************
*       config.h
*
*       Configuration Header File
* **********************************************************************
* *     Copyright (c) by Barak Pearlmutter and Kevin Lang, 1987-98.    *
* *     Portions copyright (c) by Alex Stuebinger, 1998.               *
* *     Placed under the terms of the GNU General Public License       *
* *     as published by the Free Software Foundation.                  *
* **********************************************************************
*
*       Revision log:
*       *************
*
*       date     time   author  comments
*       ================================================================
*       10/01/98 21:28  stuebi  initial revision
*       ----------------------------------------------------------------
*
*       ================================================================
*
*
*       Description:
*       ************
*
*
*
*       Planned:
*       ********
*
*       Use GNU autoconf.
*
*/


#ifndef _CONFIG_H_INCLUDED
  #ifdef __cplusplus
    extern "C" {
  #endif

  #ifndef __STDC__
    #error you lose... the whole code is ansi-c, try older release
  #endif



/* Detect Operating Systems */

  #if defined(linux) | defined(__hpux) || defined(sun) \
      || defined (__osf) || defined(convex) || defined(_AIX) \
      || defined(mips) || defined(ultrix) \

    #ifndef __unix__
      #define __unix__ /* must be defined for all unix targets */
    #endif

    #define __posix__ /* must be defined if posix headers are present */

  #elif defined(vms) || defined(decc)

    #ifndef __vms__
      #define __vms__  /* must be defined for all vms targets */
    #endif

  #elif defined(_ICC)

    #define __inmos__

  #elif defined(__DOS__) && defined(__WATCOMC__)

    #define __dos__
    #define __posix__

  #elif (defined(__WINDOWS_386__) || defined(__NT__)) && defined(__WATCOMC__)

    #define __nt__
    #define __posix__

  #elif defined(MacLSC)

    #define __mac__

  #elif defined(AMIGA)

    #define __amiga__

  #else

    /* none */

  #endif /* defined __hpux etc. **/

/* Detect Processors */

/* Make the following assumptions: */
/* "__alpha" is defined for DEC Alpha chips */
/* "convex" is defined for Convex targets */
/* "sun" is defined for SUN targets */
/* "sparc" is defined for SUN Sparc targets */
/* "mips" is defined for Mips targets */
/* "vax" is defined for DEC VAX */

/* on transputers you must define "__t4__" or "__t805__" */
  #ifdef __inmos__
    #if !defined(__t4__) && !defined(__t805__)
      #define __t4__   /* define __t4__ as default */
    #endif
  #endif

/* "__386__" is defined for 386 targets on Watcom C32 */
  #if defined(i386) || defined(linux)
    #define __386__  /* define it for linux */
  #endif


/* Detect Compilers */

/* The GNU GCC Compiler defines "__GNUC__" */
/* The DEC-C Compiler for VMS defines "decc" */
/* The Inmos Compiler for the Transputer defines "_ICC" */
/* The Watcom C/C++ 32 Compiler for Intel 386 defines "__WATCOMC__" */

  #if defined(__WATCOMC__) && defined(__386__)
    #define __watcom386__
  #endif

/* Configuration Process for the Tested Architectures */

/*
*  Some Configuration Parametres explained:
*  ========================================
*
*  WORDSIZE
*  Length of (long).  Must be <= length of (char *).
*
*  ASHR2
*  The ASHR2 macro can be ((x)>>2) on machines with arithmetic right
*  shifts of signed numbers.  But some machines (like the Convex)
*  treat all numbers being shifted as unsigned.  If your compiler
*  emits better code for ((x)>>2) than for ((x)/4) and does not have this
*  weird problem, you should use the former definition.
*
*  HAVE_LONG_LONG
*  Some machines have a 64 bit variant of long called a "long long",
*  which makes multiplication overflow detection easier.
*
*  UNALIGNED
*  UNALIGNED should be defined if malloc() might return a pointer that isn't
*  long aligned, ie, whose low two bits might not be 0.
*
*  DEFAULT_NEW_SPACE_SIZE
*  This is measured in references, each is sizeof(unsigned long).
*
*  DEFAULT_WORLD
*  Path where the emulator assumes the bootable world if no world is given.
*
*  MAX_NEW_SPACE_SIZE
*  Measured in references.  Should be defined if virtual memory is tight.
*
*  STACK_BUFFER_SIZE
*  Measured in references.
*/


/* Define the configuration here: */

  #if defined(__GCC__)

    #define HAVE_LONG_LONG
    #define ASHR2(x) ((x)>>2)
  #endif


  #if defined(__unix__)

    /* common for all unix */
    #define DEFAULT_NEW_SPACE_SIZE (1024*1024l)
    #define DEFAULT_WORLD "/usr/local/oaklisp/worlds/oaklisp.++c"

    #if defined(__alpha)

      /* unix, alpha target */
      #error alpha yet unported (provisional)

    #elif defined(sun)

      /* unix, sun target */
      #define WORDSIZE 32

    #elif defined(__hpux)

      /* unix, hp target */
      #define WORDSIZE 32

    #elif defined(convex)

      /* unix, convex target */
      #error convex yet unported (provisional)

    #elif defined(__386__)

      /* unix, 386 target, e.g. linux */
      #define WORDSIZE 32

    #else

       /* comment out the following if you are sure the code will run: */
       #error warning: untested __unix__ machine

    #endif /* defined alpha */

  #elif defined(__vms__)

    /* common for all vms */
    #error vms yet unported (provisional)

    #if defined(alpha)
      /* vms, alpha target */

    #elif defined(vax)
      /* vms, vax target*/

    #endif /* defined alpha */

  #elif defined(__inmos__)

    /* inmos transputer target */
    #define WORDSIZE 32
    #define ASHR2(x) ((x)>>2)
    /* note: to get arithmetic right shifts with the inmos compiler
     * caution: you must compile with the /FS option! */
    #ifdef __t805__
        #define DOUBLES_FOR_OVERFLOW
    #endif
    /* to make sure it runs on a 1MB transputer module define: */
    /* the size you get is a multiple of sizeof(unsigned long) */
    #define DEFAULT_NEW_SPACE_SIZE (43*1024l)
    #define MAX_NEW_SPACE_SIZE (43*1024l)
    #define STACK_BUFFER_SIZE (8*1024l)

    #define DEFAULT_WORLD "c:\\oaklisp\\worlds\\oaklisp.++c"
    #define NO_ISATTY

  #elif defined(__dos__) && defined(__386__)

    /* dos, 386 target */
    #define WORDSIZE 32
    #define ASHR2(x) ((x)>>2)
    #define DEFAULT_NEW_SPACE_SIZE (1024*1024l)
    #define DEFAULT_WORLD "c:\\oaklisp\\worlds\\oaklisp.++c"

  #elif defined(__nt__) && defined(__386__)

    /* nt, 386 target */
    #define WORDSIZE 32
    #define ASHR2(x) ((x)>>2)
    #define DEFAULT_NEW_SPACE_SIZE (1024*1024l)
    #define DEFAULT_WORLD "c:\\oaklisp\\worlds\\oaklisp.++c"

  #elif defined(__mac__)

    /* mac target */
    /* caution: the mac version is not tested in this revision! */
    /* old code for compatibility included */
    #define UNALIGNED
    #define MALLOC_STACK_BUFFER
    #define MALLOC_WP_TABLE
    #define PROTOTYPES
    #define CANT_FLUSH_STD

  #elif defined(__amiga__)

    /* amiga target */
    /* caution: the amiga version is not tested in this revision! */
    /* old code for compatibility included */
    #define MALLOC_STACK_BUFFER
    #define MALLOC_WP_TABLE

  #else

    /* comment out the following if you are sure the code will run: */
    #error warning: untested non __unix__ machine


  #endif /* defined __unix__ */



  /* Configuration Error Section, do not modify! */
  /* Beyond this point you must specify anything which is needed. */
  #if !defined(WORDSIZE)

    #error must define WORDSIZE

  #elif !defined(ASHR2)

    #define ASHR2(x) ((x)/4)
    /* and risk inefficient code */

  #elif !defined(DEFAULT_NEW_SPACE_SIZE)

    #define DEFAULT_NEW_SPACE_SIZE (256*1024l)
    /* and the user has to live with 1 megabyte of storage */

  #elif !defined(DEFAULT_WORLD)

    #error must specify DEFAULT_WORLD

  #else

    /* everything checks out o.k. */

  #endif /* not defined WORDSIZE */


  #define _CONFIG_H_INCLUDED
  #ifdef __cplusplus
    };
  #endif
#endif /* not defined _CONFIG_H_INCLUDED */
