/*********************************************************
 *  File: pcs_link.c
 *
 *  net I/O routines for use with pcserver, DEIT PISA
 *
 *  29-sep-92 lr adding support for numeric internet addresses.
 *  16-Jun-92 lr
 *    try to make it faster... When is complete, compile with -DFAST
 *  03-Jun-92 lr
 *    modified to implement timeouts correctly.
 *  05-Jun-91 lr
 *    removed C_TEST_ERR
 *  04-Jun-91 lr
 *    ReadLink returns if the error flag is set in the meantime
 *  03-Jun-91 lr
 *    read can return 0 bytes. Also, send C_TEST_ERR on opening
 *    (this must be removed in later versions)
 *  02-Jun-91 lr
 *    num_link was uninitialized... Thanks to Brad Banko.
 *  27-May-91 lr
 *    built from afserver source, IT IS NOT THE SAME !!!
 *
 */

/* Included files */
/* #define DEB */
#include "pcs_link.h"
#include "iserver.h"
#include <sys/time.h>

#define DB(x) fprintf x

#define BUF_NET_LEN 4096 /* size of net buffer */
	/* must be shorter than the pcserver one*/
#define O_p_len (*(short int *)o_net)
#define I_p_len (*(short int *)i_net)

struct timeval timeout_ack = { 10, 0 }; /* 10 sec 0 usec */
struct timeval timeout_read; /* use tv_sec, tv_usec for seconds/usec */

/* External variables */

int numsock;
struct sockaddr_in bsockaddr;
int terminate_code;	/* server exit result */

int TheLink; /* used in ABORT ... very bad */
extern int VerboseSwitch; /* used in INFO */

static int proto_sent=FALSE;

/* network buffer */
unsigned char i_net[BUF_NET_LEN];    /* input buffer (from net) */
unsigned char o_net[BUF_NET_LEN];    /* output buffer (to net) */

/* network buffer pointer */
int pri_net;     /* read input pointer */
int pwi_net;     /* write input pointer */
int pwo_net;     /* write output pointer */


#ifdef undefined
static struct linger dolinger = { 0, 300 };
#endif

host_end(x)
	int x;
{
	ABORT((stderr, " --- host_end: exiting with code %d ...",x));
}

int
OpenLink(s)
	char *s; /* the link device name */
{
	int risu;
	DB((stderr, "OpenLink: called with s=%8lx\n",s));
	proto_sent=FALSE;
	if (s) {
		DB((stderr, "OpenLink: s is %s\n",s));
	}
	risu=trans_conn(s);
	DB((stderr, "OpenLink: returns %d\n",risu));
	return(risu);
}

int
CloseLink(l)
	int l;
{
	DB((stderr,"CloseLink: called\n"));
	return(close(l)==0 ? 1 : -1);
}

int
ReadLink(l, buf, count, timeout)
	int l; /* link id */
	char *buf;
	unsigned int count;
	int timeout;
{
	int i,c1;

	/* fprintf(stderr,"r%d\t",count); */
	DB((stderr,"ReadLink: called to read %d bytes\n",count));
	c1=count;
	if (!proto_sent) {
		/* send_cmd(C_TEST_ERR); */
		send_cmd(C_PROTO);
		proto_sent=TRUE;
	}
#ifdef FAST
	short len;
	if (read(numsock,&len,2 !=2) {
		return(0);/* read error */
	}
	len=ntohs(len);
	if (len==ERROR_FLAG) {
		/* signal error set, reread */
		if (read(numsock,&len,2 !=2) {
			return(0);/* read error */
		}
		len=ntohs(len);
	}
	/*** read remaining bytes. Try to fill up the packet, unless the
	     timeout expires
	 ***/
#else
	while (count) {
		if (pri_net >= pwi_net) { /* no data available */
			if (-1==read_net(timeout)) break;
		}
		i= pwi_net-pri_net; /* available data */
		if (count<i) i=count;
		memcpy(buf, i_net+pri_net, i);
		pri_net += i;
		buf += i;
		count -= i;
	}
	if (count && c1 != 8) {
		/* only prints the warning on remaining parts of iserver
		messages. */
		fprintf(stderr,"timeout - read %d bytes instead of %d\n",c1-count,c1);
	}
	DB((stderr,"ReadLink: returns %d bytes\n",i));
	/* hexdump(buf,i); */
	return(c1-count);
#endif
}

int
WriteLink(l, buf, count, timeout)
	int l; /* link id */
	char *buf;
	unsigned int count;
	int timeout;
{
	int i,c1;
	/* fprintf(stderr,"W%d\t",count); */
	DB((stderr,"WriteLink: called to write %d bytes\n",count));
	/* hexdump(buf,count); */
	
	c1=count;
	if (!proto_sent) {
		/* send_cmd(C_TEST_ERR); */
		send_cmd(C_PROTO);
		proto_sent=TRUE;
	}
#ifdef FAST /* actually, this code proved to be slower!!! ***/
	{short len=htons(count+2);
	if (write(l,&len,2) !=2 ) {
		return(0); /* can't write... */
	}
	if (write(l,buf,count) !=count ) {
		return(0); /* can't write */
	}
	return(count);
	}
#else
	i=0;
	while(count) {
		i= BUF_NET_LEN-pwo_net;
		if (count<i) i=count;
		memcpy(o_net+pwo_net, buf, i);
		pwo_net += i;
		buf += i;
		count -= i;
		write_net(timeout);
	}
	return(c1);
#endif
}

int
ResetLink(l)
	int l;
{
	DB((stderr,"ResetLink: called\n"));
	/* fprintf(stderr,"ResetLink: called\n"); */
	send_cmd(C_RESET);
	return(1);
}

int
AnalyseLink(l)
	int l;
{
	DB((stderr,"AnalyseLink: called\n"));
	/* fprintf(stderr,"AnalyseLink: called\n"); */
	send_cmd(C_ANALYSE);
	return(1);
}

static error_flag=0;
int
TestError(l)
	int l;
{
	DB((stderr,"TestError: called\n"));
	return(error_flag);
}

int
TestRead(l)
	int l;
{
	DB((stderr,"TestRead: called\n"));
	return(-1);
}

int
TestWrite(l)
	int l;
{
	DB((stderr,"TestWrite: called\n"));
	return(-1);
}

int
trans_conn(s)
	char *s;
{
	int tipo;
	struct sockaddr_in sockaddr;
	struct hostent *hp;
	struct hostent *hpt;
	char localhost[MAXHOSTNAME+1];
	char *col=NULL;
	int num_link;

	gethostname(localhost,MAXHOSTNAME);
	if ((hpt=gethostbyname(localhost)) == NULL) {
		return(-1);
	}
	bcopy((char *)hpt->h_addr,(char *)&bsockaddr.sin_addr,hpt->h_length);
	bsockaddr.sin_family=hpt->h_addrtype;
	tipo=hpt->h_addrtype;

	if (s==NULL || *s=='\0') {
		perror("trans_conn: null host name specified");
		terminate_code=NULL;
		return(-1);
	}
/*	hostname can be in the form:
 *		host
 *		host:adapter
 *		Nhost (where n=0..9, host is a name)
 *
 */
	if (col=strstr(s,":")) {
		*col=0;
		num_link= *(col+1) - '0';
	} else if (*s>='0' && *s<='9' && *(s+1) !='\0') {
		num_link= *s - '0';
		s++;
	} else {
		num_link=0;
	}
	if ((hp=gethostbyname(s)) == NULL) {
		fprintf(stderr,"trans_conn: Unknown host\n");
		terminate_code=NULL;
		return(-1);
	}
	if (col) *col=':'; /* cleanup */
	bcopy((char *)hp->h_addr,(char *)&sockaddr.sin_addr,hp->h_length);
	sockaddr.sin_port=htons(PORTA+num_link);
	sockaddr.sin_family=hp->h_addrtype;
	tipo=hp->h_addrtype;

	if ((numsock=socket(tipo,SOCK_STREAM,0))==0) { 
		perror("trans_conn: socket");
		terminate_code=NULL;
		return(-1);
	}
#ifdef notdef
	/* here use linger on close, i.e. wait N seconds (here 30)
	   before closing to insure data are transmitted */
	{ int i;
	getsockopt(numsock,SOL_SOCKET,SO_LINGER, &dolinger, &i);
	DB((stderr, "linger opt l_onoff = %d\n",dolinger.l_onoff));
	DB((stderr, "linger opt l_linger = %d\n",dolinger.l_linger));
	dolinger.l_onoff=1;
	setsockopt(numsock,SOL_SOCKET,SO_LINGER, &dolinger, sizeof(dolinger));
	}
#endif
	if (connect(numsock,&sockaddr,sizeof(sockaddr))<0) { 
		perror("trans_conn: connect");
		terminate_code=NULL;
		return(-1);
	}
	/* init buffer pointers */
	pri_net=0;
	pwi_net=0;
	pwo_net=L_START;
	return(numsock);
}

int
send_cmd(cmd)
int cmd;
{
	o_net[L_START]= cmd;
	if (cmd == C_PROTO){
		error_flag=0;
		pwo_net = L_START+2;
#ifdef USE_ISERVER_PROTO
		o_net[L_START+1]= P_IS_PROTO;
#else
		o_net[L_START+1]= P_RAW_PROTO;
#endif
	} else {
		pwo_net = L_START+1;
	}
	write_net(5);
	if (!is_ack()){
		fprintf(stderr,"No ack received from pcserver\n");
		host_end(-1);
	}
}

int
check_timeout(t)
{
	long readfds;
	int n;
	struct timeval timeout;
	
	timeout.tv_sec=t; timeout.tv_usec=0;
	readfds=1<<numsock;
	n=select(numsock+1,&readfds,0,0,&timeout);
	if (n<0){
		perror("check_timeout: select");
		host_end(-2);
	}
	return(n!=0);
}

int
is_ack()
{
	if (check_timeout(10)==0) return(FALSE); /* timeout expired */
	read_net(10); /* cannot have errors here ... I hope */
	pri_net= pwi_net; /* ignore message */
	if (i_net[L_START] == C_NACK ) {
		fprintf(stderr,"NACK received from pcserver\n");
		return(FALSE);
	}
	return (TRUE);
}

int
safe_read_net(l,t)
	int l; /* pwi_net goes at most to l */
	int t;
{
	int i;

	while(pwi_net<l){
		if (check_timeout(t) == 0 ) return(0);
		i=read(numsock,i_net+pwi_net,l - pwi_net);
		if (i < 0) {
			perror("read_net: read");
			host_end(-3);
		}
		pwi_net+=i;
	}
	DB((stderr,"*** read_net: read %d bytes ",i));
	DB((stderr,"size of message = %d\n",ntohs(I_p_len)));
	return(1);
}

int
read_net(t)
	int t;
{
	pwi_net=0;
	if (!safe_read_net(L_START,t)) return(-1); /* no data */
	if (ntohs(I_p_len)==0) {
		/* error flag set */
		error_flag = 1;
		pwi_net=0;
		return(-1);
	}
	safe_read_net(ntohs(I_p_len),t);
	pri_net=L_START;
	return(pwi_net-L_START);
}


int
write_net(timeout)
	int timeout;
{
	int i;
	int pro_net=0;

	O_p_len= htons(pwo_net);
	DB((stderr,"*** write_net: write %d bytes\n",pwo_net));
	while( pro_net<pwo_net){
		i=write(numsock,o_net+pro_net,pwo_net-pro_net);
		if (i<0){
			perror("write_net: write");
			host_end(-4);
		}
		pro_net +=i;
	}
	pwo_net= L_START;
	return(pro_net-L_START);
}


static char flicks[]="/-\\|";

int
load_code (boot_file_name)
	char *boot_file_name;
{
	FILE *boot_file;
	int i;
	int flick=0;

	if ((boot_file = fopen(boot_file_name, "r")) == NULL) {
		ABORT((stderr,"cannot open boot file %s",boot_file_name));
	}
	o_net[L_START]=C_BOOT;
	while ( (i= fread(o_net+L_START+1,1,BUF_NET_LEN-L_START-1,
		boot_file))>0) {
		pwo_net = i + L_START + 1;
		write_net(5);
		if (isatty(1)) {
			INFO(("%c\b",flicks[flick++]));
			if (flick>3) flick=0;
		}
		if (!is_ack()) {
			fclose(boot_file);
			ABORT((stderr,"missing ack during boot"));
		}
	}
	if (!feof(boot_file)) {
		fclose(boot_file);
		ABORT((stderr,"error during boot"));
		return(ER_LINK_BAD);
	}
	if (fclose(boot_file)) {
		ABORT((stderr,"cannot close boot file"));
	}
	if (isatty(1)) {
		INFO(("ok\n"));
	}
	return(TRUE);
}
/*** end of main part of pcs_link.c ***/
/* int VerboseSwitch=0; */
/* HostEnd(){} */

hexdump(buf, len)
	unsigned char buf[];
	int len;
{
	int i;
	for (i=0;i<len;i++) {
		if (i%16 == 0) printf("\n%4x: ",i);
		printf("  %2x",buf[i]);
	}
	printf("\n");
}
