/*
 -- ---------------------------------------------------------------------------
 --
 --      ISERVER  -  INMOS standard file server
 --
 --      b004link.c
 --
 --      Link module for B004 type boards in IBM and NEC PCs
 --
 --      Copyright (c) INMOS Ltd., 1988.
 --      All Rights Reserved.
 --
 -- ---------------------------------------------------------------------------
*/

#include <stdio.h>
#include <string.h>

#include <unistd.h>
#include <sys/types.h>
#include <sys/file.h>
#include <sys/uio.h>
#include <sys/ioctl.h>


/* TODO sara' negli include di sistema ? */
#include "b004.h"
#include "inmos.h"
#include "iserver.h"


#define DEB(x)
#define DEB2(x)

DEB2(FILE *debfil);
#define NULL_LINK -1

PRIVATE LINK ActiveLink = NULL_LINK;

static char C004_DEFAULT_DEV[11] = "/dev/bqu0";

static int link_des;

static  int     gTimeout = -1;

#ifdef NEC       /*  its really a B010  */
#define C012_DEFAULT_BASE   0xd0
#define C012_IDR_OFFSET        0
#define C012_ODR_OFFSET        2
#define C012_ISR_OFFSET        4
#define C012_OSR_OFFSET        6
#define C012_RESET_OFFSET      8
#define C012_ERROR_OFFSET      8
#define C012_ANALYSE_OFFSET   10
#else
#define C012_DEFAULT_BASE  0x150
#define C012_IDR_OFFSET        0
#define C012_ODR_OFFSET        1
#define C012_ISR_OFFSET        2
#define C012_OSR_OFFSET        3
#define C012_RESET_OFFSET     16
#define C012_ERROR_OFFSET     16
#define C012_ANALYSE_OFFSET   17
#endif

unsigned int C012_base, 
	     C012_idr,
	     C012_odr,
	     C012_isr,
	     C012_osr,
	     C012_reset,
	     C012_error,
	     C012_analyse;



/*
 *   Open Link
 */

PUBLIC LINK OpenLink ( Name )
   char *Name;
{
   char *act_name;
   if ( ActiveLink != NULL_LINK )
      return( ER_LINK_CANT );


DEB(fprintf(stderr,"\nopen: INPUT PARAM %s\n",Name));
   if ( *Name == '\0' || Name == (char *) 0 )
      act_name = C004_DEFAULT_DEV;
   else
      act_name = Name;
DEB(fprintf(stderr,"\nopen: TRIING OPEN %s\n",act_name));

   if ( 0 > (link_des=open( act_name, O_RDWR )))
         return(ER_LINK_BAD);

DEB(fprintf(stderr,"\nOPEN DONE\n"));

/* TODO predisporre i giusti parametri con ioctl() */

DEB2(if(NULL==(debfil=fopen("debfil","w")))fprintf(stderr,"debfil NON APERTO\n");else fprintf(stderr,"debfil APERTO")); 

   ActiveLink = 1;
   return(ActiveLink);
}




/*
 *   Close Link
 */

int CloseLink ( LinkId )
   int LinkId;
{
   if ( LinkId != ActiveLink )
      return( -1 );
   if ( 0 > close(link_des) )
      return( -1 );
DEB(fprintf(stderr,"\nclose: CLOSE DONE\n"));
   ActiveLink = NULL_LINK;
   return(TRUE);
}




/*
 *
 *   ReadLink
 *
 *   Read `Count' chars into `Buffer' from the specified link.
 *   LinkId is a vaild link identifier, opened with OpenLink.
 *   `Timeout' is a non negative integer representing tenths
 *   of a second.  A `Timeout' of zero is an infinite timeout.
 *   The timeout is for the complete operation.
 *   If `Timeout' is positive then ReadLink may return having
 *   read less that the number of chars asked for.
 *   Returns the number of chars placed in `Buffer' (which may
 *   be zero) or negative to indicate an error.
 *
 */


int ReadLink ( LinkId, Buffer, Count, Timeout )
   LINK LinkId;
   char *Buffer;
   unsigned int Count;
   int Timeout;
{
int n,i;

/* DEB(fprintf(stderr,"\nread: CHIAMATA\n")); */
   if ( LinkId != ActiveLink )
      return( -1 );

/* TODO controllare che il device sia aperto */

   if ( Count < 1 )
      return( -2 );

   if (10*Timeout != gTimeout) {
	gTimeout = 10* Timeout;
 	ioctl(link_des, B004TIMEOUT, &gTimeout); 
DEB(fprintf(stderr,"\nRead Set Timeout = %d\n",gTimeout));
   }

/* DEB(fprintf(stderr,"\nread: READING %d BYTES\n",Count)); */

   n = read( link_des, Buffer, (int)Count);

DEB(fprintf(stderr,"read: READ %d BYTES\n",n));
if(n!=Count)DEB(fprintf(stderr,"\nread: XXXXXXXXXX TIMEOUT XXXXXXXXXXXXXXXXX"));
DEB2(if(n<30){fprintf(debfil,"read: (("); \
for(i=0;i<n;i++)fputc(Buffer[i],debfil); \
for(i=0;i<n;i++)fprintf(debfil," %d",(int)Buffer[i]); \
fprintf(debfil,"\n");})

return n;
   

}



/*
 *   Write Link
 */

int WriteLink ( LinkId, Buffer, Count, Timeout )
   LINK LinkId;
   char *Buffer;
   unsigned int Count;
   int Timeout;
{
int n,i;
/* DEB(fprintf(stderr,"\nwrite: CHIAMATA\n")); */

   if ( LinkId != ActiveLink )
      return( -1 );

/* TODO controllare che il device sia aperto */

   if ( Count < 1 )
      return( -2 );

   if (10*Timeout != gTimeout) {
	gTimeout =  10*Timeout;
/*	ioctl(link_des, B004TIMEOUT, &gTimeout); */
DEB(fprintf(stderr,"\nWrite Set Timeout = %d\n",gTimeout));
   }

/* DEB(fprintf(stderr,"\nwrite: WRITING %d BYTES\n",Count)); */
   n = write( link_des, Buffer, (size_t)Count);
DEB(fprintf(stderr,"write: WROTE %d BYTES\n",n));
DEB2(if(n<30){fprintf(debfil,"write: (("); \
for(i=0;i<n;i++)fputc(Buffer[i],debfil); \
for(i=0;i<n;i++)fprintf(debfil," %d",(int)Buffer[i]); \
fprintf(debfil,"\n");})


   return(n);

}




/*
 *   Reset Link
 */

PUBLIC int ResetLink ( LinkId )
   LINK LinkId;
{
   int i;

DEB(fprintf(stderr,"\nResetLink: CHIAMATA\n"));
   if ( LinkId != ActiveLink )
      return( -1 );

/* TODO controllare che il device sia aperto */

   i=ioctl( link_des, B004RESET );
DEB(fprintf(stderr,"\nResetLink: RES = %d\n",i));

   return( 1 );
}

/*
 *   Analyse Link
 */
 
PUBLIC int AnalyseLink ( LinkId )
   LINK LinkId;
{
   int i;
DEB(fprintf(stderr,"\nAnalyseLink: CHIAMATA\n"));

   if ( LinkId != ActiveLink )
      return( -1 );

/* TODO controllare che il device sia aperto */

   i=ioctl( link_des, B004ANALYSE );
DEB(fprintf(stderr,"\nAnalyseLink: RES = %d\n",i));

   return( 1 );
}



/*
 *   Test Error
 */
 
PUBLIC int TestError ( LinkId )
   LINK LinkId;
{
int res;
/* DEB(fprintf(stderr,"\nTestError: CHIAMATA\n")); */
   if ( LinkId != ActiveLink )
      return( -1 );

/* TODO controllare che il device sia aperto */

   ioctl( link_des, B004ERROR, &res );
DEB(fprintf(stderr,"TestError: RES = %d\n",res));

  return( res );
}




/*
 *   Test Read
 */

PUBLIC int TestRead ( LinkId )
   LINK LinkId;
{
int res;
DEB(fprintf(stderr,"\nTestRead: CHIAMATA\n"));
   if ( LinkId != ActiveLink )
      return( -1 );

/* TODO controllare che il device sia aperto */

   ioctl( link_des, B004READABLE, (char *)&res );
DEB(fprintf(stderr,"\nTestRead: RES = %d\n",res));

   return( res ); 
}




/*
 *   Test Write
 */

PUBLIC int TestWrite ( LinkId )
   LINK LinkId;
{
int res;
DEB(fprintf(stderr,"\nTestWrite: CHIAMATA\n"));
   if ( LinkId != ActiveLink )
      return( -1 );

/* TODO controllare che il device sia aperto */

   ioctl( link_des, B004WRITEABLE, &res );
DEB(fprintf(stderr,"\nTestWrite: RES = %d\n",res));

   return( res );
}



/*
 *   Eof
 */


