/***********************************************
 *
 * File: iserver.h
 *
 * 09-sep-94 lv
 *   added SPEED_DEB
 */
/*
 -- ---------------------------------------------------------------------------
 --
 --      ISERVER  -  INMOS standard file server
 --
 --      iserver.h
 --
 --      Server definitions
 --
 --      (c) Copyright INMOS Limited, 1988, 1989.
 --      All Rights Reserved.
 --
 --   26-May-91 lr
 --     added better support for Unix versions
 --
 -- ---------------------------------------------------------------------------
*/

#ifndef _INMOS_H
#  include "inmos.h"
#endif

/* #define USE_ISERVER_PROTO */
#define PROGRAM_NAME  "iserver"
#define VERSION_NAME  "DEIT 1.41E, 01 December 1992"
/* VERSION_NAME was "1.41, 13 April 1989" */
#define VERSION_ID     14




#define TRANSACTION_BUFFER_SIZE	512	/*  size of transaction object  */
#define MAX_SLICE_LENGTH	(TRANSACTION_BUFFER_SIZE - 2 - 1)
	/*  largest data item in Tbuf  */

#define BOOT_BUFFER_LENGTH	(1024 * 8)

#define CORE_SIZE		(1024 * 8)	/*  peeked at analyse  */
#define TIMEOUT			(5)	/*  basic trans. timeout in 1/10 sec */
#define BOOT_TIMEOUT		(10)

#define MAX_COMMAND_LINE_LENGTH   512
#define MAX_BOOT_FILE_LENGTH      256
#define MAX_LINK_NAME_LENGTH      64




/*  primary server operation tags  */

#define SP_ZERO        0

#define SP_OPEN       10	/*  filec.c  */
#define SP_CLOSE      11
#define SP_READ       12
#define SP_WRITE      13
#define SP_GETS       14
#define SP_PUTS       15
#define SP_FLUSH      16
#define SP_SEEK       17
#define SP_TELL       18
#define SP_EOF        19
#define SP_FERROR     20
#define SP_REMOVE     21
#define SP_RENAME     22
#define SP_GETBLOCK   23
#define SP_PUTBLOCK   24


#define SP_GETKEY     30	/*  hostc.c  */
#define SP_POLLKEY    31
#define SP_GETENV     32
#define SP_TIME       33
#define SP_SYSTEM     34
#define SP_EXIT       35

#define SP_COMMAND    40	/*  serverc.c  */
#define SP_CORE       41
#define SP_ID         42

#define SP_MSDOS      50	/*  msdos.c  */

#define SP_SUN        60
#define SP_MSC        61
#define SP_VMS        62

#ifdef SPEED_DEB
#define SP_SPEED_DEB_IN  70	/*  server.c */
#define SP_SPEED_DEB_OUT 71	/*  server.c */
#endif

#define SP_ALSYS      100	/* Not used by inmos iserver */
#define SP_KPAR       101	/* Not used by inmos iserver */


/*  INMOS reserves all numbers up to 127  */




#define SP_SUCCESS 0		/*  operation results  */
#define SP_UNIMPLEMENTED 1
#define SP_ERROR 129


#define ER_LINK_BAD  (-1)	/*  Failure codes for LinkOpen */
#define ER_LINK_CANT (-2)



/*  machine specific stuff */

#if VMS | MSC
#  define SWITCH_CHAR '/'
#else
#  define SWITCH_CHAR '-'
#  if SUN3 | IRIS | VAX | MIPS | SPARC | NEXT | __FreeBSD__
#    define UNIX 1
#  else
#    define UNDEFINED_HOST 1
#  endif
#endif


/*  exit status  */
#ifdef VMS
#  define HUNKY_DORY (1)
#  define BAD_KARMA (42)
#else
#  define HUNKY_DORY (0)
#  define BAD_KARMA (1)
#endif

#ifdef MSC	/*  DOS cant redirect stderr  */
#  define STANDARD_ERROR stdout
#else
#  define STANDARD_ERROR stderr
#endif




	/*  all this is for SpId  */
#define BOX_X       0
#define BOX_PC      1
#define BOX_NEC     2
#define BOX_VAX     3
#define BOX_SUN3    4
#define BOX_S370    5
#define BOX_SUN4    6
#define BOX_SUN386  7
#define BOX_APOLLO  8
#define BOX_ATARI   9

#define BOX_MIPS    10
#define BOX_SPARC   BOX_SUN4
#define BOX_NEXT    11

#define OS_X      0
#define OS_DOS    1
#define OS_HELIOS 2
#define OS_VMS    3
#define OS_SUN40  4
#define OS_CMS    5
#define OS_TOS    6
#define OS_IRIX   OS_TOS

/* Each OS should have a unique name. But ilink is braindead and
 * pretends every UNIX must be a SUN
 */

#define OS_ULTRIX OS_SUN40
#define OS_NEXT   OS_SUN40

#ifdef SUN3
#  define BIG_ENDIAN 1
#  define HOST       "Sun3/SunOS4.0"
#  define HOST_ID    BOX_SUN3
#  define OS_ID      OS_SUN40
#endif

#ifdef SPARC
#  define BIG_ENDIAN 1
#  define HOST       "SUNSparc/SunOS4.1"
#  define HOST_ID    BOX_SPARC
#  define OS_ID      OS_SUN40
#endif

#ifdef NEXT
#  define BIG_ENDIAN 1
#  define HOST       "NeXT..."
#  define HOST_ID    BOX_NEXT
#  define OS_ID      OS_NEXT
#endif

#ifdef VAX
#  define HOST       "uVAX/Ultrix2.2.1"
#  define HOST_ID    BOX_VAX
#  define OS_ID      OS_ULTRIX
#endif

#ifdef MIPS
#  define HOST       "DECStation2100/Ultrix4.1"
#  define HOST_ID    BOX_SUN4 /*stupid Inmos tools... */
#  define OS_ID      OS_ULTRIX
#endif

#ifdef __FreeBSD__
#  define HOST       "PC/FreeBSD"
#  define HOST_ID    BOX_SUN4 /*stupid Inmos tools... */
#  define OS_ID      OS_ULTRIX
#endif

#ifdef IRIS
#  define BIG_ENDIAN 1
#  define HOST       "IRIS/IRIX-3.1"
#  define HOST_ID    BOX_IRIS
#  define OS_ID      OS_IRIX
#endif

#ifdef MSC
#  ifdef NEC
#    define HOST     "NEC-PC/MS-DOS"
#  else
#    define HOST     "IBM-PC/MS-DOS"
#  endif
#  define HOST_ID    BOX_PC
#  define OS_ID      OS_DOS
#endif

#ifdef VMS
#  define HOST       "VAX/VMS"
#  define HOST_ID    BOX_VAX
#  define OS_ID      OS_VMS
#endif

#ifdef HELIOS
#  define HOST       "HELIOS 1.0"
#  define HOST_ID    BOX_X
#  define OS_ID      OS_HELIOS
#endif

#ifndef HOST_ID
#  define HOST       "???"
#  define HOST_ID    BOX_X
#endif

#ifndef OS_ID
#  define OS_ID      OS_X
#endif

#define HW_X      0
#define B004      1
#define B008      2 
#define B010      3
#define B011      4
#define B014      5
#define DRX11     6
#define QT0       7
#define B015      8
#define IBM_CAT   9
#define B016      10
#define VMTM      10	/* old stuff */
#define UDP       11

#define ACSILA    13
#define PCS       14

#ifndef BOARD_ID
#  define BOARD_ID   HW_X
#endif

#define BOARD_NAMES {	"???",	"B004",	"B008",	"B010",	"B011", "B014", "DRX11", "QT0", "B015", "IBM_CAT", "Parsytec VMTM", "UDP", "?? 12 ??", "ACSILA", "DEIT pcserver"}



/*  some global inlines  */

#define DEBUG(x) { if (CocoPops) {\
	fputs("(", stdout); printf x; fputs(")", stdout);\
	fputc((VerboseSwitch ? '\n' : ' '), stdout); fflush(stdout); } }

#define INFO(x) { if (VerboseSwitch) printf x ; fflush(stdout); }

#define SE STANDARD_ERROR

#define ABORT(x) { fprintf(STANDARD_ERROR, "\nError - %s - ", PROGRAM_NAME);\
	fprintf x; fputs(".\n",STANDARD_ERROR);\
	if (TheLink != -1 ) CloseLink(TheLink); HostEnd(); exit(BAD_KARMA); }


	/*  exit status  */

#ifndef VMS
#  ifndef EXIT_SUCCESS
#  define EXIT_SUCCESS (0)
#  endif
#  ifndef EXIT_FAILURE
#  define EXIT_FAILURE (1)
#  endif
#  define EXIT_USERBREAK (2)
#  define EXIT_ERRORFLAG (3)
#  define EXIT_BAD (4)
#else
#  define EXIT_SUCCESS (1)
#  define EXIT_FAILURE (4)
#  define EXIT_USERBREAK (10)
#  define EXIT_ERRORFLAG (2)
#  define EXIT_BAD (12)
#endif
/* #define MAX_SP_NUMBER_LENGTH      2 */

/*** end of file - iserver.h ***/
