/*
 --  ---------------------------------------------------------------------------
 --
 --      ISERVER  -  INMOS standard file server
 --
 --      hostc.c
 --
 --      Primary environment operations
 --
 --      Copyright (c) INMOS Ltd., 1988.
 --      All Rights Reserved.
 --
 --	derived from 1.41 - removed UDP support, added MIPS etc.
 --	29-sep-92 lr	some cleanup
 --	21-Jul-92 lr
 --	   warning: polling the keyboard stops the server for 0.1 sec
 --	   if no keys are present.
 --	   Terminal I/O still flaky
 --	05-Jun-92 lr
 --	   now tty support works better ?
 --  ---------------------------------------------------------------------------
*/



#include <stdio.h>
#include <string.h>
#include <time.h>
#include <stdlib.h>

#define LORE_MOD

#if SUN3 | SPARC
#  include <sys/termios.h>
#endif

#if VAX | MIPS | NEXT
#  include <sys/termio.h>
#  include <sgtty.h>
#  include <fcntl.h>
#endif

#if __FreeBSD__
#  include <sys/termios.h>
#  include <sys/ioctl.h>
/* #  include <sgtty.h> */
/* #  include <fcntl.h> */
#endif

#ifdef IRIS
#  include <sys/termio.h>
#  include <fcntl.h>
int filecrtl;
#endif

#ifdef VMS
#include <ssdef.h>
#include <iodef.h>
#include <descrip.h>
#include <ssdef.h>
#include <psldef.h>
#endif

#ifdef HELIOS
#include <nonansi.h>
#include <stdlib.h>
#include <attrib.h>
#endif

#include "inmos.h"
#include "iserver.h"
#include "pack.h"


EXTERN BOOL CocoPops;		/*  for DEBUG  */
EXTERN BOOL VerboseSwitch;

EXTERN BYTE Tbuf[TRANSACTION_BUFFER_SIZE];

EXTERN int TheLink;

PRIVATE BYTE DataBuffer[MAX_SLICE_LENGTH+1];
PRIVATE int Size;

#define ORG_MODE 0
#define GET_MODE 1
#define POLL_MODE 2

PRIVATE BOOL TermMode = ORG_MODE;

#if SUN3 | SPARC | __FreeBSD__
PRIVATE struct termios OrgMode, CurMode;
#endif

#if  VAX | MIPS | NEXT
PRIVATE struct termio OrgMode, CurMode;
int origdisc; /* line discipline in use at beginning */
#endif

#if IRIS
PRIVATE struct termio OrgMode, CurMode;
#endif

#ifdef HELIOS
PRIVATE Attributes CurAttributes, OrgAttributes;
PRIVATE Stream *InputStream;
#endif

#ifdef VMS       
PRIVATE short int InputChan;	/*  declare channel  */
$DESCRIPTOR( InputDescriptor, "TT:" ); /*  and descriptor for input  */

PRIVATE struct IOSB_DESC {
               short int Status;
               short int Count;
               int DeviceInfo;
        } iosb_desc;
#endif




PUBLIC VOID
HostEnd()
{
#if SUN3 | SPARC
   ioctl(0,TCSETS,&OrgMode);
#endif
#if VAX | MIPS | NEXT 
   ioctl(0,TCSETA,&OrgMode);
#endif
#if __FreeBSD__
#ifdef LORE_MOD
   ioctl(0,TIOCSETA,&OrgMode);
#else
   ioctl(0,TIOCSETP,&OrgMode);
#endif
#endif
#ifdef IRIS
   ioctl(0,TCSETA,&OrgMode);
   fcntl(0,F_GETFL,filecrtl);
   fcntl(0,F_SETFL,filecrtl&~O_NDELAY);
#endif
#ifdef HELIOS
   SetAttributes( InputStream, &CurAttributes );
#endif
}


PUBLIC VOID
ResetTerminal()
{
   if ( TermMode != ORG_MODE ) {
         HostEnd();
         TermMode = ORG_MODE;
   }
}


PUBLIC VOID
HostBegin()
{
#if SUN3 | SPARC
   ioctl(0,TCGETS,&OrgMode);
   ioctl(0,TCGETS,&CurMode);
#endif

#if VAX | MIPS | NEXT | IRIS
   ioctl(0,TCGETA,&OrgMode);
   ioctl(0,TCGETA,&CurMode);
#endif

#if __FreeBSD__
#ifdef LORE_MOD
   ioctl(0,TIOCGETA,&OrgMode);
   ioctl(0,TIOCGETA,&CurMode);
   CurMode.c_oflag |= ONLCR;
   ioctl(0,TIOCSETA,&CurMode);
#else
#endif
   /* ioctl(0,TIOCGETP,&OrgMode);
   ioctl(0,TIOCGETP,&CurMode); */
#endif

#ifdef HELIOS
   InputStream = fdstream(0);
   GetAttributes( InputStream, &OrgAttributes );
   GetAttributes( InputStream, &CurAttributes );
#endif

#ifdef VMS
   if (sys$assign(&InputDescriptor,&InputChan,PSL$C_USER,0) != SS$_NORMAL ) {
         DEBUG((SE, "cannot sys$assign TT:"));
   }
#endif

}




/*
 *   GetAKey
 */

PUBLIC BYTE
GetAKey()
{
   BYTE c;

#if VAX | MIPS | NEXT | IRIS | __FreeBSD__
   if ( TermMode != GET_MODE ) {
         /* CurMode.c_iflag &= ~ICRNL; */
         CurMode.c_lflag &= ~(ICANON | ECHO);
         CurMode.c_cc[VTIME] = 0;
         CurMode.c_cc[VMIN] = 1;
#if __FreeBSD__
#ifdef LORE_MOD
	ioctl(0,TIOCSETA,&CurMode);
#else
	ioctl(0,TIOCSETP,&OrgMode);
#endif
#else
         ioctl( 0, TCSETA, &CurMode );
#endif
         TermMode = GET_MODE;
   }
   (void)read(0, &c, 1);
#endif
#if SUN3 | SPARC
   if ( TermMode == ORG_MODE ) {
         CurMode.c_iflag &= ~ICRNL;
         CurMode.c_lflag &= ~(ICANON | ECHO);
         CurMode.c_cc[VTIME] = 0;
         CurMode.c_cc[VMIN] = 1;
         ioctl( 0, TCSETS, &CurMode );
         TermMode = GET_MODE;
   } else if ( TermMode == POLL_MODE ) {
         CurMode.c_cc[VTIME] = 0;
         CurMode.c_cc[VMIN] = 1;
         ioctl( 0, TCSETS, &CurMode );
         TermMode = GET_MODE;
   }
   (void)read(0, &c, 1);
#endif
#ifdef MSC
   c = getch();
#endif
#ifdef HELIOS
   if ( TermMode == ORG_MODE ) {
         RemoveAttribute(&CurAttributes,ConsoleEcho);
         AddAttribute(&CurAttributes,ConsoleRawInput);
         SetAttributes(InputStream,&CurAttributes);
         TermMode = GET_MODE;
   }
   (void)Read(InputStream, &c, 1, -1);
#endif
#ifdef VMS
    (void)SYS$QIOW(0, InputChan, (IO$_READVBLK | IO$M_NOECHO | IO$M_NOFILTR ),
   	 &iosb_desc, 0, 0, &c, 1, 0, 0L, 0, 0);
#endif

   return(c);
}




/*
 *   SpGetKey
 */

PUBLIC VOID
SpGetkey()
{
   BUFFER_DECLARATIONS;
   BYTE c;

   DEBUG(( "SP.GETKEY" ));
   INIT_BUFFERS;

   c = GetAKey();

   DEBUG(("key was %c",c));
   PUT_BYTE( SP_SUCCESS );
   PUT_BYTE( c );  
   REPLY;
}




/*
 *   SpPollkey
 */

PUBLIC VOID
SpPollkey()
{
   BUFFER_DECLARATIONS;
   char c ;
#ifdef VMS
   struct CHARACTERISTICS {
            short  Count;
            char   ch;
            char   res1;
            long   res2;
   } Chars;
#endif /* VMS */

   DEBUG(( "SP.POLLKEY" ));
   INIT_BUFFERS;

#ifdef MSC
   if ( kbhit() ) {
         c = getch();
         PUT_BYTE( SP_SUCCESS );
         PUT_BYTE( c );  
   } else {
         PUT_BYTE( SP_ERROR );
   }
#endif /* MSC */
#if UNIX
#if VAX | MIPS | NEXT | IRIS | __FreeBSD__
   if ( TermMode != POLL_MODE ) {
         /* CurMode.c_iflag &= ~ICRNL; */
         CurMode.c_lflag &= ~(ICANON | ECHO);
         CurMode.c_cc[VTIME] = 1;
         CurMode.c_cc[VMIN] = 0;
#if __FreeBSD__
#ifdef LORE_MOD
	ioctl(0,TIOCSETA,&CurMode);
#else
	ioctl(0,TIOCSETP,&OrgMode);
#endif
#else
         ioctl( 0, TCSETA, &CurMode );
#endif
         TermMode = POLL_MODE;
   }
#endif /* IRIS etc. */
#if SUN3 | SPARC
   if ( TermMode == ORG_MODE ) {
         CurMode.c_iflag &= ~ICRNL;
         CurMode.c_lflag &= ~(ICANON | ECHO);
         CurMode.c_cc[VTIME] = 1;
         CurMode.c_cc[VMIN] = 0;
         ioctl( 0, TCSETS, &CurMode );
         TermMode = POLL_MODE;
   } else if ( TermMode == GET_MODE ) {
         CurMode.c_cc[VTIME] = 1;
         CurMode.c_cc[VMIN] = 0;
         ioctl( 0, TCSETS, &CurMode );
         TermMode = POLL_MODE;
   }
#endif /* SUN | SPARC */
   if ( read(0, &c, 1) == 0 ) {
         PUT_BYTE( SP_ERROR );
   } else {
         PUT_BYTE( SP_SUCCESS );
         PUT_BYTE( c );  
   }
#endif /* UNIX */

#ifdef VMS
   (void)SYS$QIOW( 0, InputChan, (IO$_SENSEMODE | IO$M_TYPEAHDCNT ),
  	 &iosb_desc, 0, 0, &Chars, sizeof(struct CHARACTERISTICS),
	 0, 0, 0, 0 ) ;
   if ( Chars.Count > 0 ) {
         (void)SYS$QIOW( 0, InputChan,
		 (IO$_READVBLK | IO$M_NOECHO | IO$M_NOFILTR ), &iosb_desc,
		 0, 0, &c, 1, 0, 0L, 0, 0 );
         PUT_BYTE( SP_SUCCESS );
         PUT_BYTE( c );  
   } else {
         PUT_BYTE( SP_ERROR );
   }
#endif /* VMS */
#ifdef HELIOS
   if ( TermMode == ORG_MODE ) {
         RemoveAttribute(&CurAttributes,ConsoleEcho);
         AddAttribute(&CurAttributes,ConsoleRawInput);
         AddAttribute(&CurAttributes,ConsoleBreakInterrupt);
         SetAttributes(InputStream,&CurAttributes);
         TermMode = POLL_MODE;
   }
   if ( Read( InputStream, &c, 1, OneSec/10 ) == 1 ) {
         PUT_BYTE( SP_SUCCESS );
         PUT_BYTE( c );  
   } else {
         PUT_BYTE( SP_ERROR );
   }
#endif
   REPLY;

}




/*
 *   SpGetenv
 */

PUBLIC VOID
SpGetenv()
{
   BUFFER_DECLARATIONS;
   BYTE *Name;

   DEBUG(( "SP.GETENV" ));
   INIT_BUFFERS;

   Name = &DataBuffer[0];
   GET_SLICE( Size, Name );
   *(Name+Size)=0;
   DEBUG(( "\"%s\"", Name ));

   if( *Name == 0 ) {
         PUT_BYTE( SP_ERROR );
   } else {
         if( ( Name=(BYTE *)getenv( Name ) ) == NULL ) {
               PUT_BYTE( SP_ERROR );
         } else {
               DEBUG(( "\"%s\"", Name ));
               PUT_BYTE( SP_SUCCESS );
               Size = strlen( Name );
               PUT_SLICE( Size, Name );
         }
   }
   REPLY;
}



/*
 *   SpTime
 */

PUBLIC VOID
SpTime()
{
   BUFFER_DECLARATIONS;
   long Time, UTCTime;

   DEBUG(( "SP.TIME" ));
   INIT_BUFFERS;

#ifdef MSC   
   tzset();
   time( &UTCTime );
   Time = UTCTime - timezone;
   PUT_BYTE( SP_SUCCESS );
   PUT_INT32( Time );
   PUT_INT32( UTCTime );
   REPLY;
#endif

#if UNIX | HELIOS | VMS
   time( &Time );
   UTCTime = 0L;
   PUT_BYTE( SP_SUCCESS );
   PUT_INT32( Time );
   PUT_INT32( UTCTime );
   REPLY;
#endif

}




/*
 *   SpSystem
 */

PUBLIC VOID
SpSystem()
{
   BUFFER_DECLARATIONS;
   BYTE *Command;
   INT32 Status;

   DEBUG(( "SP.SYSTEM" ));
   INIT_BUFFERS;

#ifndef UNKNOWN_HOST
   Command = &DataBuffer[0];
   GET_SLICE(Size,Command );
   *(Command+Size)=0; DEBUG(( "\"%s\"", Command ));
   Status = system( Command );
   DEBUG(( "status %ld", Status ));
   PUT_BYTE( SP_SUCCESS );
   PUT_INT32( Status );
   REPLY;
#else
   PUT_BYTE( SP_UNIMPLEMENTED );
   REPLY;
#endif

}




/*
 *   SpExit
 */

PUBLIC int
SpExit()
{
   BUFFER_DECLARATIONS;
   long Status;
   
   DEBUG(( "SP.EXIT" ));
   INIT_BUFFERS;
   
   GET_INT32( Status );
   DEBUG(( "%ld", Status ));

   if( Status == 999999999 ) Status = HUNKY_DORY;
   if( Status == -999999999 ) Status = BAD_KARMA;

   DEBUG(( "exit with %d", (int)Status ));

   PUT_BYTE( SP_SUCCESS );
   REPLY ( (int)Status );
}

/*
 *   Eof
 */
