 {$A+} { word align data  } {$B-} { non-complete boolean evaluation }
 {$D-} { no debug info    } {$L+} { no localsymbols 		    }
 {$O+} { overlay allowed  } {$N-} { no Coprocessor needed 	    }
 {$R-} { no rangechecking } {$E-} { no Emulation needed             }

unit DisAsm;

{ STS :=(Steffen Seeger, e-Mail: seeger@physik.tu-chemnitz.de)

  History: 17-03-93 -STS- file creation, TDisassembler
   26-05-93 -STS- CodePos pointer and options field added
	   JAN-94   -STS- first public release
 Description
 
  * TDisassembler - Disassembler object for Txxx transputer
     constructor Init;
      - initialises TDisassembler by clearing operand and CodePos
        and setting options to default doAll

     destructor Done;  virtual;
      - does simply nothing but is necessary for dynamic instacnes
	of TDisassembler

     function getByte:byte; virtual;
      - is called by getInstruction to get the next byte to
        be disassembled, MUST be overwritten!

     function getInstruction:string;  virtual;
      - reads codebytes until
         (a) a direct (except nfix and pfix) instruction is recognized
         (b) 8 codebytes read and no instruction recognized
      - returns a string with a maxiumum length of 80 characters
        containing a hexdump of the codebytes read, the current CodePos
        before getInstruction was called and the mnemonic of the
        recognized instruction (depending on the options field),
        '???' if no intruction found or a bad operand code occured

     procedure SetCodePos; virtual;
      - set new code-(instruction) pointer
      - implemented to access private CodePos

     options:word;
      - determines the output format of the disasembled code:
	bit  function
	 0	add code bytes of disassembled code to the result string
	 1	add the hex value of the current CodePos-ptr to the result
         2	if set, write operands for direct functions as hex numbers,
		otherwise they will be decimal (has no effect on call,j,cj
		if doCodepos is set because CodePos (physical address-)
		values will all be hex)
}

interface

const doCodeBytes = 1;
      doCodePos   = 2;
      doHexOperand= 4;
      doAll       = 7;

type PDisassembler=^TDisassembler;
     TDisassembler=object
                    options:word;
                    constructor Init;
                    destructor Done;                            virtual;
                    function getByte:byte;                      virtual;
                    function getInstruction:string;             virtual;
                    procedure SetCodePos(NewPos:longint);       virtual;
                   private
                    operand,
                    codepos:longint;
                    function decode(code:byte):byte;            virtual;
                   end;

implementation


 uses hex;

 const Mnemonic: array[0..15] of string[5] =
                  ('j    ','ldlp ','pfix ','ldnl ',
                   'ldc  ','ldnlp','nfix ','ldl  ',
                   'adc  ','call ','cj   ','ajw  ',
                   'eqc  ','stl  ','stnl ','opr  ');

 function GetOprMnemo(Opr:LongInt):string; near; external;
  {$L DISASM.OBJ }

 constructor TDisassembler.Init;
  begin operand:=0; codepos:=0; options:= doAll; end;

 destructor TDisassembler.Done;
  begin end;

 function TDisassembler.decode(Code:byte):byte; assembler;
  asm      les   di,Self                 { load Self-pointer                 }
           mov   ax,word ptr Code
           mov   ah,al                   { load code byte and copy to AH     }

           and   ax,$F00F                { get fncode in AH and data in AL   }
           shr   ah,4                    { this code will be returned        }
                                         { load operandreg into CX:BX        }
           mov   bx,word ptr es:[di  ].TDisassembler.Operand
           mov   cx,word ptr es:[di+2].TDisassembler.Operand

           shl   bx,1; rcl   cx,1        { shift CX:BX up 4 Bit              }
           shl   bx,1; rcl   cx,1
           shl   bx,1; rcl   cx,1
           shl   bx,1; rcl   cx,1
           or    bl,al                   { put data-part of Code to oprerand }

           cmp   ah,$06                  { nfix instruction ?                }
           jne   @nnfix
           not   bx                      { if so, complement operandreg      }
           not   cx
                                         { restore operandreg                }
   @nnfix: mov   word ptr es:[di  ].TDisassembler.Operand,bx
           mov   word ptr es:[di+2].TDisassembler.Operand,cx
           mov   al,ah                   { load result into AL, that's all ! }
  end;

 function TDisassembler.GetInstruction:string;
  var res,h:string[80];
      codeByte,bcnt:byte;
      ende,code:boolean;
  begin
   fillChar(res,SizeOf(res),' '); bcnt:=0;
   if (options and doCodePos)>0
    then res:=HexLong(CodePos)+': '
    else res:='';
   code:= (options and doCodeBytes)>0;
   repeat
    CodeByte := GetByte; inc(bcnt);
    if code then res:= res+hexbyte(CodeByte);
    CodeByte := Decode(CodeByte);
    ende     := (((1 shl CodeByte) and $FFBB)>0);
   until (bcnt=8) or ende;
   inc(CodePos,bcnt);
   if (options and doCodeBytes)>0 then bcnt:=18 else bcnt:=0;
   if (options and doCodePos  )>0 then bcnt:=bcnt+10;
   res[0]:=chr(bcnt);
   if ende then begin
    if (CodeByte=$0F)
     then GetInstruction:=res+GetOprMnemo(operand)
     else
      if CodeByte in [$00,$09,$0A]
       then
	if (options and doCodePos)>0
	 then GetInstruction:= res+Mnemonic[CodeByte]+
			       ' $'+HexLong(operand+CodePos)
	 else
	  if (options and doHexOperand)>0
	   then GetInstruction:= res+Mnemonic[CodeByte]+
			       ' $'+HexLong(operand)
	   else begin str(operand,h);
		GetInstruction:=res+Mnemonic[CodeByte]+' '+h;
	   end
       else
	if (options and doHexOperand)>0
	 then GetInstruction:=res+Mnemonic[CodeByte]+' $'+HexLong(operand)
	 else begin str(operand,h);
		    GetInstruction:=res+Mnemonic[CodeByte]+' '+h; end;
    Operand:=0;
   end else GetInstruction:=res+'???';
  end;

 function TDisassembler.GetByte:byte; assembler;
  asm mov al,$20 end;

 procedure TDisassembler.SetCodePos(NewPos:longint);
  begin CodePos:=NewPos; end;

end.
