;
;
; Disassembler module for INMOS Txxx transputer (OPR instruction only)
;  written by Steffen Seeger using BORLAND PASCAL 7.0
;
;
;
; History: 12-03-93 -STS- filecreation
;          06-03-93 -STS- adaption to TASM 'Ideal' mode
;
;

IDEAL	; TASM IDEAL mode
LOCALS  ; local symbols enabled
WARN    ; warnings on
P286N   ; 286 instruction set

;

PUBLIC	GETOPRMNEMO

SEGMENT	CODE PARA PUBLIC

   MnemoTable:	_rev           DB   3,'rev'	; this table holds all the
		_lb            DB   2,'lb'	; asm mnemo-strings
		_bsub          DB   4,'bsub'
		_endp          DB   4,'endp'
		_diff          DB   4,'diff'
		_add           DB   3,'add'
		_gcall         DB   5,'gcall'
		_in            DB   2,'in'
		_prod          DB   4,'prod'
		_gt            DB   2,'gt'
		_wsub          DB   4,'wsub'
		_out           DB   3,'out'
		_sub           DB   3,'sub'
		_startp        DB   6,'startp'
		_outbyte       DB   7,'outbyte'
		_outword       DB   7,'outword'
		_seterr        DB   6,'seterr'

		_resetch       DB   7,'resetch'
		_csub0         DB   5,'csub0'

		_stopp         DB   5,'stopp'
		_ladd          DB   4,'ladd'
		_stlb          DB   4,'stlb'
		_sthf          DB   4,'sthf'
		_norm          DB   4,'norm'
		_ldiv          DB   4,'ldiv'
		_ldpi          DB   4,'ldpi'
		_stlf          DB   4,'stlf'
		_xdble         DB   5,'xdble'
		_ldpri         DB   5,'ldpri'
		_rem           DB   3,'rem'
		_ret           DB   3,'ret'
		_lend          DB   4,'lend'
		_ldtimer       DB   7,'ldtimer'

		_testerr       DB   7,'testerr'
		_testpranal    DB  10,'testpranal'
		_tin           DB   3,'tin'
		_div           DB   3,'div'

		_dist          DB   4,'dist'
		_disc          DB   4,'disc'
		_diss          DB   4,'diss'
		_lmul          DB   4,'lmul'
		_not           DB   3,'not'
		_xor           DB   3,'xor'
		_bcnt          DB   4,'bcnt'
		_lshr          DB   4,'lshr'
		_lshl          DB   4,'lshl'
		_lsum          DB   4,'lsum'
		_lsub          DB   4,'lsub'
		_runp          DB   4,'runp'
		_xword         DB   5,'xword'
		_sb            DB   2,'sb'
		_gajw          DB   4,'gajw'
		_savel         DB   5,'savel'
		_saveh         DB   5,'saveh'
		_wcnt          DB   4,'wcnt'
		_shr           DB   3,'shr'
		_shl           DB   3,'shl'
		_mint          DB   4,'mint'
		_alt           DB   3,'alt'
		_altwt         DB   5,'altwt'
		_altend        DB   6,'altend'
		_and           DB   3,'and'
		_enbt          DB   4,'enbt'
		_enbc          DB   4,'enbc'
		_enbs          DB   4,'enbs'
		_move          DB   4,'move'
		_or            DB   2,'or'
		_csngl         DB   5,'csngl'
		_ccnt1         DB   5,'ccnt1'
		_talt          DB   4,'talt'
		_ldiff         DB   5,'ldiff'
		_sthb          DB   4,'sthb'
		_taltwt        DB   6,'taltwt'
		_sum           DB   3,'sum'
		_mul           DB   3,'mul'
		_sttimer       DB   7,'sttimer'
		_stoperr       DB   7,'stoperr'
		_cword         DB   5,'cword'
		_clrhalterr    DB  10,'clrhalterr'
		_sethalterr    DB  10,'sethalterr'
		_testhalterr   DB  11,'testhalterr'
		_dup           DB   3,'dup'
		_move2dinit    DB  10,'move2dinit'
		_move2dall     DB   9,'move2dall'
		_move2dnonzero DB  13,'move2dnonzero'
		_move2dzero    DB  10,'move2dzero'

		_unpacksn      DB   8,'unpacksn'

		_postnormsn    DB  10,'postnormsn'
		_roundsn       DB   7,'roundsn'

		_ldinf         DB   5,'ldinf'
		_fmul          DB   4,'fmul'
		_cflerr        DB   6,'cflerr'
		_crcword       DB   7,'crcword'
		_crcbyte       DB   7,'crcbyte'
		_bitcnt        DB   6,'bitcnt'
		_bitrevword    DB  10,'bitrevword'
		_bitrevnbits   DB  11,'bitrevnbits'
		_pop           DB   3,'pop'
		_timerdisableh DB  13,'timerdisableh'
		_timerdisablel DB  13,'timerdisablel'
		_timerenableh  DB  12,'timerenableh'
		_timerenablel  DB  12,'timerenablel'
		_ldmemstartval DB  13,'ldmemstartval'

		_wsubdb        DB   6,'wsubdb'
		_fpldnlbi      DB   9,'fpldnldbi'
		_fpchkerror    DB  10,'fpchkerror'
		_fpstnldb      DB   8,'fpstnldb'

		_fpldnlsni     DB   9,'fpldnlsni'
		_fpadd         DB   5,'fpadd'
		_fpstnlsn      DB   8,'fpstnlsn'
		_fpsub         DB   5,'fpsub'
		_fpldnldb      DB   8,'fpldnldb'
		_fpmul         DB   5,'fpmul'
		_fpdiv         DB   5,'fpdiv'

		_fpldnlsn      DB   8,'fpldnlsn'
		_fpremfirst    DB  10,'fpremfirst'
		_fpremstep     DB   9,'fpremstep'
		_fpnan         DB   5,'fpnan'
		_fpordered     DB   9,'fpordered'
		_fpnotfinite   DB  11,'fpnotfinite'
		_fpgt          DB   4,'fpgt'
		_fpeq          DB   4,'fpeq'
		_fpi32tor32    DB  10,'fpi32tor32'

		_fpi32tor64    DB  10,'fpi32tor64'

		_fpb32tor64    DB  10,'fpb32tor64'

		_fptesterr     DB   9,'fptesterr'
		_fprtoi32      DB   8,'fprtoi32'
		_fpstnli32     DB   9,'fpstnli32'
		_fpldzerosn    DB  10,'fpldzerosn'
		_fpldzerodb    DB  10,'fpldzerodb'
		_fpint         DB   5,'fpint'

		_fpdup         DB   5,'fpdup'
		_fprev         DB   5,'fprev'

		_fpldnladddb   DB  11,'fpldnladddb'

		_fpldnlmuldb   DB  11,'fpldnlmuldb'

		_fpldnladdsn   DB  11,'fpldnladdsn'
		_fpentry       DB   7,'fpentry'
		_fpldnlmulsn   DB  11,'fpldnlmulsn'

		_break         DB   5,'break'
		_clrj0break    DB  10,'clrj0break'
		_setj0break    DB  10,'setj0break'
		_testj0break   DB  11,'testj0break'

		_unknown       DB   3,'???'
		_lddevid       DB   7,'lddevid'

;

 EVEN 	; force IndexTable to be an even address (fast access)

 IndexTable:

     ; this table holds near pointers into MnemoTable for each operand code
     ;
     ;  x0              x1              x2              x3		|L  /
     ;  x4              x5              x6              x7		|O /
     ;  x8              x9              xA              xB		|W/
     ;  xC              xD              xE              xF		|/HIGH
     ;------------------------------------------------------------------+-----
									;
DW	_rev		,_lb		,_bsub		,_endp		; 0x
DW	_diff		,_add		,_gcall		,_in		;
DW	_prod		,_gt		,_wsub		,_out		;
DW	_sub		,_startp	,_outbyte	,_outword	;
									;
DW	_seterr		,_unknown	,_resetch	,_csub0		; 1x
DW	_unknown	,_stopp		,_ladd		,_stlb		;
DW	_sthf		,_norm		,_ldiv		,_ldpi		;
DW	_stlf		,_xdble		,_ldpri		,_rem		;
									;
DW	_ret		,_lend		,_ldtimer	,_unknown	; 2x
DW	_unknown	,_unknown	,_unknown	,_unknown	;
DW	_unknown	,_testerr	,_testpranal	,_tin		;
DW	_div		,_unknown	,_dist		,_disc		;
									;
DW	_diss		,_lmul		,_not		,_xor		; 3x
DW	_bcnt		,_lshr		,_lshl		,_lsum		;
DW	_lsub		,_runp		,_xword		,_sb		;
DW	_gajw		,_savel		,_saveh		,_wcnt		;
									;
DW	_shr		,_shl		,_mint		,_alt		; 4x
DW	_altwt		,_altend	,_and		,_enbt		;
DW	_enbc		,_enbs		,_move		,_or		;
DW	_csngl		,_ccnt1		,_talt		,_ldiff		;
									;
DW	_sthb		,_taltwt	,_sum		,_mul		; 5x
DW	_sttimer	,_stoperr	,_cword		,_clrhalterr	;
DW	_sethalterr	,_testhalterr	,_dup		,_move2dinit	;
DW	_move2dall	,_move2dnonzero	,_move2dzero	,_unknown	;
									;
DW	_unknown	,_unknown	,_unknown	,_unpacksn	; 6x
DW	_unknown	,_unknown	,_unknown	,_unknown	;
DW	_unknown	,_unknown	,_unknown	,_unknown	;
DW	_postnormsn	,_roundsn	,_unknown	,_unknown	;
									;
DW	_unknown	,_ldinf		,_fmul		,_cflerr	; 7x
DW	_crcword	,_crcbyte	,_bitcnt	,_bitrevword	;
DW	_bitrevnbits	,_pop		,_timerdisableh	,_timerdisablel	;
DW	_timerenableh	,_timerenablel	,_ldmemstartval	,_unknown	;
									;
DW	_unknown	,_wsubdb	,_fpldnlbi	,_fpchkerror	; 8x
DW	_fpstnldb	,_unknown	,_fpldnlsni	,_fpadd		;
DW	_fpstnlsn	,_fpsub		,_fpldnldb	,_fpmul		;
DW	_fpdiv		,_unknown	,_fpldnlsn	,_fpremfirst	;
									;
DW	_fpremstep	,_fpnan		,_fpordered	,_fpnotfinite	; 9x
DW	_fpgt		,_fpeq		,_fpi32tor32	,_unknown	;
DW	_fpi32tor64	,_unknown	,_fpb32tor64	,_unknown	;
DW	_fptesterr	,_fprtoi32	,_fpstnli32	,_fpldzerosn	;
									;
DW	_fpldzerodb	,_fpint		,_unknown	,_fpdup		; Ax
DW	_fprev		,_unknown	,_fpldnladddb	,_unknown	;
DW	_fpldnlmuldb	,_unknown	,_fpldnladdsn	,_fpentry	;
DW	_fpldnlmulsn	,_unknown	,_unknown	,_unknown	;
									;
DW	_unknown	,_break		,_clrj0break	,_setj0break	; Bx
DW	_testj0break	,_unknown	,_unknown	,_unknown	;

LastIndexEntry	EQU 0B7h

unknownopcode	DW	_unknown
lddevidopcode	DW	_lddevid

;

Result		EQU	bp+8
Operand		EQU	bp+4
LookTable	EQU	word ptr Indextable

	ASSUME	CS:CODE

BadOprCode:	mov	si,[unknownopcode]	; load SI with string-pointer
		jmp	SHORT reentry
		nop

oplddevid:	mov	si,[lddevidopcode]	; load SI with string-pointer
		jmp	SHORT reentry
		nop


 PROC	GETOPRMNEMO NEAR

		push	bp			; save BP
		mov	bp,sp			; load BP to adress parameters
		push	ds			; save DS

		mov	ax,cs			; MOV  DS,CS
		mov	ds,ax
		ASSUME	DS:CODE

		mov	bx,[Operand  ]		; load OperandReg into AX:BX
		mov	ax,[Operand+2]

		les	di,[result]		; load pointer to string
		or	ax,ax			; msw of operand <> 0 ?
		jnz	BadOprCode		; if it is, ! bad opr-code !
		cmp	bx,017Ch		; opr-code for lddevid ?
		je	oplddevid
		or	bh,bh			; msb of lsw of operand <> 0 ?
		jnz	BadOprCode		; if it is, ! bad opr-code !

		cmp	bx,LastIndexEntry	; if operand > LastIndexEntry
		jg	BadOprCode		;  also bad opr-code

		add	bx,bx			; if valid opr-code
		mov	si,[LookTable+bx]	; load stringoffset from table
       reentry:	xor	cx,cx			; clear CX,
		mov	cl,[ds:si]		; read length of the string,
		inc	cl			; prepare for movesb
		cld
		rep movsb			; and copy CX bytes to result
		pop	ds			; restore DS
                ASSUME  DS:NOTHING

		mov	sp,bp			; restore SP
		pop	bp			; restore BP
		ret	4			; return to caller
		nop
 ENDP 	GETOPRMNEMO

ENDS CODE

END
