/* Andy's Transputer dissassembler
 *
 * http://www.wizzy.com/wizzy/dasm.html
 *  ftp://ftp.wizzy.com/wizzy/dasm.zip
 */

char           *PROGRAM_NAME = "dasm";
#define VERSION_NUMBER	"1.30"
#define	VERSION_DATE	"28 Oct 1996"

#ifdef MSC
#include <dos.h>
#include <conio.h>
#include <stdlib.h>
#endif

#include <ctype.h>
#include <stdio.h>
#include <string.h>
#ifndef MSC
char           *getenv();
#endif

#include "opcodes.h"
#include "inmos.h"

#define LINELENGTH	27
#define	BYTELENGTH	35
#define CODELINE  5
#define DATALINE  12
#define TIMEOUT 10
#define PORTBASE   0x150
#define TRUE       1
#define FALSE      0

#define RSC	1
#define ILIST	2
#define HEX	3

LINK            TheLink;

#ifndef __STDC__
void            Usage()
#else
void            Usage(void)
#endif				/* __STDC__ */

{
                    printf("\n%s  --  version %s of %s.\n", PROGRAM_NAME,
			                   VERSION_NUMBER, VERSION_DATE);
    printf("Usage: %s [-T2 -T4 -s startaddr -[lrx] file.hex ]\n",
	   	PROGRAM_NAME );
    printf("       This dis-assembles file.hex or stdin to stdout.\n");
    printf("    -s startaddr   hex address of the first byte\n");
    printf("    -l     interprets input as ilist -c output\n");
    printf("    -x     interprets input as hex dump with addresses\n");
    printf("    -r     interprets input as ilist -h file.rsc\n\n");
    printf("Andy's Transputer dissassembler http://www.wizzy.com/wizzy/dasm.html\n");
    exit(0);
}

unsigned char   chartochar(char **string)
{
    unsigned char   num = 0;
    char            c;
    int             count = 2;
    while (*string && count--)
    {
	c = **string;
	switch (c)
	{
	    case '0':
	    case '1':
	    case '2':
	    case '3':
	    case '4':
	    case '5':
	    case '6':
	    case '7':
	    case '8':
	    case '9':
		num = (num << 4) + c - '0';
		break;
	    case 'A':
	    case 'B':
	    case 'C':
	    case 'D':
	    case 'E':
	    case 'F':
		num = (num << 4) + c - 'A' + 10;
		break;
	    case 'a':
	    case 'b':
	    case 'c':
	    case 'd':
	    case 'e':
	    case 'f':
		num = (num << 4) + c - 'a' + 10;
		break;
	    default:
		count = 0;
	}
	(*string)++;
    }
    return (num);
}

long            chartolong(char *string)
{
    long            num = 0L;
    int             done = 0;
    while (*string && !done)
    {
	switch (*string)
	{
	    case '0':
	    case '1':
	    case '2':
	    case '3':
	    case '4':
	    case '5':
	    case '6':
	    case '7':
	    case '8':
	    case '9':
		num = (num << 4) + *string - '0';
		break;
	    case 'A':
	    case 'B':
	    case 'C':
	    case 'D':
	    case 'E':
	    case 'F':
		num = (num << 4) + *string - 'A' + 10;
		break;
	    case 'a':
	    case 'b':
	    case 'c':
	    case 'd':
	    case 'e':
	    case 'f':
		num = (num << 4) + *string - 'a' + 10;
		break;
	    default:
		done = 1;
	}
	string++;
    }
    return (num);
}

#ifndef __STDC__
void            addlabel(num, opcodeline, mint)
    unsigned long int num;
    char            opcodeline[];
unsigned long   mint;
#else
void            addlabel(unsigned long int num, char opcodeline[], unsigned long mint)
#endif				/* __STDC__ */
{
    if              (num > mint)
	                sprintf(&opcodeline[strlen(opcodeline)],
				                " %%%lX", num - mint);
    else
	sprintf(&opcodeline[strlen(opcodeline)],
		" %lX", num);
}

void            getparams(int argc, char *argv[], char *filename, int *format,
		           unsigned long *addr, int *bytesperword)
{
    char           *c;
    *bytesperword = 4;
    filename[0] = '\0';
    *format = 0;
    ++argv;
    while (--argc > 0)
    {
	c = *argv;
	if ((*c) != '-')
	    strcpy(filename, c);
	else
	{
	    ++c;
	    switch (*c)
	    {
		case '?':
		case 'h':
		case 'H':
		    Usage();
		    break;
		case 'l':
		case 'L':
		    *format = ILIST;
		    break;
		case 'r':
		case 'R':
		    *format = RSC;
		    break;
		case 'x':
		case 'X':
		    *format = HEX;
		    break;
		case 't':
		case 'T':
		    *bytesperword = atoi(++c);
		    if ((*bytesperword != 2) && (*bytesperword != 4))
		    {
			printf("Transputer type must be T2 or T4\n");
			exit(1);
		    }
		    break;
		case 's':
	            argv++;
		    argc--;
		    c = *argv;
		    if (sscanf(c, "%lx", addr) != 1)
		    {
			printf("Unable to decode hex address <%s>\n", c);
			exit(1);
		    }
		    break;
		default:
		    printf("What is -%c - proceeding\n", *c);
		    break;
	    }
	}
	++argv;
    }
}

#ifndef __STDC__
int             main(argc, argv)
    int             argc;
    char           *argv[];
#else
int             main(int argc, char *argv[])
#endif				/* __STDC__ */
{
    char            opcodeline[80], filename[80], line[160], *p;
    FILE           *f;
    int             i, writecount, pfixcount = 0, endline = FALSE;
    int             byte, func, bytesperword, format;
    unsigned long int addr=0xdefaced, data, ptr, mint, end;
    unsigned long int lastconstant;
    int started=0;

    getparams(argc, argv, filename, &format, &addr, &bytesperword);
    if (!filename[0])
	f = stdin;
    else
        f = fopen(filename, "r");
    if (f == NULL)
    {
	printf("File %s not found\n", filename);
	exit(1);
    }
    i = 0;
    mint = ((unsigned long int) 1 << (8 * bytesperword - 1));
    data = (unsigned long int) 0;
    writecount = 0;
    if (format == ILIST)
    {
	while (fgets(line, sizeof(line), f) != NULL &&
				!strstr(line, "LOAD_TEXT"));
	for (p = line; *p && *p != ':'; p++);
	if (addr==0xdefaced)
	    addr=0;
	end = addr + atoi(++p);
    } else if (format == RSC) {
	if (addr==0xdefaced)
	    addr=0;
	fgets(line, sizeof(line), f); printf("%s", line);
	fgets(line, sizeof(line), f); printf("%s", line);
	addr -= 4;	/* move origin past length, on third line */
    }
    ptr = addr;
    strcpy(opcodeline, "");
    while (fgets(line, sizeof(line), f) != NULL &&
			((format != ILIST) || addr < end))
    {
	p = line;
	if ((format == ILIST) || (format == RSC)) {
	    p[44] = '\0';	/* strip ascii */
	}
	if ((format == HEX) || (format == ILIST) || (format == RSC)) {
	    if (!started) {
		addr = chartolong(p);
    		ptr = addr;
		started = 1;
	    }
	    p += 9;		/* skip address */
	}
	while (*p)
	{
	    while (*p && !isalnum(*p))
		p++;
	    if (isalnum(*p))
	    {
		byte = chartochar(&p);
		if (writecount == 0)
		{
		    printf("%0*lX: ", bytesperword * 2, addr);
		    writecount += bytesperword * 2 + 2;
		}
		ptr += 1;
		printf("%02X", byte);
		writecount += 2;
		func = byte >> 4;
		data = (data << 4) | (byte & 0xF);
		switch (func)
		{
		    case 15:
			/* OPR */
			if ((data >= 0) && (data <= 256))
			{
			    printf(" ");
			    writecount++;
			    strcat(opcodeline, Secondaries[(int) data]);
			    switch ((int) data)
			    {
				case 13:	/* STARTP */
				case 27:	/* LDPI */
				    addlabel(ptr + lastconstant, opcodeline, mint);
				    break;
				case 33:	/* LEND  */
				    addlabel(ptr - lastconstant, opcodeline, mint);
				case 3:	/* ENDP  */
				case 21:	/* STOPP */
				case 32:	/* RET   */
				case 6:	/* GCALL */
				    endline = TRUE;
				    break;
			    }	/* switch */
			    addr = ptr;
			    data = 0;
			    pfixcount = 0;
			} else {
			    if (((int) data) < 0) {
			        printf(" ");
			        writecount++;
				if (((int) data) > -49) {
			            strcat(opcodeline,
					   Negatives[-((int) data)]);
				} else {
				    switch ((int) data)
				    {
				    case -64:
			                strcat(opcodeline, "NOP");
					break;
				    default:
			                printf(" ");
			                writecount++;
			                sprintf(&opcodeline[strlen(opcodeline)]
,
					        "OPR %ld ", (long int) data);
				    }
				}
			        addr = ptr;
			        data = 0;
			        pfixcount = 0;
			    } else {	/* TREAT AS PRIMARY */
			        printf(" ");
			        writecount++;
			        sprintf(&opcodeline[strlen(opcodeline)],
					"%s %ld ",
				        Primaries[func], (long int) data);
			        addr = ptr;
			        data = 0;
			        pfixcount = 0;
			    }
			}
			break;
		    case 6:
			data = ~data;
		    case 2:
			{
			    pfixcount++;
			    if (pfixcount < 8)
				break;	/* otherwise, fall through */
			}
		    default:
			{	/* PRIMARIES */
			    printf(" ");
			    writecount++;
			    strcat(opcodeline, Primaries[func]);
			    switch (func)
			    {
				case 0:
				    if (data != 0) {
				      addlabel(ptr + data, opcodeline, mint);
				      endline = TRUE;
				    }
				    break;
				case 9:
				case 10:
				    addlabel(ptr + data, opcodeline, mint);
				    break;
				case 4:
				    lastconstant = data;
				case 2:
				case 6:
				    func = 0;	/* fallen through, fool it */
				default:
				    sprintf(&opcodeline[strlen(opcodeline)],
					    " %ld", data);
			    }
			    addr = ptr;
			    data = 0;
			    pfixcount = 0;
			}
		}
		if ((func != 2) & (func != 6))
		{
		    if ((writecount > BYTELENGTH) || (strlen(opcodeline) > LINELENGTH)
			|| endline)
		    {
			printf("%*s%s\n", 40 - writecount,
			       " ", opcodeline);
			writecount = 0;
			endline = FALSE;
			strcpy(opcodeline, "");
			i++;
		    } else
			strcat(opcodeline, "/");
		}
	    }
	}
    }
    printf("%*s%s\n", 40 - writecount, " ", opcodeline);
    return (0);
}
