/*{{{Comments*/
/*
 * File        : monitorl.c
 * Author      : Stuart Menefy
 * Description : Boot monitor link support functions.
 * Header      : $Id: monitorl.c,v 1.8 1994/05/20 14:16:35 stuart Exp $
 *
 * Routines for the boot monitor when booting from an IServer.
 * Provides IServer specific commands for the boot monitor.
 *
 * History:
 *   06/02/94  SIM  Created.
 *   20/02/94  SIM  Added r_readline() command for 'more' and 'source'.
 */
/*}}}*/

/*{{{#include*/
#include <string.h>
#include "io.h"
#include "monitor.h"
/*}}}*/
/*{{{externs and globals*/
extern void* bootLinkIn;
extern void* bootLinkOut;
/*}}}*/
/*{{{Channel communications macros*/
#define ChanOut(link, data, size) \
  __asm{ ldabc size, link, data; out; }
#define ChanIn(link, data, size) \
  __asm{ ldabc size, link, data; in; }
/*}}}*/

/* This function is here to prevent linkio.c growing too big. */
/*{{{r_readline*/
int r_readline(char* buffer, int max_len)
{
    char hdr[7] = {14,                  /* Fgets */
                   0,0,0,0,             /* Handle (patched) */
                   0,0};                /* Length (patched) */
    int pkt_len = 8;                    /* 7 + padding */
    int len = 0;                        /* Clear msb and init for eof */
    extern int file_inode;

    memcpy(&hdr[1], &file_inode, 4);
    memcpy(&hdr[5], &max_len, 2);

    ChanOut(bootLinkOut, &pkt_len, 2);
    ChanOut(bootLinkOut, hdr, pkt_len);

    ChanIn(bootLinkIn, &pkt_len, 2);
    ChanIn(bootLinkIn, &hdr, 1);
    pkt_len--;
    if (pkt_len >= 2) {
        ChanIn(bootLinkIn, &len, 2);
        pkt_len -= 2;
    }
    if (len > 0) {
        ChanIn(bootLinkIn, buffer, len);
        pkt_len -= len;
    }

    if (pkt_len > 0)
        ChanIn(bootLinkIn, &hdr[1], pkt_len);

    buffer[len] = '\0';    
    return (hdr[0] == 0);
}

/*}}}*/

/*{{{commands list*/
command_t commands[] = {
    {"boot",    1, 1, boot,    NULL,          "Boot Minix"},
    {"help",    1, 1, help,    NULL,          "Print this text"},
    {"module",  2, 2, module,  "name",        "Define a new module"},
    {"more",    2, 2, more,    "filename",    "Display a file"},
    {"ramsize", 1, 2, ramsize, "[size in K]", "Set RAM disk size"},
    {"rootdev", 1, 2, rootdev, "[device]",    "Set root file system"},
    {"source",  2, 2, source,  "filename",    "Read commands from file"},
    {NULL,      0, 0, NULL,    NULL,          NULL}
};

/*}}}*/
