/*
 * File        : load.h
 * Author      : Stuart Menefy
 * Description : Interface between boot monitor and booted code.
 * Header      : $Id: load.h,v 1.1 1994/03/03 15:58:34 stuart Exp $
 *   
 * This is the interface between teh boot monitor, and the code which the
 * boot monitor loads and starts executing. The structures contain details
 * about the hardware the code is running on, and the programs which have
 * been loaded into memory.
 *
 * History:
 *   03/03/93  SIM  Created.
 */

typedef enum {
    data_first,
    text_first
} order_t;

typedef struct {
    char name[80];
    char filename[80];
    unsigned short priority;
    short procnum;
    order_t order;
    /* Details filled in as module is loaded */
    int data_clicks, text_clicks;
} module_t;

