/*{{{}}}*/
/*{{{  #includes*/
#include <errno.h>
#include <string.h>
#include <stdlib.h>
#include <stdio.h>

#include "link.h"
/*}}}  */

int main(argc,argv) int argc; char *argv[];
{
  /*{{{  variable declarations*/
  int c;
  FILE *fp;
  int linkfd;
  unsigned int res=41;
  /*}}}  */

  /*{{{  check arguments*/
  if (argc!=3)
  {
    printf("Usage: tlinkcheck link file\n");
    exit(0);
  }
  /*}}}  */
  /*{{{  open link*/
  if ((linkfd=OpenLink(argv[1]))<0)
  {
    printf("tlinkcheck: Can't open link: %s\n",strerror(errno));
    exit(1);
  }
  ResetLink(linkfd);
  /*}}}  */
  /*{{{  boot transputer*/
  if ((fp=fopen(argv[2],"r"))==(FILE*)0)
  {
    printf("tlinkcheck: Can't open file %s: %s\n",argv[2],strerror(errno));
    exit(1);
  }
  while ((c=getc(fp))!=EOF) WriteLink(linkfd,(char*)&c,1,0);
  /*}}}  */
  /*{{{  check if sirius runs the code*/
  WriteLink(linkfd,&res,4,0);
  ReadLink(linkfd,&res,4,0);
  printf("tlinkcheck: %s answers %d\n",argv[1],res);
  /*}}}  */
  /*{{{  close link*/
  CloseLink(linkfd);
  /*}}}  */
  exit(0);
}
