/* $Id: pwd.h,v 1.3 1995/06/29 11:27:48 stuart Exp $ */

#ifndef _PWD_H
#define _PWD_H

#include <sys/types.h>
#include <stdio.h>

#ifdef __cplusplus
extern "C" {
#endif

struct passwd
{
  char *pw_name;                      /* login name                        */
  char *pw_passwd;                    /* encrypted password                */
  uid_t pw_uid;                       /* user id                           */
  gid_t pw_gid;                       /* active group id                   */
  char *pw_gecos;                     /* for a GE 645 or for the user name */
  char *pw_dir;                       /* home directory                    */
  char *pw_shell;                     /* login shell                       */
  time_t pw_age;                      /* age of the password               */
  time_t pw_maxage;                   /* password expires after age+maxage */
  time_t pw_expire;                   /* account expiration date           */
};

struct passwd *getpwuid(uid_t uid);
struct passwd *getpwnam(const char *name);
int setpwent(void);
void endpwent(void);
struct passwd *getpwent(void);
int putpwent(const struct passwd *pw, FILE *stream);
int putpwxent(const struct passwd *pw, FILE *stream);
char *getpass(const char *prompt);

#ifdef __cplusplus
}
#endif

#endif
