/* $Id: syslib.h,v 1.4 1995/10/27 18:53:25 stuart Exp $ */

/* Prototypes for system library functions. */

/* Minix user+system library. */
#ifndef _SYSLIB_H
#define _SYSLIB_H

/* Minix user library. */
void printk(const char *_fmt, ...);
int _sendrec(int _src_dest, message *_m_ptr);
int _taskcall(int _who, int _syscallnr, message *_msgptr);

/* Minix system library. */
extern const int _local_systask;

int _receive(int _src, message *_m_ptr);
int _send(int _dest, message *_m_ptr);
void _interrupt(int);

int  mem_copy(int src_proc, int src_seg, vir_bytes src_vir,
              int dst_proc, int dst_seg, vir_bytes dst_vir, vir_bytes bytes);
int  mem_check(int proc, int seg, vir_bytes addr, vir_bytes len);
void panic(const char* msg, int num);
void putk(const char c);

void sys_abort(int _how);
void sys_copy(message *_mptr);
int  sys_uptime(message* m);

typedef int (*rdwt_t)(message *m_ptr);
int do_vrdwt(message *m_ptr, rdwt_t do_rdwt);

int mm_kill(int proc, int sig);
#endif /* _SYSLIB_H */
