/* $Id: procnum.h,v 1.5 1995/10/27 18:53:25 stuart Exp $ */

#ifndef _MINIX_PROCNUM_H
#define _MINIX_PROCNUM_H

/* Definitions of process numbers.
 * Process numbers are 32 bit integers, divided into three fields:
 *    Bits 31-24  family (server, device driver or user process)
 *    Bits 23-16  class (server number, major device number, etc.)
 *    Bits 15- 0  instance number
 */
typedef long procnum_t;

/* Currently defined process families. */
#define FAMILY_SYSTEM 4
#define FAMILY_SERVER 3
#define FAMILY_DEVICE 2
#define FAMILY_USER   1

/* Definitions of field usage. */
#define FAMILY_SHIFT   24
#define FAMILY_MASK    0xff
#define CLASS_SHIFT    16
#define CLASS_MASK     0xff
#define INSTANCE_SHIFT 0
#define INSTANCE_MASK  0xffff

/* Macros to extract and create procnums. */
#define EXTRACT_FAMILY(procnum)   (((procnum) >>  FAMILY_SHIFT) &   FAMILY_MASK)
#define EXTRACT_CLASS(procnum)    (((procnum) >>   CLASS_SHIFT) &    CLASS_MASK)
#define EXTRACT_INSTANCE(procnum) (((procnum)                 ) & INSTANCE_MASK)
#define CREATE_PROCNUM(family, class, instance) \
	(((((family) << (FAMILY_SHIFT - CLASS_SHIFT)) | \
	  (class)) << CLASS_SHIFT) | (instance))

#define BAD_PROCNUM (-1)

/*efine SPAWN_PROCNUM   0x001 */
#define SPAWN_PRIORITY  0x002
#define SPAWN_PROCESSOR 0x004
#define SPAWN_EXEC      0x008 /* Replace current process with new one */

struct spawn_details {
    int       flags;        /* As above */
    procnum_t procnum;      /* Procnum of new process, unless SPAWN_EXEC */
    int       priority;     /* Desired priority */
    int       processor;    /* Desired processor */
};

#endif /* _MINIX_PROCNUM_H */
