/* $Id: partition.h,v 1.2 1995/10/27 18:53:25 stuart Exp $ */

/* Description of entry in partition table.  */
#ifndef _PARTITION_H
#define _PARTITION_H

/* fdisk uses this description, and places it at PART_TABLE_OFFSET */
struct part_entry {
  unsigned char bootind;	/* boot indicator 0/ACTIVE_FLAG	 */
  unsigned char start_head;	/* head value for first sector	 */
  unsigned char start_sec;	/* sector value + cyl bits for first sector */
  unsigned char start_cyl;	/* track value for first sector	 */
  unsigned char sysind;		/* system indicator - see systype() */
  unsigned char last_head;	/* head value for last sector	 */
  unsigned char last_sec;	/* sector value + cyl bits for last sector */
  unsigned char last_cyl;	/* track value for last sector	 */
  unsigned long lowsec;		/* logical first sector		 */
  unsigned long size;		/* size of partion in sectors	 */
};

#define ACTIVE_FLAG	0x80	/* value for active in bootind field (hd0) */
#define NR_PARTITIONS	4	/* number of entries in partition table */
#if (MACHINE == IBM_PC)
#define	PART_TABLE_OFF	0x1BE	/* offset of partition table in boot sector */
#else
#if (MACHINE == TRANSPUTER)
#define PART_TABLE_OFF	0x1A0	/* offset of partition table in boot sector */
struct hard_info {
  char			gap1[PART_TABLE_OFF];
  struct part_entry	parts[NR_PARTITIONS];
  unsigned short	cylinders;	/* number of cylinders */
  unsigned char		heads;		/* number of heads */
  unsigned char		sectors;	/* sectors per track */
  unsigned short	rwc;		/* reduced write current cyl */
  unsigned short	wpc;		/* write-precompensation cyl */
  unsigned short	park;		/* parking track */
  char			gap2[2];	/* unused */
  unsigned long		size;		/* size of disk in sectors */
  char			gap3[14];	/* unused */
  unsigned char		magic[2];	/* magic number */
};

#define PART_MAGIC0 0x55
#define PART_MAGIC1 0xaa
#else
#error Machine not set up for partition table
#endif
#endif

/* Partition types. */
#define MINIX_PART	0x81	/* Minix partition type */
#define NO_PART		0x00	/* unused entry */
#define OLD_MINIX_PART	0x80	/* created before 1.4b, obsolete */
#define EXT_PART	0x05	/* extended partition */

#endif /* _PARTITION_H */
