/* $Id: locale.h,v 1.1 1994/09/21 16:41:03 stuart Exp $ */

/* The <locale.h> header is used to custom tailor currency symbols, decimal 
 * points, and other items to the local style.  It is ANSI's attempt at 
 * avoiding cultural imperialism.  The locale given below is for C.
 */

#ifndef _LOCALE_H
#define _LOCALE_H

#ifdef __cplusplus
extern "C" {
#endif

struct lconv 
{
  char *decimal_point;		/* "." */
  char *thousands_sep;		/* ""  */
  char *grouping;		/* ""  */
  char *int_curr_symbol;	/* ""  */
  char *currency_symbol;	/* ""  */
  char *mon_decimal_point;	/* ""  */
  char *mon_thousands_sep;	/* ""  */
  char *mon_grouping;		/* ""  */
  char *positive_sign;		/* ""  */
  char *negative_sign;		/* ""  */
  char int_frac_digits;		/* CHAR_MAX */
  char frac_digits;		/* CHAR_MAX */
  char p_cs_precedes;		/* CHAR_MAX */
  char p_sep_by_space;		/* CHAR_MAX */
  char n_cs_precedes;		/* CHAR_MAX */
  char n_sep_by_space;		/* CHAR_MAX */
  char p_sign_posn;		/* CHAR_MAX */
  char n_sign_posn;		/* CHAR_MAX */
};

#ifndef NULL
#define NULL    ((void *)0)
#endif

#define LC_ALL             1
#define LC_COLLATE         2
#define LC_CTYPE           3
#define LC_MONETARY        4
#ifdef _MINIX
#define LC_MESSAGES        5
#endif
#define LC_NUMERIC         6
#define LC_TIME            7

char *setlocale(int _category, const char *_locale);
struct lconv *localeconv(void);
#ifdef _MINIX
int __opennls(const char *category, const char *value, const char *charset, const char *cat);
#endif

#endif
